/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.starcos;

import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.DigestInfo;
import de.bos_bremen.common.asn1.HashAlgorithm;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GDCardHelper;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS35;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StarCOS35DGNService
extends StarCOS35 {
    private static final String IMAGE_ID_SINGLE = "0200000b";
    private static final String IMAGE_ID_SINGLE_TEST = "00c09b0b";
    private static final String IMAGE_ID_STAPLE = "0200000c";
    private static final String IMAGE_ID_STAPLE_TEST = "00c09b0c";
    protected static final List<String> IMAGE_IDS_SINGLE = Collections.unmodifiableList(Arrays.asList("0200000b", "00c09b0b"));
    protected static final List<String> IMAGE_IDS_STAPLE = Collections.unmodifiableList(Arrays.asList("0200000c", "00c09b0c"));
    public static final Map<String, String> MAP_IMAGE_ID;
    private static final byte PINID_CH = 6;
    private static final String NAME_QES_SIGNATURE_KEY = "QESSignatureKey";
    private static final byte PINID_QES1 = -127;
    private static final String AID_EA = "a000000167455349474e";
    private static final Integer INIT_LENGTH;
    private static final Log LOG;
    protected String displayName;
    private final String issuerConstant;
    private final String tokenLabel;
    protected boolean stapleSign;
    protected boolean multiSign;
    private final boolean issuerReadRequired;
    public static final String ISSUER_CONSTANT = "5a 0a 80 27 60 01 08";
    private static final String ISSUER_CONSTANT_W1 = "5a 0a 92 76 01 01 11";
    private static final String ISSUER_CONSTANT_W2 = "5a 0a 92 76 00 35 32";
    protected static final String ISSUER_CONSTANT_W3 = "5a 0a 92 76 00 35 31";
    private static final List<String> SUPPORTED_EF_GDOS;
    private GDCardHelper.CheckAlgAnalyzer siggAlgAnalyzer;
    private GDCardHelper.CheckAlgAnalyzer esignAlgAnalyzer;
    protected Integer stapleSignCounter = 254;

    protected StarCOS35DGNService() {
        this("DGN", ISSUER_CONSTANT, ISSUER_CONSTANT, false, false, Card.CardTypeEnum.HPC_ZOD_DGN, true);
    }

    public StarCOS35DGNService(String displayName, String mainIssuerConstant, String cardIssuerConstant, boolean stapleSign, boolean multiSign, Card.CardTypeEnum cardType, boolean issuerReadRequired) {
        super(cardType, new String[]{"80 31 b8 73 86 01 e0 81 05"});
        this.issuerConstant = mainIssuerConstant == null || mainIssuerConstant.isEmpty() ? ISSUER_CONSTANT : mainIssuerConstant;
        this.displayName = displayName;
        this.tokenLabel = cardIssuerConstant;
        this.stapleSign = stapleSign;
        this.multiSign = multiSign;
        this.issuerReadRequired = issuerReadRequired;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final boolean isMultiSign() {
        return this.multiSign;
    }

    @Override
    public boolean isStapleSign() {
        return this.stapleSign || GovCS.isStapleSign(this);
    }

    @Override
    protected final boolean isIssuerReadRequired() {
        return this.issuerReadRequired;
    }

    @Override
    protected String getIssuerConstant() {
        return this.tokenLabel;
    }

    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, smartcard, blocking);
        this.siggAlgAnalyzer = new GDCardHelper.CheckAlgAnalyzer(this, "D2 76 00 00 66 01", MAP_SIG_ALGORITHM_PKCS1V15, MAP_SIG_ALGORITHM_PKCS1PSS, MAP_SIG_ALGORITHM_DINSIG, MAP_AUT_ALGORITHM, null, ASYMMETRIC_KEY_IDENTIFIER);
        this.siggAlgAnalyzer.checkAlgSuppport((byte)1);
        this.esignAlgAnalyzer = new GDCardHelper.CheckAlgAnalyzer(this, "A0 00 00 01 67 45 53 49 47 4e", MAP_SIG_ALGORITHM_PKCS1V15, MAP_SIG_ALGORITHM_PKCS1PSS, MAP_SIG_ALGORITHM_DINSIG, MAP_AUT_ALGORITHM, null, ASYMMETRIC_KEY_IDENTIFIER);
        this.esignAlgAnalyzer.checkAlgSuppport((byte)1, (byte)5);
        StarCOS35DGNService.getImageID(this, MAP_IMAGE_ID);
        LOG.debug((Object)"signature key algorithms:");
        this.siggAlgAnalyzer.dumpAlgorithms();
        LOG.debug((Object)"authentication/decryption key algorithms:");
        this.esignAlgAnalyzer.dumpAlgorithms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final String readIssuerFromATR(CardChannel _channel) {
        Object readIssuerFromATR = super.readIssuerFromATR(_channel);
        boolean supported = false;
        LOG.debug((Object)("EF.GDO: " + (String)readIssuerFromATR));
        String imageID = null;
        try {
            ResponseAPDU r = _channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("a0 ca 9f 6b 08")));
            if (r.sw() != 36864) {
                return null;
            }
            LOG.debug((Object)("Chip: " + HexUtil.hexify(r.data())));
            LOG.debug((Object)("OS version: " + HexUtil.hexify(_channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("a0 ca 9f 6a 05"))).data())));
            ResponseAPDU responseImageID = _channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("a0 ca 9f 67 04")));
            LOG.debug((Object)("Image ID: " + HexUtil.hexify(responseImageID.data())));
            if (responseImageID.sw() == 36864 && responseImageID.data() != null && MAP_IMAGE_ID.containsKey(imageID = HexUtil.hexify(responseImageID.data()))) {
                LOG.debug((Object)"card identified by image id");
                supported = true;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("failed to read card informations: " + e.getMessage()), (Throwable)e);
        }
        if (supported |= SUPPORTED_EF_GDOS.contains(readIssuerFromATR)) {
            try {
                this.selectFile(_channel, new FileReference(2, "0013"));
                ASN1 mfPinCHRecord = this.findEFKEYDRecord(_channel, new StarCOS35.PwdRecordMatcher(6), null);
                StarCOS35DGNService.logLifeCycle("PIN.CH", "MF", mfPinCHRecord);
                this.selectSubDirectory(_channel, new FileReference(4, "D2 76 00 00 66 01"));
                this.selectFile(_channel, new FileReference(2, "0013"));
                ASN1 dfPinQESRecord1 = this.findEFKEYDRecord(_channel, new StarCOS35.PwdRecordMatcher(-127), null);
                if (dfPinQESRecord1 != null) {
                    StarCOS35DGNService.logLifeCycle("PIN.QES1", "DF.EUserPKI", dfPinQESRecord1);
                    ASN1 ssec = StarCOS35DGNService.getASN1Child(dfPinQESRecord1, SSEC_PATH);
                    if (ssec != null) {
                        LOG.debug((Object)("SSEC for password of QES1:\n" + HexUtil.dump(ssec.getEncoded())));
                        readIssuerFromATR = (String)readIssuerFromATR + " " + HexUtil.hexify(ssec.getValue());
                    } else if (IMAGE_IDS_SINGLE.equals(imageID)) {
                        LOG.debug((Object)"card personalization - expected SSEC value not set, using ImageID");
                        readIssuerFromATR = (String)readIssuerFromATR + " 01";
                    } else if (IMAGE_IDS_STAPLE.contains(imageID)) {
                        LOG.debug((Object)"card personalization - expected SSEC value not set, using ImageID");
                        readIssuerFromATR = (String)readIssuerFromATR + " 64";
                    } else {
                        LOG.debug((Object)"card personalization - expected SSEC value not set, ImageID unknown, using default: ff");
                        readIssuerFromATR = (String)readIssuerFromATR + " ff";
                    }
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("failed reading EF.KEYD of MF/DF.QES for PIN.CH, PIN.QES1 and PIN.QES2: " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    this.selectMasterFile(_channel);
                }
                catch (Exception e) {
                    LOG.debug((Object)("select MF failed: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        LOG.debug((Object)("card identification: " + (String)readIssuerFromATR));
        return readIssuerFromATR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String readIssuerFromATR2(CardChannel _channel) {
        Object readIssuerFromATR = super.readIssuerFromATR(_channel);
        if (this.issuerConstant.equals(readIssuerFromATR)) {
            try {
                this.selectFile(_channel, new FileReference(2, "0013"));
                ASN1 mfPinCHRecord = this.findEFKEYDRecord(_channel, new StarCOS35.PwdRecordMatcher(6), null);
                StarCOS35DGNService.logLifeCycle("PIN.CH", "MF", mfPinCHRecord);
                this.selectSubDirectory(_channel, new FileReference(4, "D2 76 00 00 66 01"));
                this.selectFile(_channel, new FileReference(2, "0013"));
                ASN1 dfPinQESRecord = this.findEFKEYDRecord(_channel, new StarCOS35.PwdRecordMatcher(-127), null);
                if (dfPinQESRecord != null) {
                    StarCOS35DGNService.logLifeCycle("PIN.CH", "DF.QES", dfPinQESRecord);
                    ASN1 ssec = StarCOS35DGNService.getASN1Child(dfPinQESRecord, SSEC_PATH);
                    if (ssec != null) {
                        LOG.debug((Object)("SSEC for password of QES:\n" + HexUtil.dump(ssec.getEncoded())));
                        readIssuerFromATR = (String)readIssuerFromATR + " " + HexUtil.hexify(ssec.getValue());
                    } else {
                        readIssuerFromATR = (String)readIssuerFromATR + " ff";
                    }
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("failed reading EF.KEYD of MF/DF.QES for PIN.CH or PIN.QES: " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    this.selectMasterFile(_channel);
                }
                catch (Exception e) {
                    LOG.debug((Object)("select MF failed: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return readIssuerFromATR;
    }

    private static void logLifeCycle(String pinName, String dfName, ASN1 pwdRecord) {
        if (pwdRecord == null) {
            return;
        }
        LOG.debug((Object)("EF.KEYD of " + dfName + " for PINID of " + pinName + ":\n" + HexUtil.dump(pwdRecord.getEncoded())));
        ASN1 lifeCycle = StarCOS35DGNService.getASN1Child(pwdRecord, (byte)-118);
        if (lifeCycle != null) {
            byte[] lifeCycleValue = lifeCycle.getValue();
            LOG.debug((Object)("lifeCycle " + pinName + " (active: " + (5 == lifeCycleValue[0]) + "): " + HexUtil.hexify(lifeCycleValue)));
        }
    }

    @Override
    public final Integer getStapleSignCounter() {
        return this.stapleSign ? this.stapleSignCounter : (this.isStapleSign() ? MAXIMUM_COUNT_OF_STAPLE_SIGNATURES : null);
    }

    @Override
    protected final Card createCardInt(Terminal pTerminal, int pSlotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        long idOfPinCH = 2000001L;
        byte pinID = 6;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardPinImpl pinCH = new CardPinImpl(Disposeable.NO_LOCK, "PIN.CH", idOfPinCH, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000001L});
        CardApplication applicationQES = this.createQESApp(pTerminal, pSlotID, idOfCard, idOfMFApplication);
        CardApplication applicationESIGN = this.createEAApp(pTerminal, pSlotID, idOfCard, idOfMFApplication, idOfPinCH);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationQES);
        mfManager.putApplication(applicationESIGN);
        mfManager.putPin(pinCH);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.MF.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.cardType.getType(), super.getCard(), mfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    protected CardApplication createEAApp(Terminal pTerminal, int pSlotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        String aid = AID_EA;
        long idOfApplication = 1000002L;
        long idOfFile01 = 3000008L;
        long idOfFile02 = 3000009L;
        long idOfFile03 = 3000010L;
        long idOfFile04 = 3000011L;
        long idOfFile05 = 3000012L;
        long idOfFile06 = 3000013L;
        long idOfKey01 = 4000002L;
        long idOfKey02 = 4000003L;
        KeyID k01 = new KeyID("82");
        KeyID k02 = new KeyID("83");
        FileReference dirRefApp = new FileReference(4, aid);
        FileReference cerRef01 = new FileReference(2, "c500");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        FileReference cerRef02 = new FileReference(2, "c508");
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02);
        FileReference cerRef03 = new FileReference(2, "c50e");
        FileEntry fileEntry03 = new FileEntry(dirRefApp, cerRef03);
        FileReference cerRef04 = new FileReference(2, "c200");
        FileEntry fileEntry04 = new FileEntry(dirRefApp, cerRef04);
        FileReference cerRef05 = new FileReference(2, "c208");
        FileEntry fileEntry05 = new FileEntry(dirRefApp, cerRef05);
        FileReference cerRef06 = new FileReference(2, "c20e");
        FileEntry fileEntry06 = new FileEntry(dirRefApp, cerRef06);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, -1L, idOfFile03, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo info04 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile04, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info05 = new OCFCertificateInfo(idOfCard, -1L, idOfFile05, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info06 = new OCFCertificateInfo(idOfCard, -1L, idOfFile06, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerAut", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "caAut", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, info02);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "rcaAut", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, info03);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "cerEnc", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardFileImpl file05 = new CardFileImpl(Disposeable.NO_LOCK, "caEnc", idOfFile05, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry05, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, info05);
        CardFileImpl file06 = new CardFileImpl(Disposeable.NO_LOCK, "rcaEnc", idOfFile06, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry06, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, info06);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ADVANCED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType()}), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPinCH, k01);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "DecryptionKey", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType()}), fileEntry04, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info04, idOfFile04, idOfPinCH, k02);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider01 = this.createDefaultAlgorithmProviderAuthentication();
        key01.setAlgorithmProvider(algorithmProvider01);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider02 = this.createDefaultAlgorithmProviderDecryption();
        key02.setAlgorithmProvider(algorithmProvider02);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl(aid, idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType()}), fileEntry03, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putFile(file03);
        applicationApp.putFile(file04);
        applicationApp.putFile(file05);
        applicationApp.putFile(file06);
        applicationApp.putKey(key01);
        applicationApp.putKey(key02);
        return applicationApp;
    }

    @Override
    protected CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 2: {
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                data.write(-124);
                data.write(_info.getKeyID().getID().length);
                data.write(_info.getKeyID().getID(), 0, _info.getKeyID().getID().length);
                data.write(-128);
                data.write(1);
                data.write(this.getHashAndCryptoID(_hashAlgorithm, _info));
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-92, data.toByteArray());
            }
        }
        return super.createMSECommand(_channel, _info, _type, _hashAlgorithm, algorithmParameters);
    }

    private int getHashAndCryptoID(String _hashAlgorithm, OCFCertificateInfo _info) {
        return 5;
    }

    private CardApplication createQESApp(Terminal pTerminal, int pSlotID, long idOfCard, long idOfMFApplication) {
        String aid = "d27600006601";
        long idOfApplication = 1000001L;
        long idOfPin01 = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfFile03 = 3000003L;
        long idOfFile04 = 3000004L;
        long idOfFile05 = 3000005L;
        long idOfFile06 = 3000006L;
        long idOfFile07 = 3000007L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID("84");
        byte pinID01 = -127;
        FileReference dirRefApp = new FileReference(4, aid);
        FileReference cerRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        FileReference cerRef02 = new FileReference(2, "c008");
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02);
        FileReference cerRef03 = new FileReference(2, "c00e");
        FileEntry fileEntry03 = new FileEntry(dirRefApp, cerRef03);
        FileReference cerRef04 = new FileReference(2, "c100");
        FileEntry fileEntry04 = new FileEntry(dirRefApp, cerRef04);
        FileReference attrCerRef01 = new FileReference(2, "c001");
        FileEntry fileEntry05 = new FileEntry(dirRefApp, attrCerRef01);
        FileReference attrCerRef02 = new FileReference(2, "c002");
        FileEntry fileEntry06 = new FileEntry(dirRefApp, attrCerRef02);
        FileReference attrCerRef03 = new FileReference(2, "c003");
        FileEntry fileEntry07 = new FileEntry(dirRefApp, attrCerRef03);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, OCFCertificateInfo.Usage.SIG, new long[]{idOfFile05, idOfFile06, idOfFile07});
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, -1L, idOfFile03, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{idOfKey01});
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerQES", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "caQES", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, info02);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "rcaQES", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, info03);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "attrCer", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication, pTerminal.getID(), this.slotID, this, CardObjectRegistryImpl.getInstance(), -1L);
        CardFileImpl file05 = new CardFileImpl(Disposeable.NO_LOCK, "attrCer1", idOfFile05, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry05, idOfCard, idOfApplication, pTerminal.getID(), this.slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file06 = new CardFileImpl(Disposeable.NO_LOCK, "attrCer2", idOfFile06, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry06, idOfCard, idOfApplication, pTerminal.getID(), this.slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file07 = new CardFileImpl(Disposeable.NO_LOCK, "attrCer3", idOfFile07, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry07, idOfCard, idOfApplication, pTerminal.getID(), this.slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, NAME_QES_SIGNATURE_KEY, idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info01, new long[]{idOfFile01}, new long[]{idOfFile05, idOfFile06, idOfFile07}, new long[]{idOfPin01}, k01);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider01 = this.createDefaultAlgorithmProviderSignatureAndOrAuthentication(Arrays.asList(UsageRelated.Usage.SIGNATURE));
        key01.setAlgorithmProvider(algorithmProvider01);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl(aid, idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putPin(pin01);
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putFile(file03);
        applicationApp.putFile(file04);
        applicationApp.putFile(file05);
        applicationApp.putFile(file06);
        applicationApp.putFile(file07);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    @Override
    public final Integer getMaxPINLengthInit(OCFCertificateInfo _info) {
        return INIT_LENGTH;
    }

    @Override
    public final Integer getMinPINLengthInit(OCFCertificateInfo _info) {
        return INIT_LENGTH;
    }

    @Override
    public final int getPasswordBlockLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    protected byte[] getPaddedPIN(OCFCertificateInfo _info, char[] _pin) {
        return this.getPinEncoder(_info).encode(_pin);
    }

    @Override
    public final PinEncoder getPinEncoder(OCFCertificateInfo _info) {
        return PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK;
    }

    @Override
    public final byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        return -1;
    }

    @Override
    public final int getMinPINLength(OCFCertificateInfo info) {
        return 4;
    }

    @Override
    public final int getMaxPINLength(OCFCertificateInfo info) {
        return 12;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA1");
            c.add("SHA224");
            c.add("SHA384");
            c.add("SHA512");
            c.add("SHA256");
        }
        return c;
    }

    @Override
    protected GovCS.ResultObject authentify(CardChannel channel, OCFCertificateInfo info, byte[] hashValue, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        if (hashValue != null && this.usesASN1HeaderWithAuthentify()) {
            LOG.debug((Object)("usesASN1HeaderWithAuthentify=" + this.usesASN1HeaderWithAuthentify()));
            try {
                hashValue = new DigestInfo(HashAlgorithm.Algorithm.getAlgorithmByName(hashAlgorithm), hashValue).getEncoded();
                LOG.debug((Object)("pkcs#1=" + HexString.hexify(hashValue)));
            }
            catch (Exception ex) {
                LOG.error((Object)"", (Throwable)ex);
            }
        }
        CommandAPDU cmd = this.createAuthentifyCommand(hashValue, algorithmParameters);
        LOG.debug((Object)("AUTH COMMAND : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("AUTH RESULT  : " + (res.getBuffer().length - 2) + " bytes, " + HexString.hexify(res.getBuffer(), false)));
        if (res.sw() != 36864) {
            throw new ResponseCodeException(res.sw(), APDUCommands.getPerformSecurityOperationErrorMsg(res.sw()));
        }
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(res.sw());
        ro.setResultData(res.data());
        this.authentifyAdjust(ro, algorithmParameters);
        return ro;
    }

    @Override
    protected boolean usesASN1HeaderWithAuthentify() {
        return true;
    }

    @Override
    protected CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[6 + _hashValue.length];
        store[0] = 0;
        store[1] = -120;
        store[2] = 0;
        store[3] = 0;
        store[4] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, store, 5, _hashValue.length);
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    static {
        LinkedHashMap<String, String> tmp = new LinkedHashMap<String, String>();
        tmp.put(IMAGE_ID_STAPLE, "Version Release V Einzelsignatur");
        tmp.put(IMAGE_ID_STAPLE, "Version Release V Stapelsignatur");
        tmp.put(IMAGE_ID_SINGLE_TEST, "Version Testkarte Einzelsignatur");
        tmp.put(IMAGE_ID_STAPLE_TEST, "Version Testkarte Stapelsignatur");
        MAP_IMAGE_ID = Collections.unmodifiableMap(tmp);
        INIT_LENGTH = 4;
        LOG = LogFactory.getLog(StarCOS35DGNService.class);
        SUPPORTED_EF_GDOS = Collections.unmodifiableList(Arrays.asList(ISSUER_CONSTANT, ISSUER_CONSTANT_W1, ISSUER_CONSTANT_W2, ISSUER_CONSTANT_W3));
    }
}

