/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.starcos;

import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.DefaultBaseAlgorithmProviderBuilder;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS35;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;

public abstract class StarCOS35BNotKV3
extends StarCOS35 {
    private static final String DEFAULT_DISPLAY_NAME_BUNDESNOTARKAMMER_V3 = "Bundesnotarkammer (V3)";
    private static final String KEY_NAME_AUTHENTICATION_DECRYPTION = "AuthenticationDecryptionKey";
    private static final Integer DEFAULT_STAPLE_SIGN_COUNTER = 100;
    private static final String AID_SHORT_EUSERPKI = "a000000525655573657201";
    private static final byte PINID_CH = 6;
    private static final String NAME_QES_SIGNATURE_KEY = "QESSignatureKey";
    private static final byte PINID_QES1 = -127;
    private static final byte PINID_QES2 = -122;
    private static final String AID_SHORT_ESIGN = "A0 00 00 01 67 45 53 49 47 4e".replaceAll(" ", "");
    private static final Integer INIT_LENGTH = 5;
    private static final Log LOG = LogFactory.getLog(StarCOS35BNotKV3.class);
    private String displayName = "Bundesnotarkammer (V3)";
    private static final String ISSUER_CONSTANT = "5a 0a 80 27 60 00 01";
    private static final String ISSUER_CONSTANT_W1 = "5a 0a 92 76 01 01 17";
    private static final String ISSUER_CONSTANT_W2 = "5a 0a 92 76 01 01 50";
    private static final String IMAGE_ID_STAPLE = "02000009";
    private static final String IMAGE_ID_MULTI = "02000008";
    protected static final String TOKEN_LABEL_STAPLE = "5a 0a 80 27 60 00 01 64 64";
    protected static final String TOKEN_LABEL_MULTI = "5a 0a 80 27 60 00 01 ff ff";
    private final boolean issuerReadRequired;
    private final boolean stapleSign;
    private final boolean multiSign;
    private final String tokenLabel;
    public static final Map<String, String> MAP_IMAGE_ID;

    public StarCOS35BNotKV3(Card.CardTypeEnum cardType, String tokenLabel, boolean stapleSign, boolean multiSign, boolean issuerReadRequired) {
        super(cardType, new String[]{"80 5b 44 45 2e 42 4e 4f 54 4b 31 30 30 81 05", "80 5b 44 45 2e 42 4e 4f 54 4b 31 31 31 81 05"});
        this.tokenLabel = tokenLabel;
        this.stapleSign = stapleSign;
        this.multiSign = multiSign;
        this.issuerReadRequired = issuerReadRequired;
    }

    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, smartcard, blocking);
        String imageID = StarCOS35BNotKV3.getImageID(this, MAP_IMAGE_ID);
        if (IMAGE_ID_STAPLE.equals(imageID)) {
            this.displayName = this.displayName + " - staple";
            LOG.debug((Object)"kind of card: staple");
        } else if (IMAGE_ID_MULTI.equals(imageID)) {
            this.displayName = this.displayName + " - multi";
            LOG.debug((Object)"kind of card: multi");
        } else {
            LOG.debug((Object)"no image description defined for card");
        }
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final boolean isMultiSign() {
        return this.multiSign;
    }

    @Override
    public boolean isStapleSign() {
        return this.stapleSign || GovCS.isStapleSign(this);
    }

    @Override
    protected final boolean isIssuerReadRequired() {
        return this.issuerReadRequired;
    }

    @Override
    protected String getIssuerConstant() {
        return this.tokenLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final String readIssuerFromATR(CardChannel _channel) {
        Object readIssuerFromATR = super.readIssuerFromATR(_channel);
        String imageID = null;
        try {
            ResponseAPDU r = _channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("a0 ca 9f 6b 08")));
            if (r.sw() != 36864) {
                return null;
            }
            LOG.debug((Object)("Chip: " + HexUtil.hexify(r.data())));
            LOG.debug((Object)("OS version: " + HexUtil.hexify(_channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("a0 ca 9f 6a 05"))).data())));
            ResponseAPDU responseImageID = _channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("a0 ca 9f 67 04")));
            LOG.debug((Object)("Image ID: " + HexUtil.hexify(responseImageID.data())));
            if (responseImageID.sw() == 36864 && responseImageID.data() != null && (IMAGE_ID_STAPLE.equals(imageID = HexUtil.hexify(responseImageID.data())) || IMAGE_ID_MULTI.equals(imageID))) {
                LOG.debug((Object)"card identified by image id");
                readIssuerFromATR = ISSUER_CONSTANT;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("failed to read card informations: " + e.getMessage()), (Throwable)e);
        }
        if (ISSUER_CONSTANT_W1.equals(readIssuerFromATR) || ISSUER_CONSTANT_W2.equals(readIssuerFromATR)) {
            readIssuerFromATR = ISSUER_CONSTANT;
        }
        if (ISSUER_CONSTANT.equals(readIssuerFromATR)) {
            try {
                ASN1 dfPinQESRecord2;
                this.selectFile(_channel, new FileReference(2, "0013"));
                ASN1 mfPinCHRecord = this.findEFKEYDRecord(_channel, new StarCOS35.PwdRecordMatcher(6), null);
                StarCOS35BNotKV3.logLifeCycle("PIN.CH", "MF", mfPinCHRecord);
                this.selectSubDirectory(_channel, new FileReference(4, AID_SHORT_ESIGN));
                this.selectFile(_channel, new FileReference(2, "0013"));
                ASN1 dfPinQESRecord1 = this.findEFKEYDRecord(_channel, new StarCOS35.PwdRecordMatcher(-127), null);
                if (dfPinQESRecord1 != null) {
                    StarCOS35BNotKV3.logLifeCycle("PIN.QES1", "DF.EUserPKI", dfPinQESRecord1);
                    ASN1 ssec = StarCOS35BNotKV3.getASN1Child(dfPinQESRecord1, SSEC_PATH);
                    if (ssec != null) {
                        LOG.debug((Object)("SSEC for password of QES1:\n" + HexUtil.dump(ssec.getEncoded())));
                        readIssuerFromATR = (String)readIssuerFromATR + " " + HexUtil.hexify(ssec.getValue());
                    } else if (IMAGE_ID_STAPLE.equals(imageID)) {
                        LOG.debug((Object)"card personalization - expected SSEC value not set, using ImageID");
                        readIssuerFromATR = (String)readIssuerFromATR + " 64";
                    } else if (IMAGE_ID_MULTI.equals(imageID)) {
                        LOG.debug((Object)"card personalization - expected SSEC value not set, using ImageID");
                        readIssuerFromATR = (String)readIssuerFromATR + " ff";
                    } else {
                        LOG.debug((Object)"card personalization - expected SSEC value not set, ImageID unknown, using default: ff");
                        readIssuerFromATR = (String)readIssuerFromATR + " ff";
                    }
                }
                if ((dfPinQESRecord2 = this.findEFKEYDRecord(_channel, new StarCOS35.PwdRecordMatcher(-122), null)) != null) {
                    StarCOS35BNotKV3.logLifeCycle("PIN.QES2", "DF.EUserPKI", dfPinQESRecord2);
                    ASN1 ssec = StarCOS35BNotKV3.getASN1Child(dfPinQESRecord2, SSEC_PATH);
                    if (ssec != null) {
                        LOG.debug((Object)("SSEC for password of QES2:\n" + HexUtil.dump(ssec.getEncoded())));
                        readIssuerFromATR = (String)readIssuerFromATR + " " + HexUtil.hexify(ssec.getValue());
                    } else if (IMAGE_ID_STAPLE.equals(imageID)) {
                        LOG.debug((Object)"card personalization - expected SSEC value not set, using ImageID");
                        readIssuerFromATR = (String)readIssuerFromATR + " 64";
                    } else if (IMAGE_ID_MULTI.equals(imageID)) {
                        LOG.debug((Object)"card personalization - expected SSEC value not set, using ImageID");
                        readIssuerFromATR = (String)readIssuerFromATR + " ff";
                    } else {
                        LOG.debug((Object)"card personalization - expected SSEC value not set, ImageID unknown, using default: ff");
                        readIssuerFromATR = (String)readIssuerFromATR + " ff";
                    }
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("failed reading EF.KEYD of MF/DF.QES for PIN.CH, PIN.QES1 and PIN.QES2: " + e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    this.selectMasterFile(_channel);
                }
                catch (Exception e) {
                    LOG.debug((Object)("select MF failed: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return readIssuerFromATR;
    }

    @Override
    protected GovCS.ResultObject readBase64BinaryCerFile(CardChannel _channel) throws InvalidCardChannelException, CardTerminalException {
        ResponseAPDU res = this.readSelectedFileChunked(_channel);
        if (res.sw() == 28416) {
            res = this.readSelectedFileChunked(_channel);
        }
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(res.sw());
        byte[] data = res.data();
        if (res.sw() == 36864 && data != null && data.length > 0) {
            try {
                ro.setResultData(CertificateFactory.getInstance("X.509", "BC").generateCertificate(new ByteArrayInputStream(data)).getEncoded());
            }
            catch (Exception e) {
                LOG.debug((Object)("error creating certifcate from base 64 binary data: " + e.getMessage()));
                ro.setResultCode(25218);
                ro.setResultData(null);
            }
        } else {
            LOG.debug((Object)("error reading base 64 binary data: " + HexUtil.hexify(ro.getResultCode())));
        }
        return ro;
    }

    private static void logLifeCycle(String pinName, String dfName, ASN1 pwdRecord) {
        if (pwdRecord == null) {
            return;
        }
        LOG.debug((Object)("EF.KEYD of " + dfName + " for PINID of " + pinName + ":\n" + HexUtil.dump(pwdRecord.getEncoded())));
        ASN1 lifeCycle = StarCOS35BNotKV3.getASN1Child(pwdRecord, (byte)-118);
        if (lifeCycle != null) {
            byte[] lifeCycleValue = lifeCycle.getValue();
            LOG.debug((Object)("lifeCycle " + pinName + " (active: " + (5 == lifeCycleValue[0]) + "): " + HexUtil.hexify(lifeCycleValue)));
        }
    }

    @Override
    public final Integer getStapleSignCounter() {
        return this.stapleSign ? DEFAULT_STAPLE_SIGN_COUNTER : (this.isStapleSign() ? MAXIMUM_COUNT_OF_STAPLE_SIGNATURES : null);
    }

    @Override
    protected final Card createCardInt(Terminal pTerminal, int pSlotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        long idOfPinCH = 2000001L;
        byte pinID = 6;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardPinImpl pinCH = new CardPinImpl(Disposeable.NO_LOCK, "PIN.CH", idOfPinCH, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000001L});
        CardApplication applicationEUserPKI = this.createEUserPKIApp(pTerminal, pSlotID, idOfCard, idOfMFApplication, idOfPinCH);
        CardApplication applicationESIGN = this.createESignApp(pTerminal, pSlotID, idOfCard, idOfMFApplication, idOfPinCH);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationEUserPKI);
        mfManager.putApplication(applicationESIGN);
        mfManager.putPin(pinCH);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.MF.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.cardType.getType(), super.getCard(), mfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    protected CardApplication createESignApp(Terminal pTerminal, int pSlotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000002L;
        long idOfFile01 = 3000005L;
        long idOfFile02 = 3000006L;
        long idOfFile03 = 3000007L;
        long idOfFile04 = 3000008L;
        long idOfFile05 = 3000009L;
        long idOfFile06 = 3000010L;
        long idOfFile07 = 3000011L;
        long idOfFile08 = 3000012L;
        long idOfPin02 = 2000003L;
        long idOfPin03 = 2000004L;
        long idOfKey01 = 4000002L;
        long idOfKey02 = 4000003L;
        KeyID k01 = new KeyID("84");
        byte pinID02 = -127;
        FileReference dirRefApp = new FileReference(4, AID_SHORT_ESIGN);
        FileReference cerRef01 = new FileReference(2, "c001");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        FileReference cerRef02 = new FileReference(2, "c011");
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02);
        FileReference cerRef03 = new FileReference(2, "c013");
        FileEntry fileEntry03 = new FileEntry(dirRefApp, cerRef03);
        FileReference cerRef04 = new FileReference(2, "c014");
        FileEntry fileEntry04 = new FileEntry(dirRefApp, cerRef04);
        KeyID k02 = new KeyID("85");
        byte pinID03 = -122;
        FileReference cerRef05 = new FileReference(2, "c002");
        FileEntry fileEntry05 = new FileEntry(dirRefApp, cerRef05);
        FileReference cerRef06 = new FileReference(2, "c012");
        FileEntry fileEntry06 = new FileEntry(dirRefApp, cerRef06);
        FileReference cerRef07 = new FileReference(2, "c015");
        FileEntry fileEntry07 = new FileEntry(dirRefApp, cerRef07);
        FileReference cerRef08 = new FileReference(2, "c016");
        FileEntry fileEntry08 = new FileEntry(dirRefApp, cerRef08);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin02, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, OCFCertificateInfo.Usage.SIG, new long[]{idOfFile03, idOfFile04});
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, idOfPin03, idOfFile05, idOfKey02, OCFCertificateInfo.ChainEntry.USER, OCFCertificateInfo.Usage.SIG, new long[]{idOfFile07, idOfFile08});
        OCFCertificateInfo info04 = new OCFCertificateInfo(idOfCard, -1L, idOfFile06, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        CardPinImpl pin02 = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN1", idOfPin02, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID02, new long[]{idOfKey01});
        CardPinImpl pin03 = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN2", idOfPin03, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID03, new long[]{idOfKey02});
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cer1", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "ca1", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, info02);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "attrCer1.1", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplication, pTerminal.getID(), this.slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "attrCer1.2", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication, pTerminal.getID(), this.slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file05 = new CardFileImpl(Disposeable.NO_LOCK, "cer2", idOfFile05, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry05, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardFileImpl file06 = new CardFileImpl(Disposeable.NO_LOCK, "ca2", idOfFile06, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry06, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, info04);
        CardFileImpl file07 = new CardFileImpl(Disposeable.NO_LOCK, "attrCer2.1", idOfFile07, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry07, idOfCard, idOfApplication, pTerminal.getID(), this.slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardFileImpl file08 = new CardFileImpl(Disposeable.NO_LOCK, "attrCer2.2", idOfFile08, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry08, idOfCard, idOfApplication, pTerminal.getID(), this.slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, NAME_QES_SIGNATURE_KEY, idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin02, k01);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey2", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry04, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info03, idOfFile05, idOfPin03, k02);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider01 = this.createDefaultAlgorithmProviderSignatureAndOrAuthentication(Arrays.asList(UsageRelated.Usage.SIGNATURE));
        key01.setAlgorithmProvider(algorithmProvider01);
        key02.setAlgorithmProvider(algorithmProvider01);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl(AID_SHORT_ESIGN, idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry03, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putFile(file03);
        applicationApp.putFile(file04);
        applicationApp.putFile(file05);
        applicationApp.putFile(file06);
        applicationApp.putFile(file07);
        applicationApp.putFile(file08);
        applicationApp.putPin(pin02);
        applicationApp.putPin(pin03);
        applicationApp.putKey(key01);
        applicationApp.putKey(key02);
        return applicationApp;
    }

    private CardApplication createEUserPKIApp(Terminal pTerminal, int pSlotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID("82");
        FileReference dirRefApp = new FileReference(4, AID_SHORT_EUSERPKI);
        FileReference cerRef01 = new FileReference(2, "c003");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        FileReference cerRef02 = new FileReference(2, "c001");
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerUserPKI", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "caUserPKI", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), -1L, info02);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, KEY_NAME_AUTHENTICATION_DECRYPTION, idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType()}), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info01, new long[]{idOfFile01}, null, new long[]{idOfPinCH}, k01);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider01 = this.createDefaultAlgorithmProviderSignatureAndOrAuthentication(Arrays.asList(UsageRelated.Usage.AUTHENTICATION, UsageRelated.Usage.SIGNATURE));
        AlgorithmProvider<OCFPrivateKey> algorithmProvider02 = this.createDefaultAlgorithmProviderDecryption();
        ArrayList algorithms = new ArrayList();
        algorithms.addAll(algorithmProvider01.getAlgorithms());
        algorithms.addAll(algorithmProvider02.getAlgorithms());
        try {
            key01.setAlgorithmProvider(DefaultBaseAlgorithmProviderBuilder.createAlgorithmProvider(algorithms));
        }
        catch (Exception e) {
            key01.setAlgorithmProvider(algorithmProvider01);
            LOG.debug((Object)"failed creating complete algorithm provider with signature/authentication/decryption");
        }
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl(AID_SHORT_EUSERPKI, idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    @Override
    public final Integer getMaxPINLengthInit(OCFCertificateInfo _info) {
        return INIT_LENGTH;
    }

    @Override
    public final Integer getMinPINLengthInit(OCFCertificateInfo _info) {
        return INIT_LENGTH;
    }

    @Override
    public final int getPasswordBlockLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    protected byte[] getPaddedPIN(OCFCertificateInfo _info, char[] _pin) {
        return this.getPinEncoder(_info).encode(_pin);
    }

    @Override
    public final PinEncoder getPinEncoder(OCFCertificateInfo _info) {
        return PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK;
    }

    @Override
    public final byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        return -1;
    }

    @Override
    public final int getMinPINLength(OCFCertificateInfo info) {
        return 6;
    }

    @Override
    public final int getMaxPINLength(OCFCertificateInfo info) {
        return 12;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA1");
            c.add("SHA224");
            c.add("SHA384");
            c.add("SHA512");
            c.add("SHA256");
        }
        return c;
    }

    @Override
    public void postInitializeCard() {
        if (this.isStapleSign()) {
            try {
                CardKey keyByName = this.getCardObject().getKeyByName(KEY_NAME_AUTHENTICATION_DECRYPTION, 1);
                if (keyByName != null && keyByName.getInfo() != null) {
                    X509Certificate x509Certificate = keyByName.getInfo().getX509Certificate();
                    X500Name subject = X500Name.getInstance((Object)x509Certificate.getSubjectX500Principal().getEncoded());
                    for (RDN rdn : subject.getRDNs()) {
                        System.out.println(rdn.getTypesAndValues()[0].getType().getId());
                    }
                    RDN[] rdns = subject.getRDNs(BCStyle.UID);
                    if (rdns != null && rdns.length > 0) {
                        this.displayName = "Bundesnotarkammer (V3)- bea Basis, staple -";
                        this.cardType = Card.CardTypeEnum.BNOTK3_BEA_STAPLE;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isMultiAuthenticate(OCFCertificateInfo info) {
        OCFCertificateInfo.Usage u = info.getUsage();
        return (u == OCFCertificateInfo.Usage.AUT || u == OCFCertificateInfo.Usage.AEN) && this.cardType == Card.CardTypeEnum.BNOTK3_BEA_STAPLE;
    }

    static {
        LinkedHashMap<String, String> tmp = new LinkedHashMap<String, String>();
        tmp.put(IMAGE_ID_MULTI, "Version Multisignaturkarte");
        tmp.put(IMAGE_ID_STAPLE, "Version Stapelsignatur");
        MAP_IMAGE_ID = Collections.unmodifiableMap(tmp);
    }
}

