/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.starcos;

import de.bos_bremen.basecard.common.crypto.Algorithm;
import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OCFDefaultAlgorithmFinder;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSession;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.MaxSignatureCountReachedException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS34;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class StarCOS34DTrust30
extends StarCOS34 {
    public static final int TRANSPORT_STATE = 25281;
    private static final Log LOG = LogFactory.getLog(StarCOS34DTrust30.class);
    private final String displayName;
    private final String tokenLabel;
    private final boolean stapleSign;
    private final boolean multiSign;
    private final Card.CardTypeEnum cardType;

    public StarCOS34DTrust30(String displayName, String tokenLabel, boolean stapleSign, boolean multiSign, Card.CardTypeEnum cardType) {
        this.displayName = displayName;
        this.tokenLabel = tokenLabel;
        this.stapleSign = stapleSign;
        this.multiSign = multiSign;
        this.cardType = cardType;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final boolean isMultiSign() {
        return this.multiSign;
    }

    @Override
    public boolean isStapleSign() {
        return this.stapleSign || GovCS.isStapleSign(this);
    }

    @Override
    protected final boolean isIssuerReadRequired() {
        return true;
    }

    @Override
    protected String getIssuerConstant() {
        return this.tokenLabel;
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        String readPKCS15TokenInfoFromCard = super.readPKCS15TokenInfoFromCard(_channel);
        if (readPKCS15TokenInfoFromCard != null && readPKCS15TokenInfoFromCard.contains(this.tokenLabel)) {
            return this.tokenLabel;
        }
        return null;
    }

    @Override
    public final Integer getStapleSignCounter() {
        return this.stapleSign ? Integer.valueOf(100) : (this.isStapleSign() ? MAXIMUM_COUNT_OF_STAPLE_SIGNATURES : null);
    }

    @Override
    protected final Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        long idOfPinCH = 2000001L;
        byte pinID = 1;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardPinImpl pinCH = new CardPinImpl(Disposeable.NO_LOCK, "PIN.CH", idOfPinCH, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000001L});
        CardApplication applicationDFCERTS = this.createDFCerts(terminal, slotID, idOfCard, idOfMFApplication, idOfPinCH, idOfPinCH);
        CardApplication applicationESIGN = this.createESignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPinCH);
        CardApplication applicationQES = this.createQESApp(terminal, slotID, idOfCard, idOfMFApplication);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationDFCERTS);
        mfManager.putApplication(applicationESIGN);
        mfManager.putApplication(applicationQES);
        mfManager.putPin(pinCH);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.MF.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.cardType.getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createDFCerts(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH, long idOfPinQES) {
        String aid = "a000000244465f4365727473";
        long idOfApplication = 1000002L;
        long idOfFile01 = 3000003L;
        long idOfFile02 = 3000004L;
        long idOfFile03 = 3000005L;
        long idOfFile04 = 3000006L;
        long idOfFile05 = 3000007L;
        long idOfFile06 = 3000008L;
        long idOfKey01 = 4000001L;
        long idOfKey02 = 4000002L;
        FileReference dirRefApp = new FileReference(4, aid);
        FileReference cerRefC_CH_ESIGN = new FileReference(2, "c100");
        FileEntry fileEntryC_CH_ESIGN = new FileEntry(dirRefApp, cerRefC_CH_ESIGN);
        FileReference cerRefSCA_CH_ESIGN = new FileReference(2, "c101");
        FileEntry fileEntrySCA_CH_ESIGN = new FileEntry(dirRefApp, cerRefSCA_CH_ESIGN);
        FileReference cerRefRCA_CH_ESIGN = new FileReference(2, "c102");
        FileEntry fileEntryRCA_CH_ESIGN = new FileEntry(dirRefApp, cerRefRCA_CH_ESIGN);
        FileReference cerRefC_CH_QES = new FileReference(2, "c103");
        FileEntry fileEntryC_CH_QES = new FileEntry(dirRefApp, cerRefC_CH_QES);
        FileReference cerRefSCA_CH_QES = new FileReference(2, "c104");
        FileEntry fileEntrySCA_CH_QES = new FileEntry(dirRefApp, cerRefSCA_CH_QES);
        FileReference cerRefRCA_CH_QES = new FileReference(2, "c105");
        FileEntry fileEntryRCA_CH_QES = new FileEntry(dirRefApp, cerRefRCA_CH_QES);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, -1L, idOfFile03, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo info05 = new OCFCertificateInfo(idOfCard, -1L, idOfFile05, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info06 = new OCFCertificateInfo(idOfCard, -1L, idOfFile06, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerESIGN", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryC_CH_ESIGN, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "scaESIGN", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntrySCA_CH_ESIGN, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info02);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "rcaESIGN", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryRCA_CH_ESIGN, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info03);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "cerQES", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryC_CH_QES, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardFileImpl file05 = new CardFileImpl(Disposeable.NO_LOCK, "scaQES", idOfFile05, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntrySCA_CH_QES, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info05);
        CardFileImpl file06 = new CardFileImpl(Disposeable.NO_LOCK, "rcaQES", idOfFile06, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntryRCA_CH_QES, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info06);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl(aid, idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntryC_CH_ESIGN, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putFile(file03);
        applicationApp.putFile(file04);
        applicationApp.putFile(file05);
        applicationApp.putFile(file06);
        return applicationApp;
    }

    private CardApplication createESignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        String aid = "a000000167455349474e";
        long idOfApplication = 1000009L;
        long idOfFile01 = 3000003L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID("81");
        FileReference dirRefApp = new FileReference(4, aid);
        FileReference fileRef = new FileReference(2, "c100");
        FileEntry fileEntry = new FileEntry(dirRefApp, fileRef);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "AutDecKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ADVANCED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType()}), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPinCH, k01);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider01 = this.createDefaultAutDecAlgorithmProvider();
        key01.setAlgorithmProvider(algorithmProvider01);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl(aid, idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType()}), fileEntry, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putKey(key01);
        return applicationApp;
    }

    private CardApplication createQESApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication) {
        String aid = "d27600006601";
        long idOfApplication = 1000010L;
        long idOfFile04 = 3000006L;
        long idOfPinQES = 2000002L;
        long idOfKey02 = 4000002L;
        byte pinID = -127;
        KeyID k02 = new KeyID("84");
        FileReference dirRefApp = new FileReference(4, aid);
        FileReference fileRef = new FileReference(2, "c100");
        FileEntry fileEntry = new FileEntry(dirRefApp, fileRef);
        OCFCertificateInfo info04 = new OCFCertificateInfo(idOfCard, idOfPinQES, idOfFile04, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardPinImpl pinQES = new CardPinImpl(Disposeable.NO_LOCK, "PIN.QES", idOfPinQES, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey02});
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "QESSignatureKey", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.DEFAULT_QUALIFIED_SIGNATURE.getType()}), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info04, idOfFile04, idOfPinQES, k02);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider01 = this.createDefaultSignatureAlgorithmProvider();
        key02.setAlgorithmProvider(algorithmProvider01);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl(aid, idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType(), CardApplication.CardApplicationTypeEnum.QUALIFIED_SIGNATURE.getType()}), fileEntry, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putPin(pinQES);
        applicationApp.putKey(key02);
        return applicationApp;
    }

    private void selectForPin(OCFCertificateInfo _info, CardChannel cardChannel) throws ResponseCodeException, CardTerminalException {
        if (_info.getPinID() == -127) {
            this.selectSubDirectory(cardChannel, _info.getPin().getParentApplication().getFileEntry().getDirectory());
        } else {
            this.selectSubDirectory(cardChannel, _info.getKey().getParentApplication().getFileEntry().getDirectory());
        }
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA256");
        }
        return c;
    }

    private AlgorithmProvider<OCFPrivateKey> createDefaultSignatureAlgorithmProvider() {
        List<Algorithm<OCFPrivateKey, ?>> listKeyAlgorithms01 = this.createDefaultSignatureAuthenticationAlgorithms(Arrays.asList(UsageRelated.Usage.SIGNATURE));
        return this.createAlgorithmProvider(listKeyAlgorithms01);
    }

    private AlgorithmProvider<OCFPrivateKey> createDefaultAutDecAlgorithmProvider() {
        List<Algorithm<OCFPrivateKey, ?>> listKeyAlgorithms01 = this.createDefaultSignatureAuthenticationAlgorithms(Arrays.asList(UsageRelated.Usage.AUTHENTICATION, UsageRelated.Usage.SIGNATURE));
        listKeyAlgorithms01.addAll(this.createDefaultCipherAlgorithms());
        return this.createAlgorithmProvider(listKeyAlgorithms01);
    }

    private List<Algorithm<OCFPrivateKey, ?>> createDefaultSignatureAuthenticationAlgorithms(List<UsageRelated.Usage> usageList01) {
        String name;
        ArrayList listKeyAlgorithms01 = new ArrayList();
        try {
            name = "SHA256withRSA";
            listKeyAlgorithms01.add(new Algorithm("OCF", usageList01, name + "andMGF1", name + "/PSS", new CardExecutionSignAuthenticateParameterSpec(name + "andMGF1", OCFDefaultAlgorithmFinder.getInstance().find(name + "andMGF1"), Boolean.FALSE, HexUtil.parse("133330"))));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        try {
            name = "SHA256hashedWithRSA";
            listKeyAlgorithms01.add(new Algorithm("OCF", usageList01, name + "andMGF1", name + "/PSS", new CardExecutionSignAuthenticateParameterSpec("SHA256hashedWithRSAandMGF1", OCFDefaultAlgorithmFinder.getInstance().find(name + "andMGF1"), Boolean.FALSE, HexUtil.parse("133330"))));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        try {
            name = "SHA256withRSA";
            listKeyAlgorithms01.add(new Algorithm("OCF", usageList01, name, name + "/PKCS1", new CardExecutionSignAuthenticateParameterSpec(name, OCFDefaultAlgorithmFinder.getInstance().find(name), Boolean.TRUE, HexUtil.parse("1323"))));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        try {
            name = "SHA256hashedWithRSA";
            listKeyAlgorithms01.add(new Algorithm("OCF", usageList01, name, name + "/PKCS1", new CardExecutionSignAuthenticateParameterSpec(name, OCFDefaultAlgorithmFinder.getInstance().find(name), Boolean.TRUE, HexUtil.parse("1323"))));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        return listKeyAlgorithms01;
    }

    @Override
    protected final synchronized boolean isKeyInitialized(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        ResponseAPDU res = this.getPinState(_channel, _info);
        int errorCode = res.sw();
        return errorCode != 25281;
    }

    @Override
    protected final int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        int errorCode;
        this.selectForPin(_info, _channel);
        String pinName = StarCOS34DTrust30.getPinNameForInfo(_info);
        ResponseAPDU res = this.getPinState(_channel, _info);
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            LOG.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 25281) {
            throw new NotYetInitializedException(pinName, errorCode, message);
        }
        if (errorCode == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }

    private ResponseAPDU getPinState(CardChannel cardChannel, OCFCertificateInfo info) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        this.selectForPin(info, cardChannel);
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(info.getPinID());
        byte[] cb = cmd.getBytes();
        cb[0] = -128;
        cmd = new CommandAPDU(cb);
        LOG.debug((Object)("PS CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = cardChannel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("PS RESULT : " + HexString.hexify(res.getBuffer(), false)));
        return res;
    }

    @Override
    public final int getPasswordBlockLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    protected final byte[] getPaddedPIN(OCFCertificateInfo _info, char[] _pin) {
        return this.get2BlockPin(_info, _pin);
    }

    @Override
    public final PinEncoder getPinEncoder(OCFCertificateInfo _info) {
        return PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK;
    }

    @Override
    public final byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        return -1;
    }

    @Override
    public final Integer getMaxPINLengthInit(OCFCertificateInfo info) {
        return info.getPinID() == -127 ? Integer.valueOf(5) : null;
    }

    @Override
    public final Integer getMinPINLengthInit(OCFCertificateInfo info) {
        return info.getPinID() == -127 ? Integer.valueOf(5) : null;
    }

    @Override
    public final int getMinPINLength(OCFCertificateInfo info) {
        return 6;
    }

    @Override
    public final int getMaxPINLength(OCFCertificateInfo info) {
        return 12;
    }

    @Override
    protected final GovCS.ResultObject authentify(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        this.selectForPin(_info, _channel);
        return super.signHash(_channel, _info, _hashValue, _hashAlgorithm, algorithmParameters);
    }

    @Override
    public final synchronized GovCS.ResultObject signHash(OCFCertificateInfo _info, byte[] _hashValue, char[] _pin, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        if (OCFProvider.Settings.getInstance().isStapleSignatureEnabled() && this.isStapleSign() || OCFProvider.Settings.getInstance().isServerEnvironmentActive() && this.isMultiSign()) {
            return this.signHashServer(_info, _hashValue, _pin, _hashAlgorithm, algorithmParameters);
        }
        return super.signHash(_info, _hashValue, _pin, _hashAlgorithm, algorithmParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized GovCS.ResultObject signHashServer(OCFCertificateInfo _info, byte[] _hashValue, char[] _pin, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        if (this.getAvailableHashAlgorithmNames(_info).indexOf(_hashAlgorithm) < 0) {
            throw new ResponseCodeException(65535, "hash algorithm not supported by card: " + _hashAlgorithm, new NoSuchAlgorithmException("OperationCancelledException"));
        }
        ProgressSession session = new ProgressSession(2);
        session.setStepCount(6);
        session.setProgressMessage("init sign hash operation");
        if (this.progressSessionListener != null) {
            this.progressSessionListener.progressSessionWillStart(session);
            this.progressSessionListener.progressSessionStarted(session);
        }
        CardChannelManager cm = new CardChannelManager();
        try {
            cm.init(this, true, false);
            boolean localTransaction = cm.isTransactionLocallyStarted();
            try {
                this.checkSignCounter(null, localTransaction);
            }
            catch (MaxSignatureCountReachedException e) {
                cm.allocate();
                this.resetCard(cm.getCardChannel());
                throw e;
            }
            GovCS.ResultObject ro = new GovCS.ResultObject();
            ro = this.signHashServerInt(_info, _hashValue, _pin, _hashAlgorithm, session, ro, algorithmParameters);
            if (ro.getResultCode() == 36864) {
                try {
                    this.increaseAndCheckSignCounter(null, localTransaction);
                }
                catch (MaxSignatureCountReachedException e) {
                    cm.allocate();
                    this.resetCard(cm.getCardChannel());
                }
            }
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cm.destroy();
        }
    }

    @Override
    protected final CommandAPDU createDecryptCommand(byte[] _encryptedBytes, byte _paddingIndicator, AlgorithmParameters algorithmParameters) {
        int index = 0;
        byte[] store = new byte[10 + _encryptedBytes.length];
        store[index++] = 0;
        store[index++] = 42;
        store[index++] = -128;
        store[index++] = -122;
        store[index++] = 0;
        int len = _encryptedBytes.length + 1;
        store[index++] = (byte)(len >> 8 & 0xFF);
        store[index++] = (byte)(len >> 0 & 0xFF);
        store[index++] = _paddingIndicator;
        System.arraycopy(_encryptedBytes, 0, store, index, _encryptedBytes.length);
        index += _encryptedBytes.length;
        store[index++] = 1;
        store[index++] = 0;
        return new CommandAPDU(store);
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 1: {
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                data.write(-124);
                data.write(_info.getKeyID().getID().length);
                data.write(_info.getKeyID().getID(), 0, _info.getKeyID().getID().length);
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-72, data.toByteArray());
            }
            case 0: 
            case 2: {
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    data.write(-124);
                    data.write(_info.getKeyID().getID().length);
                    data.write(_info.getKeyID().getID());
                    byte[] algorithm = new byte[]{19, 51, 48};
                    try {
                        CardExecutionSignAuthenticateParameterSpec parameterSpec = algorithmParameters.getParameterSpec(CardExecutionSignAuthenticateParameterSpec.class);
                        if (parameterSpec.getAlgorithmID() != null) {
                            algorithm = parameterSpec.getAlgorithmID();
                        }
                    }
                    catch (InvalidParameterSpecException e) {
                        LOG.debug((Object)e);
                    }
                    data.write(-119);
                    data.write(algorithm.length);
                    data.write(algorithm);
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
                }
                catch (IOException ex) {
                    LOG.debug((Object)ex);
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    protected final boolean usesASN1HeaderWithAuthentify() {
        return true;
    }

    @Override
    protected final boolean usesASN1HeaderWithSignHash() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GovCS.ResultObject signHashServerInt(OCFCertificateInfo _info, byte[] _hashValue, char[] _pin, String _hashAlgorithm, ProgressSession session, GovCS.ResultObject ro, AlgorithmParameters algorithmParameters) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException {
        CardChannelManager cardChannelManager = new CardChannelManager();
        CardChannel channel = null;
        try {
            this.fireProgressEvent(session, "get connection to the device");
            channel = cardChannelManager.init(this);
            this.fireProgressEvent(session, "select application on card");
            if (!this.checkChannelState(channel, _info)) {
                this.selectForPin(_info, channel);
            }
            boolean loop = true;
            this.fireProgressEvent(session, "install corresponding security environment");
            ro = this.setSecurityEnvironment(channel, _info, 0, _hashAlgorithm, algorithmParameters);
            if (ro.getResultCode() != 36864) {
                LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                GovCS.ResultObject resultObject = ro;
                return resultObject;
            }
            while (loop) {
                this.fireProgressEvent(session, "sign the given hash value");
                ro = this.signHash(channel, _info, _hashValue, _hashAlgorithm, algorithmParameters);
                if (ro.getResultCode() == 27010) {
                    this.resetChannelState(channel);
                    try {
                        this.checkSignCounter(channel, false);
                    }
                    catch (MaxSignatureCountReachedException maxSignatureCountReachedException) {
                        // empty catch block
                    }
                    this.selectFile(channel, _info, false);
                    this.fireProgressEvent(session, "verify the corresponding password");
                    ro.setResultCode(this.verifyPassword(channel, _info, _pin));
                    if (ro.getResultCode() != 36864) {
                        LOG.debug((Object)APDUCommands.getVerifyErrorMsg(ro.getResultCode()));
                        GovCS.ResultObject resultObject = ro;
                        return resultObject;
                    }
                    this.fireProgressEvent(session, "install corresponding security environment");
                    ro = this.setSecurityEnvironment(channel, _info, 0, _hashAlgorithm, algorithmParameters);
                    if (ro.getResultCode() != 36864) {
                        LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                        GovCS.ResultObject resultObject = ro;
                        return resultObject;
                    }
                    loop = true;
                    continue;
                }
                this.fireProgressEvent(session, "operation finished!");
                loop = false;
            }
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (CardTerminalException ex) {
            LOG.debug((Object)"", (Throwable)ex);
            ro.setResultCode(0);
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            ro.setResultCode(0);
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cardChannelManager.destroy();
            if (this.progressSessionListener != null) {
                while (session.getCurrentStep() != session.getStepCount()) {
                    session.increaseCurrentStep();
                }
                session.setProgressMessage("done!");
                this.progressSessionListener.progressSessionWillStop(session);
                this.progressSessionListener.progressSessionStopped(session);
            }
        }
    }
}

