/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.starcos;

import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.base.DefaultHBA;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StarCOS32DGNService
extends DefaultHBA {
    private static final Log LOG = LogFactory.getLog(StarCOS32DGNService.class);
    static final String DGN_ISSUER_CONSTANT = "DGN sprint/business";
    private Integer stapleSignCounter = null;
    private boolean stapleSign = true;
    private final String BUSINESS = "StarCOS 3.2 - DGN (business)";
    private final String SPRINT = "StarCOS 3.2 - DGN (sprint)";
    private String displayName = "StarCOS 3.2 - DGN (unknown)";
    private Card.CardTypeEnum cardType = Card.CardTypeEnum.DGN2BUSINESS;

    @Override
    protected final Card.CardTypeEnum getCardTypeEnum() {
        return this.cardType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, smartcard, blocking);
        Object applicant = new Object();
        CardChannel channel = null;
        try {
            block19: {
                channel = scheduler.allocateCardChannel(applicant, false);
                ResponseAPDU response = channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("00a4040c06d27600006601")));
                if (36864 != response.sw()) {
                    return;
                }
                response = channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("00a4020c020015")));
                if (36864 != response.sw()) {
                    return;
                }
                response = channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("00b2010400")));
                if (36864 != response.sw()) {
                    return;
                }
                if (response.data() == null || response.data().length == 0) {
                    return;
                }
                byte[] data = response.data();
                LOG.debug((Object)("DINSIG-PWDD#1: " + HexUtil.dump(data)));
                byte[] sigCounterTag = HexUtil.parse("9f22");
                int indexSigCounterTag = ByteUtil.indexOf(data, sigCounterTag);
                if (indexSigCounterTag > 0) {
                    data = ByteUtil.subbytes(data, indexSigCounterTag);
                    try {
                        data = new ASN1(data).getValue();
                        Integer sigCounterValue = new BigInteger(1, data).intValue();
                        LOG.debug((Object)("count of signatures detected: " + sigCounterValue));
                        if (sigCounterValue > 1) {
                            this.init("StarCOS 3.2 - DGN (business)", true, sigCounterValue, Card.CardTypeEnum.DGN2BUSINESS);
                            break block19;
                        }
                        this.initSprint();
                    }
                    catch (IOException e) {
                        this.initSprint();
                    }
                } else {
                    this.initSprint();
                }
            }
            LOG.debug((Object)("concrete card: " + this.displayName));
        }
        catch (CardTerminalException e) {
            LOG.debug((Object)"failed to detect staple sign possibilities");
        }
        finally {
            if (channel != null) {
                scheduler.releaseCardChannel(channel);
            }
        }
    }

    private void initSprint() {
        this.init("StarCOS 3.2 - DGN (sprint)", false, null, Card.CardTypeEnum.DGN2SPRINT);
    }

    private void init(String displayName, boolean stapleSign, Integer sigCounterValue, Card.CardTypeEnum dgn2business) {
        this.displayName = displayName;
        this.stapleSign = stapleSign;
        this.stapleSignCounter = sigCounterValue;
        this.cardType = dgn2business;
    }

    @Override
    protected final String getIssuerConstant() {
        return DGN_ISSUER_CONSTANT;
    }

    @Override
    public final String getDisplayName() {
        return "StarCOS 3.2 - DGN (sprintCard/businessCard)";
    }

    @Override
    protected final boolean isIssuerReadRequired() {
        return true;
    }

    @Override
    public final boolean isMultiSign() {
        return false;
    }

    @Override
    public final boolean isStapleSign() {
        return this.stapleSign;
    }

    @Override
    public final Integer getStapleSignCounter() {
        return this.stapleSignCounter;
    }

    @Override
    protected final String readIssuerFromATR(CardChannel _channel) {
        try {
            CommandAPDU cmd = null;
            ResponseAPDU res = null;
            int err = 36864;
            boolean tryGetData = false;
            cmd = this.createSelectMasterFile();
            if (cmd != null) {
                res = _channel.sendCommandAPDU(cmd);
                if (res == null) {
                    tryGetData = true;
                }
                if ((err = res.sw()) != 36864) {
                    tryGetData = true;
                }
            }
            if ((res = _channel.sendCommandAPDU(new CommandAPDU(HexString.parseHexString("00 a4 04 0c 09 d2 76 00 00 25 4e 50 01 00")))) == null) {
                return "";
            }
            err = res.sw();
            if (err == 36864) {
                String hbaIssuer = super.readIssuerFromATR(_channel);
                if (!"HBA".equals(hbaIssuer)) {
                    return "";
                }
                return DGN_ISSUER_CONSTANT;
            }
            return "";
        }
        catch (Throwable ex) {
            LOG.error((Object)"", ex);
            return null;
        }
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (!"83".equals(HexString.hexify(_info.getKeyID().id))) {
            c.add("SHA1");
            c.add("RIPEMD160");
            c.add("SHA224");
            c.add("SHA384");
            c.add("SHA512");
            c.add("SHA256");
        }
        return c;
    }

    @Override
    public final int getMinPINLength(OCFCertificateInfo _info) {
        return 6;
    }

    @Override
    public final int getMaxPINLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    public final Integer getMinPINLengthInit(OCFCertificateInfo _info) {
        if ("84".equals(HexUtil.hexify(_info.getKeyID().id))) {
            return 5;
        }
        return 4;
    }

    @Override
    public final Integer getMaxPINLengthInit(OCFCertificateInfo _info) {
        if ("84".equals(HexUtil.hexify(_info.getKeyID().id))) {
            return 5;
        }
        return 4;
    }
}

