/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.starcos;

import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StarCOS32
extends GovCS {
    private static final Log log = LogFactory.getLog(StarCOS32.class);
    private static final byte[][] HISTORICALS = new byte[][]{HexString.parseHexString("00 64 05 1e b2 00 31 b0 73 96 21 db 05 90 00")};
    private int historicalsIndex = 0;

    @Override
    protected String getIssuerConstant() {
        return null;
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS[this.historicalsIndex];
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        if (Objects.isNull(_historicals)) {
            return false;
        }
        this.historicalsIndex = -1;
        for (int i = 0; i < HISTORICALS.length; ++i) {
            byte[] historicals = HISTORICALS[i];
            if (historicals.length != _historicals.length) continue;
            boolean diff = false;
            for (int j = 0; j < _historicals.length && !diff; ++j) {
                diff = historicals[j] != _historicals[j];
            }
            if (diff) continue;
            this.historicalsIndex = i;
            break;
        }
        return this.historicalsIndex >= 0 && this.historicalsIndex < HISTORICALS.length;
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        long idOfPin = 2000001L;
        byte pinID = 1;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Authentisierungs-/Verschl\u00fcsselungs-PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000003L, 4000004L});
        CardApplication applicationESIGN = this.createESignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardApplication applicationQSIGN = this.createQSignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationESIGN);
        mfManager.putApplication(applicationQSIGN);
        mfManager.putPin(pin);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.getCardTypeEnum().getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createQSignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000002L;
        long idOfPin01 = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfKey01 = 4000001L;
        long idOfKey02 = 4000002L;
        long idOfFile12 = 3000012L;
        long idOfFile13 = 3000013L;
        long idOfFile14 = 3000014L;
        long idOfFile15 = 3000015L;
        long idOfFile16 = 3000016L;
        long idOfFile17 = 3000017L;
        long idOfFile18 = 3000018L;
        long idOfFile19 = 3000019L;
        long idOfFile20 = 3000020L;
        long idOfFile21 = 3000021L;
        KeyID k01 = new KeyID("84");
        KeyID k02 = new KeyID("85");
        byte pinID01 = -127;
        FileReference dirRefApp = new FileReference(4, "d27600006601");
        FileReference cerRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        FileReference cerRef02 = new FileReference(2, "c001");
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02);
        FileReference cerRef12 = new FileReference(2, "c100");
        FileEntry fileEntry12 = new FileEntry(dirRefApp, cerRef12);
        FileReference cerRef13 = new FileReference(2, "c101");
        FileEntry fileEntry13 = new FileEntry(dirRefApp, cerRef13);
        FileReference cerRef14 = new FileReference(2, "c102");
        FileEntry fileEntry14 = new FileEntry(dirRefApp, cerRef14);
        FileReference cerRef15 = new FileReference(2, "c103");
        FileEntry fileEntry15 = new FileEntry(dirRefApp, cerRef15);
        FileReference cerRef16 = new FileReference(2, "c104");
        FileEntry fileEntry16 = new FileEntry(dirRefApp, cerRef16);
        FileReference cerRef17 = new FileReference(2, "c105");
        FileEntry fileEntry17 = new FileEntry(dirRefApp, cerRef17);
        FileReference cerRef18 = new FileReference(2, "c008");
        FileEntry fileEntry18 = new FileEntry(dirRefApp, cerRef18);
        FileReference cerRef19 = new FileReference(2, "c009");
        FileEntry fileEntry19 = new FileEntry(dirRefApp, cerRef19);
        FileReference cerRef20 = new FileReference(2, "c00e");
        FileEntry fileEntry20 = new FileEntry(dirRefApp, cerRef20);
        FileReference cerRef21 = new FileReference(2, "c00f");
        FileEntry fileEntry21 = new FileEntry(dirRefApp, cerRef21);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, new long[]{idOfFile12, idOfFile13, idOfFile14});
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, new long[]{idOfFile15, idOfFile16, idOfFile17});
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{idOfKey01, idOfKey02});
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig1", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig2", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardFileImpl file12 = new CardFileImpl(Disposeable.NO_LOCK, "sigAttrCer1_1", idOfFile12, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry12, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file13 = new CardFileImpl(Disposeable.NO_LOCK, "sigAttrCer1_2", idOfFile13, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry13, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file14 = new CardFileImpl(Disposeable.NO_LOCK, "sigAttrCer1_3", idOfFile14, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry14, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file15 = new CardFileImpl(Disposeable.NO_LOCK, "sigAttrCer2_1", idOfFile15, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry15, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file16 = new CardFileImpl(Disposeable.NO_LOCK, "sigAttrCer2_2", idOfFile16, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry16, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardFileImpl file17 = new CardFileImpl(Disposeable.NO_LOCK, "sigAttrCer2_3", idOfFile17, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry17, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardFileImpl file18 = new CardFileImpl(Disposeable.NO_LOCK, "caCer1", idOfFile18, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry18, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L);
        CardFileImpl file19 = new CardFileImpl(Disposeable.NO_LOCK, "caCer2", idOfFile19, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry19, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L);
        CardFileImpl file20 = new CardFileImpl(Disposeable.NO_LOCK, "rootCA1", idOfFile20, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry20, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L);
        CardFileImpl file21 = new CardFileImpl(Disposeable.NO_LOCK, "rootCA2", idOfFile21, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry21, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey1", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, new long[]{idOfFile01, idOfFile18, idOfFile20}, new long[]{idOfFile12, idOfFile13, idOfFile14}, new long[]{idOfPin01}, k01);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey2", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info02, new long[]{idOfFile02, idOfFile19, idOfFile21}, new long[]{idOfFile15, idOfFile16, idOfFile17}, new long[]{idOfPin01}, k02);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("d27600006601", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putPin(pin01);
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putFile(file12);
        applicationApp.putFile(file13);
        applicationApp.putFile(file14);
        applicationApp.putFile(file15);
        applicationApp.putFile(file16);
        applicationApp.putFile(file17);
        applicationApp.putFile(file18);
        applicationApp.putFile(file19);
        applicationApp.putFile(file20);
        applicationApp.putFile(file21);
        applicationApp.putKey(key01);
        applicationApp.putKey(key02);
        return applicationApp;
    }

    private CardApplication createESignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfFile03 = 3000003L;
        long idOfFile04 = 3000004L;
        long idOfFile05 = 3000005L;
        long idOfFile06 = 3000006L;
        long idOfFile07 = 3000007L;
        long idOfFile08 = 3000008L;
        long idOfFile09 = 3000009L;
        long idOfFile10 = 3000010L;
        long idOfFile11 = 3000011L;
        long idOfFile22 = 3000022L;
        long idOfFile23 = 3000023L;
        long idOfFile24 = 3000024L;
        long idOfFile25 = 3000025L;
        long idOfFile26 = 3000026L;
        long idOfFile27 = 3000027L;
        long idOfKey03 = 4000003L;
        long idOfKey04 = 4000004L;
        KeyID k03 = new KeyID("1300");
        KeyID k04 = new KeyID("86");
        FileReference dirRefApp = new FileReference(4, "a000000167455349474e");
        FileReference cerRef03 = new FileReference(2, "c200");
        FileEntry fileEntry03 = new FileEntry(dirRefApp, cerRef03);
        FileReference cerRef04 = new FileReference(2, "c500");
        FileEntry fileEntry04 = new FileEntry(dirRefApp, cerRef04);
        FileReference cerRef05 = new FileReference(2, "c008");
        FileEntry fileEntry05 = new FileEntry(dirRefApp, cerRef05);
        FileReference cerRef06 = new FileReference(2, "c009");
        FileEntry fileEntry06 = new FileEntry(dirRefApp, cerRef06);
        FileReference cerRef07 = new FileReference(2, "c00e");
        FileEntry fileEntry07 = new FileEntry(dirRefApp, cerRef07);
        FileReference cerRef08 = new FileReference(2, "c208");
        FileEntry fileEntry08 = new FileEntry(dirRefApp, cerRef08);
        FileReference cerRef09 = new FileReference(2, "c20e");
        FileEntry fileEntry09 = new FileEntry(dirRefApp, cerRef09);
        FileReference cerRef10 = new FileReference(2, "c508");
        FileEntry fileEntry10 = new FileEntry(dirRefApp, cerRef10);
        FileReference cerRef11 = new FileReference(2, "c50e");
        FileEntry fileEntry11 = new FileEntry(dirRefApp, cerRef11);
        FileReference cerRef22 = new FileReference(2, "c501");
        FileEntry fileEntry22 = new FileEntry(dirRefApp, cerRef22);
        FileReference cerRef23 = new FileReference(2, "c509");
        FileEntry fileEntry23 = new FileEntry(dirRefApp, cerRef23);
        FileReference cerRef24 = new FileReference(2, "c50f");
        FileEntry fileEntry24 = new FileEntry(dirRefApp, cerRef24);
        FileReference cerRef25 = new FileReference(2, "c201");
        FileEntry fileEntry25 = new FileEntry(dirRefApp, cerRef25);
        FileReference cerRef26 = new FileReference(2, "c209");
        FileEntry fileEntry26 = new FileEntry(dirRefApp, cerRef26);
        FileReference cerRef27 = new FileReference(2, "c20f");
        FileEntry fileEntry27 = new FileEntry(dirRefApp, cerRef27);
        OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile03, idOfKey03, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info04 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile04, idOfKey04, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info05 = new OCFCertificateInfo(idOfCard, -1L, idOfFile05, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info06 = new OCFCertificateInfo(idOfCard, -1L, idOfFile06, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info07 = new OCFCertificateInfo(idOfCard, -1L, idOfFile07, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo info08 = new OCFCertificateInfo(idOfCard, -1L, idOfFile08, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info09 = new OCFCertificateInfo(idOfCard, -1L, idOfFile09, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo info10 = new OCFCertificateInfo(idOfCard, -1L, idOfFile10, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info11 = new OCFCertificateInfo(idOfCard, -1L, idOfFile11, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo info22 = new OCFCertificateInfo(idOfCard, -1L, idOfFile22, -1L, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info23 = new OCFCertificateInfo(idOfCard, -1L, idOfFile23, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info24 = new OCFCertificateInfo(idOfCard, -1L, idOfFile24, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo info25 = new OCFCertificateInfo(idOfCard, -1L, idOfFile25, -1L, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info26 = new OCFCertificateInfo(idOfCard, -1L, idOfFile26, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info27 = new OCFCertificateInfo(idOfCard, -1L, idOfFile27, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "cerEnc", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey03);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "cerX", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info04);
        CardFileImpl file05 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA05", idOfFile05, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry05, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info05);
        CardFileImpl file06 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA06", idOfFile06, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry06, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info06);
        CardFileImpl file07 = new CardFileImpl(Disposeable.NO_LOCK, "cerCAROOT07", idOfFile07, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry07, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info07);
        CardFileImpl file08 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA08", idOfFile08, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry08, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info08);
        CardFileImpl file09 = new CardFileImpl(Disposeable.NO_LOCK, "cerCAROOT09", idOfFile09, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry09, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info09);
        CardFileImpl file10 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA10", idOfFile10, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry10, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info10);
        CardFileImpl file11 = new CardFileImpl(Disposeable.NO_LOCK, "cerCAROOT11", idOfFile11, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry11, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info11);
        CardFileImpl file22 = new CardFileImpl(Disposeable.NO_LOCK, "cerUser01", idOfFile22, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry22, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info22);
        CardFileImpl file23 = new CardFileImpl(Disposeable.NO_LOCK, "cerCAaut09", idOfFile23, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry23, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info23);
        CardFileImpl file24 = new CardFileImpl(Disposeable.NO_LOCK, "cerCAROOTaut0f", idOfFile24, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry24, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info24);
        CardFileImpl file25 = new CardFileImpl(Disposeable.NO_LOCK, "cerUserEnc09", idOfFile25, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry25, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info25);
        CardFileImpl file26 = new CardFileImpl(Disposeable.NO_LOCK, "cerCAenc09", idOfFile26, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry26, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info26);
        CardFileImpl file27 = new CardFileImpl(Disposeable.NO_LOCK, "cerCAROOTenc0f", idOfFile27, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry27, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info27);
        CardKeyImpl key03 = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/DecryptionKey", idOfKey03, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType()}), fileEntry03, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info03, idOfFile03, idOfPinCH, k03);
        CardKeyImpl key04 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey04, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_ENCRYPTION.getType()}), fileEntry04, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info04, idOfFile04, idOfPinCH, k04);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("a000000167455349474e", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType(), CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntry03, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file03);
        applicationApp.putFile(file04);
        applicationApp.putFile(file05);
        applicationApp.putFile(file06);
        applicationApp.putFile(file07);
        applicationApp.putFile(file08);
        applicationApp.putFile(file09);
        applicationApp.putFile(file10);
        applicationApp.putFile(file11);
        applicationApp.putFile(file22);
        applicationApp.putFile(file23);
        applicationApp.putFile(file24);
        applicationApp.putFile(file25);
        applicationApp.putFile(file26);
        applicationApp.putFile(file27);
        applicationApp.putKey(key03);
        applicationApp.putKey(key04);
        return applicationApp;
    }

    protected Card.CardTypeEnum getCardTypeEnum() {
        return Card.CardTypeEnum.UNKNOWN_STARCOS32;
    }

    protected String readIssuerFromATR2(CardChannel _channel) {
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        try {
            String aidQES = "d27600006601";
            String aidESIGN = "a000000167455349474e";
            String fidSSD = "1f00";
            String fidKEY = "0010";
            String fidPWD = "0012";
            String fidKEYD = "0013";
            String fidPWDD = "0015";
            String fidKFPC = "0016";
            String fidALIAS = "0018";
            String fidCERT = "0019";
            String fidARR = "0030";
            String fidDO = "0031";
            String fidFCI = "0032";
            String fidSE = "0033";
            String fidRC = "0034";
            String fidRCD = "0035";
            String[] dfFids = new String[]{aidESIGN};
            String[] fids = new String[]{fidSSD, fidKEY, fidPWD, fidKEYD, fidPWDD, fidKFPC, fidALIAS, fidCERT, fidARR, fidDO, fidFCI, fidSE, fidRC, fidRCD};
            cmd = new CommandAPDU(HexString.parseHexString("00a4020c" + HexUtil.hexify(fidSSD.length() / 2) + fidSSD));
            res = _channel.sendCommandAPDU(cmd);
            if (res.sw() != 36864) {
                log.debug((Object)("\nNOT SELECTED FILE: " + fidSSD + ", " + HexUtil.hexify(res.sw())));
            } else {
                log.debug((Object)("\nSELECTED FILE: " + fidSSD));
            }
            cmd = new CommandAPDU(HexString.parseHexString("00a4040c06d27600006601"));
            res = _channel.sendCommandAPDU(cmd);
            cmd = new CommandAPDU(HexString.parseHexString("00240082102507040fffffffff26123456ffffffff"));
            res = _channel.sendCommandAPDU(cmd);
            for (int i = 0; i < dfFids.length; ++i) {
                cmd = new CommandAPDU(HexString.parseHexString("00a4040c" + HexUtil.hexify(dfFids[i].length() / 2) + dfFids[i]));
                res = _channel.sendCommandAPDU(cmd);
                if (res.sw() != 36864) {
                    log.debug((Object)("\nNOT SELECTED FILE: " + dfFids[i] + ", " + HexUtil.hexify(res.sw())));
                    continue;
                }
                log.debug((Object)("\nSELECTED: " + dfFids[i]));
                for (int j = 0; j < fids.length; ++j) {
                    cmd = new CommandAPDU(HexString.parseHexString("00a4020c" + HexUtil.hexify(fids[j].length() / 2) + fids[j]));
                    res = _channel.sendCommandAPDU(cmd);
                    if (res.sw() != 36864) {
                        log.debug((Object)("\nNOT SELECTED FILE: " + fids[j] + ", " + HexUtil.hexify(res.sw())));
                        continue;
                    }
                    log.debug((Object)("\nSELECTED FILE: " + fids[j]));
                    int rn = 1;
                    do {
                        cmd = new CommandAPDU(HexString.parseHexString("00b2" + HexUtil.hexify(rn) + "0400"));
                        res = _channel.sendCommandAPDU(cmd);
                        log.debug((Object)("\nRecord " + rn++ + ":\n" + (res.data() != null ? HexUtil.dump(res.data()) : null)));
                    } while (res.sw() == 36864 && res.data() != null && res.data().length > 0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.debug((Object)"System.exit() at readIssuerFromATR2");
        System.exit(0);
        return super.readIssuerFromATR(_channel);
    }

    @Override
    protected OCFCertificateInfo[] createCertificateInfos() {
        ArrayList<OCFCertificateInfo> l = new ArrayList<OCFCertificateInfo>();
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c000"), new KeyID("84"), -127, OCFCertificateInfo.ChainEntry.USER, "1"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c001"), new KeyID("0400"), -127, OCFCertificateInfo.ChainEntry.USER, "2"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c200"), new KeyID("1300"), 1, OCFCertificateInfo.ChainEntry.USER, "3"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c500"), new KeyID("0600"), 1, OCFCertificateInfo.ChainEntry.USER, "4"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c008"), null, 0, OCFCertificateInfo.ChainEntry.CA, "5"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c009"), null, 0, OCFCertificateInfo.ChainEntry.CA, "6"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c00e"), null, 0, OCFCertificateInfo.ChainEntry.ROOT, "7"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c208"), null, 0, OCFCertificateInfo.ChainEntry.CA, "8"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c20e"), null, 0, OCFCertificateInfo.ChainEntry.ROOT, "9"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c508"), null, 0, OCFCertificateInfo.ChainEntry.CA, "10"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c50e"), null, 0, OCFCertificateInfo.ChainEntry.ROOT, "11"));
        return l.toArray(new OCFCertificateInfo[l.size()]);
    }

    @Override
    protected String getOSName() {
        return "StarCOS 3.2";
    }

    @Override
    public String getDisplayName() {
        return "StarCOS 3.2 (53) ";
    }

    @Override
    protected int getMaximumChunkSize() {
        return 240;
    }

    @Override
    protected boolean isIssuerReadRequired() {
        return true;
    }

    protected byte[] get2BlockPin(OCFCertificateInfo _info, char[] _pin) {
        byte[] result = new byte[this.getPasswordBlockLength(_info)];
        Arrays.fill(result, this.getPasswordBlockFiller(_info));
        result[0] = (byte)(0x20 | (_pin == null ? 15 : _pin.length));
        if (_pin != null) {
            char[] pin = new char[_pin.length];
            System.arraycopy(_pin, 0, pin, 0, pin.length);
            int j = 0;
            for (int i = 1; i < result.length && j < pin.length; ++i) {
                result[i] = (byte)((pin[j++] & 0xF) << 4);
                if (j < pin.length) {
                    int n = i;
                    result[n] = (byte)(result[n] | (byte)(pin[j++] & 0xF));
                    continue;
                }
                int n = i;
                result[n] = (byte)(result[n] | 0xF);
            }
            Arrays.fill(pin, '\u0000');
        }
        return result;
    }

    @Override
    public int getPasswordBlockLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    protected byte[] getPaddedPIN(OCFCertificateInfo _info, char[] _pin) {
        return this.get2BlockPin(_info, _pin);
    }

    @Override
    public PinEncoder getPinEncoder(OCFCertificateInfo _info) {
        return PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK;
    }

    @Override
    public byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        return -1;
    }

    @Override
    protected boolean usesASN1HeaderWithSignHash() {
        return true;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA1");
            c.add("RIPEMD160");
            if (_info.getUsage() == OCFCertificateInfo.Usage.SIG) {
                c.add("SHA256");
            }
        }
        return c;
    }

    @Override
    protected void adjustForPaddingByte(GovCS.ResultObject _ro) {
    }

    protected int getCounter(String pinName, byte[] data, byte _wich) throws RetryCounterExpiredException {
        int index;
        byte length;
        for (index = 0; index < data.length; index += length) {
            byte tagID = data[index++];
            length = data[index++];
            if (tagID == _wich) break;
        }
        if (index >= data.length) {
            return -1;
        }
        int result = data[index];
        if (result < 0) {
            result += 256;
        }
        if (result == 0) {
            throw new RetryCounterExpiredException(pinName, 27011, APDUCommands.getVerifyErrorMsg(27011));
        }
        return result;
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        int errorCode;
        String pinName = StarCOS32.getPinNameForInfo(_info);
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(_info.getPinID());
        log.debug((Object)("RC CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("RC RESULT : " + HexString.hexify(res.getBuffer(), false)));
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            log.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 27013) {
            throw new NotYetInitializedException(pinName, errorCode, message);
        }
        if (errorCode == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 1: {
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    data.write(-124);
                    data.write(_info.getKeyID().getID().length + 1);
                    data.write(128);
                    data.write(_info.getKeyID().getID());
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-72, data.toByteArray());
                }
                catch (IOException data) {
                    // empty catch block
                }
            }
            case 0: {
                int hashAlg = 0;
                int keyAlg = 0;
                if ("SHA1".equals(_hashAlgorithm)) {
                    hashAlg = 16;
                    keyAlg = 18;
                } else if ("SHA256".equals(_hashAlgorithm)) {
                    hashAlg = 64;
                    keyAlg = 66;
                } else if ("RIPEMD160".equals(_hashAlgorithm)) {
                    hashAlg = 32;
                    keyAlg = 34;
                }
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    data.write(-128);
                    data.write(1);
                    data.write(hashAlg);
                    CommandAPDU cmd = APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-86, data.toByteArray());
                    log.debug((Object)("MSE SET HASH ALGORITHM CMD: " + HexString.hexify(cmd.getBuffer())));
                    ResponseAPDU res = _channel.sendCommandAPDU(cmd);
                    if (res == null || res.sw() != 36864) {
                        throw new ResponseCodeException(res.sw(), "selecting of hash algorithm failed");
                    }
                    log.debug((Object)("MSE SET HASH ALGORITHM RES: " + HexString.hexify(res.getBuffer())));
                    data = new ByteArrayOutputStream();
                    data.write(-124);
                    data.write(_info.getKeyID().getID().length);
                    data.write(_info.getKeyID().getID());
                    data.write(-128);
                    data.write(1);
                    data.write(keyAlg);
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            case 2: {
                return null;
            }
        }
        return null;
    }

    @Override
    protected final GovCS.ResultObject signHash(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        byte[] buffer = new byte[7 + _hashValue.length];
        buffer[0] = 0;
        buffer[1] = 42;
        buffer[2] = -112;
        buffer[3] = -96;
        buffer[4] = (byte)(_hashValue.length + 2);
        buffer[5] = -112;
        buffer[6] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, buffer, 7, _hashValue.length);
        cmd = new CommandAPDU(buffer);
        log.debug((Object)("PUT HASH CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("PUT HASH RES  : " + HexString.hexify(res.getBuffer(), false)));
        return super.signHash(_channel, _info, null, _hashAlgorithm, algorithmParameters);
    }

    @Override
    protected final CommandAPDU createDecryptCommand(byte[] _encryptedBytes, byte _paddingIndicator, AlgorithmParameters algorithmParameters) {
        int blockSize = 257;
        byte[] store = new byte[7 + blockSize + 2];
        Arrays.fill(store, (byte)-1);
        int i = 0;
        store[i++] = 0;
        store[i++] = 42;
        store[i++] = -128;
        store[i++] = -122;
        store[i++] = 0;
        store[i++] = (byte)(blockSize >> 8 & 0xFF);
        store[i++] = (byte)(blockSize >> 0 & 0xFF);
        store[i++] = this.getPaddingIndicator();
        System.arraycopy(_encryptedBytes, 0, store, i, _encryptedBytes.length);
        i += _encryptedBytes.length;
        int resultLength = 256;
        store[i++] = (byte)(resultLength >> 8 & 0xFF);
        store[i++] = (byte)(resultLength >> 0 & 0xFF);
        return new CommandAPDU(store);
    }

    @Override
    protected GovCS.ResultObject decrypt(CardChannel _channel, OCFCertificateInfo _info, byte[] _encryptedBytes, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException {
        int i;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        os = new ByteArrayOutputStream();
        os.write(0);
        os.write(42);
        os.write(-128);
        os.write(-122);
        os.write(0);
        os.write((byte)(_encryptedBytes.length + 1 >> 8));
        os.write((byte)(_encryptedBytes.length + 1 & 0xFF));
        os.write(this.getPaddingIndicator());
        os.write(_encryptedBytes, 0, _encryptedBytes.length);
        os.write(0);
        os.write(0);
        cmd = new CommandAPDU(os.toByteArray());
        log.debug((Object)("DECRYPT CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if ((this.ctReference.getName().toLowerCase().contains("omnikey") || this.ctReference.getName().toLowerCase().contains("XX44")) && PCSCCardTerminal.class.isInstance(this.ctReference)) {
            try {
                ((PCSCCardTerminal)this.ctReference).resetSlot(0);
            }
            catch (CardTerminalException cardTerminalException) {
                // empty catch block
            }
        }
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("DECRYPT RESULT : " + HexString.hexify(res.getBuffer(), false)));
        if (res.sw() != 36864) {
            throw new ResponseCodeException(res.sw(), APDUCommands.getPerformSecurityOperationErrorMsg(res.sw()));
        }
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(res.sw());
        ro.setResultData(res.data());
        byte[] b = (byte[])ro.getResultData();
        if (b == null || b.length < 3) {
            return ro;
        }
        if (b[0] != 0 || b[1] != 2) {
            return ro;
        }
        int count = b.length;
        for (i = 2; i < count && b[i] != 0; ++i) {
        }
        byte[] bb = new byte[b.length - i - 1];
        System.arraycopy(b, i + 1, bb, 0, bb.length);
        ro.setResultData(bb);
        return ro;
    }

    @Override
    protected final CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[6 + _hashValue.length];
        store[0] = 0;
        store[1] = 42;
        store[2] = -122;
        store[3] = -128;
        store[4] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, store, 5, _hashValue.length);
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    @Override
    protected GovCS.ResultObject authentify(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        data.write(137);
        data.write(2);
        data.write(20);
        if ("SHA1".equals(_hashAlgorithm)) {
            data.write(16);
        } else if ("RIPEMD160".equals(_hashAlgorithm)) {
            data.write(32);
        }
        CommandAPDU cmd = APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-86, data.toByteArray());
        ResponseAPDU res = null;
        if (!"SHA1".equals(_hashAlgorithm)) {
            log.debug((Object)("MSE CMD (SET HASH ALG) : " + HexString.hexify(cmd.getBuffer(), false)));
            res = _channel.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            log.debug((Object)("MSE RES (SET HASH ALG) : " + HexString.hexify(res.getBuffer(), false)));
        }
        byte[] buffer = new byte[7 + _hashValue.length];
        buffer[0] = 0;
        buffer[1] = 42;
        buffer[2] = -112;
        buffer[3] = -96;
        buffer[4] = (byte)(_hashValue.length + 2);
        buffer[5] = -112;
        buffer[6] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, buffer, 7, _hashValue.length);
        cmd = new CommandAPDU(buffer);
        log.debug((Object)("PUT HASH CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("PUT HASH RES  : " + HexString.hexify(res.getBuffer(), false)));
        try {
            data = new ByteArrayOutputStream();
            data.write(-124);
            data.write(_info.getKeyID().getID().length);
            data.write(_info.getKeyID().getID());
            data.write(137);
            data.write(3);
            data.write(19);
            data.write(35);
            if ("SHA1".equals(_hashAlgorithm)) {
                data.write(16);
            } else if ("RIPEMD160".equals(_hashAlgorithm)) {
                data.write(32);
            }
            cmd = APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
            log.debug((Object)("MSE CMD (SET KEY ALG) : " + HexString.hexify(cmd.getBuffer(), false)));
            res = _channel.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            log.debug((Object)("MSE RES (SET KEY ALG) : " + HexString.hexify(res.getBuffer(), false)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return super.signHash(_channel, _info, null, _hashAlgorithm, algorithmParameters);
    }

    protected GovCS.ResultObject authentify2(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        data.write(-128);
        data.write(1);
        if ("SHA1".equals(_hashAlgorithm)) {
            data.write(16);
        } else if ("SHA256".equals(_hashAlgorithm)) {
            data.write(64);
        } else if ("RIPEMD160".equals(_hashAlgorithm)) {
            data.write(32);
        }
        CommandAPDU cmd = APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-86, data.toByteArray());
        ResponseAPDU res = null;
        if (!"SHA1".equals(_hashAlgorithm)) {
            log.debug((Object)("MSE CMD (SET HASH ALG) : " + HexString.hexify(cmd.getBuffer(), false)));
            res = _channel.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            log.debug((Object)("MSE RES (SET HASH ALG) : " + HexString.hexify(res.getBuffer(), false)));
        }
        byte[] buffer = new byte[7 + _hashValue.length];
        buffer[0] = 0;
        buffer[1] = 42;
        buffer[2] = -112;
        buffer[3] = -96;
        buffer[4] = (byte)(_hashValue.length + 2);
        buffer[5] = -112;
        buffer[6] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, buffer, 7, _hashValue.length);
        cmd = new CommandAPDU(buffer);
        log.debug((Object)("PUT HASH CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("PUT HASH RES  : " + HexString.hexify(res.getBuffer(), false)));
        try {
            data = new ByteArrayOutputStream();
            data.write(-124);
            data.write(_info.getKeyID().getID().length + 1);
            data.write(_info.getKeyID().getID());
            data.write(-128);
            data.write(1);
            if ("SHA1".equals(_hashAlgorithm)) {
                data.write(16);
            } else if ("RIPEMD160".equals(_hashAlgorithm)) {
                data.write(32);
            }
            cmd = APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
            log.debug((Object)("MSE CMD (SET KEY ALG) : " + HexString.hexify(cmd.getBuffer(), false)));
            res = _channel.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            log.debug((Object)("MSE RES (SET KEY ALG) : " + HexString.hexify(res.getBuffer(), false)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return super.signHash(_channel, _info, null, _hashAlgorithm, algorithmParameters);
    }

    @Override
    public synchronized void reset() {
        if (!super.isCardPresent()) {
            return;
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            channel.sendCommandAPDU(new CommandAPDU(HexString.parseHexString("00 22 f3 01")));
            channel.setState(null);
        }
        catch (Exception exception) {
        }
        finally {
            cardChannelManager.destroy();
        }
    }
}

