/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.starcos;

import de.bos_bremen.common.asn1.DigestInfo;
import de.bos_bremen.common.asn1.HashAlgorithm;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.starcos.StarCOS30SignTrust;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StarCOS30DGNService
extends StarCOS30SignTrust {
    private static final Log LOG = LogFactory.getLog(StarCOS30DGNService.class);
    static final String EF_GDO_ISSUER_CONSTANT = "5a 0a 92 76 00 35 31 10";

    @Override
    protected Card.CardTypeEnum getCardTypeEnum() {
        return Card.CardTypeEnum.DGN;
    }

    @Override
    protected String getIssuerConstant() {
        return EF_GDO_ISSUER_CONSTANT;
    }

    @Override
    public String getDisplayName() {
        return "StarCOS 3.0 (33g) - DGNService";
    }

    @Override
    protected CardApplication createESignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfPin01 = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfFile03 = 3000003L;
        long idOfFile04 = 3000004L;
        long idOfFile05 = 3000005L;
        long idOfFile06 = 3000006L;
        long idOfFile07 = 3000007L;
        long idOfFile08 = 3000008L;
        long idOfFile09 = 3000009L;
        long idOfFile10 = 3000010L;
        long idOfFile11 = 3000011L;
        long idOfFile12 = 3000012L;
        long idOfKey01 = 4000001L;
        long idOfKey02 = 4000002L;
        long idOfKey03 = 4000003L;
        long idOfKey04 = 4000004L;
        KeyID k01 = new KeyID("84");
        KeyID k02 = new KeyID("0400");
        KeyID k03 = new KeyID("83");
        KeyID k04 = new KeyID("82");
        byte pinID01 = -127;
        FileReference dirRefApp = new FileReference(4, "a000000167455349474e");
        FileReference cerRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        FileReference cerRef02 = new FileReference(2, "c001");
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02);
        FileReference cerRef03 = new FileReference(2, "c200");
        FileEntry fileEntry03 = new FileEntry(dirRefApp, cerRef03);
        FileReference cerRef04 = new FileReference(2, "c500");
        FileEntry fileEntry04 = new FileEntry(dirRefApp, cerRef04);
        FileReference cerRef05 = new FileReference(2, "c008");
        FileEntry fileEntry05 = new FileEntry(dirRefApp, cerRef05);
        FileReference cerRef06 = new FileReference(2, "c009");
        FileEntry fileEntry06 = new FileEntry(dirRefApp, cerRef06);
        FileReference cerRef07 = new FileReference(2, "c00e");
        FileEntry fileEntry07 = new FileEntry(dirRefApp, cerRef07);
        FileReference cerRef08 = new FileReference(2, "c208");
        FileEntry fileEntry08 = new FileEntry(dirRefApp, cerRef08);
        FileReference cerRef09 = new FileReference(2, "c20e");
        FileEntry fileEntry09 = new FileEntry(dirRefApp, cerRef09);
        FileReference cerRef10 = new FileReference(2, "c508");
        FileEntry fileEntry10 = new FileEntry(dirRefApp, cerRef10);
        FileReference cerRef11 = new FileReference(2, "c50e");
        FileEntry fileEntry11 = new FileEntry(dirRefApp, cerRef11);
        FileReference cerRef12 = new FileReference(2, "c100");
        FileEntry fileEntry12 = new FileEntry(dirRefApp, cerRef12);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, new long[]{idOfFile12});
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile03, idOfKey03, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info04 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile04, idOfKey04, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info05 = new OCFCertificateInfo(idOfCard, -1L, idOfFile05, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info06 = new OCFCertificateInfo(idOfCard, -1L, idOfFile06, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info07 = new OCFCertificateInfo(idOfCard, -1L, idOfFile07, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo info08 = new OCFCertificateInfo(idOfCard, -1L, idOfFile08, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info09 = new OCFCertificateInfo(idOfCard, -1L, idOfFile09, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo info10 = new OCFCertificateInfo(idOfCard, -1L, idOfFile10, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info11 = new OCFCertificateInfo(idOfCard, -1L, idOfFile11, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "PIN.SIG", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{idOfKey01, idOfKey02});
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerAut", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "cerEnc", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey03);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "cerX", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info04);
        CardFileImpl file05 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA05", idOfFile05, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry05, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info05);
        CardFileImpl file06 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA06", idOfFile06, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry06, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info06);
        CardFileImpl file07 = new CardFileImpl(Disposeable.NO_LOCK, "cerCAROOT07", idOfFile07, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry07, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info07);
        CardFileImpl file08 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA08", idOfFile08, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry08, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info08);
        CardFileImpl file09 = new CardFileImpl(Disposeable.NO_LOCK, "cerCAROOT09", idOfFile09, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry09, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info09);
        CardFileImpl file10 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA10", idOfFile10, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry10, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info10);
        CardFileImpl file11 = new CardFileImpl(Disposeable.NO_LOCK, "cerCAROOT11", idOfFile11, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry11, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info11);
        CardFileImpl file12 = new CardFileImpl(Disposeable.NO_LOCK, "sigAttrCer", idOfFile12, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry12, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, new long[]{idOfFile01}, new long[]{idOfFile12}, new long[]{idOfPin01}, k01);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey2", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info02, idOfFile02, idOfPin01, k02);
        CardKeyImpl key03 = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/DecryptionKey", idOfKey03, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType()}), fileEntry03, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info03, idOfFile03, idOfPinCH, k03);
        CardKeyImpl key04 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey04, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_ENCRYPTION.getType()}), fileEntry04, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info04, idOfFile04, idOfPinCH, k04);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("a000000167455349474e", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType(), CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putPin(pin01);
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putFile(file03);
        applicationApp.putFile(file04);
        applicationApp.putFile(file05);
        applicationApp.putFile(file06);
        applicationApp.putFile(file07);
        applicationApp.putFile(file08);
        applicationApp.putFile(file09);
        applicationApp.putFile(file10);
        applicationApp.putFile(file11);
        applicationApp.putFile(file12);
        applicationApp.putKey(key01);
        applicationApp.putKey(key02);
        applicationApp.putKey(key03);
        applicationApp.putKey(key04);
        return applicationApp;
    }

    @Override
    protected GovCS.ResultObject authentify(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        if (_info.getKeyID().getID().length != 1) {
            throw new ResponseCodeException(27270, "no key usable, ID of key too long for required command, configuration error");
        }
        if (_hashValue != null) {
            try {
                _hashValue = new DigestInfo(HashAlgorithm.Algorithm.getAlgorithmByName(_hashAlgorithm), _hashValue).getEncoded();
                LOG.debug((Object)("pkcs#1=" + HexString.hexify(_hashValue)));
            }
            catch (Exception ex) {
                LOG.error((Object)"", (Throwable)ex);
            }
        }
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        try {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            data.write(0);
            data.write(-120);
            data.write(0);
            data.write(_info.getKeyID().getID());
            data.write(_hashValue.length);
            data.write(_hashValue);
            data.write(0);
            data.flush();
            data.close();
            cmd = new CommandAPDU(data.toByteArray());
        }
        catch (IOException data) {
            // empty catch block
        }
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(res.sw());
        ro.setResultData(res.data());
        return ro;
    }

    @Override
    protected CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 1: {
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    data.write(-124);
                    data.write(_info.getKeyID().getID().length);
                    data.write(_info.getKeyID().getID());
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-72, data.toByteArray());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return super.createMSECommand(_channel, _info, _type, _hashAlgorithm, algorithmParameters);
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA1");
            c.add("RIPEMD160");
        }
        if (_info.getUsage() == OCFCertificateInfo.Usage.AEN || _info.getUsage() == OCFCertificateInfo.Usage.ASC || _info.getUsage() == OCFCertificateInfo.Usage.AUT) {
            c.add("SHA224");
            c.add("SHA384");
            c.add("SHA512");
            c.add("SHA256");
        }
        return c;
    }
}

