/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.starcos;

import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StarCOS30
extends GovCS {
    private static final Log log = LogFactory.getLog(StarCOS30.class);
    private static final byte[][] HISTORICALS = new byte[][]{HexString.parseHexString("80 67 04 12 b0 03 04 00 10 81 05"), HexString.parseHexString("00 64 04 12 b0 33 31 b1 73 96 21 9b 01 90 00")};
    private int historicalsIndex = -5;

    @Override
    protected String getIssuerConstant() {
        return null;
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS[this.historicalsIndex];
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        if (Objects.isNull(_historicals)) {
            return false;
        }
        this.historicalsIndex = -1;
        for (int i = 0; i < HISTORICALS.length; ++i) {
            byte[] historicals = HISTORICALS[i];
            if (historicals.length != _historicals.length) continue;
            boolean diff = false;
            for (int j = 0; j < _historicals.length && !diff; ++j) {
                diff = historicals[j] != _historicals[j];
            }
            if (diff) continue;
            this.historicalsIndex = i;
            break;
        }
        return this.historicalsIndex >= 0 && this.historicalsIndex < HISTORICALS.length;
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        long idOfPin = 2000001L;
        byte pinID = 1;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Authentisierungs-/Verschl\u00fcsselungs-PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000003L, 4000004L});
        CardApplication applicationSIGN = this.createESignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationSIGN);
        mfManager.putPin(pin);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.getCardTypeEnum().getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    protected CardApplication createESignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfPin01 = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfFile03 = 3000003L;
        long idOfFile04 = 3000004L;
        long idOfFile05 = 3000005L;
        long idOfFile06 = 3000006L;
        long idOfFile07 = 3000007L;
        long idOfFile08 = 3000008L;
        long idOfFile09 = 3000009L;
        long idOfFile10 = 3000010L;
        long idOfFile11 = 3000011L;
        long idOfFile12 = 3000012L;
        long idOfKey01 = 4000001L;
        long idOfKey02 = 4000002L;
        long idOfKey03 = 4000003L;
        long idOfKey04 = 4000004L;
        KeyID k01 = new KeyID("84");
        KeyID k02 = new KeyID("0400");
        KeyID k03 = new KeyID("1300");
        KeyID k04 = new KeyID("0600");
        byte pinID01 = -127;
        FileReference dirRefApp = new FileReference(4, "a000000167455349474e");
        FileReference cerRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        FileReference cerRef02 = new FileReference(2, "c001");
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02);
        FileReference cerRef03 = new FileReference(2, "c200");
        FileEntry fileEntry03 = new FileEntry(dirRefApp, cerRef03);
        FileReference cerRef04 = new FileReference(2, "c500");
        FileEntry fileEntry04 = new FileEntry(dirRefApp, cerRef04);
        FileReference cerRef05 = new FileReference(2, "c008");
        FileEntry fileEntry05 = new FileEntry(dirRefApp, cerRef05);
        FileReference cerRef06 = new FileReference(2, "c009");
        FileEntry fileEntry06 = new FileEntry(dirRefApp, cerRef06);
        FileReference cerRef07 = new FileReference(2, "c00e");
        FileEntry fileEntry07 = new FileEntry(dirRefApp, cerRef07);
        FileReference cerRef08 = new FileReference(2, "c208");
        FileEntry fileEntry08 = new FileEntry(dirRefApp, cerRef08);
        FileReference cerRef09 = new FileReference(2, "c20e");
        FileEntry fileEntry09 = new FileEntry(dirRefApp, cerRef09);
        FileReference cerRef10 = new FileReference(2, "c508");
        FileEntry fileEntry10 = new FileEntry(dirRefApp, cerRef10);
        FileReference cerRef11 = new FileReference(2, "c50e");
        FileEntry fileEntry11 = new FileEntry(dirRefApp, cerRef11);
        FileReference cerRef12 = new FileReference(2, "c100");
        FileEntry fileEntry12 = new FileEntry(dirRefApp, cerRef12);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, new long[]{idOfFile12});
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile03, idOfKey03, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info04 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile04, idOfKey04, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info05 = new OCFCertificateInfo(idOfCard, -1L, idOfFile05, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info06 = new OCFCertificateInfo(idOfCard, -1L, idOfFile06, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info07 = new OCFCertificateInfo(idOfCard, -1L, idOfFile07, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo info08 = new OCFCertificateInfo(idOfCard, -1L, idOfFile08, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info09 = new OCFCertificateInfo(idOfCard, -1L, idOfFile09, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        OCFCertificateInfo info10 = new OCFCertificateInfo(idOfCard, -1L, idOfFile10, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info11 = new OCFCertificateInfo(idOfCard, -1L, idOfFile11, -1L, OCFCertificateInfo.ChainEntry.ROOT, null, null);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{idOfKey01, idOfKey02});
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerAut", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "cerEnc", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey03);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "cerX", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info04);
        CardFileImpl file05 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA05", idOfFile05, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry05, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info05);
        CardFileImpl file06 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA06", idOfFile06, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry06, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info06);
        CardFileImpl file07 = new CardFileImpl(Disposeable.NO_LOCK, "cerCAROOT07", idOfFile07, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry07, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info07);
        CardFileImpl file08 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA08", idOfFile08, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry08, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info08);
        CardFileImpl file09 = new CardFileImpl(Disposeable.NO_LOCK, "cerCAROOT09", idOfFile09, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry09, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info09);
        CardFileImpl file10 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA10", idOfFile10, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry10, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info10);
        CardFileImpl file11 = new CardFileImpl(Disposeable.NO_LOCK, "cerCAROOT11", idOfFile11, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry11, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info11);
        CardFileImpl file12 = new CardFileImpl(Disposeable.NO_LOCK, "sigAttrCer", idOfFile12, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry12, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, new long[]{idOfFile01}, new long[]{idOfFile12}, new long[]{idOfPin01}, k01);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey2", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info02, idOfFile02, idOfPin01, k02);
        CardKeyImpl key03 = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/DecryptionKey", idOfKey03, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType()}), fileEntry03, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info03, idOfFile03, idOfPinCH, k03);
        CardKeyImpl key04 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey04, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_ENCRYPTION.getType()}), fileEntry04, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info04, idOfFile04, idOfPinCH, k04);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("a000000167455349474e", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType(), CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putPin(pin01);
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putFile(file03);
        applicationApp.putFile(file04);
        applicationApp.putFile(file05);
        applicationApp.putFile(file06);
        applicationApp.putFile(file07);
        applicationApp.putFile(file08);
        applicationApp.putFile(file09);
        applicationApp.putFile(file10);
        applicationApp.putFile(file11);
        applicationApp.putFile(file12);
        applicationApp.putKey(key01);
        applicationApp.putKey(key02);
        applicationApp.putKey(key03);
        applicationApp.putKey(key04);
        return applicationApp;
    }

    protected Card.CardTypeEnum getCardTypeEnum() {
        return Card.CardTypeEnum.UNKNOWN_STARCOS30;
    }

    @Override
    protected OCFCertificateInfo[] createCertificateInfos() {
        ArrayList<OCFCertificateInfo> l = new ArrayList<OCFCertificateInfo>();
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c000"), new KeyID("84"), -127, OCFCertificateInfo.ChainEntry.USER, "1"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c001"), new KeyID("0400"), -127, OCFCertificateInfo.ChainEntry.USER, "2"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c200"), new KeyID("1300"), 1, OCFCertificateInfo.ChainEntry.USER, "3"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c500"), new KeyID("0600"), 1, OCFCertificateInfo.ChainEntry.USER, "4"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c008"), null, 0, OCFCertificateInfo.ChainEntry.CA, "5"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c009"), null, 0, OCFCertificateInfo.ChainEntry.CA, "6"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c00e"), null, 0, OCFCertificateInfo.ChainEntry.ROOT, "7"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c208"), null, 0, OCFCertificateInfo.ChainEntry.CA, "8"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c20e"), null, 0, OCFCertificateInfo.ChainEntry.ROOT, "9"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c508"), null, 0, OCFCertificateInfo.ChainEntry.CA, "10"));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c50e"), null, 0, OCFCertificateInfo.ChainEntry.ROOT, "11"));
        return l.toArray(new OCFCertificateInfo[l.size()]);
    }

    @Override
    protected String getOSName() {
        return "";
    }

    @Override
    public String getDisplayName() {
        return "StarCOS(v.3.0) (33, 33a, 33b, 33c, 33d) ";
    }

    @Override
    protected int getMaximumChunkSize() {
        return 240;
    }

    @Override
    protected boolean isIssuerReadRequired() {
        return true;
    }

    protected byte[] get2BlockPin(OCFCertificateInfo _info, char[] _pin) {
        byte[] result = new byte[this.getPasswordBlockLength(_info)];
        Arrays.fill(result, this.getPasswordBlockFiller(_info));
        result[0] = (byte)(0x20 | (_pin == null ? 15 : _pin.length));
        if (_pin != null) {
            char[] pin = new char[_pin.length];
            System.arraycopy(_pin, 0, pin, 0, pin.length);
            int j = 0;
            for (int i = 1; i < result.length && j < pin.length; ++i) {
                result[i] = (byte)((pin[j++] & 0xF) << 4);
                if (j < pin.length) {
                    int n = i;
                    result[n] = (byte)(result[n] | (byte)(pin[j++] & 0xF));
                    continue;
                }
                int n = i;
                result[n] = (byte)(result[n] | 0xF);
            }
            Arrays.fill(pin, '\u0000');
        }
        return result;
    }

    @Override
    public int getPasswordBlockLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    protected byte[] getPaddedPIN(OCFCertificateInfo _info, char[] _pin) {
        return this.get2BlockPin(_info, _pin);
    }

    @Override
    public PinEncoder getPinEncoder(OCFCertificateInfo _info) {
        return PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK;
    }

    @Override
    public byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        return -1;
    }

    @Override
    protected boolean usesASN1HeaderWithSignHash() {
        return true;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA1");
            c.add("RIPEMD160");
        }
        return c;
    }

    @Override
    protected void adjustForPaddingByte(GovCS.ResultObject _ro) {
    }

    protected int getCounter(String pinName, byte[] data, byte _wich) throws RetryCounterExpiredException {
        int index;
        byte length;
        for (index = 0; index < data.length; index += length) {
            byte tagID = data[index++];
            length = data[index++];
            if (tagID == _wich) break;
        }
        if (index >= data.length) {
            return -1;
        }
        int result = data[index];
        if (result < 0) {
            result += 256;
        }
        if (result == 0) {
            throw new RetryCounterExpiredException(pinName, 27011, APDUCommands.getVerifyErrorMsg(27011));
        }
        return result;
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        int errorCode;
        String pinName = StarCOS30.getPinNameForInfo(_info);
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(_info.getPinID());
        log.debug((Object)("RC CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("RC RESULT : " + HexString.hexify(res.getBuffer(), false)));
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            log.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 27013) {
            throw new NotYetInitializedException(pinName, errorCode, message);
        }
        if (errorCode == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }

    @Override
    protected CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 1: {
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    data.write(-124);
                    data.write(_info.getKeyID().getID().length + 1);
                    data.write(128);
                    data.write(_info.getKeyID().getID());
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-72, data.toByteArray());
                }
                catch (IOException data) {
                    // empty catch block
                }
            }
            case 0: {
                if ("SHA1".equals(_hashAlgorithm)) {
                    try {
                        ByteArrayOutputStream data = new ByteArrayOutputStream();
                        data.write(-124);
                        data.write(_info.getKeyID().getID().length);
                        data.write(_info.getKeyID().getID());
                        data.write(128);
                        data.write(1);
                        data.write(18);
                        return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
                    }
                    catch (IOException data) {
                    }
                } else {
                    if ("RIPEMD160".equals(_hashAlgorithm)) {
                        ByteArrayOutputStream data = new ByteArrayOutputStream();
                        data.write(137);
                        data.write(2);
                        data.write(20);
                        data.write(32);
                        return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-86, data.toByteArray());
                    }
                    return null;
                }
            }
            case 2: {
                return null;
            }
        }
        return null;
    }

    @Override
    protected final GovCS.ResultObject signHash(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        byte[] buffer = new byte[7 + _hashValue.length];
        buffer[0] = 0;
        buffer[1] = 42;
        buffer[2] = -112;
        buffer[3] = -96;
        buffer[4] = (byte)(_hashValue.length + 2);
        buffer[5] = -112;
        buffer[6] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, buffer, 7, _hashValue.length);
        CommandAPDU cmd = new CommandAPDU(buffer);
        log.debug((Object)("PUT HASH CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("PUT HASH RES  : " + HexString.hexify(res.getBuffer(), false)));
        if ("RIPEMD160".equals(_hashAlgorithm)) {
            try {
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                data.write(-124);
                data.write(_info.getKeyID().getID().length);
                data.write(_info.getKeyID().getID());
                data.write(137);
                data.write(3);
                data.write(19);
                data.write(35);
                data.write(32);
                cmd = APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
                log.debug((Object)("MSE KEY ALG CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                res = _channel.sendCommandAPDU(cmd);
                if (res == null) {
                    throw new ResponseCodeException(RESOURCES.getString("no_response"));
                }
                log.debug((Object)("MSE KEY ALG RES  : " + HexString.hexify(res.getBuffer(), false)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.signHash(_channel, _info, null, _hashAlgorithm, algorithmParameters);
    }

    @Override
    protected final CommandAPDU createDecryptCommand(byte[] _encryptedBytes, byte _paddingIndicator, AlgorithmParameters algorithmParameters) {
        int blockSize = 257;
        byte[] store = new byte[7 + blockSize + 2];
        Arrays.fill(store, (byte)-1);
        int i = 0;
        store[i++] = 0;
        store[i++] = 42;
        store[i++] = -128;
        store[i++] = -122;
        store[i++] = 0;
        store[i++] = (byte)(blockSize >> 8 & 0xFF);
        store[i++] = (byte)(blockSize >> 0 & 0xFF);
        store[i++] = this.getPaddingIndicator();
        System.arraycopy(_encryptedBytes, 0, store, i, _encryptedBytes.length);
        i += _encryptedBytes.length;
        int resultLength = 256;
        store[i++] = (byte)(resultLength >> 8 & 0xFF);
        store[i++] = (byte)(resultLength >> 0 & 0xFF);
        return new CommandAPDU(store);
    }

    @Override
    protected GovCS.ResultObject decrypt(CardChannel _channel, OCFCertificateInfo _info, byte[] _encryptedBytes, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException {
        int i;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(16);
        os.write(42);
        os.write(-128);
        os.write(-122);
        os.write(129);
        os.write(this.getPaddingIndicator());
        os.write(_encryptedBytes, 0, 128);
        CommandAPDU cmd = new CommandAPDU(os.toByteArray());
        log.debug((Object)("DECRYPT CMD 1 : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("DECRYPT RESULT 1 : " + HexString.hexify(res.getBuffer(), false)));
        os = new ByteArrayOutputStream();
        os.write(0);
        os.write(42);
        os.write(-128);
        os.write(-122);
        os.write(128);
        os.write(_encryptedBytes, 128, 128);
        os.write(0);
        cmd = new CommandAPDU(os.toByteArray());
        log.debug((Object)("DECRYPT CMD 2 : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("DECRYPT RESULT 2 : " + HexString.hexify(res.getBuffer(), false)));
        if (res.sw() != 36864) {
            throw new ResponseCodeException(res.sw(), APDUCommands.getPerformSecurityOperationErrorMsg(res.sw()));
        }
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(res.sw());
        ro.setResultData(res.data());
        byte[] b = (byte[])ro.getResultData();
        if (b == null || b.length < 3) {
            return ro;
        }
        if (b[0] != 0 || b[1] != 2) {
            return ro;
        }
        int count = b.length;
        for (i = 2; i < count && b[i] != 0; ++i) {
        }
        byte[] bb = new byte[b.length - i - 1];
        System.arraycopy(b, i + 1, bb, 0, bb.length);
        ro.setResultData(bb);
        return ro;
    }

    @Override
    protected final CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[6 + _hashValue.length];
        store[0] = 0;
        store[1] = 42;
        store[2] = -122;
        store[3] = -128;
        store[4] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, store, 5, _hashValue.length);
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    @Override
    protected GovCS.ResultObject authentify(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        data.write(137);
        data.write(2);
        data.write(20);
        if ("SHA1".equals(_hashAlgorithm)) {
            data.write(16);
        } else if ("RIPEMD160".equals(_hashAlgorithm)) {
            data.write(32);
        }
        CommandAPDU cmd = APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-86, data.toByteArray());
        ResponseAPDU res = null;
        if (!"SHA1".equals(_hashAlgorithm)) {
            log.debug((Object)("MSE CMD (SET HASH ALG) : " + HexString.hexify(cmd.getBuffer(), false)));
            res = _channel.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            log.debug((Object)("MSE RES (SET HASH ALG) : " + HexString.hexify(res.getBuffer(), false)));
        }
        byte[] buffer = new byte[7 + _hashValue.length];
        buffer[0] = 0;
        buffer[1] = 42;
        buffer[2] = -112;
        buffer[3] = -96;
        buffer[4] = (byte)(_hashValue.length + 2);
        buffer[5] = -112;
        buffer[6] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, buffer, 7, _hashValue.length);
        cmd = new CommandAPDU(buffer);
        log.debug((Object)("PUT HASH CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("PUT HASH RES  : " + HexString.hexify(res.getBuffer(), false)));
        try {
            data = new ByteArrayOutputStream();
            data.write(-124);
            data.write(_info.getKeyID().getID().length + 1);
            data.write(128);
            data.write(_info.getKeyID().getID());
            data.write(137);
            data.write(3);
            data.write(19);
            data.write(35);
            if ("SHA1".equals(_hashAlgorithm)) {
                data.write(16);
            } else if ("RIPEMD160".equals(_hashAlgorithm)) {
                data.write(32);
            }
            cmd = APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
            log.debug((Object)("MSE CMD (SET KEY ALG) : " + HexString.hexify(cmd.getBuffer(), false)));
            res = _channel.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            log.debug((Object)("MSE RES (SET KEY ALG) : " + HexString.hexify(res.getBuffer(), false)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return super.signHash(_channel, _info, null, _hashAlgorithm, algorithmParameters);
    }

    @Override
    public synchronized void reset() {
        if (!super.isCardPresent()) {
            return;
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            channel.sendCommandAPDU(new CommandAPDU(HexString.parseHexString("00 22 f3 01")));
            channel.setState(null);
        }
        catch (Exception exception) {
        }
        finally {
            cardChannelManager.destroy();
        }
    }
}

