/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.starcos;

import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class StarCOS
extends GovCS {
    private static final Log log = LogFactory.getLog(StarCOS.class);

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        return Arrays.equals(this.getHistoricals(), _historicals);
    }

    @Override
    protected String getOSName() {
        return "StarCOS(v.2.3)";
    }

    @Override
    protected int getMaximumChunkSize() {
        return 240;
    }

    @Override
    public int getPasswordBlockLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        return this.getPasswordBlockLength(_info);
    }

    @Override
    protected byte getPaddingIndicator() {
        return 0;
    }

    @Override
    public boolean usesASN1HeaderWithAuthentify() {
        return true;
    }

    @Override
    protected boolean usesASN1HeaderWithSignHash() {
        return false;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA1");
            c.add("RIPEMD160");
        }
        return c;
    }

    @Override
    protected void adjustForPaddingByte(GovCS.ResultObject _ro) {
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return -1;
    }

    @Override
    protected CommandAPDU createSelectMasterFile() {
        return new CommandAPDU(HexString.parseHexString("00a40000023f00"));
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        byte[] _keyID = _info.getKeyID().getID();
        int index = 0;
        byte[] data = new byte[5 + _keyID.length];
        switch (_type) {
            case 1: {
                data[index++] = -124;
                data[index++] = (byte)_keyID.length;
                System.arraycopy(_keyID, 0, data, 2, _keyID.length);
                index += _keyID.length;
                data[index++] = -128;
                data[index++] = 1;
                data[index] = 2;
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)-127, (byte)-72, data);
            }
            case 0: {
                data[index++] = -124;
                data[index++] = (byte)_keyID.length;
                System.arraycopy(_keyID, 0, data, 2, _keyID.length);
                index += _keyID.length;
                data[index++] = -128;
                data[index++] = 1;
                data[index] = 18;
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data);
            }
            case 2: {
                data[index++] = -124;
                data[index++] = (byte)_keyID.length;
                System.arraycopy(_keyID, 0, data, 2, _keyID.length);
                index += _keyID.length;
                data[index++] = -128;
                data[index++] = 1;
                data[index] = 2;
                return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-92, data);
            }
        }
        return null;
    }

    @Override
    protected final GovCS.ResultObject signHash(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        byte[] buffer = new byte[7 + _hashValue.length];
        buffer[0] = 0;
        buffer[1] = 42;
        buffer[2] = -112;
        buffer[3] = -96;
        buffer[4] = (byte)(_hashValue.length + 2);
        buffer[5] = -112;
        buffer[6] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, buffer, 7, _hashValue.length);
        CommandAPDU cmd = new CommandAPDU(buffer);
        log.debug((Object)("PUT HASH CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("PUT HASH RES  : " + HexString.hexify(res.getBuffer(), false)));
        return super.signHash(_channel, _info, null, _hashAlgorithm, algorithmParameters);
    }
}

