/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.starcos;

import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.base.DefaultHBA;
import java.util.Objects;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HBA
extends DefaultHBA {
    private static final Log log = LogFactory.getLog(HBA.class);
    private static final byte[][] HISTORICALS = new byte[][]{HexString.parseHexString("00 64 05 1e b2 07 31 b1 73 96 21 db 05 90 00")};
    private int historicalsIndex = -5;

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS[this.historicalsIndex];
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        if (Objects.isNull(_historicals)) {
            return false;
        }
        this.historicalsIndex = -1;
        for (int i = 0; i < HISTORICALS.length; ++i) {
            byte[] historicals = HISTORICALS[i];
            if (historicals.length != _historicals.length) continue;
            boolean diff = false;
            for (int j = 0; j < _historicals.length && !diff; ++j) {
                diff = historicals[j] != _historicals[j];
            }
            if (diff) continue;
            this.historicalsIndex = i;
            break;
        }
        return this.historicalsIndex >= 0 && this.historicalsIndex < HISTORICALS.length;
    }

    @Override
    protected String getOSName() {
        return "StarCOS(v.3.0) (?) ";
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        int errorCode;
        String pinName = HBA.getPinNameForInfo(_info);
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(_info.getPinID());
        log.debug((Object)("RC CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("RC RESULT : " + HexString.hexify(res.getBuffer(), false)));
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            log.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 27013) {
            throw new NotYetInitializedException(pinName, errorCode, message);
        }
        if (errorCode == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }
}

