/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.siemens;

import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.Siemensv43b;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.util.HexString;

public class TCTrust
extends Siemensv43b {
    private static final byte[] HISTORICALS = HexString.parseHexString("c8 08");
    private static final String TOKEN_INFO_CONTENT = "QSign";

    @Override
    protected String getIssuerConstant() {
        return "5a 0d d2 76 00 00 f0QSign";
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS;
    }

    @Override
    public String getDisplayName() {
        return "TC-Trust QSign (25c)";
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        String pkcs15TokenInfo;
        Object issuer = super.readIssuerFromATR(_channel);
        if (issuer != null) {
            issuer = ((String)issuer).replaceAll("\u0000", "");
        }
        if ((pkcs15TokenInfo = super.readPKCS15TokenInfoFromCard(_channel)) != null && pkcs15TokenInfo.indexOf(TOKEN_INFO_CONTENT) >= 0 && pkcs15TokenInfo != null && pkcs15TokenInfo.indexOf(TOKEN_INFO_CONTENT) >= 0) {
            issuer = issuer == null ? TOKEN_INFO_CONTENT : (String)issuer + TOKEN_INFO_CONTENT;
        }
        return issuer;
    }

    @Override
    public boolean isIssuerReadRequired() {
        return true;
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardApplication applicationSIGN = this.createSignApp(terminal, slotID, idOfCard, idOfMFApplication, -1L);
        CardApplication applicationENC = this.createEncDecApp(terminal, slotID, idOfCard, idOfMFApplication, -1L);
        CardApplication applicationAUT = this.createAutApp(terminal, slotID, idOfCard, idOfMFApplication, -1L);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationSIGN);
        mfManager.putApplication(applicationENC);
        mfManager.putApplication(applicationAUT);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, Card.CardTypeEnum.TCTRUST_QSIGN.getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createSignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfPin = 2000001L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfKey = 4000001L;
        KeyID k01 = new KeyID("02");
        byte pinID = -127;
        FileReference dirRefApp = new FileReference(8, "1fff");
        FileReference cerRef01 = new FileReference(8, "3f001003c000");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        FileReference cerRef02 = new FileReference(8, "3f001003c008");
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin, idOfFile01, idOfKey, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey});
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig1", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig2", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info02);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin, k01);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("1fff", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putPin(pin);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    private CardApplication createEncDecApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000002L;
        long idOfPin = 2000002L;
        long idOfFile = 3000003L;
        long idOfKey = 4000002L;
        byte pinID = -127;
        KeyID k = new KeyID("03");
        FileReference dirRefApp = new FileReference(8, "501550724b035503");
        FileReference cerRef = new FileReference(8, "501543044303");
        FileEntry fileEntry = new FileEntry(dirRefApp, cerRef);
        OCFCertificateInfo info = new OCFCertificateInfo(idOfCard, idOfPin, idOfFile, idOfKey, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Verschl\u00fcsselungs-PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey});
        CardFileImpl file = new CardFileImpl(Disposeable.NO_LOCK, "cerEncDec", idOfFile, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey);
        CardKeyImpl key = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/DecryptionKey", idOfKey, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType()}), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info, idOfFile, idOfPinCH, k);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("501550724b035503", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType()}), fileEntry, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putPin(pin);
        applicationApp.putFile(file);
        applicationApp.putKey(key);
        return applicationApp;
    }

    private CardApplication createAutApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000003L;
        long idOfPin = 2000003L;
        long idOfFile01 = 3000004L;
        long idOfFile02 = 3000005L;
        long idOfKey = 4000003L;
        KeyID k01 = new KeyID("01");
        byte pinID = -127;
        FileReference dirRefApp = new FileReference(8, "501550724b015501");
        FileReference dirCACerRefApp = new FileReference(8, "50154304");
        FileReference cerRef01 = new FileReference(8, "501543044301");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        FileReference cerRef02 = new FileReference(8, "501543044501");
        FileEntry fileEntry02 = new FileEntry(dirCACerRefApp, cerRef02);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin, idOfFile01, idOfKey, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Authentisierungs-PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey});
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig1", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "caCer", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info02);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_DECRYPTION.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin, k01);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("501550724b015501", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putPin(pin);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    @Override
    public OCFCertificateInfo[] createCertificateInfos() {
        ArrayList<OCFCertificateInfo> l = new ArrayList<OCFCertificateInfo>();
        l.add(new OCFCertificateInfo(new FileReference(8, "1fff"), new FileReference(8, "3f001003c000"), new KeyID("02"), -127, OCFCertificateInfo.ChainEntry.USER, "1"));
        l.add(new OCFCertificateInfo(new FileReference(8, "501550724b035503"), new FileReference(8, "501543044303"), new KeyID("03"), -127, OCFCertificateInfo.ChainEntry.USER, "2"));
        l.add(new OCFCertificateInfo(new FileReference(8, "501550724b015501"), new FileReference(8, "501543044301"), new KeyID("01"), -127, OCFCertificateInfo.ChainEntry.USER, "3"));
        l.add(new OCFCertificateInfo(new FileReference(8, "1fff"), new FileReference(8, "3f001003c008"), null, 0, OCFCertificateInfo.ChainEntry.CA, "4"));
        l.add(new OCFCertificateInfo(new FileReference(8, "50154304"), new FileReference(8, "501543044501"), null, 0, OCFCertificateInfo.ChainEntry.CA, "5"));
        return l.toArray(new OCFCertificateInfo[l.size()]);
    }

    @Override
    protected boolean usesASN1HeaderWithSignHash() {
        return true;
    }

    @Override
    protected boolean checkExecuteRetryCountKeyInitialized(OCFCertificateInfo _info) {
        CardKey ck = _info.getKey();
        if (ck != null && ((ck.getTypeValue() & CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getTypeValue()) == CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getTypeValue() || (ck.getTypeValue() & CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getTypeValue()) == CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getTypeValue() || (ck.getTypeValue() & CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getTypeValue()) == CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getTypeValue())) {
            return false;
        }
        return super.checkExecuteRetryCountKeyInitialized(_info);
    }

    @Override
    protected synchronized boolean isKeyInitialized(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        try {
            this.getRetryCount(_channel, _info);
            return true;
        }
        catch (NotYetInitializedException ex) {
            return false;
        }
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        byte[] keyID = _info.getKeyID().getID();
        byte[] data = new byte[2 + keyID.length];
        data[0] = -125;
        data[1] = (byte)keyID.length;
        System.arraycopy(keyID, 0, data, 2, keyID.length);
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)1, (byte)-72, data);
    }

    @Override
    protected GovCS.ResultObject decrypt(CardChannel _channel, OCFCertificateInfo _info, byte[] _encryptedBytes, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        int i;
        GovCS.ResultObject ro = super.decrypt(_channel, _info, _encryptedBytes, algorithmParameters);
        byte[] b = (byte[])ro.getResultData();
        if (b == null || b.length < 3) {
            return ro;
        }
        if (b[0] != 0 || b[1] != 2) {
            return ro;
        }
        int count = b.length;
        for (i = 2; i < count && b[i] != 0; ++i) {
        }
        byte[] bb = new byte[b.length - i - 1];
        System.arraycopy(b, i + 1, bb, 0, bb.length);
        ro.setResultData(bb);
        return ro;
    }

    @Override
    public boolean isMultiSign() {
        return false;
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    public int getMinPINLength(OCFCertificateInfo _info) {
        return Math.min(6, super.getMinPINLength(_info));
    }
}

