/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.siemens;

import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.util.PKCS15PinDataUtil;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Siemensv44EALight
extends GovCS {
    private static final Log log = LogFactory.getLog(Siemensv44EALight.class);
    private static final byte[] HISTORICALS = HexString.parseHexString("c8 0d");
    private static final String EF_GDO_ISSUER_CONSTANT = "5a 0a 80 27 60 01 08";
    private final PKCS15PinDataUtil pinDataUtil = new PKCS15PinDataUtil(this);

    @Override
    protected boolean isIssuerReadRequired() {
        return true;
    }

    @Override
    protected String getIssuerConstant() {
        return EF_GDO_ISSUER_CONSTANT;
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS;
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        return Arrays.equals(this.getHistoricals(), _historicals);
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfPinCH = 2000001L;
        long idOfMFApplication = 1000000L;
        CardApplication applicationESIGN = this.createESignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPinCH);
        byte pinID01 = -127;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardPinImpl pinCH = new CardPinImpl(Disposeable.NO_LOCK, "Authentisierungs-/Verschl\u00fcsselungs-PIN", idOfPinCH, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{4000001L, 4000002L});
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationESIGN);
        mfManager.putPin(pinCH);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, Card.CardTypeEnum.EA_LIGHT_PRE.getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createESignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplicationESIGN = 1000001L;
        long idOfFile01 = 3000005L;
        long idOfFile02 = 3000006L;
        long idOfKey01 = 4000002L;
        long idOfKey02 = 4000003L;
        KeyID k01 = new KeyID("02");
        KeyID k02 = new KeyID("03");
        FileReference dirRefESIGN = new FileReference(4, "a000000167455349474e");
        FileReference cerRef01 = new FileReference(2, "c500");
        FileEntry fileEntry01 = new FileEntry(dirRefESIGN, cerRef01);
        FileReference cerRef02 = new FileReference(2, "c200");
        FileEntry fileEntry02 = new FileEntry(dirRefESIGN, cerRef02);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerAut", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplicationESIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_DEFAULT.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType()}), fileEntry01, idOfCard, idOfApplicationESIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPinCH, k01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerEnc", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplicationESIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/DecryptionKey", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType()}), fileEntry02, idOfCard, idOfApplicationESIGN, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info02, idOfFile02, idOfPinCH, k02);
        CardObjectManagerImpl managerESIGN = new CardObjectManagerImpl(idOfApplicationESIGN);
        CardApplicationImpl applicationESIGN = new CardApplicationImpl("a000000167455349474e", idOfApplicationESIGN, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntry01, (CardObjectManager)managerESIGN, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationESIGN.putFile(file01);
        applicationESIGN.putFile(file02);
        applicationESIGN.putKey(key01);
        applicationESIGN.putKey(key02);
        return applicationESIGN;
    }

    @Override
    protected final OCFCertificateInfo[] createCertificateInfos() {
        ArrayList<OCFCertificateInfo> l = new ArrayList<OCFCertificateInfo>();
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c500"), new KeyID("02"), 1, OCFCertificateInfo.ChainEntry.USER));
        l.add(new OCFCertificateInfo(new FileReference(4, "a000000167455349474e"), new FileReference(2, "c200"), new KeyID("03"), 1, OCFCertificateInfo.ChainEntry.USER));
        return l.toArray(new OCFCertificateInfo[l.size()]);
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return this.getRetryCount(Siemensv44EALight.getPinNameForInfo(_info), _channel, _info.getPinID());
    }

    protected int getRetryCount(String pinName, CardChannel _channel, byte pinID) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        int errorCode;
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(pinID);
        log.debug((Object)("RC CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("RC RESULT : " + HexString.hexify(res.getBuffer(), false)));
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            log.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 27013) {
            throw new NotYetInitializedException(pinName, errorCode, message);
        }
        if (errorCode == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }

    @Override
    public final List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        c.add("SHA1");
        c.add("RIPEMD160");
        c.add("SHA224");
        c.add("SHA384");
        c.add("SHA512");
        c.add("WHIRLPOOL");
        c.add("SHA256");
        return c;
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        cmd = new CommandAPDU(HexString.parseHexString("00220301"));
        log.debug((Object)("RESET MSE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("RESET MSE RES : " + HexString.hexify(res.getBuffer(), false)));
        byte[] keyID = _info.getKeyID().getID();
        byte[] data = new byte[2 + keyID.length];
        data[0] = -124;
        data[1] = (byte)keyID.length;
        System.arraycopy(keyID, 0, data, 2, keyID.length);
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)1, (byte)-72, data);
    }

    @Override
    protected byte getPaddingIndicator() {
        return 0;
    }

    @Override
    protected void adjustForPaddingByte(GovCS.ResultObject _ro) {
    }

    @Override
    protected boolean usesASN1HeaderWithAuthentify() {
        return true;
    }

    @Override
    protected final CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        int blockSize = 257;
        byte[] store = new byte[7 + blockSize + 2];
        Arrays.fill(store, (byte)-1);
        int i = 0;
        store[i++] = 0;
        store[i++] = 42;
        store[i++] = -128;
        store[i++] = -122;
        store[i++] = 0;
        store[i++] = (byte)(blockSize >> 8 & 0xFF);
        store[i++] = (byte)(blockSize >> 0 & 0xFF);
        store[i++] = this.getPaddingIndicator();
        store[i++] = 0;
        store[i++] = 1;
        i += blockSize - 3 - _hashValue.length - 1;
        store[i++] = 0;
        System.arraycopy(_hashValue, 0, store, i, _hashValue.length);
        i += _hashValue.length;
        int resultLength = 256;
        store[i++] = (byte)(resultLength >> 8 & 0xFF);
        store[i++] = (byte)(resultLength >> 0 & 0xFF);
        return new CommandAPDU(store);
    }

    @Override
    public String getDisplayName() {
        return "eArztausweis Light (AK Nordrhein)";
    }

    protected Card.CardTypeEnum getCardTypeEnum() {
        return Card.CardTypeEnum.EA_LIGHT;
    }

    @Override
    public String getOSName() {
        return "(Siemens CardOS v.4.4)";
    }

    @Override
    public void reset() {
        if (!super.isCardPresent()) {
            return;
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel cardChannel = cardChannelManager.init(this);
            this.resetInt(cardChannel);
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    private void resetInt(CardChannel channel) {
        super.resetChannelState(channel);
        try {
            this.selectMasterFile(channel);
        }
        catch (Exception e) {
            log.debug((Object)"selecting master file failed", (Throwable)e);
        }
    }

    @Override
    public int getMinPINLength(OCFCertificateInfo _info) {
        Integer min = this.pinDataUtil.getMinPINLength(_info);
        if (min != null) {
            return min;
        }
        return super.getMinPINLength(_info);
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        Integer max = this.pinDataUtil.getMaxPINLength(_info);
        if (max != null) {
            return max;
        }
        return super.getMaxPINLength(_info);
    }

    @Override
    public void analizeCardTerminal(CardTerminal _ct, boolean _keyboardAllowed) throws CardTerminalException {
        super.analizeCardTerminal(_ct, _keyboardAllowed);
        this.pinDataUtil.readPKCS15PinData();
    }
}

