/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.siemens;

import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.Siemensv43;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Siemensv43b
extends Siemensv43 {
    protected static final Log LOG = LogFactory.getLog(Siemensv43b.class);
    private static final byte[] HISTORICALS = HexString.parseHexString("c8 08");
    static final String EF_GDO_ISSUER_CONSTANT = "5a 0e d2 76 44 52 56";

    @Override
    protected Card.CardTypeEnum getCardTypeEnum() {
        return Card.CardTypeEnum.DR;
    }

    @Override
    protected String getIssuerConstant() {
        return EF_GDO_ISSUER_CONSTANT;
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS;
    }

    @Override
    protected boolean isIssuerReadRequired() {
        return true;
    }

    @Override
    protected synchronized boolean isKeyInitialized(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        if (!super.checkExecuteRetryCountKeyInitialized(_info)) {
            return true;
        }
        CommandAPDU cmd = APDUCommands.createSelectCommand(8, 12, HexString.parseHexString("50157470"), 1024);
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        cmd = APDUCommands.createReadBinaryCommand(0, 127);
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        String s = new String(res.getBuffer(), 1, 5);
        boolean[] ku = _info.getX509Certificate().getKeyUsage();
        if (ku[0] || ku[2] || ku[3]) {
            s = new String(res.getBuffer(), 1, 2);
        } else if (ku[1]) {
            s = new String(res.getBuffer(), 3, 2);
        }
        this.selectFile(_channel, _info, true);
        return !"EX".equals(s);
    }

    @Override
    protected boolean usesASN1HeaderWithSignHash() {
        return true;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA1");
            c.add("RIPEMD160");
            c.add("SHA224");
            c.add("SHA384");
            c.add("SHA512");
            c.add("SHA256");
        }
        return c;
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        int errorCode;
        String pinName = Siemensv43b.getPinNameForInfo(_info);
        if (!this.checkExecuteRetryCountKeyInitialized(_info)) {
            return -1;
        }
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(_info.getPinID());
        LOG.debug((Object)("RC CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("RC RESULT : " + HexString.hexify(res.getBuffer(), false)));
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            LOG.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 27013) {
            throw new NotYetInitializedException(pinName, errorCode, message);
        }
        if (errorCode == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }

    @Override
    protected GovCS.ResultObject decrypt(CardChannel _channel, OCFCertificateInfo _info, byte[] _encryptedBytes, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        int i;
        GovCS.ResultObject ro = super.decrypt(_channel, _info, _encryptedBytes, algorithmParameters);
        byte[] b = (byte[])ro.getResultData();
        if (b == null || b.length < 3) {
            return ro;
        }
        if (b[0] != 0 || b[1] != 2) {
            return ro;
        }
        int count = b.length;
        for (i = 2; i < count && b[i] != 0; ++i) {
        }
        byte[] bb = new byte[b.length - i - 1];
        System.arraycopy(b, i + 1, bb, 0, bb.length);
        ro.setResultData(bb);
        return ro;
    }

    @Override
    public String getDisplayName() {
        return "DRV Mitarbeiterkarte " + super.getDisplayName();
    }

    @Override
    public boolean isMultiSign() {
        return true;
    }

    @Override
    public boolean isStapleSign() {
        return false;
    }

    @Override
    public Integer getStapleSignCounter() {
        return null;
    }
}

