/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.siemens;

import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.Siemensv43;
import de.bos_bremen.gov2.jca_provider.ocf.cards.util.CardErrorUtil;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.util.ArrayList;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public class Siemensv43BA
extends Siemensv43 {
    private static final String TOKEN_INFO_CONTENT = "BA PKCS#15 User Card";
    private static byte[] HISTORICALS = new byte[]{-56, 8};
    static final String ISSUER_CONSTANT = "BA";

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        long idOfPin = 2000001L;
        byte pinID = 1;
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000003L});
        CardApplication applicationSIGN = this.createSignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardApplication applicationENC = this.createEncDecApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardApplication applicationAUT = this.createAutApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardApplication applicationData = this.createDataApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationSIGN);
        mfManager.putApplication(applicationENC);
        mfManager.putApplication(applicationAUT);
        mfManager.putApplication(applicationData);
        mfManager.putPin(pin);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.getCardTypeEnum().getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createSignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfPin = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID("02");
        byte pinID = -127;
        FileReference dirRefApp = new FileReference(8, "1fff");
        FileReference cerRef01 = new FileReference(8, "5015430443f1");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig1", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Signature PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey01});
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin, k01);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("1fff", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putPin(pin);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    private CardApplication createEncDecApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000002L;
        long idOfFile = 3000003L;
        long idOfKey = 4000003L;
        KeyID k = new KeyID("03");
        FileReference dirRefApp = new FileReference(8, "501550724B03");
        FileReference cerRef = new FileReference(8, "501543044303");
        FileEntry fileEntry = new FileEntry(dirRefApp, cerRef);
        OCFCertificateInfo info = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile, idOfKey, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file = new CardFileImpl(Disposeable.NO_LOCK, "cerEncDec", idOfFile, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey);
        CardKeyImpl key = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/DecryptionKey", idOfKey, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType()}), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info, idOfFile, idOfPinCH, k);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("501550724B03", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType()}), fileEntry, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file);
        applicationApp.putKey(key);
        return applicationApp;
    }

    private CardApplication createAutApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000003L;
        long idOfFile = 3000004L;
        long idOfKey = 4000004L;
        KeyID k = new KeyID("01");
        FileReference dirRefApp = new FileReference(8, "501550724B01");
        FileReference cerRef = new FileReference(8, "501543044301");
        FileEntry fileEntry = new FileEntry(dirRefApp, cerRef);
        OCFCertificateInfo info = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile, idOfKey, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file = new CardFileImpl(Disposeable.NO_LOCK, "cerAut", idOfFile, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey);
        CardKeyImpl key = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_DECRYPTION.getType()}), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info, idOfFile, idOfPinCH, k);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("501550724B01", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntry, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file);
        applicationApp.putKey(key);
        return applicationApp;
    }

    private CardApplication createDataApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000004L;
        long idOfFile01 = 3000005L;
        long idOfFile02 = 3000006L;
        FileReference cerRef01 = new FileReference(8, "501543057401");
        FileEntry fileEntry01 = new FileEntry(cerRef01, cerRef01);
        FileReference cerRef02 = new FileReference(8, "501543057402");
        FileEntry fileEntry02 = new FileEntry(cerRef02, cerRef02);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, -1L, idOfFile01, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA1", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA2", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info02);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("50154305", idOfApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        return applicationApp;
    }

    @Override
    public OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[]{new OCFCertificateInfo(new FileReference(8, "1fff"), new FileReference(8, "501543044303"), new KeyID("02"), -127, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(8, "1fff"), new FileReference(8, "5015430443f1"), new KeyID("01"), -127, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(8, "501550724B02"), new FileReference(8, "501543044302"), new KeyID("02"), 1, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(8, "501550724B01"), new FileReference(8, "501543044301"), new KeyID("01"), 1, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(8, "501543057401"), new FileReference(8, "501543057401"), null, 0, OCFCertificateInfo.ChainEntry.CA), new OCFCertificateInfo(new FileReference(8, "501543057402"), new FileReference(8, "501543057402"), null, 0, OCFCertificateInfo.ChainEntry.CA)};
    }

    @Override
    protected boolean usesASN1HeaderWithSignHash() {
        return true;
    }

    @Override
    protected boolean usesASN1HeaderWithAuthentify() {
        return true;
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS;
    }

    @Override
    protected Card.CardTypeEnum getCardTypeEnum() {
        return Card.CardTypeEnum.BA;
    }

    @Override
    protected String getIssuerConstant() {
        return ISSUER_CONSTANT;
    }

    @Override
    public boolean isMultiSign() {
        return false;
    }

    @Override
    public boolean isStapleSign() {
        return false;
    }

    @Override
    public Integer getStapleSignCounter() {
        return -1;
    }

    @Override
    protected boolean isIssuerReadRequired() {
        return true;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA1");
            c.add("RIPEMD160");
            c.add("SHA224");
            c.add("SHA384");
            c.add("SHA512");
            c.add("SHA256");
        }
        return c;
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        try {
            String tokenInfoContent = this.readPKCS15TokenInfoFromCard(_channel);
            if (tokenInfoContent != null && tokenInfoContent.contains(TOKEN_INFO_CONTENT)) {
                return ISSUER_CONSTANT;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return "Bundesagentur f\u00fcr Arbeit (412, 413)";
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        int result = -1;
        try {
            CommandAPDU c = new CommandAPDU(HexUtil.parse("002000" + HexUtil.hexify(_info.getPinID())));
            ResponseAPDU r = _channel.sendCommandAPDU(c);
            if (r.sw() == 27013) {
                throw new NotYetInitializedException(Siemensv43BA.getPinNameForInfo(_info), r.sw(), "pin not initialized");
            }
            result = CardErrorUtil.getRetries(r.sw());
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected synchronized boolean isKeyInitialized(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        return true;
    }
}

