/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.siemens;

import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.util.PKCS15PinDataUtil;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Siemensv43
extends GovCS {
    private static final Log log = LogFactory.getLog(Siemensv43.class);
    private static final byte[] HISTORICALS = HexString.parseHexString("c8 04");
    static final String EF_GDO_ISSUER_CONSTANT = "5a 0e d2 76 42 66 41";
    private final PKCS15PinDataUtil pinDataUtil = new PKCS15PinDataUtil(this);

    @Override
    protected String getIssuerConstant() {
        return EF_GDO_ISSUER_CONSTANT;
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS;
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        return Arrays.equals(this.getHistoricals(), _historicals);
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        long idOfPin = 2000001L;
        byte pinID = 1;
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Authentisierungs-/Verschl\u00fcsselungs-PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000003L});
        CardApplication applicationSIGN = this.createSignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardApplication applicationENC = this.createEncDecApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardApplication applicationAUT = this.createAutApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardApplication applicationData = this.createDataApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardApplication drvApplicationData = this.createDrvDataApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationSIGN);
        mfManager.putApplication(applicationENC);
        mfManager.putApplication(applicationAUT);
        mfManager.putApplication(applicationData);
        mfManager.putApplication(drvApplicationData);
        mfManager.putPin(pin);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.getCardTypeEnum().getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createSignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfPin = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfKey01 = 4000001L;
        long idOfKey02 = 4000002L;
        KeyID k01 = new KeyID("02");
        KeyID k02 = new KeyID("01");
        byte pinID = -127;
        FileReference dirRefApp = new FileReference(8, "1fff");
        FileReference cerRef01 = new FileReference(8, "501543044303");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        FileReference cerRef02 = new FileReference(8, "5015430443f1");
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPin, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig1", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig2", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey01, idOfKey02});
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey1", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin, k01);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey2", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info02, idOfFile02, idOfPin, k02);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("1fff", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putPin(pin);
        applicationApp.putKey(key01);
        applicationApp.putKey(key02);
        return applicationApp;
    }

    private CardApplication createEncDecApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000002L;
        long idOfFile = 3000003L;
        long idOfKey = 4000003L;
        KeyID k = new KeyID("02");
        FileReference dirRefApp = new FileReference(8, "501550724B02");
        FileReference cerRef = new FileReference(8, "501543044302");
        FileEntry fileEntry = new FileEntry(dirRefApp, cerRef);
        OCFCertificateInfo info = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile, idOfKey, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file = new CardFileImpl(Disposeable.NO_LOCK, "cerEncDec", idOfFile, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey);
        CardKeyImpl key = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/DecryptionKey", idOfKey, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType()}), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info, idOfFile, idOfPinCH, k);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("501550724B02", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType()}), fileEntry, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file);
        applicationApp.putKey(key);
        return applicationApp;
    }

    private CardApplication createAutApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000003L;
        long idOfFile = 3000004L;
        long idOfKey = 4000004L;
        KeyID k = new KeyID("01");
        FileReference dirRefApp = new FileReference(8, "501550724B01");
        FileReference cerRef = new FileReference(8, "501543044301");
        FileEntry fileEntry = new FileEntry(dirRefApp, cerRef);
        OCFCertificateInfo info = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile, idOfKey, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file = new CardFileImpl(Disposeable.NO_LOCK, "cerAut", idOfFile, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey);
        CardKeyImpl key = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_DECRYPTION.getType()}), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info, idOfFile, idOfPinCH, k);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("501550724B01", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntry, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file);
        applicationApp.putKey(key);
        return applicationApp;
    }

    private CardApplication createDataApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000004L;
        long idOfFile01 = 3000005L;
        long idOfFile02 = 3000006L;
        FileReference cerRef01 = new FileReference(8, "501543057401");
        FileEntry fileEntry01 = new FileEntry(cerRef01, cerRef01);
        FileReference cerRef02 = new FileReference(8, "501543057402");
        FileEntry fileEntry02 = new FileEntry(cerRef02, cerRef02);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, -1L, idOfFile01, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA1", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA2", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info02);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("50154305", idOfApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        return applicationApp;
    }

    private CardApplication createDrvDataApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000005L;
        long idOfFile01 = 3000007L;
        long idOfFile02 = 3000008L;
        FileReference cerRef01 = new FileReference(8, "501543044305");
        FileEntry fileEntry01 = new FileEntry(cerRef01, cerRef01);
        FileReference cerRef02 = new FileReference(8, "501543044304");
        FileEntry fileEntry02 = new FileEntry(cerRef02, cerRef02);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, -1L, idOfFile01, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "drvCerCA1", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "drvCerCA2", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info02);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("50154304", idOfApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        return applicationApp;
    }

    @Override
    public OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[]{new OCFCertificateInfo(new FileReference(8, "1fff"), new FileReference(8, "501543044303"), new KeyID("02"), -127, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(8, "1fff"), new FileReference(8, "5015430443f1"), new KeyID("01"), -127, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(8, "501550724B02"), new FileReference(8, "501543044302"), new KeyID("02"), 1, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(8, "501550724B01"), new FileReference(8, "501543044301"), new KeyID("01"), 1, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(8, "501543057401"), new FileReference(8, "501543057401"), null, 0, OCFCertificateInfo.ChainEntry.CA), new OCFCertificateInfo(new FileReference(8, "501543057402"), new FileReference(8, "501543057402"), null, 0, OCFCertificateInfo.ChainEntry.CA)};
    }

    @Override
    protected GovCS.ResultObject readCertificate(CardChannel _channel, OCFCertificateInfo _info) throws ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        this.selectFileFile(_channel, _info);
        return this.readSelectedFile(_channel, 0, 2048);
    }

    @Override
    protected void selectFile(CardChannel _channel, OCFCertificateInfo _info, boolean _selectFile) throws ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        if (this.isMultiSign() && OCFProvider.Settings.getInstance().isServerEnvironmentActive() && this.checkChannelState(_channel, _info)) {
            return;
        }
        CommandAPDU cmd = new CommandAPDU(HexString.parseHexString("00A4040C0CA000000063504B43532D3135"));
        log.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("RES : " + HexString.hexify(res.getBuffer(), false)));
        cmd = APDUCommands.createSelectCommand(8, 12, _info.getDirectory().reference, 1024);
        log.debug((Object)("SELECT CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("SELECT RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err != 36864) {
            throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err));
        }
        super.setChannelState(_channel, _info);
    }

    protected void selectFileFile(CardChannel _channel, OCFCertificateInfo _info) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        byte[] path = _info.getFile().reference;
        byte[] store = new byte[5 + path.length];
        store[0] = 0;
        store[1] = -92;
        store[2] = 8;
        store[3] = 12;
        store[4] = (byte)path.length;
        System.arraycopy(path, 0, store, 5, path.length);
        CommandAPDU cmd = new CommandAPDU(store);
        log.debug((Object)("SELECT CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("SELECT RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err != 36864) {
            throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err));
        }
        super.setChannelState(_channel, _info);
    }

    @Override
    protected synchronized boolean isKeyInitialized(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        if (this.isMultiSign()) {
            return true;
        }
        CommandAPDU cmd = APDUCommands.createSelectCommand(8, 12, HexString.parseHexString("50157470"), 1024);
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        cmd = APDUCommands.createReadBinaryCommand(0, 127);
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        String s = new String(res.getBuffer(), 1, 5);
        boolean[] ku = _info.getX509Certificate().getKeyUsage();
        if (ku[0] || ku[2] || ku[3]) {
            s = new String(res.getBuffer(), 1, 2);
        } else if (ku[1]) {
            s = new String(res.getBuffer(), 3, 2);
        }
        this.selectFile(_channel, _info, true);
        return "EX".equals(s);
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return -1;
    }

    @Override
    protected synchronized boolean isInitialized(CardChannel _channel, CardPin _pin) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        if (this.isMultiSign()) {
            return true;
        }
        return super.isInitialized(_channel, _pin);
    }

    protected int evaluateVerifyPasswordResultCode(String pinName, int retry, int _resultcode) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, OperationCancelledException {
        super.evaluateVerifyPasswordResultCode(pinName, retry, _resultcode);
        if (_resultcode != 36864) {
            String errorMessage = "Verifikation fehlgeschlagen. Die Anzahl der verbleibenden Versuche kann nicht ermittelt werden.";
            if (_resultcode == 25344) {
                throw new WrongPinException(pinName, _resultcode, errorMessage);
            }
        }
        return _resultcode;
    }

    @Override
    protected boolean usesASN1HeaderWithSignHash() {
        return false;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA1");
        }
        return c;
    }

    @Override
    protected CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        cmd = new CommandAPDU(HexString.parseHexString("00220301"));
        log.debug((Object)("RESET MSE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("RESET MSE RES : " + HexString.hexify(res.getBuffer(), false)));
        byte[] keyID = _info.getKeyID().getID();
        byte[] data = new byte[2 + keyID.length];
        data[0] = -124;
        data[1] = (byte)keyID.length;
        System.arraycopy(keyID, 0, data, 2, keyID.length);
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)1, (byte)-72, data);
    }

    @Override
    protected byte getPaddingIndicator() {
        return 0;
    }

    @Override
    protected void adjustForPaddingByte(GovCS.ResultObject _ro) {
    }

    @Override
    protected boolean usesASN1HeaderWithAuthentify() {
        return true;
    }

    @Override
    protected final CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        if (!("BfA Berlin " + super.getDisplayName()).equals(this.getDisplayName())) {
            return this.createPKCS1v15SignExtendedCommand2048(_hashValue);
        }
        return this.createPKCS1v15SignShortCommand1024(_hashValue);
    }

    @Override
    public String getDisplayName() {
        return "BfA Berlin " + super.getDisplayName();
    }

    protected Card.CardTypeEnum getCardTypeEnum() {
        return Card.CardTypeEnum.BFA;
    }

    @Override
    public String getOSName() {
        return "(Siemens CardOS v.4.3)";
    }

    @Override
    public boolean isMultiSign() {
        return true;
    }

    @Override
    public void reset() {
        if (!super.isCardPresent()) {
            return;
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel cardChannel = cardChannelManager.init(this);
            this.resetInt(cardChannel);
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    private void resetInt(CardChannel channel) {
        super.resetChannelState(channel);
        try {
            this.selectMasterFile(channel);
        }
        catch (Exception e) {
            log.debug((Object)"selecting master file failed", (Throwable)e);
        }
    }

    @Override
    public int getMinPINLength(OCFCertificateInfo _info) {
        Integer min = this.pinDataUtil.getMinPINLength(_info);
        if (min != null) {
            return min;
        }
        return super.getMinPINLength(_info);
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        Integer max = this.pinDataUtil.getMaxPINLength(_info);
        if (max != null) {
            return max;
        }
        return super.getMaxPINLength(_info);
    }

    @Override
    public void analizeCardTerminal(CardTerminal _ct, boolean _keyboardAllowed) throws CardTerminalException {
        super.analizeCardTerminal(_ct, _keyboardAllowed);
        this.pinDataUtil.readPKCS15PinData();
    }

    @Override
    public boolean isStapleSign() {
        return GovCS.isStapleSign(this);
    }

    @Override
    public Integer getStapleSignCounter() {
        return this.isStapleSign() ? MAXIMUM_COUNT_OF_STAPLE_SIGNATURES : null;
    }

    @Override
    protected final CommandAPDU createDecryptCommand(byte[] _encryptedBytes, byte _paddingIndicator, AlgorithmParameters algorithmParameters) {
        if (_encryptedBytes.length >= 256) {
            int blockSize = 257;
            byte[] store = new byte[7 + blockSize + 2];
            Arrays.fill(store, (byte)-1);
            int i = 0;
            store[i++] = 0;
            store[i++] = 42;
            store[i++] = -128;
            store[i++] = -122;
            store[i++] = 0;
            store[i++] = (byte)(blockSize >> 8 & 0xFF);
            store[i++] = (byte)(blockSize >> 0 & 0xFF);
            store[i++] = this.getPaddingIndicator();
            System.arraycopy(_encryptedBytes, 0, store, i, _encryptedBytes.length);
            i += _encryptedBytes.length;
            int resultLength = 256;
            store[i++] = (byte)(resultLength >> 8 & 0xFF);
            store[i++] = (byte)(resultLength >> 0 & 0xFF);
            return new CommandAPDU(store);
        }
        return super.createDecryptCommand(_encryptedBytes, _paddingIndicator, algorithmParameters);
    }
}

