/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.siemens;

import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.siemens.Siemensv43;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DTrust2kMS
extends Siemensv43 {
    private static final Log LOG = LogFactory.getLog(DTrust2kMS.class);
    private static byte[] HISTORICALS = new byte[]{-56, 8};
    static final String EF_GDO_ISSUER_CONSTANT = "5a 0d d2 76 00 03 21";
    private static final String TOKEN_INFO_CONTENT = "multicard";
    private boolean asn1HeaderWithSignHash = false;

    @Override
    protected String getIssuerConstant() {
        return "5a 0d d2 76 00 03 21multicard";
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS;
    }

    @Override
    public String getDisplayName() {
        return "D-Trust-2k (25e) - MultiSign";
    }

    @Override
    protected boolean isIssuerReadRequired() {
        return true;
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        Object issuer = super.readIssuerFromATR(_channel);
        String pkcs15TokenInfo = super.readPKCS15TokenInfoFromCard(_channel);
        if (pkcs15TokenInfo != null && pkcs15TokenInfo.indexOf(TOKEN_INFO_CONTENT) >= 0 && pkcs15TokenInfo != null && pkcs15TokenInfo.indexOf(TOKEN_INFO_CONTENT) >= 0) {
            issuer = issuer == null ? TOKEN_INFO_CONTENT : (String)issuer + TOKEN_INFO_CONTENT;
        }
        return issuer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analizeCardTerminal(CardTerminal _ct, boolean _keyboardAllowed) throws CardTerminalException {
        super.analizeCardTerminal(_ct, _keyboardAllowed);
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            byte tag;
            CardChannel cc = cardChannelManager.init(this);
            cmd = new CommandAPDU(HexString.parseHexString("00 a4 00 0c 02 3f 00"));
            LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
            res = cc.sendCommandAPDU(cmd);
            LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
            cmd = new CommandAPDU(HexString.parseHexString("00 a4 02 0c 02 2f 00"));
            LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
            res = cc.sendCommandAPDU(cmd);
            LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
            cmd = new CommandAPDU(HexString.parseHexString("00 b0 00 00 00"));
            LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
            res = cc.sendCommandAPDU(cmd);
            LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
            byte[] buf = res.data();
            int i = 0;
            byte[] aid = null;
            while (i < buf.length && (tag = buf[i++]) == 97) {
                byte len = buf[i++];
                int end = i + len;
                while (i < end) {
                    tag = buf[i++];
                    len = buf[i++];
                    if (tag == 79) {
                        aid = new byte[len];
                        System.arraycopy(buf, i, aid, 0, len);
                        break;
                    }
                    i += len;
                }
                if (aid != null && Arrays.equals(aid, PKCS15AID)) break;
                aid = null;
            }
            if (aid != null) {
                cmd = new CommandAPDU(HexString.parseHexString("00 a4 04 0c 0c a0 00 00 00 63 50 4b 43 53 2d 31 35"));
                LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
                res = cc.sendCommandAPDU(cmd);
                LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
                cmd = new CommandAPDU(HexString.parseHexString("00 a4 02 0c 02 50 32"));
                LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
                res = cc.sendCommandAPDU(cmd);
                LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
                cmd = new CommandAPDU(HexString.parseHexString("00 b0 00 00 03"));
                LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
                res = cc.sendCommandAPDU(cmd);
                LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
                cmd = new CommandAPDU(HexString.parseHexString("00 b0 00 02 " + Integer.toHexString(res.data()[1])));
                LOG.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer())));
                res = cc.sendCommandAPDU(cmd);
                LOG.debug((Object)("RES : " + HexString.hexify(res.getBuffer())));
                buf = res.data();
                i = 0;
                int n = ++i;
                ++i;
                byte len = buf[n];
                i += len;
                int n2 = ++i;
                ++i;
                len = buf[n2];
                i += len;
                int n3 = ++i;
                ++i;
                len = buf[n3];
                i += len;
                int n4 = ++i;
                len = buf[n4];
                ByteBuffer bb = ByteBuffer.wrap(buf, ++i, len);
                CharBuffer cb = Charset.forName("UTF-8").decode(bb);
                String label = cb.toString();
                LOG.debug((Object)("Label : " + label));
                this.asn1HeaderWithSignHash = !label.endsWith("cc");
                LOG.debug((Object)("asn1HeaderWithSignHash : " + this.asn1HeaderWithSignHash));
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"", t);
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        long idOfPin = 2000001L;
        byte pinID = 1;
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Authentisierungs-/Verschl\u00fcsselungs-PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000003L});
        CardApplication applicationSIGN = this.createSignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardApplication applicationEncDecAut = this.createEncDecAutApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardApplication applicationData = this.createDataApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationSIGN);
        mfManager.putApplication(applicationEncDecAut);
        mfManager.putApplication(applicationData);
        mfManager.putPin(pin);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, Card.CardTypeEnum.DTRUST_24_2CC_MULTISIGN.getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createSignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfPin = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID("02");
        byte pinID = -127;
        FileReference dirRefApp = new FileReference(8, "1fff");
        FileReference cerRef01 = new FileReference(8, "5015430443f1");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig1", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey01});
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin, k01);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("1fff", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putPin(pin);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    private CardApplication createEncDecAutApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000002L;
        long idOfFile = 3000002L;
        long idOfKey = 4000003L;
        KeyID k = new KeyID("01");
        FileReference dirRefApp = new FileReference(8, "501550724B01");
        FileReference cerRef = new FileReference(8, "501543044301");
        FileEntry fileEntry = new FileEntry(dirRefApp, cerRef);
        OCFCertificateInfo info = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile, idOfKey, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file = new CardFileImpl(Disposeable.NO_LOCK, "cerEncDecAut", idOfFile, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey);
        CardKeyImpl key = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/DecryptionKey/AuthenticationKey", idOfKey, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_DECRYPTION.getType()}), fileEntry, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info, idOfFile, idOfPinCH, k);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("501550724B01", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntry, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file);
        applicationApp.putKey(key);
        return applicationApp;
    }

    private CardApplication createDataApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000004L;
        long idOfFile01 = 3000003L;
        long idOfFile02 = 3000004L;
        long idOfFile03 = 3000005L;
        long idOfFile04 = 3000006L;
        long idOfFile05 = 3000007L;
        long idOfFile06 = 3000008L;
        FileReference dirRef = new FileReference(8, "50154304");
        FileReference cerRef01 = new FileReference(8, "50154304c008");
        FileEntry fileEntry01 = new FileEntry(dirRef, cerRef01);
        FileReference cerRef02 = new FileReference(8, "50154304c708");
        FileEntry fileEntry02 = new FileEntry(dirRef, cerRef02);
        FileReference cerRef03 = new FileReference(8, "50154304c00e");
        FileEntry fileEntry03 = new FileEntry(dirRef, cerRef03);
        FileReference cerRef04 = new FileReference(8, "50154304c70e");
        FileEntry fileEntry04 = new FileEntry(dirRef, cerRef04);
        FileReference cerRef05 = new FileReference(8, "50154304c00f");
        FileEntry fileEntry05 = new FileEntry(dirRef, cerRef05);
        FileReference cerRef06 = new FileReference(8, "50154304c70f");
        FileEntry fileEntry06 = new FileEntry(dirRef, cerRef06);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, -1L, idOfFile01, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, -1L, idOfFile02, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, -1L, idOfFile03, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info04 = new OCFCertificateInfo(idOfCard, -1L, idOfFile04, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info05 = new OCFCertificateInfo(idOfCard, -1L, idOfFile05, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info06 = new OCFCertificateInfo(idOfCard, -1L, idOfFile06, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA1", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA2", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info02);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA3", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info03);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA4", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info04);
        CardFileImpl file05 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA5", idOfFile05, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry05, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info05);
        CardFileImpl file06 = new CardFileImpl(Disposeable.NO_LOCK, "cerCA6", idOfFile06, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry06, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info06);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("50154304", idOfApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putFile(file03);
        applicationApp.putFile(file04);
        applicationApp.putFile(file05);
        applicationApp.putFile(file06);
        return applicationApp;
    }

    @Override
    public OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[]{new OCFCertificateInfo(new FileReference(8, "1fff"), new FileReference(8, "5015430443f1"), new KeyID("02"), -127, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(8, "501550724B01"), new FileReference(8, "501543044301"), new KeyID("01"), 1, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(8, "50154304"), new FileReference(8, "50154304c008"), null, 0, OCFCertificateInfo.ChainEntry.CA), new OCFCertificateInfo(new FileReference(8, "50154304"), new FileReference(8, "50154304c708"), null, 0, OCFCertificateInfo.ChainEntry.CA), new OCFCertificateInfo(new FileReference(8, "50154304"), new FileReference(8, "50154304c00e"), null, 0, OCFCertificateInfo.ChainEntry.CA), new OCFCertificateInfo(new FileReference(8, "50154304"), new FileReference(8, "50154304c70e"), null, 0, OCFCertificateInfo.ChainEntry.CA), new OCFCertificateInfo(new FileReference(8, "50154304"), new FileReference(8, "50154304c00f"), null, 0, OCFCertificateInfo.ChainEntry.CA), new OCFCertificateInfo(new FileReference(8, "50154304"), new FileReference(8, "50154304c70f"), null, 0, OCFCertificateInfo.ChainEntry.CA)};
    }

    @Override
    protected boolean usesASN1HeaderWithSignHash() {
        return this.asn1HeaderWithSignHash;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        c.add("SHA1");
        if (this.asn1HeaderWithSignHash) {
            c.add("RIPEMD160");
            c.add("SHA224");
            c.add("SHA384");
            c.add("SHA512");
            c.add("SHA256");
        }
        return c;
    }

    @Override
    protected synchronized boolean isKeyInitialized(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        return true;
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        byte[] keyID = _info.getKeyID().getID();
        byte[] data = new byte[2 + keyID.length];
        data[0] = -125;
        data[1] = (byte)keyID.length;
        System.arraycopy(keyID, 0, data, 2, keyID.length);
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)1, (byte)-72, data);
    }

    @Override
    protected GovCS.ResultObject decrypt(CardChannel _channel, OCFCertificateInfo _info, byte[] _encryptedBytes, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        int i;
        GovCS.ResultObject ro = super.decrypt(_channel, _info, _encryptedBytes, algorithmParameters);
        byte[] b = (byte[])ro.getResultData();
        if (b == null || b.length < 3) {
            return ro;
        }
        if (b[0] != 0 || b[1] != 2) {
            return ro;
        }
        int count = b.length;
        for (i = 2; i < count && b[i] != 0; ++i) {
        }
        byte[] bb = new byte[b.length - i - 1];
        System.arraycopy(b, i + 1, bb, 0, bb.length);
        ro.setResultData(bb);
        return ro;
    }

    @Override
    public boolean isMultiSign() {
        return true;
    }

    @Override
    public boolean isStapleSign() {
        return Siemensv43.isStapleSign(this);
    }

    @Override
    public Integer getStapleSignCounter() {
        return this.isStapleSign() ? MAXIMUM_COUNT_OF_STAPLE_SIGNATURES : null;
    }
}

