/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.seccos;

import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.seccos.SECCOS;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VR10
extends SECCOS {
    private static final Log log = LogFactory.getLog(VR10.class);
    private static int GET_DATA_SIGNIFICANT_INDEX = 112;
    private static int GET_DATA_SIGNIFICANT_BYTES = 8;
    private static final List<String> INITIALISATION_TABLE_MULTISIGN_IDENTIFIER_LIST_SHORT = Arrays.asList(new String[0]);
    private static final List<String> INITIALISATION_TABLE_IDENTIFIER_LIST_SHORT = Arrays.asList("GDP4G870", "GDI3G665");
    private static final String SINGLE_SIGN_CARD = "VR-BankCard/VR-NetWorld-Card (500)";
    private static final String MULTI_SIGN_CARD = "VR-BankCard/VR-NetWorld-Card (501 - Massensignaturkarte)";
    private static final String PRE_ISSUER_CONSTANT_VR_CARD = "VR";
    private static final String[] VALID_CARD_NUMBER_PREFIXES = new String[]{"5A 0A 67 26", "5A 0A 67 29"};
    private static final byte[][] HISTORICALS = new byte[][]{HexString.parseHexString("65 63 11 06 40 02 50 00 10 00 00 00 00 05 00"), HexString.parseHexString("65 63 11 06 62 02 80 00 11 00 00 00 00 06 13"), HexString.parseHexString("65 63 0d 07 63 07 64 00 0d 00 00 00 00 06 15"), HexString.parseHexString("65 63 11 07 64 02 80 00 11 00 00 00 00 06 19"), HexString.parseHexString("65 63 11 08 43 02 50 00 10 00 00 00 00 05 30"), HexString.parseHexString("65 63 11 08 66 02 80 00 11 00 00 00 00 06 20"), HexString.parseHexString("65 63 0d 08 65 07 64 00 0d 00 00 00 00 06 16"), HexString.parseHexString("65 63 19 01 50 02 80 00 0f 00 00 00 00 50 12"), HexString.parseHexString("65 63 11 08 66 01 56 00 11 00 00 00 00 06 20"), HexString.parseHexString("65 63 11 08 43 02 50 00 10 52 30 02 07 05 30")};
    private final int historicalsIndex = 0;
    private Boolean multiSign = null;
    private final Boolean sha256Supported = null;

    @Override
    protected String getIssuerConstant() {
        return PRE_ISSUER_CONSTANT_VR_CARD;
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS[0];
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        return true;
    }

    @Override
    public byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        return -1;
    }

    @Override
    public String getDisplayName() {
        return this.multiSign == null || this.multiSign == false ? SINGLE_SIGN_CARD : MULTI_SIGN_CARD;
    }

    @Override
    protected boolean usesASN1HeaderWithAuthentify() {
        return true;
    }

    @Override
    protected final CommandAPDU createDecryptCommand(byte[] _encryptedBytes, byte _paddingIndicator, AlgorithmParameters algorithmParameters) {
        if (_encryptedBytes != null && _encryptedBytes.length >= 256) {
            int index = 0;
            byte[] store = new byte[10 + _encryptedBytes.length];
            store[index++] = 0;
            store[index++] = 42;
            store[index++] = -128;
            store[index++] = -122;
            store[index++] = 0;
            store[index++] = (byte)(_encryptedBytes.length + 1 >> 8 & 0xFF);
            store[index++] = (byte)(_encryptedBytes.length + 1 & 0xFF);
            store[index++] = _paddingIndicator;
            System.arraycopy(_encryptedBytes, 0, store, index, _encryptedBytes.length);
            index += _encryptedBytes.length;
            store[index++] = 1;
            store[index++] = 0;
            return new CommandAPDU(store);
        }
        return super.createDecryptCommand(_encryptedBytes, _paddingIndicator, algorithmParameters);
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        try {
            String cardNumber = super.readIssuerFromATR(_channel, 4).toUpperCase();
            if (cardNumber != null) {
                for (String prefix : VALID_CARD_NUMBER_PREFIXES) {
                    if (!cardNumber.equals(prefix)) continue;
                    return PRE_ISSUER_CONSTANT_VR_CARD;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private String checkMultiSign(CardChannel _channel, String result, boolean tryGetData) throws CardTerminalException, ResponseCodeException {
        int err;
        ResponseAPDU res = _channel.sendCommandAPDU(new CommandAPDU(HexString.parseHexString("00 ca df 20 00")));
        if (res == null) {
            tryGetData = true;
        }
        if ((err = res.sw()) != 36864) {
            tryGetData = true;
        }
        if (res.data() == null && tryGetData) {
            CommandAPDU cmd = new CommandAPDU(HexString.parseHexString("00 ca 01 80 00"));
            res = _channel.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            err = res.sw();
            if (err != 36864) {
                throw new ResponseCodeException(err, APDUCommands.getReadBinaryErrorMsg(err));
            }
        }
        if (res.sw() == 36864 && res != null && res.data() != null && res.data().length >= GET_DATA_SIGNIFICANT_INDEX + GET_DATA_SIGNIFICANT_BYTES + 1) {
            log.debug((Object)("Complete initialization table:\n" + HexUtil.dump(res.data())));
            String initializationTableId = new String(res.data(), GET_DATA_SIGNIFICANT_INDEX, GET_DATA_SIGNIFICANT_BYTES);
            log.debug((Object)("Used initialization table id: " + initializationTableId));
            if (INITIALISATION_TABLE_IDENTIFIER_LIST_SHORT.contains(initializationTableId)) {
                this.multiSign = INITIALISATION_TABLE_MULTISIGN_IDENTIFIER_LIST_SHORT.contains(new String(res.data(), GET_DATA_SIGNIFICANT_INDEX, GET_DATA_SIGNIFICANT_BYTES));
                result = PRE_ISSUER_CONSTANT_VR_CARD;
            }
        }
        return result;
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        long idOfPin = 2000001L;
        byte pinID = 3;
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Authentisierungs-/Verschl\u00fcsselungs-PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000002L});
        CardApplication applicationSIGN = this.createSignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationSIGN);
        mfManager.putPin(pin);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, Card.CardTypeEnum.VR_10.getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createSignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfPin = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfFile03 = 3000003L;
        long idOfFile04 = 3000004L;
        long idOfFile05 = 3000005L;
        long idOfKey01 = 4000001L;
        long idOfKey02 = 4000002L;
        long idOfKey03 = 4000003L;
        KeyID k01 = new KeyID("0400");
        KeyID k02 = new KeyID("0200");
        KeyID k03 = new KeyID("0300");
        byte pinID = -127;
        FileReference dirRefApp = new FileReference(4, "d27600006601");
        FileReference cerRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        FileReference cerRef02 = new FileReference(2, "c500");
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02);
        FileReference cerRef03 = new FileReference(2, "c608");
        FileEntry fileEntry03 = new FileEntry(dirRefApp, cerRef03);
        FileReference cerRef04 = new FileReference(2, "c708");
        FileEntry fileEntry04 = new FileEntry(dirRefApp, cerRef04);
        FileReference cerRef05 = new FileReference(2, "c200");
        FileEntry fileEntry05 = new FileEntry(dirRefApp, cerRef05);
        long idOfAutPin = idOfPinCH;
        long idOfCipherPin = idOfPinCH;
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfAutPin, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, -1L, idOfFile03, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info04 = new OCFCertificateInfo(idOfCard, -1L, idOfFile04, -1L, OCFCertificateInfo.ChainEntry.CA, null, null);
        OCFCertificateInfo info05 = new OCFCertificateInfo(idOfCard, idOfCipherPin, idOfFile05, idOfKey03, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey01});
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerAut", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "cerSigCA", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info03);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "cerEncDecAutCA", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info04);
        CardFileImpl file05 = new CardFileImpl(Disposeable.NO_LOCK, "cerEncDec", idOfFile05, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry05, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L, info05);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin, k01);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKey", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info02, idOfFile02, idOfAutPin, k02);
        CardKeyImpl key03 = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/DecryptionKey", idOfKey03, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType()}), fileEntry05, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info05, idOfFile05, idOfCipherPin, k03);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider01 = this.createDefaultAlgorithmProviderSignature();
        key01.setAlgorithmProvider(algorithmProvider01);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("d27600006601", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType(), CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putPin(pin);
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putFile(file03);
        applicationApp.putFile(file04);
        applicationApp.putFile(file05);
        applicationApp.putKey(key01);
        applicationApp.putKey(key02);
        applicationApp.putKey(key03);
        return applicationApp;
    }

    @Override
    public OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[0];
    }

    public static CommandAPDU createMSEforDecryption(byte[] _keyID) {
        int index = 0;
        byte[] data = new byte[6];
        data[index++] = -124;
        data[index++] = 1;
        data[index++] = (byte)(_keyID[0] | 0x80);
        data[index++] = -128;
        data[index++] = 1;
        data[index] = 26;
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-72, data);
    }

    public static CommandAPDU createMSEforAuthentication(byte[] _keyID) {
        int index = 0;
        byte[] data = new byte[3];
        data[index++] = -124;
        data[index++] = 1;
        data[index++] = (byte)(_keyID[0] | 0x80);
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-92, data);
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        byte[] algorithmID = null;
        if (algorithmParameters != null) {
            try {
                CardExecutionSignAuthenticateParameterSpec spec = algorithmParameters.getParameterSpec(CardExecutionSignAuthenticateParameterSpec.class);
                if (spec != null && spec.getAlgorithmName().endsWith("andMGF1")) {
                    algorithmID = spec.getAlgorithmID();
                }
            }
            catch (InvalidParameterSpecException e) {
                log.debug((Object)"no parameters found");
            }
        }
        switch (_type) {
            case 0: {
                ByteArrayOutputStream data;
                if (algorithmID != null) {
                    data = new ByteArrayOutputStream();
                    data.write(-119);
                    data.write(algorithmID.length);
                    try {
                        data.write(algorithmID);
                    }
                    catch (IOException e) {
                        throw new ResponseCodeException("prepare select of algorithm failed: " + e.getMessage());
                    }
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
                }
                if ("SHA1".equals(_hashAlgorithm)) {
                    data = new ByteArrayOutputStream();
                    data.write(-128);
                    data.write(1);
                    data.write(16);
                    CommandAPDU cmd = APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-86, data.toByteArray());
                    ResponseAPDU res = _channel.sendCommandAPDU(cmd);
                    if (res == null || res.sw() != 36864) {
                        throw new ResponseCodeException(res.sw(), "selecting of hash algorithm failed");
                    }
                    data = new ByteArrayOutputStream();
                    data.write(-128);
                    data.write(1);
                    data.write(18);
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
                }
                if ("SHA256".equals(_hashAlgorithm)) {
                    data = new ByteArrayOutputStream();
                    data.write(-128);
                    data.write(1);
                    data.write(64);
                    CommandAPDU cmd = APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-86, data.toByteArray());
                    ResponseAPDU res = _channel.sendCommandAPDU(cmd);
                    if (res == null || res.sw() != 36864) {
                        throw new ResponseCodeException(res.sw(), "selecting of hash algorithm failed");
                    }
                    data = new ByteArrayOutputStream();
                    data.write(-128);
                    data.write(1);
                    data.write(66);
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
                }
                if ("SHA384".equals(_hashAlgorithm)) {
                    data = new ByteArrayOutputStream();
                    data.write(-128);
                    data.write(1);
                    data.write(80);
                    CommandAPDU cmd = APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-86, data.toByteArray());
                    ResponseAPDU res = _channel.sendCommandAPDU(cmd);
                    if (res == null || res.sw() != 36864) {
                        throw new ResponseCodeException(res.sw(), "selecting of hash algorithm failed");
                    }
                    data = new ByteArrayOutputStream();
                    data.write(-128);
                    data.write(1);
                    data.write(82);
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
                }
                if ("SHA512".equals(_hashAlgorithm)) {
                    data = new ByteArrayOutputStream();
                    data.write(-128);
                    data.write(1);
                    data.write(96);
                    CommandAPDU cmd = APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-86, data.toByteArray());
                    ResponseAPDU res = _channel.sendCommandAPDU(cmd);
                    if (res == null || res.sw() != 36864) {
                        throw new ResponseCodeException(res.sw(), "selecting of hash algorithm failed");
                    }
                    data = new ByteArrayOutputStream();
                    data.write(-128);
                    data.write(1);
                    data.write(98);
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
                }
                if ("RIPEMD160".equals(_hashAlgorithm)) {
                    data = new ByteArrayOutputStream();
                    data.write(-128);
                    data.write(1);
                    data.write(32);
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-86, data.toByteArray());
                }
                return null;
            }
            case 1: {
                return VR10.createMSEforDecryption(_info.getKeyID().getID());
            }
            case 2: {
                return VR10.createMSEforAuthentication(_info.getKeyID().getID());
            }
        }
        return null;
    }

    @Override
    protected void adjustForPaddingByte(GovCS.ResultObject _ro) {
    }

    @Override
    protected final CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[6 + _hashValue.length];
        store[0] = 0;
        store[1] = -120;
        store[2] = 0;
        store[3] = 0;
        store[4] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, store, 5, _hashValue.length);
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, smartcard, blocking);
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            String tmp = "";
            tmp = this.checkMultiSign(channel, tmp, true);
            for (int i = 1; i < 10 && this.siggAnalyzer.checkAlgSuppport(channel, (byte)i, true, i == 1); ++i) {
            }
            List<String> listAlgSigPKCS1PSS = this.siggAnalyzer.getListAlgSigPKCS1PSS();
            listAlgSigPKCS1PSS.remove("SHA384");
            listAlgSigPKCS1PSS.remove("SHA512");
            listAlgSigPKCS1PSS.remove("SHA224");
            this.siggAnalyzer.dumpAlgorithms();
        }
        catch (Exception exception) {
        }
        finally {
            if (cardChannelManager.getCardChannel() != null) {
                try {
                    this.selectMasterFile(cardChannelManager.getCardChannel());
                }
                catch (Exception exception) {}
            }
            cardChannelManager.destroy();
        }
    }

    @Override
    public boolean isMultiSign() {
        return this.multiSign != null ? this.multiSign : false;
    }

    @Override
    public synchronized GovCS.ResultObject decrypt(OCFCertificateInfo _info, byte[] bytes, char[] _pin, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, OperationCancelledException {
        GovCS.ResultObject ro = super.decrypt(_info, bytes, _pin, algorithmParameters);
        if ((this.ctReference.getName().toLowerCase().contains("omnikey") || this.ctReference.getName().toLowerCase().contains("XX44")) && PCSCCardTerminal.class.isInstance(this.ctReference)) {
            try {
                ((PCSCCardTerminal)this.ctReference).resetSlot(0);
            }
            catch (CardTerminalException cardTerminalException) {
                // empty catch block
            }
        }
        return ro;
    }
}

