/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.seccos;

import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ocf.DefaultBaseAlgorithmProviderBuilder;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GDCardHelper;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SECCOS
extends GovCS {
    public static final GDCardHelper.AsymmetricKeyIdentifier ASYMMETRIC_KEY_IDENTIFIER = new GDCardHelper.AsymmetricKeyIdentifier(){

        @Override
        public boolean isAsymmetricKey(byte[] recordBytes) {
            if (recordBytes == null || recordBytes.length == 0) {
                return false;
            }
            return (recordBytes[0] & 0xFFFFFF90) != -112;
        }
    };
    private static final Log LOG = LogFactory.getLog(SECCOS.class);
    public static final String ASN1_ALGORITHM_ID_TAG_LENGTH = "8903";
    protected final GDCardHelper.CheckAlgAnalyzer siggAnalyzer = new GDCardHelper.CheckAlgAnalyzer(this, "D2 76 00 00 66 01".replaceAll(" ", ""), MAP_SIG_ALGORITHM_PKCS1V15, MAP_SIG_ALGORITHM_PKCS1PSS, MAP_SIG_ALGORITHM_DINSIG, MAP_AUT_ALGORITHM, null, ASYMMETRIC_KEY_IDENTIFIER);
    public static final Map<String, String> MAP_SIG_ALGORITHM_PKCS1V15;
    public static final Map<String, String> MAP_SIG_ALGORITHM_PKCS1PSS;
    public static final Map<String, String> MAP_SIG_ALGORITHM_DINSIG;
    public static final Map<String, String> MAP_AUT_ALGORITHM;

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        LOG.debug((Object)("info: " + _info));
        List<String> result = new ArrayList<String>();
        if (_info == null || _info.getChainEntry() != OCFCertificateInfo.ChainEntry.USER || _info.getKey() == null || _info.getKey().getType() == null) {
            return result;
        }
        Type type = _info.getKey().getType();
        LOG.debug((Object)("type: " + type));
        if ((type.getType() & CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getTypeValue()) == CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getTypeValue()) {
            LOG.debug((Object)"authentication");
            result = this.siggAnalyzer.getListAlgAut();
        } else if ((type.getType() & CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getTypeValue()) == CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getTypeValue()) {
            LOG.debug((Object)"signature");
            result = this.siggAnalyzer.getListAlgSig();
        }
        return result;
    }

    private List<String> getAlgorithmIDs(Map<String, String> mapAlgorithms, List<String> listAlgorithms) {
        ArrayList<String> result = new ArrayList<String>();
        for (String algorithm : listAlgorithms) {
            result.add(this.getAlgorithmID(mapAlgorithms, algorithm));
        }
        return result;
    }

    private String getAlgorithmID(Map<String, String> mapAlgorithms, String algorithm) {
        for (Map.Entry<String, String> e : mapAlgorithms.entrySet()) {
            if (!e.getValue().equals(algorithm)) continue;
            String k = e.getKey();
            return k.substring(k.indexOf(ASN1_ALGORITHM_ID_TAG_LENGTH) + ASN1_ALGORITHM_ID_TAG_LENGTH.length());
        }
        return null;
    }

    protected final AlgorithmProvider<OCFPrivateKey> createDefaultAlgorithmProviderSignature() {
        List<UsageRelated.Usage> usageList01 = Arrays.asList(UsageRelated.Usage.SIGNATURE);
        ArrayList listKeyAlgorithms01 = new ArrayList();
        try {
            List<String> listAlgSigPKCS1V15 = this.siggAnalyzer.getListAlgSigPKCS1V15();
            List<String> listAlgSigPKCS1PSS = this.siggAnalyzer.getListAlgSigPKCS1PSS();
            List<String> listAlgSigDINSIG = this.siggAnalyzer.getListAlgSigDINSIG();
            for (String a : listAlgSigDINSIG) {
                String[] separators;
                for (String separator : separators = new String[]{"with", "hashedWith"}) {
                    listKeyAlgorithms01.add(DefaultBaseAlgorithmProviderBuilder.createAlgorithm(usageList01, "", "/DINSIG", a, Boolean.FALSE, this.getAlgorithmID(MAP_SIG_ALGORITHM_DINSIG, a), separator));
                }
            }
            listKeyAlgorithms01.addAll(DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAPKCS1Algorithms(listAlgSigPKCS1V15, DefaultBaseAlgorithmProviderBuilder.createDigestInfoUsages(listAlgSigPKCS1V15.size(), Boolean.FALSE), this.getAlgorithmIDs(MAP_SIG_ALGORITHM_PKCS1V15, listAlgSigPKCS1V15), usageList01));
            listKeyAlgorithms01.addAll(DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAPSSAlgorithms(listAlgSigPKCS1PSS, DefaultBaseAlgorithmProviderBuilder.createDigestInfoUsages(listAlgSigPKCS1PSS.size(), Boolean.FALSE), this.getAlgorithmIDs(MAP_SIG_ALGORITHM_PKCS1PSS, listAlgSigPKCS1PSS), usageList01));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        Collections.reverse(listKeyAlgorithms01);
        return this.createAlgorithmProvider(listKeyAlgorithms01);
    }

    @Override
    public String getOSName() {
        return "SECCOS";
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        return Arrays.equals(this.getHistoricals(), _historicals);
    }

    @Override
    protected boolean usesASN1HeaderWithSignHash() {
        return false;
    }

    @Override
    public int getMinPINLength(OCFCertificateInfo _info) {
        return 4;
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        return 12;
    }

    protected byte[] get2BlockPin(OCFCertificateInfo _info, char[] _pin) {
        byte[] result = new byte[this.getPasswordBlockLength(_info)];
        Arrays.fill(result, this.getPasswordBlockFiller(_info));
        result[0] = (byte)(0x20 | (_pin == null ? 15 : _pin.length));
        if (_pin != null) {
            char[] pin = new char[_pin.length];
            System.arraycopy(_pin, 0, pin, 0, pin.length);
            int j = 0;
            for (int i = 1; i < result.length && j < pin.length; ++i) {
                result[i] = (byte)((pin[j++] & 0xF) << 4);
                if (j < pin.length) {
                    int n = i;
                    result[n] = (byte)(result[n] | (byte)(pin[j++] & 0xF));
                    continue;
                }
                int n = i;
                result[n] = (byte)(result[n] | 0xF);
            }
            Arrays.fill(pin, '\u0000');
        }
        return result;
    }

    @Override
    public int getPasswordBlockLength(OCFCertificateInfo _info) {
        if (_info.getX509Certificate().getKeyUsage()[1]) {
            return 8;
        }
        return super.getPasswordBlockLength(_info);
    }

    @Override
    protected byte[] getPaddedPIN(OCFCertificateInfo _info, char[] _pin) {
        if (_info.getX509Certificate().getKeyUsage()[1]) {
            return this.get2BlockPin(_info, _pin);
        }
        return super.getPaddedPIN(_info, _pin);
    }

    @Override
    public PinEncoder getPinEncoder(OCFCertificateInfo _info) {
        if (_info.getX509Certificate().getKeyUsage()[1]) {
            return PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK;
        }
        return super.getPinEncoder(_info);
    }

    @Override
    protected final GovCS.ResultObject signHash(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        byte[] buffer = new byte[7 + _hashValue.length];
        buffer[0] = 0;
        buffer[1] = 42;
        buffer[2] = -112;
        buffer[3] = -96;
        buffer[4] = (byte)(_hashValue.length + 2);
        buffer[5] = -112;
        buffer[6] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, buffer, 7, _hashValue.length);
        CommandAPDU cmd = new CommandAPDU(buffer);
        LOG.debug((Object)("PUT HASH CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("PUT HASH RES  : " + HexString.hexify(res.getBuffer(), false)));
        if (OCFProvider.Settings.getInstance().isServerEnvironmentActive() && res.sw() == 27264 && algorithmParameters.getAlgorithm().endsWith("andMGF1")) {
            _channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("0022f301")));
            _channel.sendCommandAPDU(this.createMSECommand(_channel, _info, 0, _hashAlgorithm, algorithmParameters));
            res = _channel.sendCommandAPDU(cmd);
        }
        if ("RIPEMD160".equals(_hashAlgorithm)) {
            cmd = new CommandAPDU(HexString.parseHexString("00 22 41 b6 03 80 01 21"));
            LOG.debug((Object)("MSE SET CMD : " + HexString.hexify(cmd.getBuffer(), false)));
            res = _channel.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            LOG.debug((Object)("MSE SET RES  : " + HexString.hexify(res.getBuffer(), false)));
        }
        return super.signHash(_channel, _info, null, _hashAlgorithm, algorithmParameters);
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws NotYetInitializedException, RetryCounterExpiredException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        byte[] data;
        int resultCode;
        String pinName = SECCOS.getPinNameForInfo(_info);
        this.selectMasterFile(_channel);
        if ((_info.getPinID() & 0xF0) == 128) {
            this.selectSubDirectory(_channel, _info.getDirectory());
        }
        this.selectFile(_channel, new FileReference(2, "0016"));
        int recordIndex = 1;
        CommandAPDU cmd = APDUCommands.createReadRecordCommand(recordIndex);
        LOG.debug((Object)("RR CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("RR RES : " + HexString.hexify(res.getBuffer(), false)));
        if (res.sw() == 24848) {
            cmd = new CommandAPDU(HexString.parseHexString("00c0000000"));
            LOG.debug((Object)("GET CMD : " + HexString.hexify(cmd.getBuffer(), false)));
            res = _channel.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            LOG.debug((Object)("GET RES : " + HexString.hexify(res.getBuffer(), false)));
        }
        if ((resultCode = res.sw()) == 27011) {
            throw new RetryCounterExpiredException(pinName, resultCode, APDUCommands.getVerifyErrorMsg(resultCode));
        }
        if (resultCode == 27013) {
            throw new NotYetInitializedException(pinName, resultCode, APDUCommands.getVerifyErrorMsg(resultCode));
        }
        int result = -1;
        if (resultCode == 36864 && (data = res.data()).length == 2) {
            result = data[1];
        }
        this.selectSubDirectory(_channel, _info.getDirectory());
        return result;
    }

    @Override
    protected CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 1: 
            case 2: {
                return APDUCommands.createMSEforDecryption(_info.getKeyID().getID());
            }
        }
        return null;
    }

    static {
        LinkedHashMap<String, String> tmp = new LinkedHashMap<String, String>();
        tmp.put("b6058903132310", "SHA1");
        tmp.put("b6058903132320", "RIPEMD160");
        tmp.put("b6058903132360", "SHA224");
        tmp.put("b6058903132340", "SHA384");
        tmp.put("b6058903132350", "SHA512");
        tmp.put("b6058903132330", "SHA256");
        MAP_SIG_ALGORITHM_PKCS1V15 = Collections.unmodifiableMap(tmp);
        tmp = new LinkedHashMap();
        tmp.put("b6058903133310", "SHA1");
        tmp.put("b6058903133320", "RIPEMD160");
        tmp.put("b6058903133360", "SHA224");
        tmp.put("b6058903133340", "SHA384");
        tmp.put("b6058903133350", "SHA512");
        tmp.put("b6058903133330", "SHA256");
        MAP_SIG_ALGORITHM_PKCS1PSS = Collections.unmodifiableMap(tmp);
        tmp = new LinkedHashMap();
        tmp.put("b6058903131310", "SHA1");
        tmp.put("b6058903131320", "RIPEMD160");
        tmp.put("b6058903131360", "SHA224");
        tmp.put("b6058903131340", "SHA384");
        tmp.put("b6058903131350", "SHA512");
        tmp.put("b6058903131330", "SHA256");
        MAP_SIG_ALGORITHM_DINSIG = Collections.unmodifiableMap(tmp);
        tmp = new LinkedHashMap();
        tmp.put("a4058903235310", "SHA1");
        tmp.put("a4058903235320", "RIPEMD160");
        tmp.put("a4058903235360", "SHA224");
        tmp.put("a4058903235340", "SHA384");
        tmp.put("a4058903235350", "SHA512");
        tmp.put("a4058903235330", "SHA256");
        MAP_AUT_ALGORITHM = Collections.unmodifiableMap(tmp);
    }
}

