/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.pingui;

import de.bos_bremen.common.ArrayUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SquareGridLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -7411804673224730901L;
    private int hgap;
    private int vgap;
    private int rows;
    private int cols;
    private int alignment;
    public static final List<Integer> POSSIBLE_ALIGNMENTS = Collections.unmodifiableList(Arrays.asList(ArrayUtil.to(new int[]{8, 1, 2, 7, 0, 3, 6, 5, 4})));

    public SquareGridLayout() {
        this(1, 0, 0, 0, 8);
    }

    public SquareGridLayout(int rows, int cols) throws IllegalArgumentException {
        this(rows, cols, 0, 0, 8);
    }

    public SquareGridLayout(int rows, int cols, int alignment) throws IllegalArgumentException {
        this(rows, cols, 0, 0, alignment);
    }

    public SquareGridLayout(int rows, int cols, int hgap, int vgap, int alignment) throws IllegalArgumentException {
        if (rows == 0 && cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        if (!POSSIBLE_ALIGNMENTS.contains(alignment)) {
            throw new IllegalArgumentException("no possible alignment, permitted only: " + POSSIBLE_ALIGNMENTS);
        }
        this.rows = rows;
        this.cols = cols;
        this.hgap = hgap;
        this.vgap = vgap;
        this.alignment = alignment;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        if (rows == 0 && this.cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setColumns(int cols) {
        if (cols == 0 && this.rows == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.cols = cols;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.rows;
            int ncols = this.cols;
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            int w = 0;
            int h = 0;
            for (int i = 0; i < ncomponents; ++i) {
                Component comp = parent.getComponent(i);
                Dimension d = comp.getPreferredSize();
                if (w < d.width) {
                    w = d.width;
                }
                if (h >= d.height) continue;
                h = d.height;
            }
            return new Dimension(insets.left + insets.right + ncols * w + (ncols - 1) * this.hgap, insets.top + insets.bottom + nrows * h + (nrows - 1) * this.vgap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.rows;
            int ncols = this.cols;
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            int w = 0;
            int h = 0;
            for (int i = 0; i < ncomponents; ++i) {
                Component comp = parent.getComponent(i);
                Dimension d = comp.getMinimumSize();
                if (w < d.width) {
                    w = d.width;
                }
                if (h >= d.height) continue;
                h = d.height;
            }
            return new Dimension(insets.left + insets.right + ncols * w + (ncols - 1) * this.hgap, insets.top + insets.bottom + nrows * h + (nrows - 1) * this.vgap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.rows;
            int ncols = this.cols;
            boolean ltr = parent.getComponentOrientation().isLeftToRight();
            if (ncomponents == 0) {
                return;
            }
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            int w = parent.getWidth() - (insets.left + insets.right);
            int h = parent.getHeight() - (insets.top + insets.bottom);
            int offsetx = w;
            int offsety = h;
            w = (w - (ncols - 1) * this.hgap) / ncols;
            h = (h - (nrows - 1) * this.vgap) / nrows;
            w = Math.min(w, h);
            h = Math.min(w, h);
            switch (this.alignment) {
                case 6: 
                case 7: 
                case 8: {
                    offsetx = 0;
                    break;
                }
                case 0: 
                case 1: 
                case 5: {
                    offsetx = (offsetx - w * ncols) / 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    offsetx -= w * ncols;
                }
            }
            switch (this.alignment) {
                case 1: 
                case 2: 
                case 8: {
                    offsety = 0;
                    break;
                }
                case 0: 
                case 3: 
                case 7: {
                    offsety = (offsety - h * nrows) / 2;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    offsety -= h * nrows;
                }
            }
            w -= 2;
            h -= 2;
            if (ltr) {
                int c = 0;
                int x = insets.left;
                while (c < ncols) {
                    int r = 0;
                    int y = insets.top;
                    while (r < nrows) {
                        int i = r * ncols + c;
                        if (i < ncomponents) {
                            Component cp = parent.getComponent(i);
                            cp.setBounds(x + offsetx, y + offsety, w, h);
                        }
                        ++r;
                        y += h + this.vgap;
                    }
                    ++c;
                    x += w + this.hgap;
                }
            } else {
                int c = 0;
                int x = parent.getWidth() - insets.right - w;
                while (c < ncols) {
                    int r = 0;
                    int y = insets.top;
                    while (r < nrows) {
                        int i = r * ncols + c;
                        if (i < ncomponents) {
                            Component cp = parent.getComponent(i);
                            cp.setBounds(x + offsetx, y + offsety, w, h);
                        }
                        ++r;
                        y += h + this.vgap;
                    }
                    ++c;
                    x -= w + this.hgap;
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + "]";
    }
}

