/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.pingui;

import de.bos_bremen.gov2.jca_provider.ocf.cards.pingui.SEBorders;
import de.bos_bremen.gov2.jca_provider.ocf.cards.pingui.SEButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import sun.swing.CachedPainter;
import sun.swing.SwingUtilities2;

public class SEButtonUI
extends BasicButtonUI {
    public static final int ROUND_ARC = 50;
    private static final SEButtonUI seButtonUI = new SEButtonUI();
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;
    private MouseAdapter adapter = null;

    public static ComponentUI createUI(JComponent c) {
        return seButtonUI;
    }

    @Override
    public void installDefaults(final AbstractButton b) {
        this.adapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                b.getModel().setRollover(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                b.getModel().setRollover(false);
            }
        };
        b.addMouseListener(this.adapter);
        super.installDefaults(b);
        b.setBorder(SEBorders.getButtonBorder());
    }

    @Override
    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.removeMouseListener(this.adapter);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return super.createButtonListener(b);
    }

    protected Color getSelectColor() {
        this.selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        this.disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        this.focusColor = Color.LIGHT_GRAY;
        return this.focusColor;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        g.setClip(null);
        g.setColor(c.getBackground());
        g.fillRect(0, 0, (int)c.getSize().getWidth(), (int)c.getSize().getHeight());
        g.setClip(new RoundRectangle2D.Double(0.0, 0.0, c.getSize().getWidth(), c.getSize().getHeight(), 50.0, 50.0));
        if ((c.getBackground() instanceof UIResource || c.getBackground() instanceof Color) && button.isContentAreaFilled() && c.isEnabled()) {
            if (!SEButtonUI.isToolBarButton(c)) {
                if (!model.isArmed() && !model.isPressed() && SEButtonUI.drawGradient(c, g, "Button.gradient", 0, 0, c.getWidth(), c.getHeight(), true)) {
                    g.setClip(new RoundRectangle2D.Double(0.0, 0.0, c.getSize().getWidth(), c.getSize().getHeight(), 50.0, 50.0));
                    this.paint(g, c);
                    return;
                }
            } else if (model.isRollover() && SEButtonUI.drawGradient(c, g, "Button.gradient", 0, 0, c.getWidth(), c.getHeight(), true)) {
                g.setClip(new RoundRectangle2D.Double(0.0, 0.0, c.getSize().getWidth(), c.getSize().getHeight(), 50.0, 50.0));
                this.paint(g, c);
                return;
            }
        }
        g.setClip(new RoundRectangle2D.Double(0.0, 0.0, c.getSize().getWidth(), c.getSize().getHeight(), 50.0, 50.0));
        super.update(g, c);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            Dimension size = b.getSize();
            g.setColor(this.getSelectColor());
            g.fillRoundRect(0, 0, size.width, size.height, 50, 50);
        }
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        boolean isIcon;
        Rectangle focusRect = new Rectangle();
        String text = b.getText();
        boolean bl = isIcon = b.getIcon() != null;
        if (text != null && !text.equals("")) {
            if (!isIcon) {
                focusRect.setBounds(textRect);
            } else {
                focusRect.setBounds(iconRect.union(textRect));
            }
        } else if (isIcon) {
            focusRect.setBounds(iconRect);
        }
        g.setColor(this.getFocusColor());
        g.drawRect(focusRect.x - 1, focusRect.y - 1, focusRect.width + 1, focusRect.height + 1);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g);
        int mnemIndex = -1;
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
        } else {
            g.setColor(this.getDisabledTextColor());
        }
        if (model.isPressed()) {
            g.setColor(Color.BLACK);
        }
        Graphics2D g2 = (Graphics2D)g;
        Shape bs = g2.getClip();
        g2.setClip(null);
        SwingUtilities2.drawStringUnderlineCharAt(c, g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        g2.setClip(bs);
    }

    static boolean drawGradient(Component c, Graphics g, String key, int x, int y, int w, int h, boolean vertical) {
        ArrayList<Serializable> gradient = (ArrayList<Serializable>)UIManager.get(key);
        if (gradient != null) {
            gradient = new ArrayList(gradient);
        } else {
            gradient = new ArrayList<Serializable>();
            gradient.add(Double.valueOf(0.3));
            gradient.add(Integer.valueOf(0));
            gradient.add(Color.red);
            gradient.add(Color.orange);
            gradient.add(Color.yellow);
        }
        gradient.set(2, ((SEButton)c).getColor1());
        gradient.set(3, ((SEButton)c).getColor2());
        gradient.set(4, ((SEButton)c).getColor3());
        if (gradient == null || !(g instanceof Graphics2D)) {
            return false;
        }
        if (w <= 0 || h <= 0) {
            return true;
        }
        GradientPainter.INSTANCE.paint(c, (Graphics2D)g, gradient, x, y, w, h, vertical);
        return true;
    }

    static boolean isToolBarButton(JComponent c) {
        return c.getParent() instanceof JToolBar;
    }

    private static class GradientPainter
    extends CachedPainter {
        public static final GradientPainter INSTANCE = new GradientPainter(8);
        private static final int IMAGE_SIZE = 64;
        private int w;
        private int h;

        GradientPainter(int count) {
            super(count);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Component c, Graphics2D g, List<?> gradient, int x, int y, int w, int h, boolean isVertical) {
            Object object = c.getTreeLock();
            synchronized (object) {
                g.clip(new RoundRectangle2D.Double(x, y, x + w, x + h, 50.0, 50.0));
                this.w = w;
                this.h = h;
                this.paint(c, (Graphics)g, x, y, w, h, gradient, isVertical);
            }
        }

        @Override
        protected void paintToImage(Component c, Image image, Graphics g, int w, int h, Object[] args) {
            Graphics2D g2 = (Graphics2D)g;
            List gradient = (List)args[0];
            boolean isVertical = (Boolean)args[1];
            this.drawVerticalGradient(g2, ((Number)gradient.get(0)).floatValue(), ((Number)gradient.get(1)).floatValue(), (Color)gradient.get(2), (Color)gradient.get(3), (Color)gradient.get(4), w, h);
        }

        private void drawVerticalGradient(Graphics2D g, float ratio1, float ratio2, Color c1, Color c2, Color c3, int w, int h) {
            int mid = (int)(ratio1 * (float)h);
            int mid2 = (int)(ratio2 * (float)h);
            if (mid > 0) {
                g.setPaint(this.getGradient(0.0f, 0.0f, c1, 0.0f, mid, c2));
                g.fillRect(0, 0, w, mid);
            }
            if (mid2 > 0) {
                g.setColor(c2);
                g.fillRect(0, mid, w, mid2);
            }
            if (mid > 0) {
                g.setPaint(this.getGradient(0.0f, (float)mid + (float)mid2, c2, 0.0f, (float)mid * 2.0f + (float)mid2, c1));
                g.fillRect(0, mid + mid2, w, mid);
            }
            if (h - mid * 2 - mid2 > 0) {
                g.setPaint(this.getGradient(0.0f, (float)mid * 2.0f + (float)mid2, c1, 0.0f, h, c3));
                g.fillRect(0, mid * 2 + mid2, w, h - mid * 2 - mid2);
            }
        }

        private GradientPaint getGradient(float x1, float y1, Color c1, float x2, float y2, Color c2) {
            return new GradientPaint(x1, y1, c1, x2, y2, c2, true);
        }
    }
}

