/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.pingui;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.StringUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.pingui.PinGUIUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.pingui.PinInputCallback;
import de.bos_bremen.gov2.jca_provider.ocf.cards.pingui.SEButton;
import de.bos_bremen.gov2.jca_provider.ocf.cards.pingui.SquareGridLayout;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.plaf.ColorUIResource;

public class RandomKeyboardPanel
extends JPanel
implements ActionListener,
KeyListener {
    public static final String PROPERTY_KEY_CANCELLED = "KEY_CANCELLED";
    public static final String PROPERTY_KEY_OPTIONPANE = "KEY_OPTIONPANE";
    public static final String KEY_INITIAL_VALUE = "KEY_INITIAL_VALUE";
    private static final int IDX_BUTTON_INITIAL = 0;
    private static final int IDX_BUTTON_F1 = 9;
    private static final int IDX_BUTTON_F2 = 11;
    private static final long serialVersionUID = 1L;
    private ResourceBundle bundle = null;
    private PinInputCallback callback = null;
    private List<SEButton> listButtons = null;
    private PinGUIUtil.Mode mode = null;
    private static final int MODE_DEFAULT = 0;
    private static final int MODE_YELLOW = 1;
    private static final int MODE_RED = 2;

    public RandomKeyboardPanel(PinInputCallback callback, PinGUIUtil.Mode mode) throws IllegalArgumentException {
        AssertUtil.notNull(callback, "Callback");
        AssertUtil.notNull((Object)mode, "Mode");
        this.init(callback, mode);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.listButtons.get(11)) {
            this.putClientProperty(PROPERTY_KEY_CANCELLED, true);
            Object o = this.getClientProperty(PROPERTY_KEY_OPTIONPANE);
            if (JOptionPane.class.isInstance(o)) {
                ((JOptionPane)o).setValue(2);
            }
        } else if (src == this.listButtons.get(9)) {
            this.callback.clearDigits();
        } else if (this.listButtons.contains(src) && this.listButtons.indexOf(src) != 9 && this.listButtons.indexOf(src) != 11) {
            this.callback.addDigit(((JButton)src).getText().toCharArray()[0]);
        }
    }

    private void adjustButton(SEButton b, int buttonMode) {
        Dimension d = new Dimension(70, 70);
        b.setPreferredSize(d);
        b.setMinimumSize(d);
        b.setSize(d);
        b.setIconTextGap(0);
        b.setFont(b.getFont().deriveFont(1));
        switch (buttonMode) {
            case 2: {
                b.setColor1(new ColorUIResource(Color.RED.brighter()));
                b.setColor2(new ColorUIResource(Color.RED));
                b.setColor3(new ColorUIResource(Color.RED.darker()));
                b.setForeground(Color.BLACK);
                break;
            }
            case 1: {
                b.setColor1(new ColorUIResource(Color.YELLOW.brighter()));
                b.setColor2(new ColorUIResource(Color.YELLOW));
                b.setColor3(new ColorUIResource(Color.YELLOW.darker()));
                b.setForeground(Color.BLACK);
                break;
            }
            default: {
                b.setForeground(Color.white);
            }
        }
    }

    private List<Integer> createMapping() {
        ArrayList<Integer> values = new ArrayList<Integer>();
        SecureRandom sr = new SecureRandom();
        for (int i = 0; i < 10; ++i) {
            int tmp = Math.abs(sr.nextInt() % 10);
            while (values.contains(tmp)) {
                tmp = Math.abs(sr.nextInt() % 10);
            }
            values.add(tmp);
        }
        return values;
    }

    private void init(PinInputCallback callback, PinGUIUtil.Mode mode) {
        super.removeAll();
        this.mode = mode;
        this.bundle = ResourceBundle.getBundle(RandomKeyboardPanel.class.getName());
        List<Integer> mapping = this.createMapping();
        this.setLayout(new SquareGridLayout(4, 3, 5, 5, 0));
        this.callback = callback;
        this.listButtons = new ArrayList<SEButton>();
        double min = 10.0;
        double max = 48.0;
        double relation = 0.7;
        ComponentListener cl = new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                JButton b = (JButton)e.getSource();
                Font f = b.getFont();
                int h = (int)((double)b.getSize().height * 0.7);
                if ((double)h < 10.0) {
                    h = 10;
                } else if ((double)h > 48.0) {
                    h = 48;
                }
                Font nf = f.deriveFont((float)h);
                b.setFont(nf);
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        };
        for (int i = 0; i < 10; ++i) {
            this.addButtonF1(cl, i);
            this.addDigitButton(mapping, cl, i);
            this.addButtonF2(cl, i);
        }
    }

    private void addDigitButton(List<Integer> mapping, ComponentListener cl, int i) {
        String txt = String.valueOf(mapping.get(i));
        SEButton b = new SEButton(txt);
        this.listButtons.add(b);
        int n = (i + 1) % 10;
        char mn = String.valueOf(n).toCharArray()[0];
        b.setMnemonic(mn);
        this.adjustButton(b, 0);
        this.addButton(b);
        b.addKeyListener(this);
        b.addActionListener(this);
        b.addComponentListener(cl);
        String tooltip = StringUtil.format(this.bundle.getString("button.digit.tooltip"), txt, n, n);
        b.setToolTipText(tooltip);
        if (i == 0) {
            this.putClientProperty(KEY_INITIAL_VALUE, b);
        }
    }

    private void addButtonF2(ComponentListener cl, int i) {
        if (i == 9) {
            SEButton bcAll = new SEButton(this.bundle.getString("button.f2.txt"));
            this.listButtons.add(bcAll);
            Icon trashIcon = new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setStroke(new BasicStroke(2.0f));
                    g2.setColor(Color.BLACK);
                    int ox = 2;
                    int oy = 0;
                    Path2D.Double s = new Path2D.Double();
                    s.append(new Line2D.Double(x + ox + 0, y + oy + 0, x + ox + 30, y + oy + 0), false);
                    s.append(new Line2D.Double(x + ox + 2, y + oy + 7, x + ox + 28, y + oy + 7), false);
                    s.append(new Line2D.Double(x + ox + 3, y + oy + 15, x + ox + 27, y + oy + 15), false);
                    s.append(new Line2D.Double(x + ox + 4, y + oy + 22, x + ox + 26, y + oy + 22), false);
                    s.append(new Line2D.Double(x + ox + 5, y + oy + 30, x + ox + 25, y + oy + 30), false);
                    s.append(new Line2D.Double(x + ox + 0, y + oy + 0, x + ox + 5, y + oy + 30), false);
                    s.append(new Line2D.Double(x + ox + 30, y + oy + 0, x + ox + 25, y + oy + 30), false);
                    s.append(new Line2D.Double(x + ox + 15, y + oy + 0, x + ox + 15, y + oy + 30), false);
                    s.append(new Line2D.Double(x + ox + 22, y + oy + 0, x + ox + 20, y + oy + 30), false);
                    s.append(new Line2D.Double(x + ox + 7, y + oy + 0, x + ox + 10, y + oy + 30), false);
                    g2.draw(s);
                }

                @Override
                public int getIconWidth() {
                    return 35;
                }

                @Override
                public int getIconHeight() {
                    return 35;
                }
            };
            this.adjustButton(bcAll, 2);
            this.addButton(bcAll);
            bcAll.addKeyListener(this);
            bcAll.addActionListener(this);
            bcAll.addComponentListener(cl);
            bcAll.setToolTipText(this.bundle.getString("button.f2.tooltip." + (this.mode == PinGUIUtil.Mode.MODE_VERIFY ? "verify" : "modify")));
        }
    }

    private void addButtonF1(ComponentListener cl, int i) {
        if (i == 9) {
            SEButton bC = new SEButton(this.bundle.getString("button.f1.txt"));
            this.listButtons.add(bC);
            this.adjustButton(bC, 1);
            this.addButton(bC);
            bC.addKeyListener(this);
            bC.addActionListener(this);
            bC.addComponentListener(cl);
            bC.setToolTipText(this.bundle.getString("button.f1.tooltip." + (this.mode == PinGUIUtil.Mode.MODE_VERIFY ? "verify" : "modify")));
        }
    }

    private void addButton(JButton b) {
        this.add(b);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (JButton.class.isInstance(e.getSource())) {
            JButton button = (JButton)e.getSource();
            JButton focusButton = null;
            int idx = this.listButtons.indexOf(button);
            switch (e.getKeyCode()) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int tmp = e.getKeyCode() - 48;
                    focusButton = this.listButtons.get((tmp - 1) % 10);
                    if (focusButton == null) break;
                    focusButton.grabFocus();
                    this.actionPerformed(new ActionEvent(focusButton, -1, focusButton.getActionCommand()));
                    break;
                }
                case 10: {
                    this.actionPerformed(new ActionEvent(button, -1, button.getActionCommand()));
                    break;
                }
                case 38: {
                    idx = (idx - 3 + 12) % 12;
                    focusButton = this.listButtons.get(idx);
                    if (!focusButton.isVisible()) {
                        focusButton = this.listButtons.get(6);
                    }
                    if (focusButton == null) break;
                    focusButton.grabFocus();
                    break;
                }
                case 40: {
                    idx = (idx + 3 + 12) % 12;
                    focusButton = this.listButtons.get(idx);
                    if (!focusButton.isVisible()) {
                        focusButton = this.listButtons.get(0);
                    }
                    if (focusButton == null) break;
                    focusButton.grabFocus();
                    break;
                }
                case 37: {
                    idx = (idx - 1 + 12) % 12;
                    focusButton = this.listButtons.get(idx);
                    if (!focusButton.isVisible()) {
                        focusButton = this.listButtons.get(8);
                    }
                    if (focusButton == null) break;
                    focusButton.grabFocus();
                    break;
                }
                case 39: {
                    idx = (idx + 1 + 12) % 12;
                    focusButton = this.listButtons.get(idx);
                    if (!focusButton.isVisible()) {
                        focusButton = this.listButtons.get(10);
                    }
                    if (focusButton == null) break;
                    focusButton.grabFocus();
                    break;
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

