/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.pingui;

import de.bos_bremen.basecard.common.dialog.BDialogMode;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.StringUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVConfiguration;
import de.bos_bremen.gov2.jca_provider.ocf.cards.default_gui.DefaultGovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.pingui.ButtonActionListener;
import de.bos_bremen.gov2.jca_provider.ocf.cards.pingui.Closeable;
import de.bos_bremen.gov2.jca_provider.ocf.cards.pingui.JPasswordFieldPinInputCallbackImpl;
import de.bos_bremen.gov2.jca_provider.ocf.cards.pingui.RandomKeyboardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;

public class PinGUIUtil {
    public static final String KEY_CLIENT_PROPERTY_COMPARE_PASSWORDFIELD = "KEY_CLIENT_PROPERTY_COMPARE_PASSWORDFIELD";
    private static final int IDX_OK_BUTTON = 1;
    private static final String KEY_DOCUMENT_LISTENER = "DocumentListener";
    public static final int PIN_UNLIMITED_LENGTH = -1;
    private static final int IDX_MIN = 0;
    private static final int IDX_MAX = 1;

    private static void check(Mode mode, String viewDesc, Object view, JPasswordField passwordField, JLabel promptLabel, String title, Closeable closeable, GovCHVConfiguration configuration) throws IllegalArgumentException {
        AssertUtil.notNull((Object)mode, "mode");
        AssertUtil.notNull(view, viewDesc);
        AssertUtil.notNull(promptLabel, "label of prompt");
        AssertUtil.notNull(passwordField, "passwordField");
        AssertUtil.notNull(configuration, "GovCHVConfiguration");
        AssertUtil.notNullOrEmpty(title, "title");
        AssertUtil.notNull(closeable, "Closeable");
    }

    private static void closeModify(JPasswordField passwordField, Closeable closeable, int returnValue) {
        if (2 != returnValue && 0 == returnValue) {
            passwordField.setText("");
        }
    }

    private static void closeVerify(JPasswordField passwordField, Closeable closeable, int returnValue) {
        if (2 == returnValue) {
            closeable.close(2);
        } else if (0 == returnValue) {
            passwordField.setText("");
        } else {
            closeable.close(0);
        }
    }

    private static void copyComponent(Component src, Component destination) {
        destination.setEnabled(src.isEnabled());
        destination.setFocusable(src.isFocusable());
        destination.setBackground(src.getBackground());
        destination.setFont(src.getFont());
    }

    private static void copyJComponent(JComponent src, JComponent destination) {
        PinGUIUtil.copyComponent(src, destination);
        destination.setBorder(src.getBorder());
        destination.setToolTipText(src.getToolTipText());
        destination.setOpaque(src.isOpaque());
    }

    private static void copyJTextComponent(JTextComponent src, JTextComponent destination) {
        PinGUIUtil.copyJComponent(src, destination);
        destination.setEditable(src.isEditable());
        destination.setDisabledTextColor(src.getDisabledTextColor());
    }

    private static JLabel createCopy(JLabel label) {
        JLabel result = new JLabel(label.getText(), label.getIcon(), label.getHorizontalAlignment());
        PinGUIUtil.copyJComponent(label, result);
        return result;
    }

    private static JDialog createDialog(JDialog dialog, JOptionPane optionPane, String title) {
        JDialog d = new JDialog((Dialog)dialog, true);
        PinGUIUtil.initDialog(optionPane, title, d);
        d.setLocationRelativeTo(dialog);
        return d;
    }

    private static JDialog createDialog(JFrame frame, JOptionPane optionPane, String title) {
        JDialog d = new JDialog((Frame)frame, true);
        PinGUIUtil.initDialog(optionPane, title, d);
        d.setLocationRelativeTo(frame);
        return d;
    }

    private static JButton[] createDialogButtons(Mode mode, ResourceBundle bundle) {
        ArrayList<JButton> buttonList = new ArrayList<JButton>();
        String modeKeyPart = (mode == Mode.MODE_VERIFY ? "verify" : "modify") + ".";
        String key = "button.back." + modeKeyPart;
        JButton b = new JButton(bundle.getString(key + "txt"));
        b.setToolTipText(bundle.getString(key + "txt.tooltip"));
        buttonList.add(b);
        key = "button.ok." + modeKeyPart;
        b = new JButton(bundle.getString(key + "txt"));
        b.setToolTipText(bundle.getString(key + "txt.tooltip"));
        buttonList.add(b);
        return buttonList.toArray(new JButton[0]);
    }

    private static JPasswordField createDisabledCopy(JPasswordField passwordField) {
        JPasswordField result = new JPasswordField(passwordField.getDocument(), null, passwordField.getColumns());
        PinGUIUtil.copyJTextComponent(passwordField, result);
        result.setEnabled(false);
        result.setFocusable(false);
        result.setHighlighter(null);
        result.setEditable(false);
        result.setDisabledTextColor(passwordField.getForeground());
        result.setHorizontalAlignment(0);
        return result;
    }

    private static JOptionPane createOptionPane(Mode mode, JLabel prompt, final GovCHVConfiguration configuration, final JPasswordField passwordField, boolean useInitPinLengths) {
        boolean retriesLabel;
        ResourceBundle bundle = ResourceBundle.getBundle(PinGUIUtil.class.getName());
        Object[] buttons = PinGUIUtil.createDialogButtons(mode, bundle);
        final JButton okButton = buttons[1];
        final Integer[] pinLengths = PinGUIUtil.getLengths(configuration, useInitPinLengths);
        okButton.setEnabled(PinGUIUtil.isButtonToBeEnabled(configuration, passwordField.getDocument(), pinLengths));
        final JPasswordField copy = PinGUIUtil.createDisabledCopy(passwordField);
        DocumentListener dl = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.check(e);
            }

            private void check(DocumentEvent e) {
                Document d = e.getDocument();
                boolean enabled = PinGUIUtil.isButtonToBeEnabled(configuration, d, pinLengths);
                Object o = passwordField.getClientProperty(PinGUIUtil.KEY_CLIENT_PROPERTY_COMPARE_PASSWORDFIELD);
                if (enabled && o != null && JPasswordField.class.isInstance(o)) {
                    JPasswordField cp = (JPasswordField)o;
                    Document d1 = d;
                    Segment s1 = new Segment();
                    try {
                        d1.getText(0, d1.getLength(), s1);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    Document d2 = cp.getDocument();
                    Segment s2 = new Segment();
                    try {
                        d2.getText(0, d2.getLength(), s2);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    char c1 = s1.first();
                    char c2 = s2.first();
                    while (enabled && c1 != '\uffff') {
                        enabled = c1 == c2;
                        c1 = s1.next();
                        c2 = s2.next();
                    }
                    if (enabled) {
                        PinGUIUtil.replaceTooltipText(copy, pinLengths[0], pinLengths[1], false);
                    } else {
                        PinGUIUtil.replaceTooltipText(copy, pinLengths[0], pinLengths[1], true);
                    }
                } else {
                    PinGUIUtil.replaceTooltipText(copy, pinLengths[0], pinLengths[1], false);
                }
                okButton.setEnabled(enabled);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.check(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.check(e);
            }
        };
        passwordField.getDocument().addDocumentListener(dl);
        JPasswordFieldPinInputCallbackImpl spc = new JPasswordFieldPinInputCallbackImpl(copy);
        RandomKeyboardPanel rkp = new RandomKeyboardPanel(spc, mode);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 1));
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BorderLayout());
        TitledBorder tb = BorderFactory.createTitledBorder(bundle.getString("info.title"));
        tb.setTitleFont(copy.getFont().deriveFont(1));
        infoPanel.setBorder(tb);
        JPanel infoLabelPanel = new JPanel();
        int ln = 2;
        boolean bl = retriesLabel = configuration.getMode() != BDialogMode.EID_CAN && configuration.getMode() != BDialogMode.EID_PUK;
        if (!retriesLabel) {
            ln = 1;
        }
        infoLabelPanel.setLayout(new GridLayout(ln, 1));
        JLabel l = new JLabel(bundle.getString("info.label.terminal"));
        l.setFont(l.getFont().deriveFont(1));
        infoLabelPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        infoLabelPanel.add(l);
        if (retriesLabel) {
            l = new JLabel(bundle.getString("info.label.retries"));
            l.setFont(l.getFont().deriveFont(1));
            infoLabelPanel.add(l);
        }
        JPanel infoValuePanel = new JPanel();
        infoValuePanel.setLayout(new GridLayout(ln, 1));
        infoValuePanel.add(new JLabel(configuration.getTerminalName()));
        if (retriesLabel) {
            infoValuePanel.add(new JLabel(String.valueOf(configuration.getRetryCount())));
        }
        infoPanel.add((Component)infoLabelPanel, "West");
        infoPanel.add((Component)infoValuePanel, "Center");
        p2.add(infoPanel);
        JPanel labelPasswordFieldPanel = new JPanel();
        labelPasswordFieldPanel.setLayout(new BorderLayout());
        JLabel copyLabel = PinGUIUtil.createCopy(prompt);
        labelPasswordFieldPanel.add((Component)copyLabel, "North");
        labelPasswordFieldPanel.add((Component)copy, "South");
        p2.add(labelPasswordFieldPanel);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)p2, "North");
        p.add((Component)rkp, "Center");
        JOptionPane result = new JOptionPane(p, -1, 1, null, buttons, null);
        result.putClientProperty(KEY_DOCUMENT_LISTENER, dl);
        for (int i = 0; i < buttons.length; ++i) {
            ((AbstractButton)buttons[i]).addActionListener(new ButtonActionListener(result, i));
        }
        rkp.putClientProperty("KEY_OPTIONPANE", result);
        Object initialValue = rkp.getClientProperty("KEY_INITIAL_VALUE");
        if (initialValue != null) {
            result.setInitialSelectionValue(initialValue);
        } else {
            result.setInitialSelectionValue(buttons[0]);
        }
        return result;
    }

    private static Integer[] getLengths(GovCHVConfiguration configuration, boolean useInitPinLengths) {
        Integer[] result = new Integer[2];
        Integer minLength = configuration.getMinLength();
        Integer maxLength = configuration.getMaxLength();
        if (useInitPinLengths) {
            if (configuration.getMinLengthInit() != null) {
                minLength = configuration.getMinLengthInit();
            }
            if (configuration.getMaxLengthInit() != null) {
                maxLength = configuration.getMaxLengthInit();
            }
        }
        result[0] = minLength;
        result[1] = maxLength;
        return result;
    }

    private static boolean isButtonToBeEnabled(GovCHVConfiguration configuration, Document document, Integer[] lengths) {
        return !(lengths[0] != -1 && lengths[0] > document.getLength() || lengths[1] != -1 && lengths[1] < document.getLength());
    }

    private static void initDialog(JOptionPane optionPane, String title, JDialog d) {
        d.getContentPane().add(optionPane);
        d.pack();
        Dimension dim = d.getSize();
        d.setSize(dim);
        d.setMinimumSize(dim);
        d.setPreferredSize(dim);
        d.setMaximumSize(new Dimension(dim.width, dim.height));
        d.setResizable(true);
        d.setTitle(title);
        PinGUIUtil.initDialogListener(d, optionPane);
    }

    private static void initDialogListener(JDialog dialog, final JOptionPane optionPane) {
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowClosing(WindowEvent we) {
                optionPane.setValue(null);
            }

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    Object o = optionPane.getInitialSelectionValue();
                    if (JComponent.class.isInstance(o)) {
                        ((JComponent)o).grabFocus();
                    }
                    optionPane.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        };
        dialog.addWindowListener(adapter);
        dialog.addWindowFocusListener(adapter);
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        });
        optionPane.addPropertyChangeListener(event -> {
            if (dialog.isVisible() && event.getSource() == optionPane && event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                dialog.setVisible(false);
            }
        });
    }

    private static int processInput(Mode mode, JPasswordField passwordField, Closeable closeable, JOptionPane optionPane, JDialog dialog) {
        int returnValue = -1;
        dialog.setVisible(true);
        int n = returnValue = optionPane.getValue() != null ? (Integer)optionPane.getValue() : 2;
        if (-1 == returnValue) {
            returnValue = 2;
        }
        switch (mode) {
            case MODE_VERIFY: {
                PinGUIUtil.closeVerify(passwordField, closeable, returnValue);
                break;
            }
            case MODE_MODIFY: {
                PinGUIUtil.closeModify(passwordField, closeable, returnValue);
            }
        }
        passwordField.getDocument().removeDocumentListener((DocumentListener)optionPane.getClientProperty(KEY_DOCUMENT_LISTENER));
        passwordField.setCaretPosition(0);
        return returnValue;
    }

    public static int requestPIN(Mode mode, JDialog dialog, String title, JLabel prompt, GovCHVConfiguration configuration, JPasswordField passwordField, Closeable closeable, boolean useInitPinLengths) throws IllegalArgumentException {
        PinGUIUtil.check(mode, "dialog", dialog, passwordField, prompt, title, closeable, configuration);
        JOptionPane op = PinGUIUtil.createOptionPane(mode, prompt, configuration, passwordField, useInitPinLengths);
        JDialog d = PinGUIUtil.createDialog(dialog, op, title);
        return PinGUIUtil.processInput(mode, passwordField, closeable, op, d);
    }

    public static int requestPIN(Mode mode, JFrame frame, String title, JLabel prompt, GovCHVConfiguration configuration, JPasswordField passwordField, Closeable closeable, boolean useInitPinLengths) throws IllegalArgumentException {
        PinGUIUtil.check(mode, "frame", frame, passwordField, prompt, title, closeable, configuration);
        JOptionPane op = PinGUIUtil.createOptionPane(mode, prompt, configuration, passwordField, useInitPinLengths);
        JDialog d = PinGUIUtil.createDialog(frame, op, title);
        return PinGUIUtil.processInput(mode, passwordField, closeable, op, d);
    }

    public static void replaceTooltipText(JPasswordField p, int minLength, int maxLength, boolean wrongRepeat) throws IllegalArgumentException {
        if (minLength > maxLength) {
            throw new IllegalArgumentException("minLength not allowed to be greater than maxLength");
        }
        ResourceBundle rb = ResourceBundle.getBundle(DefaultGovCHVDialog.class.getName());
        int currentLength = p.getDocument().getLength();
        Object tooltip = p.getToolTipText();
        String newText = "";
        newText = currentLength < minLength ? StringUtil.format(rb.getString("inputTooShort"), currentLength) : (currentLength > maxLength ? StringUtil.format(rb.getString("inputTooLong"), currentLength) : (wrongRepeat ? StringUtil.format(rb.getString("inputDifferent"), currentLength) : rb.getString("inputOk")));
        if (((String)tooltip).lastIndexOf(". ") >= 0) {
            tooltip = ((String)tooltip).substring(0, ((String)tooltip).lastIndexOf(". ")) + ".";
            p.setToolTipText((String)tooltip + " " + newText);
        } else {
            p.setToolTipText(newText);
        }
    }

    private PinGUIUtil() {
    }

    public static enum Mode {
        MODE_MODIFY,
        MODE_VERIFY;

    }
}

