/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.micardo;

import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MICARDOv21r1_DTrust
extends GovCS {
    private static final Log log = LogFactory.getLog(MICARDOv21r1_DTrust.class);
    private static byte[] HISTORICALS = new byte[]{0, 104, -46, 118, 0, 0, 40, -1, 5, 30, 49, -128, 0, -112, 0};
    static final String EF_GDO_ISSUER_CONSTANT = "5a 0d d2 76 00 00 00";
    private static final byte TAG_COUNTER_RETRY = -112;
    private static final byte TAG_COUNTER_USAGE = -111;
    private int usageCounter = 0;

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        return Arrays.equals(this.getHistoricals(), _historicals);
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS;
    }

    @Override
    protected String getIssuerConstant() {
        return EF_GDO_ISSUER_CONSTANT;
    }

    @Override
    public String getDisplayName() {
        return "D-Trust (15) " + super.getDisplayName();
    }

    @Override
    protected boolean usesASN1HeaderWithAuthentify() {
        return true;
    }

    @Override
    protected void adjustForPaddingByte(GovCS.ResultObject _ro) {
    }

    @Override
    public String getOSName() {
        return "(MICARDO v.2.1 r.1.0)";
    }

    @Override
    protected byte getPaddingIndicator() {
        return 0;
    }

    @Override
    public int getPasswordBlockLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        switch (_type) {
            case 1: {
                return MICARDOv21r1_DTrust.createMSEforDecryption_DTrust(_info.getKeyID().getID());
            }
            case 0: {
                return MICARDOv21r1_DTrust.createMSEforSignHash_DTrust(_info.getKeyID().getID());
            }
            case 2: {
                return MICARDOv21r1_DTrust.createMSEforAuthentification_DTrust(_info.getKeyID().getID());
            }
        }
        return null;
    }

    private static CommandAPDU createMSEforDecryption_DTrust(byte[] _keyID) {
        int index = 0;
        byte[] data = new byte[3 + _keyID.length];
        data[index++] = -125;
        data[index++] = (byte)(data.length - index);
        data[index++] = -128;
        System.arraycopy(_keyID, 0, data, index, _keyID.length);
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)-63, (byte)-72, data);
    }

    private static CommandAPDU createMSEforAuthentification_DTrust(byte[] _keyID) {
        int index = 0;
        byte[] data = new byte[3 + _keyID.length];
        data[index++] = -125;
        data[index++] = (byte)(data.length - index);
        data[index++] = -128;
        System.arraycopy(_keyID, 0, data, index, _keyID.length);
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)-63, (byte)-92, data);
    }

    private static CommandAPDU createMSEforSignHash_DTrust(byte[] _keyID) {
        int index = 0;
        byte[] data = new byte[3 + _keyID.length];
        data[index++] = -125;
        data[index++] = (byte)(data.length - index);
        data[index++] = -128;
        System.arraycopy(_keyID, 0, data, index, _keyID.length);
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)-63, (byte)-74, data);
    }

    @Override
    protected final CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[6 + _hashValue.length];
        store[0] = 0;
        store[1] = -120;
        store[2] = 0;
        store[3] = 0;
        store[4] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, store, 5, _hashValue.length);
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    protected int getCounter(String pinName, byte[] data, byte _wich) throws RetryCounterExpiredException {
        int index;
        byte length;
        for (index = 0; index < data.length; index += length) {
            byte tagID = data[index++];
            length = data[index++];
            if (tagID == _wich) break;
        }
        if (index >= data.length) {
            return -1;
        }
        int result = data[index];
        if (result < 0) {
            result += 256;
        }
        if (result == 0) {
            throw new RetryCounterExpiredException(pinName, 27011, APDUCommands.getVerifyErrorMsg(27011));
        }
        return result;
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws NotYetInitializedException, RetryCounterExpiredException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        String pinName = MICARDOv21r1_DTrust.getPinNameForInfo(_info);
        this.selectMasterFile(_channel);
        if ((_info.getPinID() & 0xF0) == 128) {
            this.selectSubDirectory(_channel, _info.getDirectory());
        }
        this.selectFile(_channel, new FileReference(2, "0016"));
        int recordIndex = 1;
        CommandAPDU cmd = APDUCommands.createReadRecordCommand(recordIndex);
        log.debug((Object)("RR CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("RR RES : " + HexString.hexify(res.getBuffer(), false)));
        if (res.getBuffer().length == 2) {
            cmd = new CommandAPDU(HexString.parseHexString("00c0000000"));
            log.debug((Object)("GET CMD : " + HexString.hexify(cmd.getBuffer(), false)));
            res = _channel.sendCommandAPDU(cmd);
        }
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("GET RES : " + HexString.hexify(res.getBuffer(), false)));
        int resultCode = res.sw();
        if (resultCode == 27011) {
            throw new RetryCounterExpiredException(pinName, resultCode, APDUCommands.getVerifyErrorMsg(resultCode));
        }
        if (resultCode == 27013) {
            throw new NotYetInitializedException(pinName, resultCode, APDUCommands.getVerifyErrorMsg(resultCode));
        }
        int result = -1;
        if (resultCode == 36864) {
            try {
                this.usageCounter = this.getCounter(pinName, res.data(), (byte)-111);
                log.debug((Object)("usage counter : " + this.usageCounter));
            }
            catch (RetryCounterExpiredException ex) {
                log.fatal((Object)"TODO should inform the user to reset the usage counter by changing the password");
            }
            result = this.getCounter(pinName, res.data(), (byte)-112);
            log.debug((Object)("retry counter : " + result));
        }
        this.selectSubDirectory(_channel, _info.getDirectory());
        return result;
    }

    @Override
    protected synchronized boolean isKeyInitialized(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        this.selectMasterFile(_channel);
        if ((_info.getPinID() & 0xF0) == 128) {
            this.selectSubDirectory(_channel, _info.getDirectory());
        }
        this.selectFile(_channel, new FileReference(2, "0016"));
        int recordIndex = 1;
        CommandAPDU cmd = APDUCommands.createReadRecordCommand(recordIndex);
        log.debug((Object)("RR CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("RR RES : " + HexString.hexify(res.getBuffer(), false)));
        cmd = new CommandAPDU(HexString.parseHexString("00c0000000"));
        log.debug((Object)("GET CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("GET RES : " + HexString.hexify(res.getBuffer(), false)));
        boolean result = false;
        if (res.sw() == 27013) {
            result = true;
        } else if (res.sw() != 36864) {
            result = false;
        } else {
            byte[] data = res.data();
            int index = 0;
            while (index < data.length) {
                byte tagID = data[index++];
                byte length = data[index++];
                if (tagID != -111) {
                    index += length;
                    continue;
                }
                if (data[index++] != 0) continue;
                result = false;
            }
            result = true;
        }
        this.selectSubDirectory(_channel, _info.getDirectory());
        return result;
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        long idOfPin = 2000001L;
        byte pinID = 1;
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Authentisierungs-/Verschl\u00fcsselungs-PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000003L});
        CardApplication applicationSIGN = this.createSignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationSIGN);
        mfManager.putPin(pin);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, Card.CardTypeEnum.DTRUST_11.getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createSignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfPin = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfKey01 = 4000001L;
        long idOfKey02 = 4000002L;
        KeyID k01 = new KeyID("5000");
        KeyID k02 = new KeyID("5100");
        byte pinID = -126;
        FileReference dirRefApp = new FileReference(4, "d27600006601");
        FileReference cerRef01 = new FileReference(2, "c000");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        FileReference cerRef02 = new FileReference(2, "c500");
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey01});
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerEncDecAut", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin, k01);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "EncryptionKey/DecryptionKey/AuthenticationKey", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.ENCRYPTION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_DEFAULT.getType()}), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info02, idOfFile02, idOfPinCH, k02);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("d27600006601", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType(), CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putPin(pin);
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putKey(key01);
        applicationApp.putKey(key02);
        return applicationApp;
    }

    @Override
    public OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[]{new OCFCertificateInfo(new FileReference(4, "d27600006601"), new FileReference(2, "c000"), new KeyID("5000"), -126, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(4, "d27600006601"), new FileReference(2, "c500"), new KeyID("5100"), 1, OCFCertificateInfo.ChainEntry.USER)};
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA1");
            c.add("RIPEMD160");
            c.add("SHA224");
        }
        return c;
    }
}

