/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.gp;

import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.crypto.Digest;

public final class RSAHelper {
    private static final Log LOG = LogFactory.getLog(RSAHelper.class);

    private RSAHelper() {
    }

    public static int getKeySize(PublicKey publicKey) {
        try {
            return ((RSAPublicKey)publicKey).getModulus().bitLength();
        }
        catch (Exception e) {
            LOG.debug((Object)e);
            throw new IllegalArgumentException("failed to calculate key size");
        }
    }

    public static byte[] buildSignatureInputPKCS1pss(byte[] hash, Digest mgf1Digest, int keySize) throws Exception {
        int hLen = mgf1Digest.getDigestSize();
        if (hash.length != hLen) {
            throw new IllegalArgumentException("only PSS supported using same digest algorithm for hash value and MGF1");
        }
        return RSAHelper.generateSignature(keySize, mgf1Digest, hLen, hash);
    }

    public static byte[] generateSignature(int keySize, Digest mgfDigest, int sLen, byte[] digestValue) throws Exception {
        int hLen = digestValue.length;
        byte[] mDash = new byte[8 + sLen + hLen];
        Arrays.fill(mDash, (byte)0);
        System.arraycopy(digestValue, 0, mDash, 8, hLen);
        int emBits = keySize - 1;
        if (emBits < 8 * hLen + 8 * sLen + 9) {
            throw new IllegalArgumentException("key too small for specified hash and salt lengths");
        }
        byte[] salt = new byte[sLen];
        byte[] block = new byte[keySize / 8];
        int trailer = -68;
        SecureRandom random = new SecureRandom();
        if (sLen != 0) {
            ((Random)random).nextBytes(salt);
            System.arraycopy(salt, 0, mDash, mDash.length - sLen, sLen);
        }
        byte[] h = new byte[hLen];
        mgfDigest.update(mDash, 0, mDash.length);
        mgfDigest.doFinal(h, 0);
        block[block.length - sLen - 1 - hLen - 1] = 1;
        System.arraycopy(salt, 0, block, block.length - sLen - hLen - 1, sLen);
        byte[] dbMask = RSAHelper.maskGeneratorFunction1(mgfDigest, h, 0, h.length, block.length - hLen - 1);
        for (int i = 0; i != dbMask.length; ++i) {
            int n = i;
            block[n] = (byte)(block[n] ^ dbMask[i]);
        }
        block[0] = (byte)(block[0] & 255 >> block.length * 8 - emBits);
        System.arraycopy(h, 0, block, block.length - hLen - 1, hLen);
        block[block.length - 1] = trailer;
        mgfDigest.reset();
        return block;
    }

    public static byte[] maskGeneratorFunction1(Digest mgfDigest, byte[] Z, int zOff, int zLen, int length) {
        int counter;
        int mgfhLen = mgfDigest.getDigestSize();
        byte[] mask = new byte[length];
        byte[] hashBuf = new byte[mgfhLen];
        byte[] C = new byte[4];
        mgfDigest.reset();
        for (counter = 0; counter < length / mgfhLen; ++counter) {
            RSAHelper.ItoOSP(counter, C);
            mgfDigest.update(Z, zOff, zLen);
            mgfDigest.update(C, 0, C.length);
            mgfDigest.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, mask, counter * mgfhLen, mgfhLen);
        }
        if (counter * mgfhLen < length) {
            RSAHelper.ItoOSP(counter, C);
            mgfDigest.update(Z, zOff, zLen);
            mgfDigest.update(C, 0, C.length);
            mgfDigest.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, mask, counter * mgfhLen, mask.length - counter * mgfhLen);
        }
        return mask;
    }

    public static void ItoOSP(int i, byte[] sp) {
        sp[0] = (byte)(i >>> 24);
        sp[1] = (byte)(i >>> 16);
        sp[2] = (byte)(i >>> 8);
        sp[3] = (byte)(i >>> 0);
    }

    public static byte[] buildSignatureInputPKCS1v15(byte[] digestInfo, int keySize) throws Exception {
        byte[] signatureInput = new byte[keySize / 8];
        Arrays.fill(signatureInput, (byte)-1);
        signatureInput[0] = 0;
        signatureInput[1] = 1;
        signatureInput[signatureInput.length - digestInfo.length - 1] = 0;
        System.arraycopy(digestInfo, 0, signatureInput, signatureInput.length - digestInfo.length, digestInfo.length);
        return signatureInput;
    }

    public static byte[] unpadOAEP(String digestAlgorithmName, byte[] oaepPaddedData) throws Exception {
        return RSAHelper.unpadOAEP(new OAEPParameterSpec(digestAlgorithmName, "MGF1", new MGF1ParameterSpec(digestAlgorithmName), PSource.PSpecified.DEFAULT), oaepPaddedData);
    }

    public static byte[] unpadOAEP(OAEPParameterSpec spec, byte[] oaepPaddedData) throws BadPaddingException, NoSuchAlgorithmException {
        int i;
        MessageDigest md = MessageDigest.getInstance(spec.getDigestAlgorithm());
        MessageDigest mgfMd = MessageDigest.getInstance(((MGF1ParameterSpec)spec.getMGFParameters()).getDigestAlgorithm());
        byte[] digestInput = ((PSource.PSpecified)spec.getPSource()).getValue();
        byte[] EM = oaepPaddedData;
        byte[] lHash = md.digest(digestInput);
        int hLen = lHash.length;
        if (EM[0] != 0) {
            throw new BadPaddingException("Data must start with zero");
        }
        int seedStart = 1;
        int seedLen = hLen;
        int dbStart = hLen + 1;
        int dbLen = EM.length - dbStart;
        RSAHelper.maskGenerationFunction1(mgfMd, EM, dbStart, dbLen, EM, seedStart, seedLen, lHash.length);
        RSAHelper.maskGenerationFunction1(mgfMd, EM, seedStart, seedLen, EM, dbStart, dbLen, lHash.length);
        for (i = 0; i < hLen; ++i) {
            if (lHash[i] == EM[dbStart + i]) continue;
            throw new BadPaddingException("lHash mismatch");
        }
        i = dbStart + hLen;
        while (EM[i] == 0) {
            if (++i < EM.length) continue;
            throw new BadPaddingException("Padding string not terminated");
        }
        if (EM[i++] != 1) {
            throw new BadPaddingException("Padding string not terminated by 0x01 byte");
        }
        int mLen = EM.length - i;
        byte[] m = new byte[mLen];
        System.arraycopy(EM, i, m, 0, mLen);
        return m;
    }

    protected static void maskGenerationFunction1(MessageDigest mgfMd, byte[] seed, int seedOfs, int seedLen, byte[] out, int outOfs, int maskLen, int digestLength) throws BadPaddingException {
        byte[] C = new byte[4];
        byte[] digest = new byte[digestLength];
        block2: while (maskLen > 0) {
            mgfMd.update(seed, seedOfs, seedLen);
            mgfMd.update(C);
            try {
                mgfMd.digest(digest, 0, digest.length);
            }
            catch (DigestException e) {
                throw new BadPaddingException(e.toString());
            }
            int i = 0;
            while (i < digest.length && maskLen > 0) {
                int n = outOfs++;
                out[n] = (byte)(out[n] ^ digest[i++]);
                --maskLen;
            }
            if (maskLen <= 0) continue;
            i = C.length - 1;
            while (true) {
                int n = --i;
                C[n] = (byte)(C[n] + 1);
                if (C[n] != 0 || i <= 0) continue block2;
            }
        }
    }
}

