/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.gp;

import de.bos_bremen.basecard.common.crypto.Algorithm;
import de.bos_bremen.basecard.common.crypto.CardExecutionDecryptRSAParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.OCFDefaultAlgorithmFinder;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public final class JCOPAlgorithmHelper {
    private static final Log LOG = LogFactory.getLog(JCOPAlgorithmHelper.class);
    public static final String JCE_DIGEST_ALGORITHM_SHA512 = "SHA512";
    public static final String JCE_DIGEST_ALGORIHM_SHA384 = "SHA384";
    public static final String JCE_DIGEST_ALGORITHM_SHA256 = "SHA256";
    public static final int ALGORITHM_ID_MASK_FUNCTION = 3840;
    public static final int ALGORITHM_ID_MASK_PADDING = 240;
    public static final int ALGORITHM_ID_MASK_DIGEST = 15;
    public static final int ALGORITHM_ID_FUNCTION_SIGN = 256;
    public static final int ALGORITHM_ID_FUNCTION_CIPHER = 512;
    public static final int ALGORITHM_ID_PADDING_PKCS1_V15 = 16;
    public static final int ALGORITHM_ID_PADDING_PKCS1_PSS = 32;
    public static final int ALGORITHM_ID_PADDING_PKCS1_OAEP = 32;
    public static final int ALGORITHM_ID_SHA256 = 2;
    public static final int ALGORITHM_ID_SHA384 = 4;
    public static final int ALGORITHM_ID_SHA512 = 8;
    public static final int ALGORITHM_ID_SIGN_RSA_PKCS1V15_SHA256 = 274;
    public static final int ALGORITHM_ID_SIGN_RSA_PKCS1V15_SHA384 = 276;
    public static final int ALGORITHM_ID_SIGN_RSA_PKCS1V15_SHA512 = 280;
    public static final int ALGORITHM_ID_SIGN_RSA_PSS_SHA256 = 290;
    public static final int ALGORITHM_ID_SIGN_RSA_PSS_SHA384 = 292;
    public static final int ALGORITHM_ID_SIGN_RSA_PSS_SHA512 = 296;
    public static final int ALGORITHM_ID_CIPHER_RSA_PKCS1V15 = 528;
    public static final int ALGORITHM_ID_CIPHER_RSA_OAEP = 544;

    private JCOPAlgorithmHelper() {
    }

    public static List<Algorithm<OCFPrivateKey, ?>> getBeaSupportedAlgorithms() {
        List<UsageRelated.Usage> usageList01 = Arrays.asList(UsageRelated.Usage.SIGNATURE, UsageRelated.Usage.AUTHENTICATION);
        ArrayList listKeyAlgorithms = new ArrayList();
        JCOPAlgorithmHelper.addRSAPKCS1PSSSignAlgorithm(listKeyAlgorithms, usageList01, JCE_DIGEST_ALGORITHM_SHA256, JCE_DIGEST_ALGORIHM_SHA384, JCE_DIGEST_ALGORITHM_SHA512);
        JCOPAlgorithmHelper.addRSAPKCS1v15SignAlgorithm(listKeyAlgorithms, usageList01, JCE_DIGEST_ALGORITHM_SHA256, JCE_DIGEST_ALGORIHM_SHA384, JCE_DIGEST_ALGORITHM_SHA512);
        JCOPAlgorithmHelper.addRSAPKCS1v12OAEPCipher(listKeyAlgorithms);
        return listKeyAlgorithms;
    }

    private static void addRSAPKCS1v12OAEPCipher(List<Algorithm<OCFPrivateKey, ?>> listKeyAlgorithms) {
        List<UsageRelated.Usage> usageList02 = Arrays.asList(UsageRelated.Usage.CIPHER);
        OCFDefaultAlgorithmFinder finder = OCFDefaultAlgorithmFinder.getInstance();
        try {
            listKeyAlgorithms.add(new Algorithm("OCF", usageList02, "RSA/ECB/PKCS1Padding", "RSA/PKCS1", new CardExecutionDecryptRSAParameterSpec("RSA/ECB/PKCS1Padding", new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), finder.findURI("RSA/ECB/PKCS1Padding"), null, BigInteger.valueOf(528L).toByteArray())));
            listKeyAlgorithms.add(new Algorithm("OCF", usageList02, "RSA/ECB/OAEP", "RSA/ECB/OAEP", new CardExecutionDecryptRSAParameterSpec("RSA/ECB/OAEP", new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), finder.findURI("RSA/ECB/OAEP"), null, BigInteger.valueOf(544L).toByteArray())));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
    }

    private static void addRSAPKCS1v15SignAlgorithm(List<Algorithm<OCFPrivateKey, ?>> listKeyAlgorithms, List<UsageRelated.Usage> usageList, String ... digestNames) {
        for (String digestName : digestNames) {
            String name;
            byte[] algorithmID = null;
            if (JCE_DIGEST_ALGORITHM_SHA256.equals(digestName)) {
                algorithmID = BigInteger.valueOf(274L).toByteArray();
            } else if (JCE_DIGEST_ALGORIHM_SHA384.equals(digestName)) {
                algorithmID = BigInteger.valueOf(276L).toByteArray();
            } else if (JCE_DIGEST_ALGORITHM_SHA512.equals(digestName)) {
                algorithmID = BigInteger.valueOf(280L).toByteArray();
            }
            try {
                name = digestName + "withRSA";
                listKeyAlgorithms.add(new Algorithm("OCF", usageList, name, name + "/PKCS1", new CardExecutionSignAuthenticateParameterSpec(name, OCFDefaultAlgorithmFinder.getInstance().find(name), OCFDefaultAlgorithmFinder.getInstance().findURI(name), Boolean.TRUE, algorithmID)));
            }
            catch (Exception e) {
                LOG.debug((Object)e);
            }
            try {
                name = digestName + "hashedWithRSA";
                listKeyAlgorithms.add(new Algorithm("OCF", usageList, name, name + "/PKCS1", new CardExecutionSignAuthenticateParameterSpec(name, OCFDefaultAlgorithmFinder.getInstance().find(name), OCFDefaultAlgorithmFinder.getInstance().findURI(name), Boolean.TRUE, algorithmID)));
            }
            catch (Exception e) {
                LOG.debug((Object)e);
            }
        }
    }

    private static void addRSAPKCS1PSSSignAlgorithm(List<Algorithm<OCFPrivateKey, ?>> listKeyAlgorithms, List<UsageRelated.Usage> usageList, String ... digestNames) {
        for (String digestName : digestNames) {
            String name;
            byte[] algorithmID = null;
            if (JCE_DIGEST_ALGORITHM_SHA256.equals(digestName)) {
                algorithmID = BigInteger.valueOf(290L).toByteArray();
            } else if (JCE_DIGEST_ALGORIHM_SHA384.equals(digestName)) {
                algorithmID = BigInteger.valueOf(292L).toByteArray();
            } else if (JCE_DIGEST_ALGORITHM_SHA512.equals(digestName)) {
                algorithmID = BigInteger.valueOf(296L).toByteArray();
            }
            try {
                name = digestName + "withRSA";
                listKeyAlgorithms.add(new Algorithm("OCF", usageList, name + "andMGF1", name + "/PSS", new CardExecutionSignAuthenticateParameterSpec(name + "andMGF1", OCFDefaultAlgorithmFinder.getInstance().find(name + "andMGF1"), OCFDefaultAlgorithmFinder.getInstance().findURI(name + "andMGF1"), Boolean.FALSE, algorithmID)));
            }
            catch (Exception e) {
                LOG.debug((Object)e);
            }
            try {
                name = digestName + "hashedWithRSA";
                listKeyAlgorithms.add(new Algorithm("OCF", usageList, name + "andMGF1", name + "/PSS", new CardExecutionSignAuthenticateParameterSpec(name + "andMGF1", OCFDefaultAlgorithmFinder.getInstance().find(name + "andMGF1"), OCFDefaultAlgorithmFinder.getInstance().findURI(name + "andMGF1"), Boolean.FALSE, algorithmID)));
            }
            catch (Exception e) {
                LOG.debug((Object)e);
            }
        }
    }
}

