/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.gp;

import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.cvc.ECCVCPath;
import java.io.IOException;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JCOP231BNotkbEAProductIdentiferHelper {
    private static final Log LOG = LogFactory.getLog(JCOP231BNotkbEAProductIdentiferHelper.class);
    public static final String HEX_COMMAND_SELECT_HSM_APPLET = "00a404000bE82B0601040181C31F020100";
    public static final String HEX_COMMAND_READ_CVCERTIFICATE = "00b12f02000004540200000000";
    public static final String HEX_IDENTIFIER_PRODUCT_TPCARD = "44 45 44 49 43 43 31 32 30 30 30 30 31";
    public static final String HEX_IDENTIFIER_PRODUCT_NCARD = "44 45 44 49 42 4e 4f 54 4b 4e 43 30 30 30 30 31";
    public static final String HEX_IDENTIFIER_PRODUCT_RCARD = "44 45 44 49 42 4e 4f 54 4b 52 43 30 30 30 30 31";
    public static final String HEX_IDENTIFIER_PRODUCT_BEACARD = "44 45 44 49 42 4e 4f 54 4b 42 43 30 30 30 30 31";
    public static final String HEX_IDENTIFIER_PRODUCT_BEAMCARD = "44 45 44 49 42 4e 4f 54 4b 42 4d 30 30 30 30 31";
    public static final String HEX_IDENTIFIER_PRODUCT_ACARD = "44 45 44 49 42 4e 4f 54 4b 41 43 30 30 30 30 31";
    public static final String CARD_PRODUCT_NAME_NCARD = "NCARD Notary cards (personalized)";
    public static final String CARD_PRODUCT_NAME_RCARD = "RCARD Justice card (personalized)";
    public static final String CARD_PRODUCT_NAME_BEACARD = "BEACARD beA basic card (personalized)";
    public static final String CARD_PRODUCT_NAME_BEAMCARD = "BEAMCARD beA employee card (partially personalized)";
    public static final String CARD_PRODUCT_NAME_ACARD = "ACARD Authentication card for reference persons (personalized)";
    public static final String CARD_PRODUCT_NAME_TCARD = "TCARD test card for implementation of provider";
    public static final String CARD_NAME_NCARD = "Notarkarte";
    public static final String CARD_NAME_RCARD = "Justizkarte (Fernsignatur)";
    public static final String CARD_NAME_BEACARD = "beA Karte";
    public static final String CARD_NAME_BEAMCARD = "bea MA Karte";
    public static final String CARD_NAME_ACARD = "Authentifizierungskarte";
    public static final String CARD_NAME_TCARD = "Fernsignaturkarte (Test)";

    private JCOP231BNotkbEAProductIdentiferHelper() {
    }

    public static BEACardProduct findCardProduct(CardChannel cardChannel) {
        return BEACardProduct.findCardProduct(JCOP231BNotkbEAProductIdentiferHelper.readCVCertificateASN1(cardChannel));
    }

    private static ASN1 readCVCertificateASN1(CardChannel channel) {
        Object result;
        byte[] cvCertificateBytes = JCOP231BNotkbEAProductIdentiferHelper.readCVCertificateBytes(channel);
        if (cvCertificateBytes == null || cvCertificateBytes.length == 0) {
            result = null;
        } else {
            try {
                return new ASN1(cvCertificateBytes);
            }
            catch (IOException e) {
                result = null;
            }
        }
        return result;
    }

    private static byte[] readCVCertificateBytes(CardChannel channel) {
        try {
            ResponseAPDU responseAPDU = channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse(HEX_COMMAND_SELECT_HSM_APPLET)));
            if (36864 == responseAPDU.sw() && 36864 == (responseAPDU = channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse(HEX_COMMAND_READ_CVCERTIFICATE)))).sw() && responseAPDU.data() != null && responseAPDU.data().length > 0) {
                return responseAPDU.data();
            }
        }
        catch (InvalidCardChannelException | CardTerminalException exception) {
            // empty catch block
        }
        return null;
    }

    static enum BEACardProduct {
        UNKNOWN("", "", ""),
        NCARD("Notarkarte", "NCARD Notary cards (personalized)", "44 45 44 49 42 4e 4f 54 4b 4e 43 30 30 30 30 31"),
        RCARD("Justizkarte (Fernsignatur)", "RCARD Justice card (personalized)", "44 45 44 49 42 4e 4f 54 4b 52 43 30 30 30 30 31"),
        BEACARD("beA Karte", "BEACARD beA basic card (personalized)", "44 45 44 49 42 4e 4f 54 4b 42 43 30 30 30 30 31"),
        BEAMCARD("bea MA Karte", "BEAMCARD beA employee card (partially personalized)", "44 45 44 49 42 4e 4f 54 4b 42 4d 30 30 30 30 31"),
        ACARD("Authentifizierungskarte", "ACARD Authentication card for reference persons (personalized)", "44 45 44 49 42 4e 4f 54 4b 41 43 30 30 30 30 31"),
        TCARD("Fernsignaturkarte (Test)", "TCARD test card for implementation of provider", "44 45 44 49 43 43 31 32 30 30 30 30 31");

        private final String cardProductName;
        private final String hexCar;
        private final boolean supported;
        private String cardName;

        private BEACardProduct(String cardName, String cardProductName, String hexCar) {
            this(cardName, cardProductName, hexCar, true);
        }

        private BEACardProduct(String cardName, String cardProductName, String hexCar, boolean supported) {
            this.cardName = cardName;
            this.cardProductName = cardProductName;
            this.hexCar = hexCar.replace(" ", "");
            this.supported = supported;
        }

        public String toString() {
            return super.toString() + "[name: " + this.cardName + ", product name: " + this.cardProductName + ", hex car: " + this.hexCar + "]";
        }

        public String getCardProductName() {
            return this.cardProductName;
        }

        public String getHexCar() {
            return this.hexCar;
        }

        public static BEACardProduct findCardProduct(ASN1 cvCertificate) {
            BEACardProduct result = UNKNOWN;
            if (cvCertificate != null) {
                try {
                    ASN1 car = cvCertificate.getChildElementByPath(ECCVCPath.CA_REFERENCE);
                    String hexCAR = HexUtil.hexify(car.getValue());
                    for (BEACardProduct bEACardProduct : BEACardProduct.values()) {
                        if (!bEACardProduct.getHexCar().contentEquals(hexCAR)) continue;
                        if (!bEACardProduct.isSupported()) {
                            LOG.warn((Object)("not supported BNotK card detected: " + bEACardProduct));
                            result = UNKNOWN;
                        } else {
                            result = bEACardProduct;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return result;
        }

        public boolean isSupported() {
            return this.supported;
        }

        public String getCardName() {
            return this.cardName;
        }
    }
}

