/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.gp;

import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.CardExecutionDecryptRSAParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSession;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.MaxSignatureCountReachedException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.gp.JCOP231;
import de.bos_bremen.gov2.jca_provider.ocf.cards.gp.JCOP231BNotkbEAProductIdentiferHelper;
import de.bos_bremen.gov2.jca_provider.ocf.cards.gp.JCOPAlgorithmHelper;
import de.bos_bremen.gov2.jca_provider.ocf.cards.gp.RSAHelper;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import opencard.opt.terminal.ISOCommandAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;

public class JCOP231BNotkV2GP
extends JCOP231 {
    private static final Log LOG = LogFactory.getLog(JCOP231BNotkV2GP.class);
    private final String displayName;
    private final String tokenLabel;
    private final boolean stapleSign;
    private final boolean multiSign;
    private final Card.CardTypeEnum cardType = DEFAULT_CARD_TYPE;
    private String cardProductName;
    public static final String DEFAULT_DISPLAY_NAME = "BNotK V2 (GP)";
    public static final String ISSUER_CONSTANT = "BNotK V2 (GP)";
    public static final boolean DEFAULT_STAPLE_SIGN = true;
    public static final boolean DEFAULT_MULTI_SIGN = false;
    public static final Card.CardTypeEnum DEFAULT_CARD_TYPE = Card.CardTypeEnum.BNOTK_V2_GP;
    public static final String AID_BEA = "E8 2B 06 01 04 01 81 C3 1F 02 01";

    public JCOP231BNotkV2GP() {
        this.displayName = "BNotK V2 (GP)";
        this.tokenLabel = "BNotK V2 (GP)";
        this.stapleSign = true;
        this.multiSign = false;
    }

    @Override
    public void setKeyboardAllowed(boolean flag) {
        if (this.isContactLess()) {
            return;
        }
        super.setKeyboardAllowed(flag);
    }

    @Override
    public void setHasPinPad(boolean flag) {
        if (this.isContactLess()) {
            return;
        }
        super.setHasPinPad(flag);
    }

    @Override
    public boolean isKeybordAllowed() {
        if (this.isContactLess()) {
            return true;
        }
        return super.isKeybordAllowed();
    }

    @Override
    public boolean hasPinPad() {
        if (this.isContactLess()) {
            return false;
        }
        return super.hasPinPad();
    }

    private boolean isContactLess() {
        if (super.getCard() == null || super.getCard().getCardID() == null || super.getCard().getCardID().getATR() == null || super.getCard().getCardID().getATR().length <= 2) {
            return false;
        }
        return super.getCard().getCardID().getATR()[1] == -114;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, smartcard, blocking);
        CardChannel cardChannel = null;
        boolean local = false;
        try {
            cardChannel = scheduler.allocateCardChannel(this, blocking);
            local = true;
            this.cardProductName = JCOP231BNotkbEAProductIdentiferHelper.findCardProduct(cardChannel).getCardProductName();
        }
        catch (CardTerminalException e) {
            this.cardProductName = JCOP231BNotkbEAProductIdentiferHelper.BEACardProduct.UNKNOWN.getCardProductName();
        }
        finally {
            if (local && cardChannel != null) {
                scheduler.releaseCardChannel(cardChannel);
            }
        }
    }

    @Override
    public final String getDisplayName() {
        return this.displayName + (String)(this.cardProductName == null || this.cardProductName.isEmpty() ? "" : " [" + this.cardProductName + "]") + (this.isContactLess() ? " (kontaktlos)" : "");
    }

    @Override
    public final boolean isMultiSign() {
        return this.multiSign;
    }

    @Override
    public boolean isStapleSign() {
        return this.stapleSign || GovCS.isStapleSign(this);
    }

    @Override
    protected final boolean isIssuerReadRequired() {
        return true;
    }

    @Override
    protected String getIssuerConstant() {
        return this.tokenLabel;
    }

    @Override
    protected String readIssuerFromATR(CardChannel channel) {
        String readIssuerFromATR = super.readIssuerFromATR(channel);
        if ("GLOBAL_PLATFORM_CARD_2_3_1".equals(readIssuerFromATR)) {
            JCOP231BNotkbEAProductIdentiferHelper.BEACardProduct cardProduct = JCOP231BNotkbEAProductIdentiferHelper.findCardProduct(channel);
            if (!cardProduct.isSupported()) {
                return null;
            }
            try {
                readIssuerFromATR = null;
                if (36864 == channel.sendCommandAPDU(JCOP231BNotkV2GP.createSelectAID(AID_BEA)).sw()) {
                    readIssuerFromATR = "BNotK V2 (GP)";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return readIssuerFromATR;
    }

    @Override
    public final Integer getStapleSignCounter() {
        if (this.stapleSign) {
            return 100;
        }
        return this.isStapleSign() ? MAXIMUM_COUNT_OF_STAPLE_SIGNATURES : null;
    }

    @Override
    protected final Card createCardInt(Terminal pTerminal, int pSlotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardApplication appBEA = this.createBEAApp(pTerminal, pSlotID, idOfCard, idOfMFApplication);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(appBEA);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.MF.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        return new CardImpl(this.getDisplayName() + "-" + idOfCard, idOfCard, this.cardType.getType(), super.getCard(), mfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance());
    }

    @Override
    protected CommandAPDU createSelectMasterFile() {
        return JCOP231BNotkV2GP.createSelectAID((byte[])null);
    }

    @Override
    protected CommandAPDU createSelectMasterFile1() {
        return null;
    }

    @Override
    protected CommandAPDU createSelectMasterFile2() {
        return null;
    }

    @Override
    protected void selectSubDirectory(CardChannel channel, FileReference directory) throws ResponseCodeException, CardTerminalException {
        CommandAPDU cmd = JCOP231BNotkV2GP.createSelectAID(directory.reference);
        LOG.debug((Object)("SELECT SUB DIR CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("SELECT SUB DIR RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err != 36864) {
            throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err));
        }
    }

    @Override
    protected void selectFile(CardChannel channel, FileReference file) throws ResponseCodeException, CardTerminalException {
        if (file == null) {
            return;
        }
        CommandAPDU cmd = JCOP231BNotkV2GP.createSelectCommand(file.reference, 1);
        LOG.debug((Object)("SELECT FILE CMD : " + HexString.hexify(cmd.getBytes(), false)));
        ResponseAPDU res = channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("SELECT FILE RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err != 36864) {
            throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err));
        }
    }

    private CardApplication createBEAApp(Terminal pTerminal, int pSlotID, long idOfCard, long idOfMFApplication) {
        String aid = AID_BEA.replaceAll(" ", "");
        long idOfApplication = 1000001L;
        long idOfPin01 = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfKey01 = 4000001L;
        byte pinID01 = -127;
        KeyID k01 = new KeyID("01");
        FileReference dirRefApp = new FileReference(4, aid);
        FileReference cerRef01 = new FileReference(2, "ce01");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Card-PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{idOfKey01});
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cer", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "CardKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType()}), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info01, new long[]{idOfFile01}, new long[0], new long[]{idOfPin01}, k01);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider01 = this.createAlgorithmProvider(JCOPAlgorithmHelper.getBeaSupportedAlgorithms());
        key01.setAlgorithmProvider(algorithmProvider01);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl(aid, idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putPin(pin01);
        applicationApp.putFile(file01);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    private void selectForPin(OCFCertificateInfo info, CardChannel cardChannel) throws ResponseCodeException, CardTerminalException {
        if (info.getPinID() == -127) {
            this.selectSubDirectory(cardChannel, info.getPin().getParentApplication().getFileEntry().getDirectory());
        } else {
            this.selectSubDirectory(cardChannel, info.getKey().getParentApplication().getFileEntry().getDirectory());
        }
    }

    @Override
    protected final synchronized boolean isKeyInitialized(CardChannel channel, OCFCertificateInfo info) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException {
        ResponseAPDU res = this.getPinState(channel, info);
        int errorCode = res.sw();
        return errorCode != 27013;
    }

    @Override
    protected final int getRetryCount(CardChannel channel, OCFCertificateInfo info) throws RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, ResponseCodeException {
        int errorCode;
        this.selectForPin(info, channel);
        String pinName = JCOP231BNotkV2GP.getPinNameForInfo(info);
        ResponseAPDU res = this.getPinState(channel, info);
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            LOG.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 27013) {
            throw new NotYetInitializedException(pinName, errorCode, message);
        }
        if (errorCode == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }

    private ResponseAPDU getPinState(CardChannel cardChannel, OCFCertificateInfo info) throws CardTerminalException, ResponseCodeException {
        this.selectForPin(info, cardChannel);
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(info.getPinID());
        LOG.debug((Object)("PS CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = cardChannel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("PS RESULT : " + HexString.hexify(res.getBuffer(), false)));
        return res;
    }

    @Override
    public final int getPasswordBlockLength(OCFCertificateInfo info) {
        return -1;
    }

    @Override
    protected byte[] getPaddedPIN(OCFCertificateInfo info, char[] pin) {
        return ByteUtil.convert(pin);
    }

    @Override
    public final PinEncoder getPinEncoder(OCFCertificateInfo info) {
        return PinEncoder.ENCODER_T50;
    }

    @Override
    public final byte getPasswordBlockFiller(OCFCertificateInfo info) {
        return 0;
    }

    @Override
    public final Integer getMaxPINLengthInit(OCFCertificateInfo info) {
        return info.getPinID() == -127 ? Integer.valueOf(5) : null;
    }

    @Override
    public final Integer getMinPINLengthInit(OCFCertificateInfo info) {
        return info.getPinID() == -127 ? Integer.valueOf(5) : null;
    }

    @Override
    public final int getMinPINLength(OCFCertificateInfo info) {
        return 6;
    }

    @Override
    public final int getMaxPINLength(OCFCertificateInfo info) {
        return 12;
    }

    @Override
    protected CommandAPDU createSignHashCommand(byte[] hashValue, AlgorithmParameters algorithmParameters, OCFCertificateInfo info) {
        CardExecutionSignAuthenticateParameterSpec parameterSpec = null;
        try {
            parameterSpec = algorithmParameters.getParameterSpec(CardExecutionSignAuthenticateParameterSpec.class);
        }
        catch (InvalidParameterSpecException e) {
            LOG.debug((Object)e);
            throw new IllegalArgumentException("failed to get spec with informations", e);
        }
        int algorithmID = new BigInteger(1, parameterSpec.getAlgorithmID()).intValue();
        int functionID = algorithmID & 0xF00;
        int digestID = algorithmID & 0xF;
        int paddingID = algorithmID & 0xF0;
        if (functionID != 256) {
            throw new IllegalArgumentException("wrong function at algorithmID");
        }
        int keySize = RSAHelper.getKeySize(info.getCertificateBag().getCertificate().getPublicKey());
        byte[] signatureInput = null;
        try {
            SHA256Digest digest = null;
            switch (digestID) {
                case 2: {
                    digest = new SHA256Digest();
                    break;
                }
                case 4: {
                    digest = new SHA384Digest();
                    break;
                }
                case 8: {
                    digest = new SHA512Digest();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("wrong digest at algorithmID");
                }
            }
            switch (paddingID) {
                case 16: {
                    signatureInput = RSAHelper.buildSignatureInputPKCS1v15(hashValue, keySize);
                    break;
                }
                case 32: {
                    signatureInput = RSAHelper.buildSignatureInputPKCS1pss(hashValue, (Digest)digest, keySize);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("wrong padding at algorithmID");
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to create sign input: " + e.getMessage(), e);
        }
        return new ISOCommandAPDU(-128, 104, info.getKeyID().id[0], 32, signatureInput, keySize / 8);
    }

    @Override
    protected final GovCS.ResultObject authentify(CardChannel channel, OCFCertificateInfo info, byte[] hashValue, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws CardTerminalException, ResponseCodeException, OperationCancelledException {
        return super.signHash(channel, info, hashValue, hashAlgorithm, algorithmParameters);
    }

    @Override
    public final synchronized GovCS.ResultObject signHash(OCFCertificateInfo info, byte[] hashValue, char[] pin, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        if (OCFProvider.Settings.getInstance().isStapleSignatureEnabled() && this.isStapleSign() || OCFProvider.Settings.getInstance().isServerEnvironmentActive() && this.isMultiSign()) {
            return this.signHashServer(info, hashValue, pin, hashAlgorithm, algorithmParameters);
        }
        return super.signHash(info, hashValue, pin, hashAlgorithm, algorithmParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized GovCS.ResultObject signHashServer(OCFCertificateInfo info, byte[] hashValue, char[] pin, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, OperationCancelledException {
        if (this.getAvailableHashAlgorithmNames(info).indexOf(hashAlgorithm) < 0) {
            throw new ResponseCodeException(65535, "hash algorithm not supported by card: " + hashAlgorithm, new NoSuchAlgorithmException("OperationCancelledException"));
        }
        ProgressSession session = new ProgressSession(2);
        session.setStepCount(6);
        session.setProgressMessage("init sign hash operation");
        if (this.progressSessionListener != null) {
            this.progressSessionListener.progressSessionWillStart(session);
            this.progressSessionListener.progressSessionStarted(session);
        }
        CardChannelManager cm = new CardChannelManager();
        try {
            cm.init(this, true, false);
            boolean localTransaction = cm.isTransactionLocallyStarted();
            try {
                this.checkSignCounter(null, localTransaction);
            }
            catch (MaxSignatureCountReachedException e) {
                cm.allocate();
                this.resetCard(cm.getCardChannel());
                throw e;
            }
            GovCS.ResultObject ro = new GovCS.ResultObject();
            ro = this.signHashServerInt(info, hashValue, pin, hashAlgorithm, session, ro, algorithmParameters);
            if (ro.getResultCode() == 36864) {
                try {
                    this.increaseAndCheckSignCounter(null, localTransaction);
                }
                catch (MaxSignatureCountReachedException e) {
                    cm.allocate();
                    this.resetCard(cm.getCardChannel());
                }
            }
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cm.destroy();
        }
    }

    @Override
    protected GovCS.ResultObject decrypt(CardChannel channel, OCFCertificateInfo info, byte[] encryptedBytes, AlgorithmParameters algorithmParameters) throws CardTerminalException, ResponseCodeException, OperationCancelledException {
        CardExecutionDecryptRSAParameterSpec parameterSpec = null;
        try {
            parameterSpec = algorithmParameters.getParameterSpec(CardExecutionDecryptRSAParameterSpec.class);
        }
        catch (Exception e) {
            LOG.debug((Object)e);
            throw new IllegalArgumentException("failed to get spec with informations", e);
        }
        int algorithmID = new BigInteger(1, parameterSpec.getAlgorithmID()).intValue();
        int functionID = algorithmID & 0xF00;
        int paddingID = algorithmID & 0xF0;
        if (functionID != 512) {
            throw new IllegalArgumentException("wrong function at algorithmID");
        }
        switch (paddingID) {
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalArgumentException("wrong padding at algorithmID");
            }
        }
        GovCS.ResultObject paddedResultObject = super.decrypt(channel, info, encryptedBytes, algorithmParameters);
        if (paddedResultObject.getResultCode() == 36864) {
            try {
                byte[] paddedData = (byte[])paddedResultObject.getResultData();
                switch (paddingID) {
                    case 16: {
                        paddedResultObject.setResultData(ByteUtil.subbytes(paddedData, ByteUtil.lastIndexOf(paddedData, new byte[]{0}) + 1));
                        break;
                    }
                    case 32: {
                        paddedResultObject.setResultData(RSAHelper.unpadOAEP("SHA256", paddedData));
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new ResponseCodeException(paddedResultObject.getResultCode(), "unpadding failed: " + e.getMessage(), e);
            }
        }
        return paddedResultObject;
    }

    @Override
    protected final CommandAPDU createDecryptCommand(byte[] encryptedBytes, byte paddingIndicator, AlgorithmParameters algorithmParameters, OCFCertificateInfo info) {
        return new ISOCommandAPDU(-128, 98, info.getKeyID().id[0], 33, encryptedBytes, RSAHelper.getKeySize(info.getCertificateBag().getCertificate().getPublicKey()) / 8);
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo info) {
        ArrayList<String> c = new ArrayList<String>();
        if (info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA256");
            c.add("SHA384");
            c.add("SHA512");
        }
        return c;
    }

    @Override
    protected final boolean usesASN1HeaderWithAuthentify() {
        return false;
    }

    @Override
    protected final boolean usesASN1HeaderWithSignHash() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GovCS.ResultObject signHashServerInt(OCFCertificateInfo info, byte[] hashValue, char[] pin, String hashAlgorithm, ProgressSession session, GovCS.ResultObject notUsedRO, AlgorithmParameters algorithmParameters) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, OperationCancelledException {
        GovCS.ResultObject ro = null;
        CardChannelManager cardChannelManager = new CardChannelManager();
        CardChannel channel = null;
        try {
            this.fireProgressEvent(session, "get connection to the device");
            channel = cardChannelManager.init(this);
            this.fireProgressEvent(session, "select application on card");
            if (!this.checkChannelState(channel, info)) {
                this.selectForPin(info, channel);
            }
            boolean loop = true;
            this.fireProgressEvent(session, "install corresponding security environment");
            ro = this.setSecurityEnvironment(channel, info, 0, hashAlgorithm, algorithmParameters);
            if (ro.getResultCode() != 36864) {
                LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                GovCS.ResultObject resultObject = ro;
                return resultObject;
            }
            while (loop) {
                this.fireProgressEvent(session, "sign the given hash value");
                ro = this.signHash(channel, info, hashValue, hashAlgorithm, algorithmParameters);
                if (ro.getResultCode() == 27010) {
                    this.resetChannelState(channel);
                    try {
                        this.checkSignCounter(channel, false);
                    }
                    catch (MaxSignatureCountReachedException e) {
                        LOG.debug((Object)"maximum signature count reached, ignored");
                    }
                    this.selectFile(channel, info, false);
                    this.fireProgressEvent(session, "verify the corresponding password");
                    ro.setResultCode(this.verifyPassword(channel, info, pin));
                    if (ro.getResultCode() != 36864) {
                        LOG.debug((Object)APDUCommands.getVerifyErrorMsg(ro.getResultCode()));
                        GovCS.ResultObject resultObject = ro;
                        return resultObject;
                    }
                    this.fireProgressEvent(session, "install corresponding security environment");
                    ro = this.setSecurityEnvironment(channel, info, 0, hashAlgorithm, algorithmParameters);
                    if (ro.getResultCode() != 36864) {
                        LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                        GovCS.ResultObject resultObject = ro;
                        return resultObject;
                    }
                    loop = true;
                    continue;
                }
                this.fireProgressEvent(session, "operation finished!");
                loop = false;
            }
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (NotYetInitializedException | OperationCancelledException | ResponseCodeException | RetryCounterExpiredException | WrongPinException e) {
            throw e;
        }
        catch (CardTerminalException ex) {
            LOG.debug((Object)"", (Throwable)ex);
            ro.setResultCode(0);
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            ro.setResultCode(0);
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cardChannelManager.destroy();
            if (this.progressSessionListener != null) {
                while (session.getCurrentStep() != session.getStepCount()) {
                    session.increaseCurrentStep();
                }
                session.setProgressMessage("done!");
                this.progressSessionListener.progressSessionWillStop(session);
                this.progressSessionListener.progressSessionStopped(session);
            }
        }
    }

    @Override
    protected CommandAPDU createSignHashCommand(byte[] hashValue, AlgorithmParameters algorithmParameters) {
        return null;
    }

    @Override
    public boolean isMultiAuthenticate(OCFCertificateInfo info) {
        OCFCertificateInfo.Usage u = info.getUsage();
        return u == OCFCertificateInfo.Usage.AUT || u == OCFCertificateInfo.Usage.AEN;
    }
}

