/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.gp;

import de.bos_bremen.basecard.common.crypto.Algorithm;
import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.CardExecutionDecryptRSAParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OCFDefaultAlgorithmFinder;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSession;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.MaxSignatureCountReachedException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.gp.JCOP211;
import de.bos_bremen.gov2.jca_provider.ocf.cards.gp.RSAHelper;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import opencard.opt.terminal.ISOCommandAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;

public class JCOP211BNotkBea
extends JCOP211 {
    private static final int ALGORITHM_ID_MASK_FUNCTION = 3840;
    private static final int ALGORITHM_ID_MASK_PADDING = 240;
    private static final int ALGORITHM_ID_MASK_DIGEST = 15;
    private static final int ALGORITHM_ID_FUNCTION_SIGN = 256;
    private static final int ALGORITHM_ID_FUNCTION_CIPHER = 512;
    private static final int ALGORITHM_ID_PADDING_PKCS1_v15 = 16;
    private static final int ALGORITHM_ID_PADDING_PKCS1_PSS = 32;
    private static final int ALGORITHM_ID_PADDING_PKCS1_OAEP = 32;
    private static final int ALGORITHM_ID_SHA256 = 2;
    private static final int ALGORITHM_ID_SHA384 = 4;
    private static final int ALGORITHM_ID_SHA512 = 8;
    private static final int ALGORITHM_ID_SIGN_RSA_PKCS1v15_SHA256 = 274;
    private static final int ALGORITHM_ID_SIGN_RSA_PKCS1v15_SHA384 = 276;
    private static final int ALGORITHM_ID_SIGN_RSA_PKCS1v15_SHA512 = 280;
    private static final int ALGORITHM_ID_SIGN_RSA_PSS_SHA256 = 290;
    private static final int ALGORITHM_ID_SIGN_RSA_PSS_SHA384 = 292;
    private static final int ALGORITHM_ID_SIGN_RSA_PSS_SHA512 = 296;
    private static final int ALGORITHM_ID_CIPHER_RSA_PKCS1v15 = 528;
    private static final int ALGORITHM_ID_CIPHER_RSA_OAEP = 544;
    private static final Log LOG = LogFactory.getLog(JCOP211BNotkBea.class);
    private String displayName = "beA Mitarbeiterkarte BNotK";
    private final String tokenLabel;
    private boolean stapleSign = false;
    private boolean multiSign = false;
    private Card.CardTypeEnum cardType = DEFAULT_CARD_TYPE;
    public static final String DEFAULT_DISPLAY_NAME = "beA Mitarbeiterkarte BNotK";
    public static final String ISSUER_CONSTANT = "beA Mitarbeiterkarte BNotK";
    public static final boolean DEFAULT_STAPLE_SIGN = false;
    public static final boolean DEFAULT_MULTI_SIGN = false;
    public static final Card.CardTypeEnum DEFAULT_CARD_TYPE = Card.CardTypeEnum.BNOTK_BEA_MA;
    public static final String AID_BEA = "E8 2B 06 01 04 01 81 C3 1F 02 01";

    public JCOP211BNotkBea() {
        this.tokenLabel = "beA Mitarbeiterkarte BNotK";
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final boolean isMultiSign() {
        return this.multiSign;
    }

    @Override
    public boolean isStapleSign() {
        return this.stapleSign || GovCS.isStapleSign(this);
    }

    @Override
    protected final boolean isIssuerReadRequired() {
        return true;
    }

    @Override
    protected String getIssuerConstant() {
        return this.tokenLabel;
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        String readIssuerFromATR = super.readIssuerFromATR(_channel);
        if ("GLOBAL_PLATFORM_CARD_2_1_1".equals(readIssuerFromATR)) {
            try {
                readIssuerFromATR = null;
                if (36864 == _channel.sendCommandAPDU(JCOP211BNotkBea.createSelectAID(AID_BEA)).sw()) {
                    readIssuerFromATR = "beA Mitarbeiterkarte BNotK";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return readIssuerFromATR;
    }

    @Override
    public final Integer getStapleSignCounter() {
        return this.stapleSign ? Integer.valueOf(100) : (this.isStapleSign() ? MAXIMUM_COUNT_OF_STAPLE_SIGNATURES : null);
    }

    @Override
    protected final Card createCardInt(Terminal pTerminal, int pSlotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardApplication appBEA = this.createBEAApp(pTerminal, pSlotID, idOfCard, idOfMFApplication);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(appBEA);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.MF.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, this.cardType.getType(), super.getCard(), mfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    @Override
    protected CommandAPDU createSelectMasterFile() {
        return JCOP211BNotkBea.createSelectAID((byte[])null);
    }

    @Override
    protected CommandAPDU createSelectMasterFile1() {
        return null;
    }

    @Override
    protected CommandAPDU createSelectMasterFile2() {
        return null;
    }

    @Override
    protected void selectSubDirectory(CardChannel _channel, FileReference _directory) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        CommandAPDU cmd = JCOP211BNotkBea.createSelectAID(_directory.reference);
        LOG.debug((Object)("SELECT SUB DIR CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("SELECT SUB DIR RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err != 36864) {
            throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err));
        }
    }

    @Override
    protected void selectFile(CardChannel _channel, FileReference _file) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (_file == null) {
            return;
        }
        CommandAPDU cmd = JCOP211BNotkBea.createSelectCommand(_file.reference, 1);
        LOG.debug((Object)("SELECT FILE CMD : " + HexString.hexify(cmd.getBytes(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("SELECT FILE RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err != 36864) {
            throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err));
        }
    }

    private CardApplication createBEAApp(Terminal pTerminal, int pSlotID, long idOfCard, long idOfMFApplication) {
        String aid = AID_BEA.replaceAll(" ", "");
        long idOfApplication = 1000001L;
        long idOfPin01 = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfKey01 = 4000001L;
        byte pinID01 = -127;
        KeyID k01 = new KeyID("01");
        FileReference dirRefApp = new FileReference(4, aid);
        FileReference cerRef01 = new FileReference(2, "ce01");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Card-PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{idOfKey01});
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cer", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "CardKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType()}), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info01, new long[]{idOfFile01}, new long[0], new long[]{idOfPin01}, k01);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider01 = this.createAlgorithmProvider();
        key01.setAlgorithmProvider(algorithmProvider01);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl(aid, idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putPin(pin01);
        applicationApp.putFile(file01);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    private AlgorithmProvider<OCFPrivateKey> createAlgorithmProvider() {
        List<UsageRelated.Usage> usageList01 = Arrays.asList(UsageRelated.Usage.SIGNATURE, UsageRelated.Usage.AUTHENTICATION);
        List<UsageRelated.Usage> usageList02 = Arrays.asList(UsageRelated.Usage.CIPHER);
        ArrayList listKeyAlgorithms01 = new ArrayList();
        this.addPKCS1PSSSignAlgorithm(listKeyAlgorithms01, usageList01, "SHA256", "SHA384", "SHA512");
        this.addPKCS1v15SignAlgorithm(listKeyAlgorithms01, usageList01, "SHA256", "SHA384", "SHA512");
        OCFDefaultAlgorithmFinder finder = OCFDefaultAlgorithmFinder.getInstance();
        try {
            listKeyAlgorithms01.add(new Algorithm("OCF", usageList02, "RSA/ECB/PKCS1Padding", "RSA/PKCS1", new CardExecutionDecryptRSAParameterSpec("RSA/ECB/PKCS1Padding", new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), finder.findURI("RSA/ECB/PKCS1Padding"), null, BigInteger.valueOf(528L).toByteArray())));
            listKeyAlgorithms01.add(new Algorithm("OCF", usageList02, "RSA/ECB/OAEP", "RSA/ECB/OAEP", new CardExecutionDecryptRSAParameterSpec("RSA/ECB/OAEP", new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), finder.findURI("RSA/ECB/OAEP"), null, BigInteger.valueOf(544L).toByteArray())));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        return this.createAlgorithmProvider(listKeyAlgorithms01);
    }

    private void addPKCS1v15SignAlgorithm(List<Algorithm<OCFPrivateKey, ?>> listKeyAlgorithms, List<UsageRelated.Usage> usageList, String ... digestNames) {
        for (String digestName : digestNames) {
            String name;
            byte[] algorithmID = null;
            if ("SHA256".equals(digestName)) {
                algorithmID = BigInteger.valueOf(274L).toByteArray();
            } else if ("SHA384".equals(digestName)) {
                algorithmID = BigInteger.valueOf(276L).toByteArray();
            } else if ("SHA512".equals(digestName)) {
                algorithmID = BigInteger.valueOf(280L).toByteArray();
            }
            try {
                name = digestName + "withRSA";
                listKeyAlgorithms.add(new Algorithm("OCF", usageList, name, name + "/PKCS1", new CardExecutionSignAuthenticateParameterSpec(name, OCFDefaultAlgorithmFinder.getInstance().find(name), Boolean.TRUE, algorithmID)));
            }
            catch (Exception e) {
                LOG.debug((Object)e);
            }
            try {
                name = digestName + "hashedWithRSA";
                listKeyAlgorithms.add(new Algorithm("OCF", usageList, name, name + "/PKCS1", new CardExecutionSignAuthenticateParameterSpec(name, OCFDefaultAlgorithmFinder.getInstance().find(name), Boolean.TRUE, algorithmID)));
            }
            catch (Exception e) {
                LOG.debug((Object)e);
            }
        }
    }

    private void addPKCS1PSSSignAlgorithm(List<Algorithm<OCFPrivateKey, ?>> listKeyAlgorithms, List<UsageRelated.Usage> usageList, String ... digestNames) {
        for (String digestName : digestNames) {
            String name;
            byte[] algorithmID = null;
            if ("SHA256".equals(digestName)) {
                algorithmID = BigInteger.valueOf(290L).toByteArray();
            } else if ("SHA384".equals(digestName)) {
                algorithmID = BigInteger.valueOf(292L).toByteArray();
            } else if ("SHA512".equals(digestName)) {
                algorithmID = BigInteger.valueOf(296L).toByteArray();
            }
            try {
                name = digestName + "withRSA";
                listKeyAlgorithms.add(new Algorithm("OCF", usageList, name + "andMGF1", name + "/PSS", new CardExecutionSignAuthenticateParameterSpec(name + "andMGF1", OCFDefaultAlgorithmFinder.getInstance().find(name + "andMGF1"), Boolean.FALSE, algorithmID)));
            }
            catch (Exception e) {
                LOG.debug((Object)e);
            }
            try {
                name = digestName + "hashedWithRSA";
                listKeyAlgorithms.add(new Algorithm("OCF", usageList, name + "andMGF1", name + "/PSS", new CardExecutionSignAuthenticateParameterSpec(digestName + "hashedWithRSAandMGF1", OCFDefaultAlgorithmFinder.getInstance().find(name + "andMGF1"), Boolean.FALSE, algorithmID)));
            }
            catch (Exception e) {
                LOG.debug((Object)e);
            }
        }
    }

    private void selectForPin(OCFCertificateInfo _info, CardChannel cardChannel) throws ResponseCodeException, CardTerminalException {
        if (_info.getPinID() == -127) {
            this.selectSubDirectory(cardChannel, _info.getPin().getParentApplication().getFileEntry().getDirectory());
        } else {
            this.selectSubDirectory(cardChannel, _info.getKey().getParentApplication().getFileEntry().getDirectory());
        }
    }

    @Override
    protected final synchronized boolean isKeyInitialized(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        ResponseAPDU res = this.getPinState(_channel, _info);
        int errorCode = res.sw();
        return errorCode != 27013;
    }

    @Override
    protected final int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        int errorCode;
        this.selectForPin(_info, _channel);
        String pinName = JCOP211BNotkBea.getPinNameForInfo(_info);
        ResponseAPDU res = this.getPinState(_channel, _info);
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            LOG.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 27013) {
            throw new NotYetInitializedException(pinName, errorCode, message);
        }
        if (errorCode == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }

    private ResponseAPDU getPinState(CardChannel cardChannel, OCFCertificateInfo info) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        this.selectForPin(info, cardChannel);
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(info.getPinID());
        LOG.debug((Object)("PS CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = cardChannel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("PS RESULT : " + HexString.hexify(res.getBuffer(), false)));
        return res;
    }

    @Override
    public final int getPasswordBlockLength(OCFCertificateInfo _info) {
        return -1;
    }

    @Override
    protected byte[] getPaddedPIN(OCFCertificateInfo _info, char[] _pin) {
        return ByteUtil.convert(_pin);
    }

    @Override
    public final PinEncoder getPinEncoder(OCFCertificateInfo _info) {
        return PinEncoder.ENCODER_T50;
    }

    @Override
    public final byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        return 0;
    }

    @Override
    public final Integer getMaxPINLengthInit(OCFCertificateInfo info) {
        return info.getPinID() == -127 ? Integer.valueOf(5) : null;
    }

    @Override
    public final Integer getMinPINLengthInit(OCFCertificateInfo info) {
        return info.getPinID() == -127 ? Integer.valueOf(5) : null;
    }

    @Override
    public final int getMinPINLength(OCFCertificateInfo info) {
        return 6;
    }

    @Override
    public final int getMaxPINLength(OCFCertificateInfo info) {
        return 12;
    }

    @Override
    protected CommandAPDU createSignHashCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters, OCFCertificateInfo info) {
        CardExecutionSignAuthenticateParameterSpec parameterSpec = null;
        try {
            parameterSpec = algorithmParameters.getParameterSpec(CardExecutionSignAuthenticateParameterSpec.class);
        }
        catch (InvalidParameterSpecException e) {
            LOG.debug((Object)e);
            throw new IllegalArgumentException("failed to get spec with informations");
        }
        int algorithmID = new BigInteger(1, parameterSpec.getAlgorithmID()).intValue();
        int functionID = algorithmID & 0xF00;
        int digestID = algorithmID & 0xF;
        int paddingID = algorithmID & 0xF0;
        if (functionID != 256) {
            throw new IllegalArgumentException("wrong function at algorithmID");
        }
        int keySize = RSAHelper.getKeySize(info.getCertificateBag().getCertificate().getPublicKey());
        byte[] signatureInput = null;
        try {
            SHA256Digest digest = null;
            switch (digestID) {
                case 2: {
                    digest = new SHA256Digest();
                    break;
                }
                case 4: {
                    digest = new SHA384Digest();
                    break;
                }
                case 8: {
                    digest = new SHA512Digest();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("wrong digest at algorithmID");
                }
            }
            switch (paddingID) {
                case 16: {
                    signatureInput = RSAHelper.buildSignatureInputPKCS1v15(_hashValue, keySize);
                    break;
                }
                case 32: {
                    signatureInput = RSAHelper.buildSignatureInputPKCS1pss(_hashValue, (Digest)digest, keySize);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("wrong padding at algorithmID");
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to create sign input: " + e.getMessage());
        }
        return new ISOCommandAPDU(-128, 104, info.getKeyID().id[0], 32, signatureInput, keySize / 8);
    }

    @Override
    protected final GovCS.ResultObject authentify(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        return super.signHash(_channel, _info, _hashValue, _hashAlgorithm, algorithmParameters);
    }

    @Override
    public final synchronized GovCS.ResultObject signHash(OCFCertificateInfo _info, byte[] _hashValue, char[] _pin, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        if (OCFProvider.Settings.getInstance().isStapleSignatureEnabled() && this.isStapleSign() || OCFProvider.Settings.getInstance().isServerEnvironmentActive() && this.isMultiSign()) {
            return this.signHashServer(_info, _hashValue, _pin, _hashAlgorithm, algorithmParameters);
        }
        return super.signHash(_info, _hashValue, _pin, _hashAlgorithm, algorithmParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized GovCS.ResultObject signHashServer(OCFCertificateInfo _info, byte[] _hashValue, char[] _pin, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        if (this.getAvailableHashAlgorithmNames(_info).indexOf(_hashAlgorithm) < 0) {
            throw new ResponseCodeException(65535, "hash algorithm not supported by card: " + _hashAlgorithm, new NoSuchAlgorithmException("OperationCancelledException"));
        }
        ProgressSession session = new ProgressSession(2);
        session.setStepCount(6);
        session.setProgressMessage("init sign hash operation");
        if (this.progressSessionListener != null) {
            this.progressSessionListener.progressSessionWillStart(session);
            this.progressSessionListener.progressSessionStarted(session);
        }
        CardChannelManager cm = new CardChannelManager();
        try {
            cm.init(this, true, false);
            boolean localTransaction = cm.isTransactionLocallyStarted();
            try {
                this.checkSignCounter(null, localTransaction);
            }
            catch (MaxSignatureCountReachedException e) {
                cm.allocate();
                this.resetCard(cm.getCardChannel());
                throw e;
            }
            GovCS.ResultObject ro = new GovCS.ResultObject();
            ro = this.signHashServerInt(_info, _hashValue, _pin, _hashAlgorithm, session, ro, algorithmParameters);
            if (ro.getResultCode() == 36864) {
                try {
                    this.increaseAndCheckSignCounter(null, localTransaction);
                }
                catch (MaxSignatureCountReachedException e) {
                    cm.allocate();
                    this.resetCard(cm.getCardChannel());
                }
            }
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cm.destroy();
        }
    }

    @Override
    protected GovCS.ResultObject decrypt(CardChannel _channel, OCFCertificateInfo _info, byte[] _encryptedBytes, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        CardExecutionDecryptRSAParameterSpec parameterSpec = null;
        try {
            parameterSpec = algorithmParameters.getParameterSpec(CardExecutionDecryptRSAParameterSpec.class);
        }
        catch (Exception e) {
            LOG.debug((Object)e);
            throw new IllegalArgumentException("failed to get spec with informations");
        }
        int algorithmID = new BigInteger(1, parameterSpec.getAlgorithmID()).intValue();
        int functionID = algorithmID & 0xF00;
        int paddingID = algorithmID & 0xF0;
        if (functionID != 512) {
            throw new IllegalArgumentException("wrong function at algorithmID");
        }
        switch (paddingID) {
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalArgumentException("wrong padding at algorithmID");
            }
        }
        GovCS.ResultObject paddedResultObject = super.decrypt(_channel, _info, _encryptedBytes, algorithmParameters);
        if (paddedResultObject.getResultCode() == 36864) {
            try {
                byte[] paddedData = (byte[])paddedResultObject.getResultData();
                switch (paddingID) {
                    case 16: {
                        paddedResultObject.setResultData(ByteUtil.subbytes(paddedData, ByteUtil.lastIndexOf(paddedData, new byte[]{0}) + 1));
                        break;
                    }
                    case 32: {
                        paddedResultObject.setResultData(RSAHelper.unpadOAEP("SHA256", paddedData));
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new ResponseCodeException("unpadding failed: " + e.getMessage());
            }
        }
        return paddedResultObject;
    }

    @Override
    protected final CommandAPDU createDecryptCommand(byte[] _encryptedBytes, byte _paddingIndicator, AlgorithmParameters algorithmParameters, OCFCertificateInfo info) {
        return new ISOCommandAPDU(-128, 98, info.getKeyID().id[0], 33, _encryptedBytes, RSAHelper.getKeySize(info.getCertificateBag().getCertificate().getPublicKey()) / 8);
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA256");
            c.add("SHA384");
            c.add("SHA512");
        }
        return c;
    }

    @Override
    protected final boolean usesASN1HeaderWithAuthentify() {
        return false;
    }

    @Override
    protected final boolean usesASN1HeaderWithSignHash() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GovCS.ResultObject signHashServerInt(OCFCertificateInfo _info, byte[] _hashValue, char[] _pin, String _hashAlgorithm, ProgressSession session, GovCS.ResultObject ro, AlgorithmParameters algorithmParameters) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, PinInputCancelledException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, OperationCancelledException {
        CardChannelManager cardChannelManager = new CardChannelManager();
        CardChannel channel = null;
        try {
            this.fireProgressEvent(session, "get connection to the device");
            channel = cardChannelManager.init(this);
            this.fireProgressEvent(session, "select application on card");
            if (!this.checkChannelState(channel, _info)) {
                this.selectForPin(_info, channel);
            }
            boolean loop = true;
            this.fireProgressEvent(session, "install corresponding security environment");
            ro = this.setSecurityEnvironment(channel, _info, 0, _hashAlgorithm, algorithmParameters);
            if (ro.getResultCode() != 36864) {
                LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                GovCS.ResultObject resultObject = ro;
                return resultObject;
            }
            while (loop) {
                this.fireProgressEvent(session, "sign the given hash value");
                ro = this.signHash(channel, _info, _hashValue, _hashAlgorithm, algorithmParameters);
                if (ro.getResultCode() == 27010) {
                    this.resetChannelState(channel);
                    try {
                        this.checkSignCounter(channel, false);
                    }
                    catch (MaxSignatureCountReachedException maxSignatureCountReachedException) {
                        // empty catch block
                    }
                    this.selectFile(channel, _info, false);
                    this.fireProgressEvent(session, "verify the corresponding password");
                    ro.setResultCode(this.verifyPassword(channel, _info, _pin));
                    if (ro.getResultCode() != 36864) {
                        LOG.debug((Object)APDUCommands.getVerifyErrorMsg(ro.getResultCode()));
                        GovCS.ResultObject resultObject = ro;
                        return resultObject;
                    }
                    this.fireProgressEvent(session, "install corresponding security environment");
                    ro = this.setSecurityEnvironment(channel, _info, 0, _hashAlgorithm, algorithmParameters);
                    if (ro.getResultCode() != 36864) {
                        LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                        GovCS.ResultObject resultObject = ro;
                        return resultObject;
                    }
                    loop = true;
                    continue;
                }
                this.fireProgressEvent(session, "operation finished!");
                loop = false;
            }
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (WrongPinException e) {
            throw e;
        }
        catch (RetryCounterExpiredException e) {
            throw e;
        }
        catch (NotYetInitializedException e) {
            throw e;
        }
        catch (PinInputTooShortException e) {
            throw e;
        }
        catch (PinInputTooLongException e) {
            throw e;
        }
        catch (PinInputTimeoutException e) {
            throw e;
        }
        catch (PinInputCancelledException e) {
            throw e;
        }
        catch (OperationCancelledException e) {
            throw e;
        }
        catch (ResponseCodeException e) {
            throw e;
        }
        catch (CardTerminalException ex) {
            LOG.debug((Object)"", (Throwable)ex);
            ro.setResultCode(0);
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            ro.setResultCode(0);
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cardChannelManager.destroy();
            if (this.progressSessionListener != null) {
                while (session.getCurrentStep() != session.getStepCount()) {
                    session.increaseCurrentStep();
                }
                session.setProgressMessage("done!");
                this.progressSessionListener.progressSessionWillStop(session);
                this.progressSessionListener.progressSessionStopped(session);
            }
        }
    }

    @Override
    protected CommandAPDU createSignHashCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        return null;
    }

    @Override
    public boolean isMultiAuthenticate(OCFCertificateInfo info) {
        OCFCertificateInfo.Usage u = info.getUsage();
        return u == OCFCertificateInfo.Usage.AUT || u == OCFCertificateInfo.Usage.AEN;
    }

    @Override
    protected void resetAuthentication(CardChannel channel) {
        super.resetAuthentication(channel);
    }
}

