/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.gp;

import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import opencard.opt.terminal.ISOCommandAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JCOP211
extends GovCS {
    public static final String PRE_CARD_ISSUER_CONSTANT = "GLOBAL_PLATFORM_CARD_2_1_1";
    private static final Log LOG = LogFactory.getLog(JCOP211.class);
    private static final byte[][] HISTORICALS = new byte[][]{HexString.parseHexString("80 31 81 54 48 53 4D 31 73 80 21 40 81 07")};
    private int historicalsIndex = 0;
    public static final int CHUNK_SIZE = JCOP211.abs((byte)-16);
    public static final OID OID_GP211 = new OID("1.2.840.114283.2.2.1.1");

    @Override
    protected String getIssuerConstant() {
        return PRE_CARD_ISSUER_CONSTANT;
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS[this.historicalsIndex];
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        if (!this.areHistoricalsValid(_historicals)) {
            return false;
        }
        this.historicalsIndex = -1;
        for (int i = 0; i < HISTORICALS.length; ++i) {
            byte[] historicals = HISTORICALS[i];
            if (historicals.length != _historicals.length) continue;
            boolean diff = false;
            for (int j = 0; j < _historicals.length && !diff; ++j) {
                diff = historicals[j] != _historicals[j];
            }
            if (diff) continue;
            this.historicalsIndex = i;
            break;
        }
        return this.historicalsIndex >= 0 && this.historicalsIndex < HISTORICALS.length;
    }

    public static CommandAPDU createSelectAID(String aid) {
        if (aid == null || aid.length() == 0) {
            return new ISOCommandAPDU(0, -92, 4, 0, 0);
        }
        return new ISOCommandAPDU(0, -92, 4, 0, HexUtil.parse(aid), 0);
    }

    public static CommandAPDU createSelectAID(byte[] aid) {
        if (aid == null || aid.length == 0) {
            return new ISOCommandAPDU(0, -92, 4, 0, 0);
        }
        return new ISOCommandAPDU(0, -92, 4, 0, aid, 0);
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        ResponseAPDU globalPlatformSelectFCI = null;
        try {
            globalPlatformSelectFCI = _channel.sendCommandAPDU(JCOP211.createSelectAID((byte[])null));
            byte[] data = globalPlatformSelectFCI.data();
            if (36864 == globalPlatformSelectFCI.sw() && data != null && data.length > 0 && ByteUtil.indexOf(data, OID_GP211.getEncoded()) > 0) {
                return PRE_CARD_ISSUER_CONSTANT;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String(globalPlatformSelectFCI.data());
    }

    @Override
    protected final OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[0];
    }

    @Override
    protected final String getOSName() {
        return "JCOP 2.1.1";
    }

    @Override
    protected final int getMaximumChunkSize() {
        return CHUNK_SIZE;
    }

    @Override
    protected void adjustForPaddingByte(GovCS.ResultObject _ro) {
    }

    protected int getCounter(String pinName, byte[] data, byte _wich) throws RetryCounterExpiredException {
        int index;
        byte length;
        for (index = 0; index < data.length; index += length) {
            byte tagID = data[index++];
            length = data[index++];
            if (tagID == _wich) break;
        }
        if (index >= data.length) {
            return -1;
        }
        int result = data[index];
        if (result < 0) {
            result += 256;
        }
        if (result == 0) {
            throw new RetryCounterExpiredException(pinName, 27011, APDUCommands.getVerifyErrorMsg(27011));
        }
        return result;
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        int errorCode;
        String pinName = JCOP211.getPinNameForInfo(_info);
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(_info.getPinID());
        LOG.debug((Object)("RC CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        LOG.debug((Object)("RC RESULT : " + HexString.hexify(res.getBuffer(), false)));
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            LOG.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 27013) {
            throw new NotYetInitializedException(pinName, errorCode, message);
        }
        if (errorCode == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return null;
    }

    @Override
    protected final CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        return null;
    }

    @Override
    public synchronized void reset() {
        if (!super.isCardPresent()) {
            return;
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            channel.setState(null);
        }
        catch (Exception exception) {
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    protected static GovCS.ResultObject readASN1EF(CardChannel cardChannel, String fid, int chunkSize) throws ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        int firstLengthByte;
        byte[] firstBytes;
        int err;
        ResponseAPDU res;
        CommandAPDU cmd;
        ByteArrayOutputStream baos;
        block13: {
            baos = new ByteArrayOutputStream();
            cmd = JCOP211.createSelectCommand(HexUtil.parse(fid), chunkSize);
            LOG.debug((Object)("SELECT FILE/READ FIRST BYTES CMD : " + HexString.hexify(cmd.getBytes(), false)));
            res = cardChannel.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            LOG.debug((Object)("SELECT FILE RES/READ FIRST BYTES : " + HexString.hexify(res.getBuffer(), false)));
            err = res.sw();
            if (err != 36864) {
                throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err) + " - reading first bytes failed");
            }
            firstBytes = res.data();
            if (firstBytes == null || firstBytes.length < 10) {
                throw new ResponseCodeException(RESOURCES.getString("no_response"));
            }
            firstLengthByte = JCOP211.abs(firstBytes[1]);
            if (firstLengthByte >= 128) break block13;
            LOG.debug((Object)("Certificate too short, length: " + firstLengthByte));
            GovCS.ResultObject resultObject = null;
            return resultObject;
        }
        try {
            if (firstLengthByte == 128) {
                throw new ResponseCodeException("indeterminate length coding at EF, not supported");
            }
            int length = 256 * JCOP211.abs(firstBytes[2]) + JCOP211.abs(firstBytes[3]) + 4;
            LOG.debug((Object)("Length: " + length));
            String chunkSizeHex = HexUtil.hexify(new byte[]{(byte)chunkSize});
            LOG.debug((Object)("ChunkSize: " + chunkSize + "/ 0x" + chunkSizeHex));
            int chunks = length / chunkSize;
            int lastChunk = length % chunkSize;
            LOG.debug((Object)("Chunks: " + chunks));
            LOG.debug((Object)("Last chunk: " + lastChunk));
            for (int i = 0; i < chunks; ++i) {
                int offset = i * chunkSize;
                cmd = JCOP211.createReadCommand(HexUtil.parse(fid), offset, chunkSize);
                res = cardChannel.sendCommandAPDU(cmd);
                err = res.sw();
                if (err != 36864) {
                    throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err) + "failed reading chunk: " + i);
                }
                baos.write(res.data());
            }
            int offset = chunks * chunkSize;
            if (lastChunk > 0) {
                cmd = JCOP211.createReadCommand(HexUtil.parse(fid), offset, lastChunk);
                res = cardChannel.sendCommandAPDU(cmd);
                err = res.sw();
                if (err != 36864) {
                    throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err) + "failed reading last chunk");
                }
                baos.write(res.data());
            }
            LOG.debug((Object)("Read length: " + baos.toByteArray().length));
            GovCS.ResultObject ro = new GovCS.ResultObject();
            ro.setResultCode(36864);
            ro.setResultData(baos.toByteArray());
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (IOException e) {
            throw new ResponseCodeException("reading failed: " + e.getMessage());
        }
    }

    @Override
    protected GovCS.ResultObject readCertificate(CardChannel _channel, OCFCertificateInfo _info) throws ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        return JCOP211.readASN1EF(_channel, HexUtil.hexify(_info.getFile().reference), CHUNK_SIZE);
    }

    public static CommandAPDU createSelectCommand(byte[] reference, int chunk) {
        return JCOP211.createReadCommand(reference, 0, chunk);
    }

    public static CommandAPDU createReadCommand(byte[] reference, int offset, int chunk) {
        String hexOffset = HexUtil.hexify(new byte[]{(byte)(offset / 256)}) + HexUtil.hexify(new byte[]{(byte)(offset % 256)});
        return new ISOCommandAPDU(0, -79, reference[0], reference[1], HexUtil.parse("5402" + hexOffset), chunk);
    }

    public static int abs(byte b) {
        return b > 0 ? b : b + 256;
    }
}

