/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.gematik;

import de.bos_bremen.basecard.common.crypto.Algorithm;
import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.CardExecutionDecryptRSAParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.crypto.AlgorithmIdentifierHelper;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ocf.DefaultBaseAlgorithmProviderBuilder;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OCFDefaultAlgorithmFinder;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSession;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongConfirmedNewPinException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.MaxSignatureCountReachedException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.base.HPCHBAG2Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import opencard.core.service.CardChannel;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public abstract class EHBAg2Service
extends GovCS
implements HPCHBAG2Card {
    public static final String ALGORITHM_ID_ELC_SHARED_SECRET_CALCULATION = "0b";
    public static final String ALGORITHM_ID_RSA_DECIPHER_OAEP = "85";
    public static final String ALGORITHM_ID_RSA_ENCIPHER_OAEP = "05";
    public static final String ALGORITHM_ID_SIGN_9796_2_DS2 = "07";
    public static final String ALGORITHM_ID_SIGN_ECDSA = "00";
    public static final String ALGORITHM_ID_SIGN_PKCS1_V1_5 = "02";
    public static final String ALGORITHM_ID_SIGN_PSS = "05";
    private static final int CLA_PIN_STATE_GEMATIK = 128;
    private static final String DEFAULT_HASH_ALGORITHM = "SHA256";
    private static final Log LOG = LogFactory.getLog(EHBAg2Service.class);
    private static final String LOG_SELECT_MF_CMD = "SELECT MF CMD : ";
    private static final String LOG_SELECT_MF_RES = "SELECT MF RES : ";
    private static final String MSG_RESOURCE_BUNDLE_NO_RESPONSE = "no_response";
    protected Card.CardTypeEnum cardType;

    protected EHBAg2Service(Card.CardTypeEnum cardType) {
        this.cardType = cardType == null ? Card.CardTypeEnum.UNKNOWN : cardType;
    }

    protected static AlgorithmProvider<OCFPrivateKey> createAlgorithmProviderInt(List<Algorithm<OCFPrivateKey, ?>> listKeyAlgorithms) {
        try {
            return DefaultBaseAlgorithmProviderBuilder.createAlgorithmProvider(listKeyAlgorithms);
        }
        catch (Exception e) {
            LOG.debug((Object)e);
            return null;
        }
    }

    protected static AlgorithmProvider<OCFPrivateKey> createDefaultECAlgorithmProviderSignature(List<UsageRelated.Usage> usages) {
        ArrayList listKeyAlgorithms01 = new ArrayList();
        EHBAg2Service.addECSignatureAuthenticationAlgorithms(usages, listKeyAlgorithms01);
        return EHBAg2Service.createAlgorithmProviderInt(listKeyAlgorithms01);
    }

    private static void addECSignatureAuthenticationAlgorithms(List<UsageRelated.Usage> usageAlgorithms, List<Algorithm<OCFPrivateKey, ?>> listAlgorithms) {
        try {
            String hashAlgorithm = DEFAULT_HASH_ALGORITHM;
            String algorithmID = ALGORITHM_ID_SIGN_ECDSA;
            String providerName = "OCF";
            String[] separators = new String[]{"with", "hashedWith"};
            String[] formats = new String[]{"ECDSA", "CVC-ECDSA"};
            for (String separator : separators) {
                for (String format : formats) {
                    String sigAutAlgorithmName;
                    String sigAutAlternativeAlgorithmName = sigAutAlgorithmName = hashAlgorithm + separator + format;
                    listAlgorithms.add(new Algorithm("OCF", usageAlgorithms, sigAutAlgorithmName, sigAutAlternativeAlgorithmName, new CardExecutionSignAuthenticateParameterSpec(sigAutAlgorithmName, OCFDefaultAlgorithmFinder.getInstance().find(sigAutAlgorithmName), OCFDefaultAlgorithmFinder.getInstance().findURI(sigAutAlgorithmName), false, HexUtil.parse(algorithmID))));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Card.CardTypeEnum getCardType() {
        return this.cardType;
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo info) {
        if (info == null) {
            return 6;
        }
        return super.getMaxPINLength(info);
    }

    @Override
    public final synchronized void reset() {
        if (!super.isCardPresent()) {
            return;
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel channel = cardChannelManager.init(this);
            channel.sendCommandAPDU(new CommandAPDU(HexString.parseHexString("00 22 f3 01")));
            channel.setState(null);
        }
        catch (Exception e) {
            LOG.debug((Object)("reset failed: " + e.getMessage()));
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    @Override
    public final synchronized GovCS.ResultObject signHash(OCFCertificateInfo info, byte[] hashValue, char[] pin, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        if (OCFProvider.Settings.getInstance().isStapleSignatureEnabled() && this.isStapleSign() || OCFProvider.Settings.getInstance().isServerEnvironmentActive() && this.isMultiSign()) {
            return this.signHashServer(info, hashValue, pin, hashAlgorithm, algorithmParameters);
        }
        return super.signHash(info, hashValue, pin, hashAlgorithm, algorithmParameters);
    }

    @Override
    protected final void adjustForPaddingByte(GovCS.ResultObject ro) {
    }

    @Override
    protected GovCS.ResultObject authentify(CardChannel channel, OCFCertificateInfo info, byte[] hashValue, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws CardTerminalException, ResponseCodeException, OperationCancelledException {
        this.selectForPin(info, channel);
        return super.signHash(channel, info, hashValue, hashAlgorithm, algorithmParameters);
    }

    @Override
    protected CommandAPDU createAuthentifyCommand(byte[] hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[6 + hashValue.length];
        store[0] = 0;
        store[1] = 42;
        store[2] = -122;
        store[3] = -128;
        store[4] = (byte)hashValue.length;
        System.arraycopy(hashValue, 0, store, 5, hashValue.length);
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    @Override
    protected final OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[0];
    }

    @Override
    protected final CommandAPDU createDecryptCommand(byte[] encryptedBytes, byte paddingIndicator, AlgorithmParameters algorithmParameters) {
        int blockSize = 257;
        byte[] store = new byte[7 + blockSize + 2];
        Arrays.fill(store, (byte)-1);
        int i = 0;
        store[i++] = 0;
        store[i++] = 42;
        store[i++] = -128;
        store[i++] = -122;
        store[i++] = 0;
        store[i++] = (byte)(blockSize >> 8 & 0xFF);
        store[i++] = (byte)(blockSize >> 0 & 0xFF);
        store[i++] = this.getPaddingIndicator();
        System.arraycopy(encryptedBytes, 0, store, i, encryptedBytes.length);
        i += encryptedBytes.length;
        int resultLength = 256;
        store[i++] = (byte)(resultLength >> 8 & 0xFF);
        store[i] = (byte)(resultLength & 0xFF);
        return new CommandAPDU(store);
    }

    protected final AlgorithmProvider<OCFPrivateKey> createDefaultAlgorithmProviderAuthentication() {
        List<UsageRelated.Usage> usageList = Arrays.asList(UsageRelated.Usage.AUTHENTICATION);
        ArrayList listKeyAlgorithms01 = new ArrayList();
        try {
            listKeyAlgorithms01.addAll(DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAPKCS1Algorithms(Arrays.asList(DEFAULT_HASH_ALGORITHM), Arrays.asList(Boolean.TRUE), Arrays.asList(ALGORITHM_ID_SIGN_PKCS1_V1_5), usageList));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        return this.createAlgorithmProvider(listKeyAlgorithms01);
    }

    protected final AlgorithmProvider<OCFPrivateKey> createDefaultAlgorithmProviderDecryption() {
        List<UsageRelated.Usage> usageList01 = Arrays.asList(UsageRelated.Usage.CIPHER);
        ArrayList listKeyAlgorithms01 = new ArrayList();
        OCFDefaultAlgorithmFinder finder = OCFDefaultAlgorithmFinder.getInstance();
        try {
            String algorithmRSAOAEPSHA256 = "RSA/NONE/OAEPWithSHA256AndMGF1Padding";
            listKeyAlgorithms01.add(new Algorithm("OCF", usageList01, algorithmRSAOAEPSHA256, "RSA/ECB/OAEP-SHA256", new CardExecutionDecryptRSAParameterSpec(algorithmRSAOAEPSHA256, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSAES_OAEP, (ASN1Encodable)AlgorithmIdentifierHelper.createRSAOAEPByHashAlgorithm(DEFAULT_HASH_ALGORITHM)), finder.findURI(algorithmRSAOAEPSHA256), null, HexUtil.parse(ALGORITHM_ID_RSA_DECIPHER_OAEP))));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        return this.createAlgorithmProvider(listKeyAlgorithms01);
    }

    protected final AlgorithmProvider<OCFPrivateKey> createDefaultAlgorithmProviderSignatureAndOrAuthentication(List<UsageRelated.Usage> usageList) {
        ArrayList listKeyAlgorithms01 = new ArrayList();
        try {
            listKeyAlgorithms01.addAll(DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAPSSAlgorithms(Arrays.asList(DEFAULT_HASH_ALGORITHM), Arrays.asList(Boolean.FALSE), Arrays.asList("05"), usageList));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
        }
        return this.createAlgorithmProvider(listKeyAlgorithms01);
    }

    @Override
    protected CommandAPDU createMSECommand(CardChannel channel, OCFCertificateInfo info, int type, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws CardTerminalException, ResponseCodeException {
        switch (type) {
            case 1: {
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    data.write(-124);
                    data.write(info.getKeyID().getID().length);
                    data.write(info.getKeyID().getID());
                    byte[] algorithm = HexUtil.parse(ALGORITHM_ID_RSA_DECIPHER_OAEP);
                    algorithm = this.adjustDecryptAlgorithm(algorithmParameters, algorithm);
                    data.write(-128);
                    data.write(algorithm.length);
                    data.write(algorithm);
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-72, data.toByteArray());
                }
                catch (IOException ex) {
                    LOG.debug((Object)ex);
                    throw new ResponseCodeException(27270, "MSE failed");
                }
            }
            case 0: 
            case 2: {
                try {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    data.write(-124);
                    data.write(info.getKeyID().getID().length);
                    data.write(info.getKeyID().getID());
                    if (algorithmParameters != null) {
                        byte[] algorithm = new byte[]{5};
                        algorithm = this.adjustSigAutAlgorithm(algorithmParameters, algorithm);
                        data.write(-128);
                        data.write(algorithm.length);
                        data.write(algorithm);
                    }
                    return APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, data.toByteArray());
                }
                catch (IOException ex) {
                    LOG.debug((Object)ex);
                    throw new ResponseCodeException(27270, "MSE failed");
                }
            }
        }
        return null;
    }

    @Override
    protected final GovCS.ResultObject decrypt(CardChannel channel, OCFCertificateInfo info, byte[] encryptedBytes, AlgorithmParameters algorithmParameters) throws CardTerminalException, ResponseCodeException {
        boolean ec = this.isECKey(info.getX509Certificate().getPublicKey().getAlgorithm());
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            os.write(0);
            os.write(42);
            os.write(-128);
            os.write(-122);
            byte[] cryptogram = this.encodeCipherData(ec, encryptedBytes);
            int len = cryptogram.length;
            os.write(0);
            os.write((byte)(len >> 8 & 0xFF));
            os.write((byte)(len >> 0 & 0xFF));
            os.write(cryptogram);
            os.write(1);
            os.write(0);
            cmd = new CommandAPDU(os.toByteArray());
        }
        catch (IOException e) {
            throw new ResponseCodeException(26368, APDUCommands.getLocalizedErrorMessage(26368), e);
        }
        LOG.debug((Object)("DECRYPT CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = channel.sendCommandAPDU(cmd);
        if ((this.ctReference.getName().toLowerCase().contains("omnikey") || this.ctReference.getName().toLowerCase().contains("XX44")) && PCSCCardTerminal.class.isInstance(this.ctReference)) {
            try {
                ((PCSCCardTerminal)this.ctReference).resetSlot(0);
            }
            catch (CardTerminalException e) {
                LOG.debug((Object)("reset of slot failed: " + e.getMessage()));
            }
        }
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString(MSG_RESOURCE_BUNDLE_NO_RESPONSE));
        }
        LOG.debug((Object)("DECRYPT RESULT : " + HexString.hexify(res.getBuffer(), false)));
        if (res.sw() != 36864) {
            throw new ResponseCodeException(res.sw(), APDUCommands.getPerformSecurityOperationErrorMsg(res.sw()));
        }
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(res.sw());
        ro.setResultData(res.data());
        byte[] b = (byte[])ro.getResultData();
        if (ec || b == null || b.length < 3) {
            return ro;
        }
        return this.handleRSAPKCS15(ro, b);
    }

    @Override
    protected int evaluateChangePasswordResultCode(String pinName, Integer retries, int resultcode) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, WrongConfirmedNewPinException, OperationCancelledException {
        if (resultcode != 36864) {
            String errorMessage = APDUCommands.getChangePasswordErrorMsg(resultcode);
            if (25602 == resultcode) {
                throw new WrongConfirmedNewPinException(pinName, resultcode, errorMessage);
            }
            this.handleVerifyChangeError(pinName, resultcode, errorMessage);
        }
        return resultcode;
    }

    @Override
    protected int evaluateVerifyPasswordResultCode(String pinName, Integer retries, int resultcode) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, OperationCancelledException {
        if (36864 != resultcode) {
            String errorMessage = APDUCommands.getVerifyErrorMsg(resultcode);
            this.handleVerifyChangeError(pinName, resultcode, errorMessage);
        }
        return resultcode;
    }

    @Override
    protected byte[] getHistoricals() {
        return new byte[0];
    }

    @Override
    protected final int getMaximumChunkSize() {
        return 240;
    }

    @Override
    protected final String getOSName() {
        return "generic gematik eHBA";
    }

    @Override
    protected byte getPaddingIndicator() {
        return 0;
    }

    protected final ResponseAPDU getPinState(CardChannel cardChannel, OCFCertificateInfo info) throws ResponseCodeException, CardTerminalException {
        this.selectForPin(info, cardChannel);
        CommandAPDU cmd = this.createGetRetryCounterCommand(info.getPinID());
        LOG.debug((Object)("PS CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = cardChannel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString(MSG_RESOURCE_BUNDLE_NO_RESPONSE));
        }
        LOG.debug((Object)("PS RESULT : " + HexString.hexify(res.getBuffer(), false)));
        return res;
    }

    @Override
    protected final int getRetryCount(CardChannel channel, OCFCertificateInfo info) throws RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, ResponseCodeException {
        int errorCode;
        String pinName = EHBAg2Service.getPinNameForInfo(info);
        if (!this.isKeyInitialized(info)) {
            throw new NotYetInitializedException(pinName, 27013, "password not initialized");
        }
        CommandAPDU cmd = this.createGetRetryCounterCommand(info.getPinID());
        LOG.debug((Object)("RC CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString(MSG_RESOURCE_BUNDLE_NO_RESPONSE));
        }
        LOG.debug((Object)("RC RESULT : " + HexString.hexify(res.getBuffer(), false)));
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            LOG.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }

    @Override
    protected boolean historicalsEquals(byte[] historicals) {
        return true;
    }

    protected boolean isECKey(String keyAlgorithm) {
        return "EC".equals(keyAlgorithm) || "ECDSA".equals(keyAlgorithm);
    }

    @Override
    protected final synchronized boolean isKeyInitialized(CardChannel channel, OCFCertificateInfo info) throws ResponseCodeException, CardTerminalException {
        ResponseAPDU res = this.getPinState(channel, info);
        int errorCode = res.sw();
        boolean result = errorCode != 25281 && errorCode != 25287;
        return result;
    }

    @Override
    protected void resetAuthentication(CardChannel channel) {
        try {
            CommandAPDU cmd = new CommandAPDU(HexUtil.parse("00 22 f3 01"));
            LOG.debug((Object)("EHBA RESET CMD : " + HexString.hexify(cmd.getBytes(), false)));
            ResponseAPDU res = channel.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString(MSG_RESOURCE_BUNDLE_NO_RESPONSE));
            }
            LOG.debug((Object)("EHBA RESET RES : " + HexString.hexify(res.getBytes(), false)));
            super.resetAuthentication(channel);
        }
        catch (Exception e) {
            throw new RuntimeException("reset failed: " + e.getMessage(), e);
        }
    }

    protected final void selectForPin(OCFCertificateInfo info, CardChannel cardChannel) throws ResponseCodeException, CardTerminalException {
        if (info.getPinID() == -127) {
            this.selectSubDirectory(cardChannel, info.getPin().getParentApplication().getFileEntry().getDirectory());
        } else {
            this.selectSubDirectory(cardChannel, info.getKey().getParentApplication().getFileEntry().getDirectory());
        }
    }

    @Override
    protected void selectMasterFile(CardChannel channel) throws ResponseCodeException, CardTerminalException {
        if (this.ctReference != null && !this.ctReference.isCardPresent(this.slotID)) {
            return;
        }
        CommandAPDU cmd = this.createSelectMasterFile();
        if (cmd == null) {
            return;
        }
        LOG.debug((Object)(LOG_SELECT_MF_CMD + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString(MSG_RESOURCE_BUNDLE_NO_RESPONSE));
        }
        LOG.debug((Object)(LOG_SELECT_MF_RES + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err != 36864 && err != 25220) {
            cmd = this.createSelectMasterFile1();
            if (cmd == null) {
                return;
            }
            LOG.debug((Object)(LOG_SELECT_MF_CMD + HexString.hexify(cmd.getBuffer(), false)));
            res = channel.sendCommandAPDU(cmd);
            if (res == null) {
                throw new ResponseCodeException(RESOURCES.getString(MSG_RESOURCE_BUNDLE_NO_RESPONSE));
            }
            LOG.debug((Object)(LOG_SELECT_MF_RES + HexString.hexify(res.getBuffer(), false)));
            err = res.sw();
            if (err != 36864 && err != 25220) {
                cmd = this.createSelectMasterFile2();
                if (cmd == null) {
                    return;
                }
                LOG.debug((Object)(LOG_SELECT_MF_CMD + HexString.hexify(cmd.getBuffer(), false)));
                res = channel.sendCommandAPDU(cmd);
                if (res == null) {
                    throw new ResponseCodeException(RESOURCES.getString(MSG_RESOURCE_BUNDLE_NO_RESPONSE));
                }
                LOG.debug((Object)(LOG_SELECT_MF_RES + HexString.hexify(res.getBuffer(), false)));
                err = res.sw();
                if (err != 36864 && err != 25220) {
                    throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final GovCS.ResultObject signHashServerInt(OCFCertificateInfo info, byte[] hashValue, char[] pin, String hashAlgorithm, ProgressSession session, AlgorithmParameters algorithmParameters) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, OperationCancelledException {
        GovCS.ResultObject ro = new GovCS.ResultObject();
        CardChannelManager cardChannelManager = new CardChannelManager();
        boolean externalTransaction = !cardChannelManager.isTransactionLocallyStarted();
        CardChannel channel = null;
        try {
            this.fireProgressEvent(session, "get connection to the device");
            channel = cardChannelManager.init(this);
            this.fireProgressEvent(session, "select application on card");
            if (!this.checkChannelState(channel, info)) {
                this.selectForPin(info, channel);
            }
            boolean loop = true;
            this.fireProgressEvent(session, "install corresponding security environment");
            ro = this.setSecurityEnvironment(channel, info, 0, hashAlgorithm, algorithmParameters);
            if (ro.getResultCode() != 36864) {
                LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                GovCS.ResultObject resultObject = ro;
                return resultObject;
            }
            while (loop) {
                this.fireProgressEvent(session, "sign the given hash value");
                ro = this.signHash(channel, info, hashValue, hashAlgorithm, algorithmParameters);
                if (ro.getResultCode() == 27010) {
                    this.resetChannelState(channel);
                    this.logCheckSignatureCount(channel);
                    this.selectFile(channel, info, false);
                    this.fireProgressEvent(session, "verify the corresponding password");
                    ro.setResultCode(this.verifyPassword(channel, info, pin));
                    if (ro.getResultCode() != 36864) {
                        LOG.debug((Object)APDUCommands.getVerifyErrorMsg(ro.getResultCode()));
                        GovCS.ResultObject resultObject = ro;
                        return resultObject;
                    }
                    if (externalTransaction) {
                        this.setChannelState(channel, info);
                    }
                    this.fireProgressEvent(session, "install corresponding security environment");
                    ro = this.setSecurityEnvironment(channel, info, 0, hashAlgorithm, algorithmParameters);
                    if (ro.getResultCode() != 36864) {
                        LOG.debug((Object)APDUCommands.getManageSecurityEnvironmentErrorMsg(ro.getResultCode()));
                        GovCS.ResultObject resultObject = ro;
                        return resultObject;
                    }
                    loop = true;
                    continue;
                }
                this.fireProgressEvent(session, "operation finished!");
                loop = false;
            }
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (NotYetInitializedException | OperationCancelledException | ResponseCodeException | RetryCounterExpiredException | WrongPinException e) {
            throw e;
        }
        catch (CardTerminalException ex) {
            LOG.debug((Object)"", (Throwable)ex);
            ro.setResultCode(0);
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        catch (Throwable ex) {
            LOG.debug((Object)"", ex);
            ro.setResultCode(0);
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cardChannelManager.destroy();
            if (this.progressSessionListener != null) {
                while (session.getCurrentStep() != session.getStepCount()) {
                    session.increaseCurrentStep();
                }
                session.setProgressMessage("done!");
                this.progressSessionListener.progressSessionWillStop(session);
                this.progressSessionListener.progressSessionStopped(session);
            }
        }
    }

    @Override
    protected final boolean usesASN1HeaderWithSignHash() {
        return false;
    }

    private byte[] adjustDecryptAlgorithm(AlgorithmParameters algorithmParameters, byte[] algorithm) {
        byte[] result = algorithm;
        if (Objects.nonNull(algorithmParameters)) {
            try {
                CardExecutionDecryptRSAParameterSpec parameterSpec = algorithmParameters.getParameterSpec(CardExecutionDecryptRSAParameterSpec.class);
                result = parameterSpec.getAlgorithmID();
            }
            catch (InvalidParameterSpecException e) {
                LOG.debug((Object)e);
            }
        }
        return result;
    }

    private byte[] adjustSigAutAlgorithm(AlgorithmParameters algorithmParameters, byte[] algorithm) {
        byte[] result = algorithm;
        if (Objects.nonNull(algorithmParameters)) {
            try {
                CardExecutionSignAuthenticateParameterSpec parameterSpec = algorithmParameters.getParameterSpec(CardExecutionSignAuthenticateParameterSpec.class);
                result = parameterSpec.getAlgorithmID();
            }
            catch (InvalidParameterSpecException e) {
                LOG.debug((Object)e);
            }
        }
        return result;
    }

    private CommandAPDU createGetRetryCounterCommand(byte pinID) {
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(pinID);
        byte[] cb = cmd.getBytes();
        cb[0] = -128;
        return new CommandAPDU(cb);
    }

    private byte[] encodeCipherData(boolean isEC, byte[] encryptedBytes) throws ResponseCodeException {
        byte[] result = null;
        if (isEC) {
            result = encryptedBytes;
        } else {
            result = new byte[encryptedBytes.length + 1];
            result[0] = this.getPaddingIndicator();
            System.arraycopy(encryptedBytes, 0, result, 1, encryptedBytes.length);
        }
        if (result == null || result.length == 0) {
            throw new ResponseCodeException(26368, APDUCommands.getLocalizedErrorMessage(26368));
        }
        return result;
    }

    private GovCS.ResultObject handleRSAPKCS15(GovCS.ResultObject ro, byte[] b) {
        int i;
        if (b[0] != 0 || b[1] != 2) {
            return ro;
        }
        int count = b.length;
        for (i = 2; i < count && b[i] != 0; ++i) {
        }
        byte[] bb = new byte[b.length - i - 1];
        System.arraycopy(b, i + 1, bb, 0, bb.length);
        ro.setResultData(bb);
        return ro;
    }

    private void handleVerifyChangeError(String pinName, int resultcode, String errorMessage) throws NotYetInitializedException, WrongPinException, RetryCounterExpiredException, OperationCancelledException {
        if (25601 == resultcode) {
            throw new PinInputCancelledException(pinName, resultcode, errorMessage);
        }
        if (27013 == resultcode || 25281 == resultcode || 25287 == resultcode) {
            throw new NotYetInitializedException(pinName, resultcode, errorMessage);
        }
        if (25603 == resultcode) {
            throw new PinInputTooShortException(pinName, resultcode, errorMessage);
        }
        if (25604 == resultcode) {
            throw new PinInputTooLongException(pinName, resultcode, errorMessage);
        }
        if (25600 == resultcode) {
            throw new PinInputTimeoutException(pinName, resultcode, errorMessage);
        }
        if (25344 == resultcode || 25536 == (resultcode & 0xFFF0) && (resultcode & 0xF) > 0) {
            throw new WrongPinException(pinName, resultcode, APDUCommands.getChangePasswordErrorMsg(resultcode));
        }
        if (27011 == resultcode || 25536 == (resultcode & 0xFFF0) && (resultcode & 0xF) == 0) {
            throw new RetryCounterExpiredException(pinName, resultcode, errorMessage);
        }
        throw new OperationCancelledException(pinName, resultcode, "card operation failed");
    }

    private void logCheckSignatureCount(CardChannel channel) {
        try {
            this.checkSignCounter(channel, false);
        }
        catch (MaxSignatureCountReachedException e) {
            LOG.debug((Object)"maximum of signatures reached - never happens in server mode and method");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized GovCS.ResultObject signHashServer(OCFCertificateInfo info, byte[] hashValue, char[] pin, String hashAlgorithm, AlgorithmParameters algorithmParameters) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, OperationCancelledException {
        if (this.getAvailableHashAlgorithmNames(info).indexOf(hashAlgorithm) < 0) {
            throw new ResponseCodeException(65535, "hash algorithm not supported by card: " + hashAlgorithm, new NoSuchAlgorithmException("OperationCancelledException"));
        }
        ProgressSession session = new ProgressSession(2);
        session.setStepCount(6);
        session.setProgressMessage("init sign hash operation");
        if (this.progressSessionListener != null) {
            this.progressSessionListener.progressSessionWillStart(session);
            this.progressSessionListener.progressSessionStarted(session);
        }
        CardChannelManager cm = new CardChannelManager();
        try {
            cm.init(this, true, false);
            boolean localTransaction = cm.isTransactionLocallyStarted();
            try {
                this.checkSignCounter(null, localTransaction);
            }
            catch (MaxSignatureCountReachedException e) {
                cm.allocate();
                this.resetCard(cm.getCardChannel());
                throw e;
            }
            GovCS.ResultObject ro = this.signHashServerInt(info, hashValue, pin, hashAlgorithm, session, algorithmParameters);
            if (ro.getResultCode() == 36864) {
                try {
                    this.increaseAndCheckSignCounter(null, localTransaction);
                }
                catch (MaxSignatureCountReachedException e) {
                    cm.allocate();
                    this.resetCard(cm.getCardChannel());
                }
            }
            GovCS.ResultObject resultObject = ro;
            return resultObject;
        }
        finally {
            cm.destroy();
        }
    }
}

