/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.gematik;

import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDU;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.gematik.EHBAg2Service;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.util.Collections;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EHBAg2
extends EHBAg2Service {
    private static final String AID_HPA = "D27600014602";
    private static final String DF_QES_FID_EF_SSEC = "D005";
    private static final byte PINID_CH = 1;
    private static final String NAME_QES_SIGNATURE_KEY_RSA = "QESRSASignatureKey";
    private static final String NAME_QES_SIGNATURE_KEY_EC = "QESECSignatureKey";
    private static final byte PINID_QES1 = -127;
    private static final String AID_EA = "a000000167455349474e";
    private static final Integer INIT_LENGTH = 5;
    private static final Log LOG = LogFactory.getLog(EHBAg2.class);
    protected String displayName;
    protected boolean stapleSign;
    protected boolean multiSign;
    private final boolean issuerReadRequired;
    protected static final String ISSUER_CONSTANT_EHBA = "eHBA";
    protected Integer stapleSignCounter = 1;

    public EHBAg2() {
        this(ISSUER_CONSTANT_EHBA, true);
    }

    protected EHBAg2(String displayName, boolean issuerReadRequired) {
        super(Card.CardTypeEnum.EHBA_G2);
        this.displayName = displayName;
        this.issuerReadRequired = issuerReadRequired;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final boolean isMultiSign() {
        return this.multiSign;
    }

    @Override
    public boolean isStapleSign() {
        return this.stapleSign || GovCS.isStapleSign(this);
    }

    @Override
    protected final boolean isIssuerReadRequired() {
        return this.issuerReadRequired;
    }

    @Override
    protected String getIssuerConstant() {
        return ISSUER_CONSTANT_EHBA;
    }

    @Override
    protected void initialize(CardServiceScheduler scheduler, SmartCard smartcard, boolean blocking) throws CardServiceException {
        super.initialize(scheduler, smartcard, blocking);
        CardChannel cardChannel = null;
        try {
            cardChannel = scheduler.allocateCardChannel(this, false);
            int sigs = this.evaluateSignatureCount(cardChannel);
            if (sigs > 1) {
                LOG.info((Object)"staple supported");
                this.stapleSign = true;
                this.stapleSignCounter = sigs;
            } else {
                this.stapleSign = false;
                this.stapleSignCounter = 1;
            }
            scheduler.releaseCardChannel(cardChannel);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected final String readIssuerFromATR(CardChannel channel) {
        String readIssuerFromATR = "";
        try {
            ResponseAPDU r = channel.sendCommandAPDU(new GISOCommandAPDU((Byte)0, (Byte)-92, (Byte)4, (Byte)12, HexUtil.parse(AID_HPA)));
            if (r.sw() != 36864) {
                return null;
            }
            int sigs = this.evaluateSignatureCount(channel);
            if (sigs > 1) {
                LOG.info((Object)"staple supported");
            }
            readIssuerFromATR = ISSUER_CONSTANT_EHBA;
        }
        catch (Exception e) {
            LOG.debug((Object)("failed to read card informations: " + e.getMessage()), (Throwable)e);
        }
        LOG.debug((Object)("card identification: " + readIssuerFromATR));
        return readIssuerFromATR;
    }

    private int evaluateSignatureCount(CardChannel channel) throws IOException {
        ResponseAPDU r = channel.sendCommandAPDU(new GISOCommandAPDU((Byte)0, (Byte)-92, (Byte)4, (Byte)12, HexUtil.parse("D2 76 00 00 66 01")));
        if (r.sw() != 36864) {
            return 1;
        }
        r = channel.sendCommandAPDU(new GISOCommandAPDU((Byte)0, (Byte)-92, (Byte)2, (Byte)12, HexUtil.parse(DF_QES_FID_EF_SSEC)));
        if (r.sw() != 36864) {
            return 1;
        }
        int sigs = 1;
        byte[] ssecBytes = this.readFileBytesFromCard(channel, DF_QES_FID_EF_SSEC);
        ASN1 asn1SSEC = new ASN1(ssecBytes);
        int l = asn1SSEC.getChildElementCount();
        for (int i = 0; i < l; i += 2) {
            ASN1 child = asn1SSEC.getChildElements()[i];
            if (child.getDTag().intValue() != -128 || child.getValue().length != 1 || child.getValue()[0] != 1 || (child = asn1SSEC.getChildElements()[i + 1]).getDTag().intValue() != -92 || child.getChildElementCount() != 4) continue;
            sigs = (child = child.getChildElements()[3]).getValue()[0] < 0 ? 256 + child.getValue()[0] : child.getValue()[0];
        }
        LOG.info((Object)("signatures supported: " + sigs));
        return sigs;
    }

    @Override
    public final Integer getStapleSignCounter() {
        return this.stapleSignCounter;
    }

    @Override
    protected final Card createCardInt(Terminal pTerminal, int pSlotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        long idOfPinCH = 2000001L;
        byte pinID = 1;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardPinImpl pinCH = new CardPinImpl(Disposeable.NO_LOCK, "PIN.CH", idOfPinCH, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000001L});
        CardApplication applicationQES = this.createQESApp(pTerminal, pSlotID, idOfCard, idOfMFApplication);
        CardApplication applicationESIGN = this.createESignApp(pTerminal, pSlotID, idOfCard, idOfMFApplication, idOfPinCH);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationQES);
        mfManager.putApplication(applicationESIGN);
        mfManager.putPin(pinCH);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.MF.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        return new CardImpl(this.getDisplayName() + "-" + idOfCard, idOfCard, this.cardType.getType(), super.getCard(), mfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance());
    }

    private CardApplication createESignApp(Terminal pTerminal, int pSlotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        String aid = AID_EA;
        long idOfApplication = 1000002L;
        long idOfFile01 = 3000003L;
        long idOfFile02 = 3000004L;
        long idOfFile03 = 3000005L;
        long idOfFile04 = 3000006L;
        long idOfKey01 = 4000003L;
        long idOfKey02 = 4000004L;
        long idOfKey03 = 4000005L;
        long idOfKey04 = 4000006L;
        KeyID k01 = new KeyID("82");
        KeyID k02 = new KeyID("83");
        KeyID k03 = new KeyID("86");
        KeyID k04 = new KeyID("85");
        FileReference dirRefApp = new FileReference(4, aid);
        FileReference cerRef01 = new FileReference(2, "c500");
        FileReference cerRef02 = new FileReference(2, "c200");
        FileReference cerRef03 = new FileReference(2, "c506");
        FileReference cerRef04 = new FileReference(2, "c205");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02);
        FileEntry fileEntry03 = new FileEntry(dirRefApp, cerRef03);
        FileEntry fileEntry04 = new FileEntry(dirRefApp, cerRef04);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info03 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile03, idOfKey03, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info04 = new OCFCertificateInfo(idOfCard, idOfPinCH, idOfFile04, idOfKey04, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerAutRSA", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerEncRSA", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "cerAutEC", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey03);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "cerEncEC", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey04);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKeyRSA", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ADVANCED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType()}), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPinCH, k01);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "DecryptionKeyRSA", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DECRYPTION.getType()}), fileEntry02, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info02, idOfFile02, idOfPinCH, k02);
        CardKeyImpl key03 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationKeyEC", idOfKey03, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.ADVANCED_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType()}), fileEntry03, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info03, idOfFile03, idOfPinCH, k03);
        CardKeyImpl key04 = new CardKeyImpl(Disposeable.NO_LOCK, "DecryptionKeyEC", idOfKey04, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType()}), fileEntry04, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info04, idOfFile04, idOfPinCH, k04);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider01 = this.createDefaultAlgorithmProviderSignatureAndOrAuthentication(Collections.singletonList(UsageRelated.Usage.AUTHENTICATION));
        key01.setAlgorithmProvider(algorithmProvider01);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider02 = this.createDefaultAlgorithmProviderDecryption();
        key02.setAlgorithmProvider(algorithmProvider02);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider03 = EHBAg2.createDefaultECAlgorithmProviderSignature(Collections.singletonList(UsageRelated.Usage.AUTHENTICATION));
        key03.setAlgorithmProvider(algorithmProvider03);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl(aid, idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType()}), fileEntry03, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putFile(file03);
        applicationApp.putFile(file04);
        applicationApp.putKey(key01);
        applicationApp.putKey(key02);
        applicationApp.putKey(key03);
        applicationApp.putKey(key04);
        return applicationApp;
    }

    private CardApplication createQESApp(Terminal pTerminal, int pSlotID, long idOfCard, long idOfMFApplication) {
        String aid = "d27600006601";
        long idOfApplication = 1000001L;
        long idOfPin01 = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfKey01 = 4000001L;
        long idOfKey02 = 4000002L;
        KeyID k01 = new KeyID("84");
        KeyID k02 = new KeyID("86");
        byte pinID01 = -127;
        FileReference dirRefApp = new FileReference(4, aid);
        FileReference cerRef01rsa = new FileReference(2, "c000");
        FileReference cerRef02ec = new FileReference(2, "c006");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01rsa);
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02ec);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, OCFCertificateInfo.Usage.SIG, new long[0]);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, OCFCertificateInfo.Usage.SIG, new long[0]);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, new long[]{idOfKey01, idOfKey02});
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerQESrsa", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerQESec", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, NAME_QES_SIGNATURE_KEY_RSA, idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info01, new long[]{idOfFile01}, new long[0], new long[]{idOfPin01}, k01);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, NAME_QES_SIGNATURE_KEY_EC, idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType()}), fileEntry02, idOfCard, idOfApplication, pTerminal.getID(), pSlotID, this, CardObjectRegistryImpl.getInstance(), info02, new long[]{idOfFile02}, new long[0], new long[]{idOfPin01}, k02);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider01 = this.createDefaultAlgorithmProviderSignatureAndOrAuthentication(Collections.singletonList(UsageRelated.Usage.SIGNATURE));
        key01.setAlgorithmProvider(algorithmProvider01);
        AlgorithmProvider<OCFPrivateKey> algorithmProvider02 = EHBAg2.createDefaultECAlgorithmProviderSignature(Collections.singletonList(UsageRelated.Usage.SIGNATURE));
        key02.setAlgorithmProvider(algorithmProvider02);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl(aid, idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, pTerminal.getID(), pSlotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putPin(pin01);
        applicationApp.putFile(file01);
        applicationApp.putFile(file02);
        applicationApp.putKey(key01);
        applicationApp.putKey(key02);
        return applicationApp;
    }

    @Override
    public final Integer getMaxPINLengthInit(OCFCertificateInfo info) {
        return INIT_LENGTH;
    }

    @Override
    public final Integer getMinPINLengthInit(OCFCertificateInfo info) {
        return INIT_LENGTH;
    }

    @Override
    public final int getPasswordBlockLength(OCFCertificateInfo info) {
        return 8;
    }

    @Override
    protected byte[] getPaddedPIN(OCFCertificateInfo info, char[] pin) {
        return this.getPinEncoder(info).encode(pin);
    }

    @Override
    public final PinEncoder getPinEncoder(OCFCertificateInfo info) {
        return PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK;
    }

    @Override
    public final byte getPasswordBlockFiller(OCFCertificateInfo info) {
        return -1;
    }

    @Override
    public final int getMinPINLength(OCFCertificateInfo info) {
        return 6;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo info) {
        return Collections.singletonList("SHA256");
    }

    @Override
    protected boolean usesASN1HeaderWithAuthentify() {
        return false;
    }

    @Override
    protected CommandAPDU createAuthentifyCommand(byte[] hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[6 + hashValue.length];
        store[0] = 0;
        store[1] = -120;
        store[2] = 0;
        store[3] = 0;
        store[4] = (byte)hashValue.length;
        System.arraycopy(hashValue, 0, store, 5, hashValue.length);
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }
}

