/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.eu.it.infocert;

import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.PinInformationProvider;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InfoCert
extends GovCS
implements PinInformationProvider {
    private static final Log log = LogFactory.getLog(InfoCert.class);
    static String ISSUER_CONSTANT = "InfoCert";
    private static final byte[][] HISTORICALS = new byte[][]{HexString.parseHexString("00 6b 02 09 03 03 01 11 01 43 4e 53 11 31 80")};
    private static final String DF_FID = "1100";
    private static String CERT_FID = "1101";

    @Override
    protected boolean isIssuerReadRequired() {
        return true;
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000001L;
        long idOfPin01 = 2000001L;
        long idOfFile01 = 3000001L;
        long idOfKey01 = 4000001L;
        byte gpinID01 = 16;
        KeyID k01 = new KeyID("01");
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        FileReference fileRef01 = new FileReference(0, CERT_FID);
        FileEntry fileEntry01 = new FileEntry(dirRefMF, fileRef01);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "fileFID0004sigCer", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfMFApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "SignaturePIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), gpinID01, idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType()}), fileEntry01, idOfCard, idOfMFApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin01, k01);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        mfApplication.put(file01);
        mfApplication.put(pin01);
        mfApplication.put(key01);
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, Card.CardTypeEnum.INFOCERT.getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    @Override
    protected OCFCertificateInfo[] createCertificateInfos() {
        ArrayList result = new ArrayList();
        return result.toArray(new OCFCertificateInfo[result.size()]);
    }

    @Override
    protected final CommandAPDU createSignHashCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        return null;
    }

    @Override
    public byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        return 0;
    }

    @Override
    protected CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        CommandAPDU cmd = new CommandAPDU(HexUtil.parse("0022f303"));
        log.debug((Object)("MSE RESET (CMD): " + cmd));
        ResponseAPDU resp = _channel.sendCommandAPDU(cmd);
        log.debug((Object)("MSE RESET (RESP): " + resp));
        return new CommandAPDU(HexString.parseHexString("00 22 f1 b8 03 83 01 " + HexString.hexify(_info.getKeyID().getID())));
    }

    @Override
    protected GovCS.ResultObject authentify(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        GovCS.ResultObject aut = super.authentify(_channel, _info, _hashValue, _hashAlgorithm, algorithmParameters);
        return aut;
    }

    @Override
    protected byte[] getHistoricals() {
        return null;
    }

    @Override
    public void authentifyAdjust(GovCS.ResultObject ro, AlgorithmParameters algorithmParameters) {
    }

    @Override
    protected String getIssuerConstant() {
        return ISSUER_CONSTANT;
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        return ISSUER_CONSTANT;
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        return Arrays.equals(HISTORICALS[0], _historicals);
    }

    @Override
    protected byte getPaddingIndicator() {
        return 0;
    }

    @Override
    public String getDisplayName() {
        return "InfoCert (?)";
    }

    @Override
    protected String getOSName() {
        return "(GPK 1.0)";
    }

    @Override
    public int getPasswordBlockLength(OCFCertificateInfo _info) {
        return -1;
    }

    @Override
    protected boolean usesASN1HeaderWithSignHash() {
        return true;
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    public int getMinPINLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    protected void selectFile(CardChannel _channel, FileEntry entry, boolean file) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        super.selectFile(_channel, entry, file);
    }

    @Override
    protected void selectFile(CardChannel _channel, FileReference _file) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        if (CERT_FID.equals(HexUtil.hexify(_file.reference))) {
            cmd = APDUCommands.createSelectCommand(0, 0, HexUtil.parse(DF_FID), 0);
            log.debug((Object)("SELECT SUB FILE CMD (INIT CARD): " + HexString.hexify(cmd.getBuffer(), false)));
            res = _channel.sendCommandAPDU(cmd);
        }
        cmd = APDUCommands.createSelectCommand(0, 0, _file.reference, 0);
        log.debug((Object)("SELECT SUB FILE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
    }

    @Override
    protected GovCS.ResultObject readSelectedFile(CardChannel _channel, int _offset, int _length) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (_length == 2048) {
            CommandAPDU cmd = null;
            ResponseAPDU res = null;
            byte[] readBytes = null;
            int chunkSize = this.getMaximumChunkSize();
            int offset = _offset;
            boolean ignoreErrorCode = false;
            int err = 36864;
            try {
                ByteArrayOutputStream baos;
                block10: {
                    baos = new ByteArrayOutputStream();
                    do {
                        if ((res = _channel.sendCommandAPDU(cmd = this.createReadBinaryCommand(offset, chunkSize))) == null) {
                            throw new ResponseCodeException(RESOURCES.getString("no_response"));
                        }
                        err = res.sw();
                        if (err != 36864) {
                            if (err == 27270) {
                                ignoreErrorCode = true;
                                break block10;
                            }
                            if (err != 27392 && err != 25218) break block10;
                        }
                        if (res.data() != null && res.data().length > 0) {
                            baos.write(res.data());
                            if (ByteUtil.indexOf(res.data(), new byte[16]) >= 0) break block10;
                        }
                        offset += chunkSize;
                        if (baos == null) break block10;
                        chunkSize = this.getMaximumChunkSize();
                    } while (err != 25218 && err != 27392);
                    log.debug((Object)"precisely when it means to ...");
                    ignoreErrorCode = true;
                }
                log.debug((Object)ignoreErrorCode);
                baos.flush();
                baos.close();
                readBytes = baos.toByteArray();
            }
            catch (IOException baos) {
                // empty catch block
            }
            GovCS.ResultObject ro = new GovCS.ResultObject();
            try {
                ro.setResultData(new ASN1(readBytes).getEncoded());
            }
            catch (IOException e) {
                ro.setResultData(readBytes);
            }
            ro.setResultCode(36864);
            return ro;
        }
        return super.readSelectedFile(_channel, _offset, _length);
    }

    @Override
    protected void selectMasterFile(CardChannel _channel) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        _channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("00a40000023f0000")));
    }

    @Override
    protected void selectSubDirectory(CardChannel _channel, FileReference _directory) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        CommandAPDU cmd = APDUCommands.createSelectCommand(0, 0, _directory.reference, 0);
        log.debug((Object)("SELECT SUB DIR CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
    }

    @Override
    public boolean isStapleSign() {
        return false;
    }

    @Override
    public boolean isMultiSign() {
        return false;
    }

    @Override
    protected final CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(HexUtil.parse("00:2a:80:86:81:00:00:01:".replaceAll(Pattern.quote(":"), " ")));
            baos.write(HexUtil.parse("ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff".substring((_hashValue.length + 1) * 3).replaceAll(Pattern.quote(":"), " ")));
            baos.write(0);
            baos.write(_hashValue);
            baos.write(-127);
            baos.flush();
            baos.close();
            CommandAPDU cmd = new CommandAPDU(baos.toByteArray());
            return cmd;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected boolean usesASN1HeaderWithAuthentify() {
        return true;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA1");
            c.add("SHA224");
            c.add("SHA384");
            c.add("SHA512");
            c.add("WHIRLPOOL");
            c.add("SHA256");
        }
        return c;
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(_info.getPinID());
        log.debug((Object)("FBZ CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("FBZ RES : " + HexString.hexify(res.getBuffer(), false)));
        return res.sw() & 0xF;
    }
}

