/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.eu.fr.certinomis;

import de.bos_bremen.basecard.impl.CommandImpl;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1Util;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.PinInformationProvider;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import de.bos_bremen.opencard.terminal.bcs.AbstractOCFBCSTerminal;
import de.bos_bremen.opencard.terminal.bcs.OCFBCSClass3Terminal;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Certinomis
extends GovCS
implements PinInformationProvider {
    private static final Log log = LogFactory.getLog(Certinomis.class);
    static String ISSUER_CONSTANT = "Certinomis";
    private static final byte[][] HISTORICALS = new byte[][]{HexString.parseHexString("80 31 80 65 b0 83 02 04 7e 83 00 90 00")};

    @Override
    protected boolean isIssuerReadRequired() {
        return true;
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000001L;
        long idOfApplication1 = 1000002L;
        FileReference dirRefMF = new FileReference(8, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardApplication application1 = this.createApp1Sig(terminal, slotID, idOfCard, idOfMFApplication, idOfApplication1);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(application1);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, Card.CardTypeEnum.CERTINOMIS.getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createApp1Sig(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfApplication1) {
        long idOfFile04 = 3000004L;
        long idOfPin01 = 2000001L;
        long idOfKey01 = 4000001L;
        byte pinID01 = -127;
        KeyID k01 = new KeyID("06");
        FileReference dirRef1 = new FileReference(8, "a0000000180c000001634200");
        FileReference fileRef01 = new FileReference(8, "1600");
        FileEntry fileEntry01 = new FileEntry(dirRef1, fileRef01);
        FileReference fileRef04 = new FileReference(8, "50005040");
        FileEntry fileEntry04 = new FileEntry(dirRef1, fileRef04);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile04, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "fileFID0004sigCer", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication1, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "SignaturePIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry04, idOfCard, idOfApplication1, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType()}), fileEntry04, idOfCard, idOfApplication1, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile04, idOfPin01, k01);
        CardObjectManagerImpl manager1 = new CardObjectManagerImpl(idOfApplication1);
        CardApplicationImpl application1 = new CardApplicationImpl("a0000000180c000001634200", idOfApplication1, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)manager1, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        application1.putFile(file04);
        application1.putPin(pin01);
        application1.putKey(key01);
        return application1;
    }

    @Override
    protected OCFCertificateInfo[] createCertificateInfos() {
        ArrayList result = new ArrayList();
        return result.toArray(new OCFCertificateInfo[result.size()]);
    }

    @Override
    protected final CommandAPDU createSignHashCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        CardChannelManager cm = new CardChannelManager();
        cm.destroy();
        byte[] store = new byte[6 + (_hashValue == null ? 0 : 1 + _hashValue.length)];
        store[0] = 0;
        store[1] = 42;
        store[2] = -112;
        store[3] = -96;
        store[4] = (byte)(_hashValue.length + 2);
        store[5] = -112;
        if (_hashValue != null) {
            store[6] = (byte)_hashValue.length;
            System.arraycopy(_hashValue, 0, store, 7, _hashValue.length);
        }
        return new CommandAPDU(store);
    }

    @Override
    public byte getPasswordBlockFiller(OCFCertificateInfo _info) {
        return 0;
    }

    @Override
    protected CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        if (_hashAlgorithm.equals("SHA256")) {
            return new CommandAPDU(HexString.parseHexString("00 22 41 " + HexString.hexify(-74) + " 06 80 01 42 84 01 " + HexString.hexify(_info.getKeyID().getID())));
        }
        return new CommandAPDU(HexString.parseHexString("00 22 41 " + HexString.hexify(-74) + " 06 80 01 12 84 01 " + HexString.hexify(_info.getKeyID().getID())));
    }

    @Override
    protected byte[] getHistoricals() {
        return null;
    }

    @Override
    protected String getIssuerConstant() {
        return ISSUER_CONSTANT;
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        return ISSUER_CONSTANT;
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        return Arrays.equals(HISTORICALS[0], _historicals);
    }

    @Override
    protected byte getPaddingIndicator() {
        return 0;
    }

    @Override
    public String getDisplayName() {
        return "Certinomis (?)";
    }

    @Override
    protected String getOSName() {
        return "(GPK 1.0)";
    }

    @Override
    public int getPasswordBlockLength(OCFCertificateInfo _info) {
        return 16;
    }

    @Override
    protected boolean usesASN1HeaderWithSignHash() {
        return false;
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        return 6;
    }

    @Override
    public int getMinPINLength(OCFCertificateInfo _info) {
        return 6;
    }

    @Override
    protected void selectFile(CardChannel _channel, FileEntry entry, boolean file) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        super.selectFile(_channel, entry, file);
    }

    @Override
    protected void selectFile(CardChannel _channel, FileReference _file) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        CommandAPDU cmd = APDUCommands.createSelectCommand(8, 12, _file.reference, 1024);
        log.debug((Object)("SELECT SUB FILE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
    }

    @Override
    protected GovCS.ResultObject readSelectedFile(CardChannel _channel, int _offset, int _length) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (_length == 2048) {
            CommandAPDU cmd = null;
            ResponseAPDU res = null;
            byte[] readBytes = null;
            int chunkSize = this.getMaximumChunkSize();
            int offset = _offset;
            boolean ignoreErrorCode = false;
            int err = 36864;
            try {
                ByteArrayOutputStream baos;
                block11: {
                    baos = new ByteArrayOutputStream();
                    do {
                        if ((res = _channel.sendCommandAPDU(cmd = this.createReadBinaryCommand(offset, chunkSize))) == null) {
                            throw new ResponseCodeException(RESOURCES.getString("no_response"));
                        }
                        err = res.sw();
                        if (err != 36864) {
                            if (err == 27270) {
                                ignoreErrorCode = true;
                                break block11;
                            }
                            if (err != 27392 && err != 25218) break block11;
                        }
                        if (res.data() != null && res.data().length > 0) {
                            baos.write(res.data());
                            if (ByteUtil.indexOf(res.data(), new byte[16]) >= 0) break block11;
                        }
                        offset += chunkSize;
                        if (baos == null) break block11;
                        chunkSize = this.getMaximumChunkSize();
                    } while (err != 25218 && err != 27392);
                    log.debug((Object)"precisely when it means to ...");
                    ignoreErrorCode = true;
                }
                baos.flush();
                baos.close();
                readBytes = baos.toByteArray();
            }
            catch (IOException baos) {
                // empty catch block
            }
            log.debug((Object)ignoreErrorCode);
            GovCS.ResultObject ro = new GovCS.ResultObject();
            ro.setResultData(readBytes);
            ro.setResultCode(36864);
            GovCS.ResultObject xo = Certinomis.findCertificate(res, readBytes, ignoreErrorCode, true);
            if (xo != null) {
                try {
                    Certificate c = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream((byte[])xo.getResultData()));
                    MessageDigest messageDigest = MessageDigest.getInstance("SHA1", "BC");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return xo;
            }
            return ro;
        }
        return super.readSelectedFile(_channel, _offset, _length);
    }

    @Override
    protected boolean useKeyboard() {
        return !OCFBCSClass3Terminal.class.isInstance(this.ctReference);
    }

    @Override
    protected void selectMasterFile(CardChannel _channel) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
    }

    @Override
    protected void selectSubDirectory(CardChannel _channel, FileReference _directory) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        CommandAPDU cmd = APDUCommands.createSelectCommand(4, 0, _directory.reference, 1024);
        log.debug((Object)("SELECT SUB DIR CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("SELECT SUB DIR RES : " + HexString.hexify(res.getBuffer(), false)));
    }

    @Override
    public boolean isStapleSign() {
        return false;
    }

    @Override
    public boolean isMultiSign() {
        return false;
    }

    @Override
    protected final CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[6 + _hashValue.length];
        store[0] = 0;
        store[1] = 42;
        store[2] = -98;
        store[3] = -102;
        store[4] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, store, 5, _hashValue.length);
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA1");
        }
        return c;
    }

    public static GovCS.ResultObject findCertificate(ResponseAPDU res, byte[] readBytes, boolean ignoreErrorCode, boolean repudiation) {
        ArrayList<Integer> certPositionOffsetList = new ArrayList<Integer>();
        byte[] search = HexUtil.parse("3082");
        int boffset = 0;
        int index = 0;
        while ((index = ByteUtil.indexOf(readBytes, search, boffset)) >= 0) {
            certPositionOffsetList.add(index);
            boffset = index + 1;
        }
        log.debug((Object)("certPositionOffsetList-Count: " + certPositionOffsetList.size()));
        GovCS.ResultObject ro = new GovCS.ResultObject();
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (Integer certPositionOffset : certPositionOffsetList) {
                X509Certificate x509;
                ByteArrayInputStream bis = new ByteArrayInputStream(readBytes);
                bis.skip(certPositionOffset.intValue());
                int l = ASN1Util.getLength(bis).intValue() + 4;
                log.debug((Object)("l: " + l));
                byte[] c = ByteUtil.subbytes(readBytes, certPositionOffset, certPositionOffset + l);
                Certificate cert = null;
                try {
                    cert = cf.generateCertificate(new ByteArrayInputStream(c));
                    log.debug((Object)"Cert: found");
                }
                catch (Exception e) {
                    continue;
                }
                if (!X509Certificate.class.isInstance(cert) || (x509 = (X509Certificate)X509Certificate.class.cast(cert)).getKeyUsage()[1] != repudiation) continue;
                ro.setResultCode(ignoreErrorCode ? 36864 : res.sw());
                ro.setResultData(c);
                break;
            }
        }
        catch (Exception e) {
            log.fatal((Object)e);
        }
        return ro;
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(_info.getPinID());
        log.debug((Object)("FBZ CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("FBZ RES : " + HexString.hexify(res.getBuffer(), false)));
        return res.sw() & 0xF;
    }

    @Override
    protected final GovCS.ResultObject signHash(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        cmd = this.createSignHashCommand(_hashValue, algorithmParameters);
        if (AbstractOCFBCSTerminal.class.isInstance(this.ctReference)) {
            AbstractOCFBCSTerminal aobt = (AbstractOCFBCSTerminal)AbstractOCFBCSTerminal.class.cast(this.ctReference);
            log.debug((Object)("PUT HASH CMD : " + HexString.hexify(cmd.getBuffer(), false)));
            try {
                res = new ResponseAPDU(aobt.getBCSTerminal().sendCardCommand(CardObjectRegistryImpl.getInstance().getCard(this.smartcard).getSlotID() + 1, new CommandImpl(cmd.getBytes()), 32).getRaw());
                log.debug((Object)("PUT HASH RES : " + HexString.hexify(res.getBuffer(), false)));
            }
            catch (Exception exception) {}
        } else {
            log.debug((Object)("PUT HASH CMD : " + HexString.hexify(cmd.getBuffer(), false)));
            res = _channel.sendCommandAPDU(cmd);
            log.debug((Object)("PUT HASH RES : " + HexString.hexify(res.getBuffer(), false)));
            log.debug((Object)("GET RESPONSE CMD : " + HexString.hexify(new byte[]{0, -64, 0, 0, 20}, false)));
            res = _channel.sendCommandAPDU(new CommandAPDU(new byte[]{0, -64, 0, 0, 20}));
            log.debug((Object)("GET RESPONSE RES : " + HexString.hexify(res.getBuffer(), false)));
        }
        cmd = new CommandAPDU(HexUtil.parse("002a9e9a00"));
        log.debug((Object)("SIGN HASH CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        log.debug((Object)("SIGN HASH RES : " + HexString.hexify(res.getBuffer(), false)));
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(res.sw());
        ro.setResultData(res.data());
        return ro;
    }
}

