/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.eu.fi;

import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FinEID21
extends GovCS {
    private static final Log log = LogFactory.getLog(FinEID21.class);
    private static final byte[] HISTORICALS = HexString.parseHexString("806211515646696e454944");

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long ifOfMFApplication = 1000001L;
        long idOfApplication = 1000002L;
        long idOfKey01 = 4000001L;
        long idOfFile01 = 3000001L;
        long idOfPin01 = 2000001L;
        long idOfKey02 = 4000002L;
        long idOfFile02 = 3000002L;
        long idOfPin02 = 2000002L;
        KeyID k01 = new KeyID("01");
        KeyID k02 = new KeyID("02");
        byte pinID01 = -127;
        byte pinID02 = -126;
        FileReference dirRef = new FileReference(4, "a000000063504b43532d3135");
        FileReference cerRef01 = new FileReference(0, "4331");
        FileEntry fileEntry01 = new FileEntry(dirRef, cerRef01);
        FileReference cerRef02 = new FileReference(0, "4332");
        FileEntry fileEntry02 = new FileEntry(dirRef, cerRef02);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPin02, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerFID4331", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "AuthenticationDecryptionKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_DECRYPTION.getType(), CardKey.CardKeyTypeEnum.DEFAULT_AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.DECRYPTION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION.getType(), CardKey.CardKeyTypeEnum.AUTHENTICATION_BY_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin01, k01);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "cerFID4332", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardPinImpl pin02 = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin02, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID02, idOfKey02);
        CardKeyImpl key02 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType()}), fileEntry02, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info02, idOfFile02, idOfPin02, k02);
        CardObjectManagerImpl manager = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl application = new CardApplicationImpl("a000000063504b43532d3135", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType(), CardApplication.CardApplicationTypeEnum.DECRYPTION.getType(), CardApplication.CardApplicationTypeEnum.AUTHENTICATION.getType(), CardApplication.CardApplicationTypeEnum.ENCRYPTION.getType()}), fileEntry01, (CardObjectManager)manager, idOfCard, ifOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        application.putFile(file02);
        application.putPin(pin02);
        application.putKey(key02);
        application.putFile(file01);
        application.putPin(pin01);
        application.putKey(key01);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", ifOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), null, (CardObjectManager)application, idOfCard, ifOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, Card.CardTypeEnum.FINEID_21.getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    @Override
    protected OCFCertificateInfo[] createCertificateInfos() {
        ArrayList<OCFCertificateInfo> result = new ArrayList<OCFCertificateInfo>();
        result.add(new OCFCertificateInfo(new FileReference(4, "a000000063504b43532d3135"), new FileReference(0, "4332"), new KeyID("02"), -126, OCFCertificateInfo.ChainEntry.USER));
        result.add(new OCFCertificateInfo(new FileReference(4, "a000000063504b43532d3135"), new FileReference(0, "4331"), new KeyID("01"), -127, OCFCertificateInfo.ChainEntry.USER));
        return result.toArray(new OCFCertificateInfo[result.size()]);
    }

    @Override
    protected CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        CommandAPDU cmd = null;
        ResponseAPDU res = null;
        cmd = new CommandAPDU(HexString.parseHexString("0022f300"));
        log.debug((Object)("RESET MSE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("RESET MSE RES : " + HexString.hexify(res.getBuffer(), false)));
        return new CommandAPDU(HexString.parseHexString("00 22 41 " + HexString.hexify(_type == 0 ? -74 : -72) + " 07 80 01 " + HexString.hexify(2 + (_type == 0 ? 16 : 0)) + " 81 02 4b " + HexString.hexify(_info.getKeyID().getID())));
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS;
    }

    @Override
    protected String getIssuerConstant() {
        return "46 T7 69 6E 45 49 44";
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        return "46 T7 69 6E 45 49 44";
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        return Arrays.equals(this.getHistoricals(), _historicals);
    }

    @Override
    protected byte getPaddingIndicator() {
        return 0;
    }

    @Override
    protected CommandAPDU createSelectMasterFile() {
        return null;
    }

    @Override
    protected void selectSubDirectory(CardChannel _channel, FileReference _directory) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
    }

    @Override
    protected void selectFile(CardChannel _channel, FileReference _file) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        CommandAPDU cmd = new CommandAPDU(HexString.parseHexString("00a404000ca000000063504b43532d313500"));
        log.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("RES : " + HexString.hexify(res.getBuffer(), false)));
        cmd = new CommandAPDU(HexString.parseHexString("00a4080002501600"));
        log.debug((Object)("CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("RES : " + HexString.hexify(res.getBuffer(), false)));
        cmd = APDUCommands.createSelectCommand(_file.referenceType, 0, _file.reference, 0);
        log.debug((Object)("SELECT FILE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("SELECT FILE RES : " + HexString.hexify(res.getBuffer(), false)));
        int err = res.sw();
        if (err != 36864) {
            throw new ResponseCodeException(err, APDUCommands.getSelectErrorMsg(err));
        }
    }

    @Override
    public int getPasswordBlockLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        return this.getPasswordBlockLength(_info);
    }

    @Override
    protected boolean usesASN1HeaderWithSignHash() {
        return false;
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        int errorCode;
        String pinName = FinEID21.getPinNameForInfo(_info);
        this.selectFile(_channel, _info.getFile());
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(_info.getPinID());
        log.debug((Object)("RC CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("RC RESULT : " + HexString.hexify(res.getBuffer(), false)));
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            log.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 27013) {
            throw new NotYetInitializedException(pinName, errorCode, message);
        }
        if (errorCode == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }

    @Override
    protected final CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[6 + _hashValue.length];
        store[0] = 0;
        store[1] = 42;
        store[2] = -98;
        store[3] = -102;
        store[4] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, store, 5, _hashValue.length);
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA1");
        }
        return c;
    }
}

