/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.eu.at;

import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.DigestInfo;
import de.bos_bremen.common.asn1.HashAlgorithm;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ATrustV2Card
extends GovCS {
    private static final Log log = LogFactory.getLog(ATrustV2Card.class);
    private static final byte[] HISTORICALS = HexUtil.parse("455041000000000000000000000000");

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        long idOfPin = 2000001L;
        byte pinID = 1;
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000003L});
        CardApplication applicationSign = this.createSignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardApplication applicationAuth = this.createAuthApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationSign);
        mfManager.putApplication(applicationAuth);
        mfManager.putPin(pin);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, Card.CardTypeEnum.ATRUST.getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createSignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfPin = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID("01");
        byte pinID = -127;
        FileReference dirRefApp = new FileReference(4, "a0000001184543");
        FileReference cerRef01 = new FileReference(0, "c002");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig1", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey01});
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin, k01);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("signApp", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putPin(pin);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    private CardApplication createAuthApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication02 = 1000002L;
        long idOfPin02 = 2000003L;
        long idOfFile02 = 3000002L;
        long idOfKey02 = 4000002L;
        KeyID k02 = new KeyID("00");
        byte pinID = -127;
        FileReference dirRefApp = new FileReference(4, "a000000118454e");
        FileReference cerRef02 = new FileReference(0, "c001");
        FileEntry fileEntry02 = new FileEntry(dirRefApp, cerRef02);
        OCFCertificateInfo info02 = new OCFCertificateInfo(idOfCard, idOfPin02, idOfFile02, idOfKey02, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig2", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication02, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey02);
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Authentisierungs-PIN", idOfPin02, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry02, idOfCard, idOfApplication02, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey02});
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey2", idOfKey02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry02, idOfCard, idOfApplication02, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info02, idOfFile02, idOfPin02, k02);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication02);
        CardApplicationImpl applicationApp = new CardApplicationImpl("signApp2", idOfApplication02, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry02, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putPin(pin);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    @Override
    protected OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[]{new OCFCertificateInfo(new FileReference(4, "a0000001184543"), new FileReference(0, "c002"), new KeyID("01"), -127, OCFCertificateInfo.ChainEntry.USER), new OCFCertificateInfo(new FileReference(4, "a000000118454e"), new FileReference(0, "c001"), new KeyID("00"), -127, OCFCertificateInfo.ChainEntry.USER)};
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS;
    }

    @Override
    protected String getIssuerConstant() {
        return null;
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return -1;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        List<String> c = null;
        c = _info.getUsage() == OCFCertificateInfo.Usage.AEN ? Arrays.asList("SHA1", "RIPEMD160", "SHA224", "SHA384", "SHA512", "SHA256") : (this.areBetterAlgorithmsSupported(_info) ? Arrays.asList("SHA1", "SHA224", "SHA256") : Arrays.asList("SHA1", "SHA224"));
        return c;
    }

    private synchronized boolean areBetterAlgorithmsSupported(OCFCertificateInfo _info) {
        X509Certificate x509Certificate = _info.getX509Certificate();
        if (x509Certificate == null) {
            return false;
        }
        boolean result = true;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "SUN");
            Certificate sunCertificate = cf.generateCertificate(new ByteArrayInputStream(x509Certificate.getEncoded()));
            PublicKey publicKey = sunCertificate.getPublicKey();
            if (ECPublicKey.class.isInstance(publicKey)) {
                result = ((ECPublicKey)ECPublicKey.class.cast(publicKey)).getParams().getOrder().bitLength() > 192;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        return Arrays.equals(this.getHistoricals(), _historicals);
    }

    @Override
    public int getPasswordBlockLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        return this.getPasswordBlockLength(_info);
    }

    @Override
    protected final GovCS.ResultObject signHash(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException, OperationCancelledException {
        String hexString = "8401888001" + (_hashAlgorithm == "SHA1" ? "14" : (_hashAlgorithm == "SHA256" ? "44" : (_hashAlgorithm == "SHA224" ? "34" : "")));
        CommandAPDU cmd = APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-74, HexUtil.parse(hexString));
        log.debug((Object)("MSE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("MSE RES  : " + HexString.hexify(res.getBuffer(), false)));
        byte[] buffer = new byte[5 + _hashValue.length];
        buffer[0] = 0;
        buffer[1] = 42;
        buffer[2] = -112;
        buffer[3] = _info.getPinID();
        buffer[4] = (byte)_hashValue.length;
        System.arraycopy(_hashValue, 0, buffer, 5, _hashValue.length);
        cmd = new CommandAPDU(buffer);
        log.debug((Object)("PUT HASH CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("PUT HASH RES  : " + HexString.hexify(res.getBuffer(), false)));
        return super.signHash(_channel, _info, null, _hashAlgorithm, algorithmParameters);
    }

    @Override
    public int getMinPINLength(OCFCertificateInfo _info) {
        return 4;
    }

    @Override
    protected GovCS.ResultObject authentify(CardChannel _channel, OCFCertificateInfo _info, byte[] _hashValue, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, ResponseCodeException, CardTerminalException, ResponseCodeException {
        CommandAPDU cmd = APDUCommands.createManageSecurityEnvironmentCommand((byte)65, (byte)-92, HexUtil.parse("840188800101"));
        ResponseAPDU res = null;
        log.debug((Object)("MSE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("MSE RES : " + HexString.hexify(res.getBuffer(), false)));
        try {
            _hashValue = new DigestInfo(HashAlgorithm.Algorithm.getAlgorithmByName(_hashAlgorithm), _hashValue).getEncoded();
            log.debug((Object)("pkcs#1=" + HexString.hexify(_hashValue)));
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
        }
        try {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            data.write(0);
            data.write(-120);
            data.write(16);
            data.write(_info.getKeyID().getID());
            data.write(_hashValue.length);
            data.write(_hashValue);
            data.write(0);
            data.flush();
            data.close();
            cmd = new CommandAPDU(data.toByteArray());
        }
        catch (IOException data) {
            // empty catch block
        }
        log.debug((Object)("INT AUTH CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("INT AUTH RES : " + HexString.hexify(res.getBuffer(), false)));
        GovCS.ResultObject ro = new GovCS.ResultObject();
        ro.setResultCode(res.sw());
        ro.setResultData(res.data());
        return ro;
    }

    @Override
    public String getDisplayName() {
        return "ATrust (206)";
    }

    @Override
    protected int getMaximumChunkSize() {
        return 240;
    }

    @Override
    protected CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return null;
    }
}

