/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch;

import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.PinDeactivatedException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SuisseID
extends GovCS {
    private static final Log log = LogFactory.getLog(SuisseID.class);
    private boolean serverEnvironment = OCFProvider.Settings.getInstance().isServerEnvironmentActive();
    private Boolean multiSign = null;
    private Boolean asn1HeaderWithAuthentify = false;
    private Boolean asn1HeaderWithSignHash = true;

    public SuisseID(Boolean multiSign, Boolean asn1HeaderWithSignHash, Boolean asn1HeaderWithAuthentify) {
        this.multiSign = multiSign;
        this.asn1HeaderWithSignHash = asn1HeaderWithSignHash;
        this.asn1HeaderWithAuthentify = asn1HeaderWithAuthentify;
    }

    @Override
    public final boolean isMultiSign() {
        if (this.multiSign == null) {
            return this.serverEnvironment;
        }
        return this.multiSign;
    }

    @Override
    public OCFCertificateInfo[] getAllCertificates() {
        try {
            OCFCertificateInfo[] oCFCertificateInfoArray = super.getAllCertificates();
            return oCFCertificateInfoArray;
        }
        finally {
            this.allocateCardChannel();
            CardChannel channel = this.getCardChannel();
            this.getChannelState(channel).setInfo(null);
            this.releaseCardChannel();
        }
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        return Arrays.asList("SHA1", "RIPEMD160", "SHA384", "SHA512", "SHA256");
    }

    public boolean existsFile(CardChannel channel, String fileID) {
        boolean result = false;
        try {
            CommandAPDU c = new CommandAPDU(HexUtil.parse("00a4080c0650154304" + fileID));
            ResponseAPDU r = channel.sendCommandAPDU(c);
            result = r.sw() == 36864;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean existsApplication(CardChannel channel, String p1, String aid) {
        boolean result = false;
        try {
            CommandAPDU c = new CommandAPDU(HexUtil.parse("00a4" + p1 + "0c" + HexUtil.hexify(aid.length() / 2) + aid));
            ResponseAPDU r = channel.sendCommandAPDU(c);
            result = r.sw() == 36864;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected final boolean isIssuerReadRequired() {
        return true;
    }

    @Override
    public synchronized boolean isKeyInitialized(OCFCertificateInfo _info) throws ResponseCodeException, CardTerminalException {
        if (this.serverEnvironment && (this.multiSign == null || this.multiSign.booleanValue())) {
            return true;
        }
        return super.isKeyInitialized(_info);
    }

    @Override
    public synchronized int getRetryCount(CardPin _pin) throws NotYetInitializedException, RetryCounterExpiredException, PinDeactivatedException {
        if (this.serverEnvironment && (this.multiSign == null || this.multiSign.booleanValue())) {
            return -1;
        }
        return super.getRetryCount(_pin);
    }

    @Override
    public synchronized int getRetryCount(OCFCertificateInfo _info) throws NotYetInitializedException, RetryCounterExpiredException, PinDeactivatedException {
        if (this.serverEnvironment && (this.multiSign == null || this.multiSign.booleanValue())) {
            return -1;
        }
        return super.getRetryCount(_info);
    }

    @Override
    protected int getRetryCount(CardChannel _channel, CardPin pin) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException, PinDeactivatedException {
        if (this.serverEnvironment && (this.multiSign == null || this.multiSign.booleanValue())) {
            return -1;
        }
        return pin != null && pin.getInfos() != null && pin.getInfos().length >= 1 ? this.getRetryCount(_channel, pin.getInfos()[0]) : -1;
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        int errorCode;
        if (this.serverEnvironment && (this.multiSign == null || this.multiSign.booleanValue())) {
            return -1;
        }
        String pinName = SuisseID.getPinNameForInfo(_info);
        CommandAPDU cmd = APDUCommands.createGetRetryCounterCommand(_info.getPinID());
        log.debug((Object)("RC CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
        log.debug((Object)("RC RESULT : " + HexString.hexify(res.getBuffer(), false)));
        String message = APDUCommands.getVerifyErrorMsg(res.sw());
        if ((res.sw() & 0xFFF0) != 25536) {
            log.debug((Object)("RC RESULT : " + message));
        }
        if ((errorCode = res.sw()) == 27013) {
            throw new NotYetInitializedException(pinName, errorCode, message);
        }
        if (errorCode == 27011) {
            throw new RetryCounterExpiredException(pinName, errorCode, message);
        }
        if (errorCode != 36864 && (errorCode & 0xFFF0) == 25536) {
            int retryCounter = errorCode - 25536;
            if (retryCounter == 0) {
                throw new RetryCounterExpiredException(pinName, errorCode, message);
            }
            return retryCounter;
        }
        return -1;
    }

    @Override
    protected synchronized boolean isKeyInitialized(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        if (this.serverEnvironment && (this.multiSign == null || this.multiSign.booleanValue())) {
            return true;
        }
        return super.isKeyInitialized(_channel, _info);
    }

    @Override
    protected final boolean usesASN1HeaderWithAuthentify() {
        if (this.asn1HeaderWithAuthentify == null) {
            return super.usesASN1HeaderWithAuthentify();
        }
        return this.asn1HeaderWithAuthentify;
    }

    @Override
    protected final boolean usesASN1HeaderWithSignHash() {
        if (this.asn1HeaderWithSignHash == null) {
            return super.usesASN1HeaderWithSignHash();
        }
        return this.asn1HeaderWithSignHash;
    }

    @Override
    protected final String getOSName() {
        return "CardOS 4.3b";
    }
}

