/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch;

import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;

public class QuoVadisToken
extends GovCS {
    private static final byte[] HISTORICALS = HexUtil.parse("80 73 c8 21 10");
    private static final String ISSUER_CONSTANT = "SuisseID - QuoVadis Token";
    private static final String TOKEN_INFO_CONTENT = "QuoVadis SuisseID";

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        long idOfPin = 2000001L;
        byte pinID = 1;
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Authentisierungs-/Verschl\u00fcsselungs-PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntryMF, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000003L});
        CardApplication applicationSIGN = this.createSignApp(terminal, slotID, idOfCard, idOfMFApplication, idOfPin);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationSIGN);
        mfManager.putPin(pin);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, Card.CardTypeEnum.QUOVADIS_TOKEN.getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createSignApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfPinCH) {
        long idOfApplication = 1000001L;
        long idOfPin = 2000002L;
        long idOfFile01 = 3000001L;
        long idOfKey01 = 4000001L;
        KeyID k01 = new KeyID("02");
        byte pinID = -127;
        FileReference dirRefApp = new FileReference(4, "d27600006601");
        FileReference cerRef01 = new FileReference(8, "501543044302");
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig1", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardPinImpl pin = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{idOfKey01});
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin, k01);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("signApp", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putPin(pin);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    @Override
    protected OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[]{new OCFCertificateInfo(new FileReference(8, "3f00"), new FileReference(8, "501543044305"), new KeyID("01"), 1, OCFCertificateInfo.ChainEntry.USER)};
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return null;
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS;
    }

    @Override
    protected String getIssuerConstant() {
        return ISSUER_CONSTANT;
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return -1;
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        return Arrays.asList("SHA1", "RIPEMD160", "SHA382", "SHA512", "SHA256");
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        return Arrays.equals(this.getHistoricals(), _historicals);
    }

    @Override
    public boolean isIssuerReadRequired() {
        return true;
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        String issuer = null;
        try {
            System.out.println(HexUtil.hexify(ByteUtil.setBits((byte)-62, (byte)49)));
            System.out.println(HexUtil.hexify(ByteUtil.setBits((byte)-62, (byte)18)));
            System.out.println(HexUtil.hexify(ByteUtil.setBits((byte)-62, (byte)38)));
            System.out.println(HexUtil.hexify(ByteUtil.xorBits((byte)-62, (byte)49)));
            System.out.println(HexUtil.hexify(ByteUtil.xorBits((byte)-62, (byte)18)));
            System.out.println(HexUtil.hexify(ByteUtil.xorBits((byte)-62, (byte)38)));
            System.out.println(_channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("00 a4 04 00 07 a0 00 00 03 12 02 02 00"))));
            System.out.println(_channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("00 a4 08 04 04 66 66 50 00 00"))));
            System.out.println(_channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("80 17 00 00 08"))));
            System.out.println(_channel.sendCommandAPDU(new CommandAPDU(HexUtil.parse("00 a4 08 04 08 66 66 50 00 02 20 30 01 00"))));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(HexUtil.parse("80 0c 03 31 00 01 04 10 ff 01 00 00 01"));
            byte[] dg = HexUtil.parse("30 21 30 09 06 05 2b 0e 03 02 1a 05 00 04 14 62 bf 15 19 08 74 04 9b b8 d3 d4 68 dc ba c9 34 8f 5d a1 c6");
            System.out.println((dg.length + 3) * 3);
            baos.write(HexUtil.parse("ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:ff:".substring((dg.length + 3) * 3).replaceAll(Pattern.quote(":"), " ")));
            baos.write(0);
            baos.write(dg);
            baos.write(HexUtil.parse("00 00"));
            baos.flush();
            baos.close();
            CommandAPDU cmd = new CommandAPDU(baos.toByteArray());
            System.out.println(_channel.sendCommandAPDU(cmd));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        issuer = super.readIssuerFromATR(_channel);
        if (issuer != null) {
            String pkcs15TokenInfo = super.readPKCS15TokenInfoFromCard(_channel);
            if (pkcs15TokenInfo != null && pkcs15TokenInfo.indexOf(TOKEN_INFO_CONTENT) >= 0) {
                issuer = ISSUER_CONSTANT;
            }
        } else if (issuer == null && _channel.getCardTerminal().getName().contains("Aladdin Token JC")) {
            issuer = ISSUER_CONSTANT;
        }
        return issuer;
    }

    @Override
    public String getDisplayName() {
        return "QuoVadis Token (208)";
    }

    @Override
    protected String getOSName() {
        return "JavaCard";
    }
}

