/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch;

import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.CardChannelManager;
import de.bos_bremen.gov2.jca_provider.ocf.cards.ChannelState;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.foreign.ch.SuisseID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.security.AlgorithmParameters;
import java.util.Arrays;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiSignBTCQuoVadis
extends SuisseID {
    protected static final Log LOG = LogFactory.getLog(MultiSignBTCQuoVadis.class);
    private static final byte[] HISTORICALS = HexUtil.parse("c8 0d");
    private static final String ISSUER_CONSTANT = "BTC - QuoVadis";
    private static final String SIG_CERT_FID = "501543044301";

    public MultiSignBTCQuoVadis() {
        super(true, null, null);
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000000L;
        FileReference dirRefMF = new FileReference(0, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardApplication applicationSIGN = this.createDecAutApp(terminal, slotID, idOfCard, idOfMFApplication);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(applicationSIGN);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, Card.CardTypeEnum.QUOVADIS_BTC.getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createDecAutApp(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication) {
        long idOfApplication = 1000001L;
        long idOfFile01 = 3000001L;
        long idOfKey01 = 4000001L;
        long idOfPin01 = 2000002L;
        byte pinID = -127;
        KeyID k01 = new KeyID("01");
        FileReference dirRefApp = new FileReference(8, "501550724B01");
        FileReference cerRef01 = new FileReference(8, SIG_CERT_FID);
        FileEntry fileEntry01 = new FileEntry(dirRefApp, cerRef01);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile01, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "cerSig1", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "Signatur-PIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID, new long[]{4000001L});
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType()}), fileEntry01, idOfCard, idOfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile01, idOfPin01, k01);
        CardObjectManagerImpl managerApp = new CardObjectManagerImpl(idOfApplication);
        CardApplicationImpl applicationApp = new CardApplicationImpl("signApp", idOfApplication, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)managerApp, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        applicationApp.putFile(file01);
        applicationApp.putPin(pin01);
        applicationApp.putKey(key01);
        return applicationApp;
    }

    @Override
    protected OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[]{new OCFCertificateInfo(new FileReference(8, "3f00"), new FileReference(8, SIG_CERT_FID), new KeyID("02"), 1, OCFCertificateInfo.ChainEntry.USER)};
    }

    @Override
    protected CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        byte[] keyID = _info.getKeyID().getID();
        byte[] data = new byte[2 + keyID.length];
        data[0] = -125;
        data[1] = (byte)keyID.length;
        System.arraycopy(keyID, 0, data, 2, keyID.length);
        return APDUCommands.createManageSecurityEnvironmentCommand((byte)1, (byte)-74, data);
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS;
    }

    @Override
    protected String getIssuerConstant() {
        return ISSUER_CONSTANT;
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        return Arrays.equals(this.getHistoricals(), _historicals);
    }

    @Override
    public synchronized boolean isKeyInitialized(OCFCertificateInfo _info) throws ResponseCodeException, CardTerminalException {
        return true;
    }

    @Override
    public final synchronized int getRetryCount(CardPin _pin) throws NotYetInitializedException, RetryCounterExpiredException {
        return -1;
    }

    @Override
    public final synchronized int getRetryCount(OCFCertificateInfo _info) throws NotYetInitializedException, RetryCounterExpiredException {
        return -1;
    }

    @Override
    protected synchronized boolean isInitialized(CardChannel _channel, CardPin _pin) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        return true;
    }

    @Override
    protected synchronized boolean isKeyInitialized(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, ResponseCodeException, CardTerminalException, InvalidCardChannelException {
        return true;
    }

    @Override
    protected final int getRetryCount(CardChannel _channel, CardPin pin) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return -1;
    }

    @Override
    protected final int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        try {
            this.forceSelectMF(_channel);
            String issuer = "";
            String pkcs15TokenInfo = super.readPKCS15TokenInfoFromCard(_channel);
            if (pkcs15TokenInfo != null) {
                issuer = ISSUER_CONSTANT;
            }
            String string = issuer;
            return string;
        }
        finally {
            this.forceSelectMF(_channel);
        }
    }

    private void forceSelectMF(CardChannel _channel) {
        try {
            super.selectMasterFile(_channel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getDisplayName() {
        return "MultiSign EIDV - BTC";
    }

    @Override
    public void reset() {
        if (!super.isCardPresent()) {
            return;
        }
        CardChannelManager cardChannelManager = new CardChannelManager();
        try {
            CardChannel cardChannel = cardChannelManager.init(this);
            this.resetInt(cardChannel);
        }
        finally {
            cardChannelManager.destroy();
        }
    }

    private void resetInt(CardChannel channel) {
        super.resetChannelState(channel);
        this.resetCard(channel);
    }

    @Override
    protected void resetCard(CardChannel channel) {
        try {
            LOG.debug((Object)"reset of card");
            this.selectMasterFile(channel);
            CommandAPDU c = new CommandAPDU(HexUtil.parse("80ea0000"));
            LOG.debug((Object)("RESET CMD: " + HexUtil.hexify(c.getBytes())));
            ResponseAPDU r = channel.sendCommandAPDU(c);
            LOG.debug((Object)("RESET RSP: " + HexUtil.hexify(r.getBytes())));
            LOG.debug((Object)"reset of card finished");
            ChannelState channelState = this.getChannelState(channel);
            if (channelState != null) {
                channelState.resetCurrentSignCount();
            }
        }
        catch (Throwable t) {
            LOG.debug((Object)("reset of card failed: " + t.getMessage()), t);
        }
    }
}

