/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epo;

import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epo.EPO;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epo.EPOVersionAnalyzer;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardApplicationImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardKeyImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectManagerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardPinImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OLDEPO
extends GovCS {
    private static final Log log = LogFactory.getLog(OLDEPO.class);
    static String ISSUER_CONSTANT = "European Patent Office";
    private static final byte[] HISTORICALS = HexString.parseHexString("8065a209010352");

    @Override
    protected boolean isIssuerReadRequired() {
        return true;
    }

    @Override
    protected Card createCardInt(Terminal terminal, int slotID) {
        long idOfCard = CARD_OBJECT_REGISTRY.createNewCardID();
        long idOfMFApplication = 1000001L;
        long idOfApplication2 = 1000003L;
        long idOfApplication1 = 1000002L;
        FileReference dirRefMF = new FileReference(8, "3f00");
        FileEntry fileEntryMF = new FileEntry(dirRefMF, dirRefMF);
        CardApplication application1 = this.createApp1Sig(terminal, slotID, idOfCard, idOfMFApplication, idOfApplication1);
        CardApplication application2 = this.createApp2(terminal, slotID, idOfCard, idOfMFApplication, idOfApplication2);
        CardObjectManagerImpl mfManager = new CardObjectManagerImpl(idOfMFApplication);
        mfManager.putApplication(application1);
        CardApplicationImpl mfApplication = new CardApplicationImpl("MF", idOfMFApplication, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), fileEntryMF, (CardObjectManager)mfManager, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        CardImpl card = new CardImpl(this.getDisplayName() + "-" + String.valueOf(idOfCard), idOfCard, Card.CardTypeEnum.EPO.getType(), super.getCard(), mfApplication, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance());
        return card;
    }

    private CardApplication createApp1Sig(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfApplication1) {
        long idOfFile01 = 3000001L;
        long idOfFile02 = 3000002L;
        long idOfFile03 = 3000003L;
        long idOfFile04 = 3000004L;
        long idOfFile05 = 3000005L;
        long idOfPin01 = 2000001L;
        long idOfKey01 = 4000001L;
        byte pinID01 = 0;
        KeyID k01 = new KeyID("07");
        FileReference dirRef1 = new FileReference(8, "a0000000180f00000163000104");
        FileReference fileRef01 = new FileReference(8, "1600");
        FileEntry fileEntry01 = new FileEntry(dirRef1, fileRef01);
        FileReference fileRef02 = new FileReference(8, "0002");
        FileEntry fileEntry02 = new FileEntry(dirRef1, fileRef02);
        FileReference fileRef03 = new FileReference(8, "0003");
        FileEntry fileEntry03 = new FileEntry(dirRef1, fileRef03);
        FileReference fileRef04 = new FileReference(8, "0004");
        FileEntry fileEntry04 = new FileEntry(dirRef1, fileRef04);
        FileReference fileRef05 = new FileReference(8, "0005");
        FileEntry fileEntry05 = new FileEntry(dirRef1, fileRef05);
        OCFCertificateInfo info01 = new OCFCertificateInfo(idOfCard, idOfPin01, idOfFile04, idOfKey01, OCFCertificateInfo.ChainEntry.USER, null, null);
        CardFileImpl file01 = new CardFileImpl(Disposeable.NO_LOCK, "fileFID1600", idOfFile01, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry01, idOfCard, idOfApplication1, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L);
        CardFileImpl file02 = new CardFileImpl(Disposeable.NO_LOCK, "fileFID0002", idOfFile02, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry02, idOfCard, idOfApplication1, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L);
        CardFileImpl file03 = new CardFileImpl(Disposeable.NO_LOCK, "fileFID0003", idOfFile03, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry03, idOfCard, idOfApplication1, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L);
        CardFileImpl file04 = new CardFileImpl(Disposeable.NO_LOCK, "fileFID0004sigCer", idOfFile04, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry04, idOfCard, idOfApplication1, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), idOfKey01);
        CardFileImpl file05 = new CardFileImpl(Disposeable.NO_LOCK, "fileFID0005", idOfFile05, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry05, idOfCard, idOfApplication1, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L);
        CardPinImpl pin01 = new CardPinImpl(Disposeable.NO_LOCK, "SignaturePIN", idOfPin01, CardPin.CardPinTypeEnum.PIN.getType(), fileEntry04, idOfCard, idOfApplication1, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance(), pinID01, idOfKey01);
        CardKeyImpl key01 = new CardKeyImpl(Disposeable.NO_LOCK, "SignatureKey", idOfKey01, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardKey.CardKeyTypeEnum.DEFAULT_SIGNATURE.getType(), CardKey.CardKeyTypeEnum.SIGNATURE.getType(), CardKey.CardKeyTypeEnum.QUALIFIED_SIGNATURE.getType()}), fileEntry04, idOfCard, idOfApplication1, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), info01, idOfFile04, idOfPin01, k01);
        CardObjectManagerImpl manager1 = new CardObjectManagerImpl(idOfApplication1);
        CardApplicationImpl application1 = new CardApplicationImpl("a0000000180f00000163000104", idOfApplication1, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[]{CardApplication.CardApplicationTypeEnum.SIGNATURE.getType()}), fileEntry01, (CardObjectManager)manager1, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        application1.putFile(file01);
        application1.putFile(file02);
        application1.putFile(file03);
        application1.putFile(file04);
        application1.putFile(file05);
        application1.putPin(pin01);
        application1.putKey(key01);
        return application1;
    }

    private CardApplication createApp2(Terminal terminal, int slotID, long idOfCard, long idOfMFApplication, long idOfApplication2) {
        long idOfFile06 = 3000006L;
        long idOfFile07 = 3000007L;
        FileReference dirRef2 = new FileReference(8, "a000000018434d");
        FileReference fileRef06 = new FileReference(8, "9f7f");
        FileEntry fileEntry06 = new FileEntry(dirRef2, fileRef06);
        FileReference fileRef07 = new FileReference(8, "0101");
        FileEntry fileEntry07 = new FileEntry(dirRef2, fileRef07);
        CardFileImpl file06 = new CardFileImpl(Disposeable.NO_LOCK, "fileFID9f7f", idOfFile06, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry06, idOfCard, idOfApplication2, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L);
        CardFileImpl file07 = new CardFileImpl(Disposeable.NO_LOCK, "fileFID0101", idOfFile07, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), fileEntry07, idOfCard, idOfApplication2, terminal.getID(), slotID, this, CardObjectRegistryImpl.getInstance(), -1L);
        CardObjectManagerImpl manager2 = new CardObjectManagerImpl(idOfApplication2);
        CardApplicationImpl application2 = new CardApplicationImpl("a000000018434d", idOfApplication2, TypedType.TypedTypeEnum.BIT.combineTypes(new Type[0]), fileEntry06, (CardObjectManager)manager2, idOfCard, idOfMFApplication, terminal.getID(), slotID, (GovCS)this, (CardRegistry)CardObjectRegistryImpl.getInstance());
        application2.put(file06);
        application2.put(file07);
        return application2;
    }

    @Override
    protected OCFCertificateInfo[] createCertificateInfos() {
        return new OCFCertificateInfo[0];
    }

    @Override
    protected final CommandAPDU createSignHashCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        byte[] store = new byte[5 + (_hashValue == null ? 0 : 1 + _hashValue.length)];
        store[0] = -128;
        store[1] = -22;
        store[2] = 0;
        store[3] = 0;
        if (_hashValue != null) {
            store[4] = (byte)_hashValue.length;
            _hashValue = ByteUtil.flip(_hashValue);
            System.arraycopy(_hashValue, 0, store, 5, _hashValue.length);
        }
        store[store.length - 1] = 0;
        return new CommandAPDU(store);
    }

    @Override
    protected final CommandAPDU createMSECommand(CardChannel _channel, OCFCertificateInfo _info, int _type, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        CommandAPDU cmd = new CommandAPDU(HexString.parseHexString("00 a4 02 00 02 00 02"));
        log.debug((Object)("select for sign: " + HexUtil.hexify(cmd.getBuffer())));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        log.debug((Object)("select response for sign: " + HexUtil.hexify(res.getBuffer())));
        return new CommandAPDU(HexString.parseHexString("80 a6 " + HexUtil.hexify(_info.getKeyID().getID()) + " 12 00"));
    }

    @Override
    protected byte[] getHistoricals() {
        return HISTORICALS;
    }

    @Override
    protected String getIssuerConstant() {
        return ISSUER_CONSTANT;
    }

    @Override
    protected String readIssuerFromATR(CardChannel _channel) {
        log.debug((Object)("EPO version: " + EPOVersionAnalyzer.getVersion(_channel)));
        return ISSUER_CONSTANT;
    }

    @Override
    protected boolean historicalsEquals(byte[] _historicals) {
        return Arrays.equals(this.getHistoricals(), _historicals);
    }

    @Override
    protected byte getPaddingIndicator() {
        return 0;
    }

    @Override
    public String getDisplayName() {
        return "OLDEPO";
    }

    @Override
    protected String getOSName() {
        return "(GPK 1.0)";
    }

    @Override
    public int getPasswordBlockLength(OCFCertificateInfo _info) {
        return 8;
    }

    @Override
    public int getMaxPINLength(OCFCertificateInfo _info) {
        return this.getPasswordBlockLength(_info);
    }

    @Override
    protected boolean usesASN1HeaderWithSignHash() {
        return false;
    }

    @Override
    protected int getRetryCount(CardChannel _channel, OCFCertificateInfo _info) throws RetryCounterExpiredException, NotYetInitializedException, InvalidCardChannelException, CardTerminalException, ResponseCodeException {
        return -1;
    }

    @Override
    protected void selectFile(CardChannel _channel, FileEntry entry, boolean file) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        super.selectFile(_channel, entry, file);
    }

    @Override
    protected void selectFile(CardChannel _channel, FileReference _file) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        CommandAPDU cmd = APDUCommands.createSelectCommand(2, 12, _file.reference, 1024);
        log.debug((Object)("SELECT FILE CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
    }

    @Override
    protected int getMaximumChunkSize() {
        return 248;
    }

    @Override
    protected GovCS.ResultObject readSelectedFile(CardChannel _channel, int _offset, int _length) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        if (_length == 2048) {
            CommandAPDU cmd = null;
            ResponseAPDU res = null;
            byte[] readBytes = null;
            boolean ignoreErrorCode = false;
            int chunkSize = this.getMaximumChunkSize();
            int offset = 0;
            readBytes = null;
            ignoreErrorCode = false;
            int err = 36864;
            try {
                ByteArrayOutputStream baos;
                block8: {
                    baos = new ByteArrayOutputStream();
                    do {
                        cmd = this.createReadBinaryCommand(offset, chunkSize);
                        log.debug((Object)("READ BINARY CMD : " + HexString.hexify(cmd.getBuffer(), false)));
                        res = _channel.sendCommandAPDU(cmd);
                        log.debug((Object)("READ BINARY RESPONSE: " + HexString.hexify(res.getBuffer(), false)));
                        if (res == null) {
                            throw new ResponseCodeException(RESOURCES.getString("no_response"));
                        }
                        err = res.sw();
                        if (err != 36864) {
                            if (err == 27270) {
                                ignoreErrorCode = true;
                                break block8;
                            }
                            if (err != 27392 && err != 25218) break block8;
                        }
                        if (res.data() != null && res.data().length > 0) {
                            baos.write(res.data());
                            if (ByteUtil.indexOf(res.data(), new byte[16]) >= 0) break block8;
                        }
                        offset += 62;
                        if (baos == null) break block8;
                        chunkSize = this.getMaximumChunkSize();
                    } while (err != 25218 && err != 27392);
                    log.debug((Object)"precisely when it means to ...");
                    ignoreErrorCode = true;
                }
                baos.flush();
                baos.close();
                readBytes = baos.toByteArray();
            }
            catch (IOException baos) {
                // empty catch block
            }
            log.debug((Object)("File:\n" + HexString.dump(readBytes)));
            GovCS.ResultObject ro = EPO.findCertificate(res, readBytes, ignoreErrorCode, true);
            return ro;
        }
        return super.readSelectedFile(_channel, _offset, _length);
    }

    @Override
    protected void selectMasterFile(CardChannel _channel) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
    }

    @Override
    protected void selectSubDirectory(CardChannel _channel, FileReference _directory) throws ResponseCodeException, InvalidCardChannelException, CardTerminalException {
        CommandAPDU cmd = APDUCommands.createSelectCommand(4, 12, _directory.reference, 1024);
        log.debug((Object)("SELECT SUB DIR CMD : " + HexString.hexify(cmd.getBuffer(), false)));
        ResponseAPDU res = _channel.sendCommandAPDU(cmd);
        if (res == null) {
            throw new ResponseCodeException(RESOURCES.getString("no_response"));
        }
    }

    @Override
    public boolean isStapleSign() {
        return false;
    }

    @Override
    public boolean isMultiSign() {
        return false;
    }

    @Override
    protected final CommandAPDU createAuthentifyCommand(byte[] _hashValue, AlgorithmParameters algorithmParameters) {
        return this.createSignHashCommand(_hashValue, algorithmParameters);
    }

    @Override
    public List<String> getAvailableHashAlgorithmNames(OCFCertificateInfo _info) {
        ArrayList<String> c = new ArrayList<String>();
        if (_info.getUsage() != OCFCertificateInfo.Usage.ENC) {
            c.add("SHA1");
        }
        return c;
    }
}

