/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epo;

import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import opencard.core.service.CardChannel;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EPOVersionAnalyzer {
    private static final Log LOG = LogFactory.getLog(EPOVersionAnalyzer.class);
    private static final String CMD_SELECT_AID_A = "00a404000ca0000000180a000001634200";
    private static final String CMD_SELECT_AID_C = "00a404000ca0000000180c000001634200";
    private static final List<String> LIST_SELECT_AIDS = Collections.unmodifiableList(Arrays.asList("00a404000ca0000000180c000001634200", "00a404000ca0000000180a000001634200"));
    private static final String CMD_VERSION_STRING_V3_03 = "00cadf3008";
    private static final String CMD_VERSION_STRING_V1_11 = "80cadf0308";
    private static final List<String> LIST_READ_VERSION = Collections.unmodifiableList(Arrays.asList("00cadf3008", "80cadf0308"));

    private EPOVersionAnalyzer() {
    }

    public static String getVersion(CardChannel cardChannel) {
        if (!EPOVersionAnalyzer.selectApplication(cardChannel)) {
            return null;
        }
        return EPOVersionAnalyzer.readVersion(cardChannel);
    }

    private static String readVersion(CardChannel cardChannel) {
        for (String cmdReadVersionString : LIST_READ_VERSION) {
            CommandAPDU cmdReadVersion = new CommandAPDU(HexUtil.parse(cmdReadVersionString));
            LOG.debug((Object)("CMD EPO READ VERSION: " + HexUtil.hexify(cmdReadVersion.getBuffer())));
            ResponseAPDU resVersion = null;
            try {
                resVersion = cardChannel.sendCommandAPDU(cmdReadVersion);
            }
            catch (Throwable e) {
                LOG.debug((Object)("RES EPO READ VERSION: " + e.getMessage()));
            }
            if (resVersion == null || resVersion.sw() != 36864 || resVersion.data() == null || resVersion.data().length > 1) {
                LOG.debug((Object)"RES EPO READ VERSION: no response received");
            }
            try {
                ASN1 asn1 = new ASN1(ByteUtil.subbytes(resVersion.data(), 1));
                String version = new String(asn1.getValue());
                LOG.debug((Object)("RES EPO READ VERSION: " + version));
                return version;
            }
            catch (Throwable e) {
                LOG.debug((Object)("failed to analyze version: " + e.getMessage()));
            }
        }
        return null;
    }

    private static boolean selectApplication(CardChannel cardChannel) {
        for (String cmdSelectString : LIST_SELECT_AIDS) {
            CommandAPDU cmdSelect = new CommandAPDU(HexUtil.parse(cmdSelectString));
            LOG.debug((Object)("CMD EPO SELECT: " + HexUtil.hexify(cmdSelect.getBuffer())));
            ResponseAPDU resSelect = null;
            try {
                resSelect = cardChannel.sendCommandAPDU(cmdSelect);
            }
            catch (Throwable e) {
                LOG.debug((Object)("RES EPO SELECT: " + e.getMessage()));
            }
            if (resSelect == null) continue;
            LOG.debug((Object)("RES EPO VERSION: " + HexUtil.hexify(resSelect.getBuffer())));
            if (resSelect == null || resSelect.sw() != 36864) continue;
            return true;
        }
        return false;
    }
}

