/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ta.impl;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.asn1.cvc.ECCVCPath;
import de.bos_bremen.common.asn1.cvc.ECCVCertificate;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.epa.SecurityInfos;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPA;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPAUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.KeyHandlerEC;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ta.CertAndKeyProvider;
import de.bos_bremen.gov2.jca_provider.service.ServiceRegistry;
import de.bos_bremen.gov2.jca_provider.service.hsm.HSMServiceFactory;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMException;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMService;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TerminalAuthentication {
    private static final String TA_CHALLENGE_LENGTH = "08";
    private EPA epaService = null;
    private Integer taVersion = null;
    private SecurityInfos.ChipAuthenticationDomainParameterInfo caDomParamInfo = null;
    private static Log log = LogFactory.getLog(TerminalAuthentication.class);
    private KeyPair ephTACAKeyPair = null;
    private boolean success = false;

    public TerminalAuthentication(EPA epaService, SecurityInfos.TerminalAuthenticationInfo taInfo, SecurityInfos.ChipAuthenticationDomainParameterInfo caDomParamInfo) throws IllegalArgumentException {
        if (epaService == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        if (taInfo != null) {
            try {
                this.taVersion = new Integer(taInfo.getVersion().getValue()[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to construct TA: cannot read version");
            }
            if (this.taVersion < 1 || this.taVersion > 2) {
                throw new IllegalArgumentException("Unable to construct TA: unknown version");
            }
        }
        this.epaService = epaService;
        this.caDomParamInfo = caDomParamInfo;
    }

    public synchronized boolean executeTARemote(List<ECCVCertificate> certList, List<ASN1> carList, byte[] terminalEphPublicKey, byte[] additionalData, byte[] signature) throws IllegalArgumentException, Exception {
        ResponseAPDU decResponse;
        CommandAPDU cmd;
        AssertUtil.notNullOrEmpty(certList, "list of certificates");
        AssertUtil.notNullOrEmpty(carList, "list of CAR");
        AssertUtil.notNullOrEmpty(terminalEphPublicKey, "ephemeral public key of terminal");
        AssertUtil.notNullOrEmpty(signature, "signature");
        ECCVCertificate cert = null;
        String carString = new String(carList.get(0).getValue());
        String carString2 = null;
        if (carList.size() == 2) {
            carString2 = new String(carList.get(1).getValue());
        }
        cert = certList.get(0);
        String certID = new String(cert.getChildElementByPath(ECCVCPath.CA_REFERENCE).getValue());
        boolean car1Matching = certID.equals(carString);
        boolean car2Matching = certID.equals(carString2);
        if (!car1Matching && !car2Matching) {
            throw new IllegalArgumentException("(TA) given certificates not matching request from card");
        }
        String certHolderReference = HexUtil.hexify(car1Matching ? carList.get(0).getValue() : carList.get(1).getValue());
        while (certList.size() > 0) {
            String dataField = EPAUtil.makeTag("83", certHolderReference);
            cmd = EPAUtil.commandFromString("002281 B6", dataField, null);
            decResponse = this.epaService.sendCommandAPDU(cmd);
            EPAUtil.logCommand(log, "MSE:Set DST", cmd, decResponse);
            try {
                EPAUtil.checkResponse(decResponse, false);
            }
            catch (Exception e) {
                throw new InternalError("(TA) MSE:Set DST failed: " + decResponse.sw());
            }
            cert = certList.remove(0);
            String certBodyString = HexUtil.hexify(cert.getChildElementByPath(ECCVCPath.CV_CERTIFICATE_BODY).getEncoded());
            String certSigString = HexUtil.hexify(cert.getChildElementByPath(ECCVCPath.SIGNATURE).getEncoded());
            certHolderReference = HexUtil.hexify(cert.getChildElementByPath(ECCVCPath.HOLDER_REFERENCE).getValue());
            cmd = EPAUtil.commandFromString("002A00 BE", certBodyString + certSigString, null);
            decResponse = this.epaService.sendCommandAPDU(cmd);
            EPAUtil.logCommand(log, "PSO:Verify Certificate: " + new String(HexUtil.parse(certHolderReference)), cmd, decResponse);
            try {
                EPAUtil.checkResponse(decResponse, false);
            }
            catch (Exception e) {
                throw new InternalError("(TA) Certificate not accepted: " + decResponse.sw());
            }
        }
        OID protocol = new OID(this.caDomParamInfo.getProtocol().getEncoded());
        KeyHandlerEC kh = null;
        if (!protocol.equals(SecurityInfos.OID_CA_ECDH)) {
            throw new InternalError("(TA) not successful: unsupported key handling algorithm requested");
        }
        kh = new KeyHandlerEC();
        byte[] compressedKey = kh.compressKeyFromBytes(terminalEphPublicKey);
        OID signatureAlg = (OID)cert.getChildElementByPath(ECCVCPath.PUBLIC_KEY_OID);
        String dataFieldString = EPAUtil.makeTag("80", HexUtil.hexify(signatureAlg.getValue())) + EPAUtil.makeTag("83", certHolderReference);
        dataFieldString = dataFieldString + EPAUtil.makeTag("91", HexUtil.hexify(compressedKey));
        dataFieldString = dataFieldString + (additionalData != null ? HexUtil.hexify(additionalData) : "");
        cmd = EPAUtil.commandFromString("002281 A4", dataFieldString, null);
        decResponse = this.epaService.sendCommandAPDU(cmd);
        EPAUtil.logCommand(log, "MSE:Set AT", cmd, decResponse);
        try {
            EPAUtil.checkResponse(decResponse, false);
        }
        catch (Exception e) {
            throw new InternalError("(TA) MSE:Set AT failed: " + decResponse.sw());
        }
        cmd = EPAUtil.commandFromString("0082 00 00", HexUtil.hexify(signature), null);
        decResponse = this.epaService.sendCommandAPDU(cmd);
        EPAUtil.logCommand(log, "External Authenticate", cmd, decResponse);
        try {
            EPAUtil.checkResponse(decResponse, false);
        }
        catch (Exception e) {
            throw new InternalError("(TA) External Authenticate failed: " + decResponse.sw());
        }
        this.success = true;
        return this.success;
    }

    public synchronized boolean executeTALocal(String certID, CertAndKeyProvider cakProvider, List<ASN1> car, byte[] cardEphemeralPublicKey, KeyPair ephTACAKeyPair, String auxDataString) throws IllegalArgumentException, IllegalStateException {
        if (this.taVersion == null || this.caDomParamInfo == null) {
            throw new IllegalStateException("required data not available");
        }
        if (certID == null || cakProvider == null || car == null || cardEphemeralPublicKey == null || cardEphemeralPublicKey.length == 0) {
            throw new IllegalArgumentException("TA cannot be executed: required parameter null");
        }
        if (car.size() < 1 || car.size() > 2) {
            throw new IllegalArgumentException("TA cannot be executed: there must be exactly 1 or 2 certification authority references");
        }
        if (this.taVersion == 1 && ephTACAKeyPair == null) {
            throw new IllegalArgumentException("TA cannot be executed: in version 1, an ephemeral key pair established in CA must be provided");
        }
        if (this.taVersion == 2 && ephTACAKeyPair != null) {
            throw new IllegalArgumentException("TA cannot be executed: in version 2, an ephemeral key pair must not be provided");
        }
        if (this.taVersion != 2 && auxDataString != null) {
            throw new IllegalArgumentException("TA cannot be executed: auxiliary data only permitted in version 2");
        }
        CommandAPDU cmd = null;
        ResponseAPDU decResponse = null;
        try {
            String certHolderReference;
            List<byte[]> certList;
            String carString = new String(car.get(0).getValue());
            String carString2 = null;
            if (car.size() == 2) {
                carString2 = new String(car.get(1).getValue());
            }
            if ((certList = cakProvider.getCertChain(carString, certID)) == null) {
                if (carString2 != null) {
                    certList = cakProvider.getCertChain(carString2, certID);
                }
                if (certList == null) {
                    log.debug((Object)("TA not successful: no certificate chain from " + certID + " to " + carString + " or " + carString2 + " available"));
                    return false;
                }
                certHolderReference = HexUtil.hexify(car.get(1).getValue());
            } else {
                certHolderReference = HexUtil.hexify(car.get(0).getValue());
            }
            String signer = new String(HexUtil.parse(certHolderReference));
            ECCVCertificate cert = null;
            while (certList.size() > 0) {
                String dataField = EPAUtil.makeTag("83", certHolderReference);
                cmd = EPAUtil.commandFromString("002281 B6", dataField, null);
                decResponse = this.epaService.sendCommandAPDU(cmd);
                EPAUtil.logCommand(log, "MSE:Set DST (certificate signed by " + signer + ")", cmd, decResponse);
                EPAUtil.checkResponse(decResponse, false);
                cert = new ECCVCertificate(certList.remove(0));
                String certBodyString = HexUtil.hexify(cert.getChildElementByPath(ECCVCPath.CV_CERTIFICATE_BODY).getEncoded());
                String certSigString = HexUtil.hexify(cert.getChildElementByPath(ECCVCPath.SIGNATURE).getEncoded());
                certHolderReference = HexUtil.hexify(cert.getChildElementByPath(ECCVCPath.HOLDER_REFERENCE).getValue());
                signer = new String(HexUtil.parse(certHolderReference));
                cmd = EPAUtil.commandFromString("002A00 BE", certBodyString + certSigString, null);
                decResponse = this.epaService.sendCommandAPDU(cmd);
                EPAUtil.logCommand(log, "PSO:Verify Certificate: " + signer, cmd, decResponse);
                EPAUtil.checkResponse(decResponse, false);
            }
            OID signatureAlg = (OID)cert.getChildElementByPath(ECCVCPath.PUBLIC_KEY_OID);
            String dataFieldString = EPAUtil.makeTag("80", HexUtil.hexify(signatureAlg.getValue())) + EPAUtil.makeTag("83", certHolderReference);
            OID protocol = new OID(this.caDomParamInfo.getProtocol().getEncoded());
            KeyHandlerEC kh = null;
            if (!protocol.equals(SecurityInfos.OID_CA_ECDH)) {
                log.debug((Object)"TA not successful: unsupported key handling algorithm requested");
                return false;
            }
            kh = new KeyHandlerEC();
            if (this.taVersion == 2) {
                this.ephTACAKeyPair = kh.generateKeyPair(this.caDomParamInfo);
                log.debug((Object)"TA version 2: generating ephemeral key pair");
            } else {
                this.ephTACAKeyPair = ephTACAKeyPair;
                log.debug((Object)"TA version 1: using ephemeral key pair generated during CA");
            }
            byte[] encodedKeyBytes = this.ephTACAKeyPair.getPublic().getEncoded();
            log.debug((Object)("Public key:\n" + HexUtil.dump(encodedKeyBytes)));
            encodedKeyBytes = this.ephTACAKeyPair.getPrivate().getEncoded();
            log.debug((Object)("Private key:\n" + HexUtil.dump(encodedKeyBytes)));
            byte[] compOwnEphPubKey = kh.compressKey(this.ephTACAKeyPair.getPublic());
            log.debug((Object)("Compressed public key:\n" + HexUtil.dump(compOwnEphPubKey)));
            if (this.taVersion == 2) {
                dataFieldString = dataFieldString + EPAUtil.makeTag("91", HexUtil.hexify(compOwnEphPubKey));
                dataFieldString = dataFieldString + (auxDataString != null ? auxDataString : "");
            }
            cmd = EPAUtil.commandFromString("002281 A4", dataFieldString, null);
            decResponse = this.epaService.sendCommandAPDU(cmd);
            EPAUtil.logCommand(log, "MSE:Set AT", cmd, decResponse);
            EPAUtil.checkResponse(decResponse, false);
            byte[] rPicc = TerminalAuthentication.requestChallenge(this.epaService);
            byte[] idPicc = cardEphemeralPublicKey;
            byte[] auxiliaryBytes = auxDataString != null ? HexUtil.parse(auxDataString) : null;
            byte[] convertedSignature = TerminalAuthentication.sign(certID, signatureAlg, idPicc, rPicc, compOwnEphPubKey, auxiliaryBytes);
            cmd = EPAUtil.commandFromString("0082 00 00", HexUtil.hexify(convertedSignature), null);
            decResponse = this.epaService.sendCommandAPDU(cmd);
            EPAUtil.logCommand(log, "External Authenticate", cmd, decResponse);
            EPAUtil.checkResponse(decResponse, false);
            this.success = true;
        }
        catch (Exception e) {
            log.warn((Object)("TA not successful: Exception thrown - " + e.getMessage()));
            this.success = false;
        }
        return this.success;
    }

    public synchronized KeyPair getEphTACAKeyPair() throws IllegalStateException {
        if (!this.success) {
            throw new IllegalStateException("TA not yet successfully executed");
        }
        return this.ephTACAKeyPair;
    }

    public static byte[] requestChallenge(EPA epaService) throws CardTerminalException {
        CommandAPDU cmd = EPAUtil.commandFromString("0084 00 00", null, TA_CHALLENGE_LENGTH);
        ResponseAPDU response = epaService.sendCommandAPDU(cmd);
        EPAUtil.logCommand(log, "Get Challenge", cmd, response);
        EPAUtil.checkResponse(response, true);
        byte[] challenge = response.data();
        return challenge;
    }

    public static byte[] sign(String alias, OID algorithm, byte[] idPicc, byte[] rPicc, byte[] compOwnEphPubKey, byte[] auxiliaryData) throws IllegalArgumentException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, IOException, UnrecoverableKeyException, KeyStoreException, CertificateException, HSMException {
        AssertUtil.notNullOrEmpty(alias, "alias of key");
        AssertUtil.notNull(algorithm, "OID of algorithm");
        AssertUtil.notNullOrEmpty(idPicc, "idPicc");
        AssertUtil.notNullOrEmpty(rPicc, "rPicc");
        AssertUtil.notNullOrEmpty(compOwnEphPubKey, "compressed own public key");
        byte[] completeChallenge = ByteUtil.combine(new byte[][]{idPicc, rPicc, compOwnEphPubKey, auxiliaryData});
        HSMService hsm = ServiceRegistry.Util.getServiceRegistry().getService(HSMServiceFactory.class).getHSMService();
        return hsm.sign(alias, algorithm, completeChallenge);
    }
}

