/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.local;

import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.cvc.CertificateDescription;
import de.bos_bremen.common.asn1.cvc.CertificateHolderAuthorizationTemplate;
import de.bos_bremen.common.asn1.cvc.ECCVCertificate;
import de.bos_bremen.gov2.jca_provider.ocf.CardTerminalManager;
import de.bos_bremen.gov2.jca_provider.ocf.SecureCard;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPA;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PACE;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PaceInputParameters;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PacePlusOutputParameters;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PacePlusResult;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.EAC1OutputType;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.EAC1Result;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.EAC2InputType;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.EAC2OutputType;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.EAC2Result;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.EACAdditionalInputType;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.ExtendedClientEAC1InputType;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ta.impl.TACAInputParameters;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ta.impl.TACAOutputParameters;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ta.impl.TACAResult;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.CardRequest;
import opencard.core.service.CardServiceException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;

public class EACClient {
    private static EACClient instance = null;
    private EPA epaService = null;
    private ECCVCertificate terminalCertificate = null;
    private byte[] auxiliaryData = null;

    private EACClient() {
    }

    public static synchronized EACClient getInstance() {
        if (instance == null) {
            instance = new EACClient();
        }
        return instance;
    }

    public synchronized EAC1Result executePACEPlus(ExtendedClientEAC1InputType input) {
        if (input == null) {
            return new EAC1Result(new IllegalArgumentException("null not permitted as input for executePACEPlus"));
        }
        try {
            this.createEPAService();
            this.terminalCertificate = new ECCVCertificate(input.getCertificate());
            this.auxiliaryData = input.getAuthenticatedAuxiliaryData();
            PaceInputParameters pip = new PaceInputParameters();
            pip.setSecretChoice(input.getPasswordType() == null ? null : (input.getPasswordType() == 2 ? PACE.USE_CAN_KEY : PACE.USE_PIN_KEY));
            pip.setSecretValue(input.getPassword() != null ? input.getPassword().toCharArray() : null);
            ASN1 chatASN1 = new ASN1(input.getRequiredCHAT());
            CertificateHolderAuthorizationTemplate chat = new CertificateHolderAuthorizationTemplate();
            chat.decode(chatASN1);
            pip.setTemplate(chat);
            try {
                pip.setCertificateDescription(new CertificateDescription(new ASN1(input.getCertificateDescription().get(0)).getValue()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SecureCard.SecurityProtocolResult<? extends Object> spop = this.epaService.allocateSecureContext(SecureCard.SecurityProtocol.EAC2_PACEPLUS, pip);
            if (!PacePlusResult.class.isInstance(spop)) {
                return new EAC1Result(new InternalError("incorrect return class of PACE+"));
            }
            PacePlusOutputParameters ppop = (PacePlusOutputParameters)spop.getData();
            EAC1OutputType output = new EAC1OutputType();
            output.setCertificateHolderAuthorizationTemplate(input.getRequiredCHAT());
            if (ppop != null) {
                output.setChallenge(ppop.getChallenge());
                output.setRetryCounter(ppop.getRetryCounter());
                ArrayList<String> carStringList = new ArrayList<String>();
                for (ASN1 car : ppop.getCertificationAuthorityReference()) {
                    carStringList.add(new String(car.getValue()));
                }
                output.setCertificationAuthorityReference(carStringList);
                output.setIdPicc(ppop.getCardEphemeralPublicKey());
            }
            if (this.epaService.getCardAccess() != null) {
                output.setEfCardAccess(this.epaService.getCardAccess().getEncoded());
            }
            return new EAC1Result(output, spop.getThrowable());
        }
        catch (Throwable t) {
            return new EAC1Result(t);
        }
    }

    public synchronized EAC2Result executeTACA(EAC2InputType input) {
        if (input == null) {
            return new EAC2Result(new IllegalArgumentException("null not permitted as input for exceuteTACA"));
        }
        try {
            this.createEPAService();
            TACAInputParameters tacaInput = new TACAInputParameters();
            tacaInput.setAuxiliaryData(this.auxiliaryData);
            tacaInput.setEphemeralKey(input.getEphemeralPublicKey());
            tacaInput.setSignature(input.getSignature());
            ArrayList<ECCVCertificate> certList = new ArrayList<ECCVCertificate>();
            for (byte[] certBytes : input.getCertificate()) {
                certList.add(new ECCVCertificate(certBytes));
            }
            if (!((ECCVCertificate)certList.get(certList.size() - 1)).equals(this.terminalCertificate)) {
                certList.add(this.terminalCertificate);
            }
            tacaInput.setCertificateList(certList);
            SecureCard.SecurityProtocolResult<? extends Object> spop = this.epaService.allocateSecureContext(SecureCard.SecurityProtocol.EAC2_TACA, tacaInput);
            if (!TACAResult.class.isInstance(spop)) {
                return new EAC2Result(new InternalError("incorrect return class of TA/CA (epaService)"));
            }
            TACAOutputParameters tcop = (TACAOutputParameters)spop.getData();
            if (tcop == null) {
                if (spop.getThrowable() != null) {
                    return new EAC2Result(spop.getThrowable());
                }
                return new EAC2Result(new InternalError("unknown error while running TA/CA"));
            }
            EAC2OutputType output = new EAC2OutputType();
            output.setAuthenticationToken(tcop.getAuthenticationToken());
            output.setNonce(tcop.getNonce());
            output.setEfCardSecurity(this.epaService.getRawCardSecurity());
            return new EAC2Result(output, spop.getThrowable());
        }
        catch (Throwable t) {
            return new EAC2Result(t);
        }
    }

    public synchronized EAC2Result executeOptionalTACA(EACAdditionalInputType input) {
        return null;
    }

    private void createEPAService() throws CardTerminalException, CardServiceException, ClassNotFoundException {
        if (this.epaService == null) {
            this.epaService = EACClient.getEPAService();
        }
    }

    public static EPA getEPAService() throws CardTerminalException, CardServiceException, ClassNotFoundException {
        EPA result = null;
        Vector<GovCS> cardServices = CardTerminalManager.getInstance(null, null, null).getConnectedCardServices();
        for (GovCS cs : cardServices) {
            if (!EPA.class.isInstance(cs)) continue;
            return (EPA)cs;
        }
        Enumeration<CardTerminal> terminalEnum = CardTerminalRegistry.getRegistry().getCardTerminals();
        if (terminalEnum.hasMoreElements()) {
            CardTerminal terminal = terminalEnum.nextElement();
            if (terminal.isCardPresent(0)) {
                CardTerminalEvent ctEvent = new CardTerminalEvent(terminal, 1, 0);
                CardRequest request = new CardRequest(1, terminal, null);
                SmartCard sc = SmartCard.getSmartCard(ctEvent, request);
                result = (EPA)sc.getCardService(EPA.class, false);
            }
            return result;
        }
        return null;
    }
}

