/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.asn1.cvc.ECCVCPath;
import de.bos_bremen.common.asn1.cvc.ECCVCertificate;
import de.bos_bremen.common.constants.OIDConstants;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.epa.SecurityInfos;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPA;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPAUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ca.impl.ChipAuthentication;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.SignedDataChecker;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.misc.impl.KeyHandlerEC;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.Connector;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.ProtocolParameter;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.ProtocolResult;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.ProtocolStep;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.EAC1InputType;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.EAC1OutputType;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.EAC1Result;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.EAC2InputType;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.EAC2OutputType;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.EAC2Result;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.EACAdditionalInputType;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.EACFinal;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.OptionalTACAProtocol;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.PacePlusProtocol;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.protocols.eac.TACAProtocol;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ta.CertAndKeyProvider;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ta.impl.TerminalAuthentication;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.AESKeyMaterialImpl;
import de.bos_bremen.gov2.jca_provider.ocf.channel.iso7816.AESSecureMessagingImpl;
import de.bos_bremen.gov2.jca_provider.ocf.channel.util.AESEncSSCIvParameterSpecImpl;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMException;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.LocalCertAndKeyProvider;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.List;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class EACServer
implements ProtocolStep<ProtocolParameter, ProtocolResult<?>> {
    public static final int STEP_PACE_OUTPUT_TO_TACA_INPUT = 1;
    public static final int STEP_OPTIONAL = 2;
    public static final int STEP_TACA_RESULT = 3;
    private PacePlusProtocol pacePlus = new PacePlusProtocol();
    private TACAProtocol taca = new TACAProtocol();
    private OptionalTACAProtocol optionalTACA = new OptionalTACAProtocol();
    private SecurityInfos.ChipAuthenticationDomainParameterInfo caDomParamInfo = null;
    private SecurityInfos.PACEInfo paceInfo = null;
    private KeyPair ephemeralTACAKeys = null;
    private byte[] compressedKey = null;
    private boolean isInitialized = false;

    public void init(Connector<EAC1OutputType, EAC1InputType, EAC1Result> pacePlusConnector, Connector<EAC2OutputType, EAC2InputType, EAC2Result> tacaConnector, Connector<EAC2OutputType, EACAdditionalInputType, EAC2Result> optionalTACAConnector) {
        this.pacePlus.setConnector(pacePlusConnector);
        this.taca.setConnector(tacaConnector);
        this.optionalTACA.setConnector(optionalTACAConnector);
        this.isInitialized = true;
    }

    public EACFinal execute(EAC1InputType input, CertAndKeyProvider cakProvider, SignedDataChecker checker) throws Exception {
        EAC2Result tacaOutput;
        if (!this.isInitialized) {
            throw new IllegalStateException("instance not initialized");
        }
        if (input == null || cakProvider == null || checker == null) {
            throw new IllegalArgumentException("null not permitted");
        }
        EAC1Result pacePlusOutput = this.performPACEPlus(input);
        if (((EAC1OutputType)pacePlusOutput.getData()).getEfCardAccess() == null) {
            // empty if block
        }
        if (((EAC2OutputType)(tacaOutput = this.performTACA(input, (EAC1OutputType)pacePlusOutput.getData(), cakProvider)).getData()).getEfCardSecurity() == null) {
            tacaOutput = this.performOptionalTACA((EAC2OutputType)tacaOutput.getData(), (EAC1OutputType)pacePlusOutput.getData(), input);
        }
        return this.processCompleteTACAOutput((EAC2OutputType)tacaOutput.getData(), new Object[]{checker});
    }

    private EAC1Result performPACEPlus(EAC1InputType input) throws Exception {
        AssertUtil.notNull(input, "input for PACE");
        return (EAC1Result)this.pacePlus.execute(input);
    }

    private EAC2Result performTACA(EAC1InputType firstInput, EAC1OutputType firstOutput, CertAndKeyProvider cakProvider) throws Exception {
        AssertUtil.notNull(firstInput, "input for PACE");
        AssertUtil.notNull(firstOutput, "output from PACE");
        AssertUtil.notNull(cakProvider, "certificate and key provider");
        EAC2InputType input = this.produceSecondInput(firstOutput, new Object[]{firstInput, cakProvider});
        return (EAC2Result)this.taca.execute(input);
    }

    private EAC2Result performOptionalTACA(EAC2OutputType secondOutput, EAC1OutputType firstOutput, EAC1InputType firstInput) throws Exception {
        AssertUtil.notNull(secondOutput, "output from TACA (first part)");
        AssertUtil.notNull(firstOutput, "output from PACE");
        AssertUtil.notNull(firstInput, "input to PACE");
        EAC1Result firstResult = new EAC1Result(firstOutput);
        EACAdditionalInputType input = this.produceThirdInput(secondOutput, new Object[]{firstInput, firstResult});
        return (EAC2Result)this.optionalTACA.execute(input);
    }

    private EAC2InputType produceSecondInput(EAC1OutputType firstOutput, Object[] additionalParameters) throws IOException, IllegalArgumentException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, InvalidKeySpecException, SignatureException, UnrecoverableKeyException, KeyStoreException, CertificateException, HSMException {
        byte[] rPicc;
        AssertUtil.notNull(firstOutput, "first output");
        AssertUtil.notNullOrEmpty(additionalParameters, "additional parameters");
        if (additionalParameters.length != 2 && additionalParameters.length != 3) {
            throw new IllegalArgumentException("two or three parameters required as additional input");
        }
        AssertUtil.notNull(additionalParameters[0], "instance of EAC1InputType");
        AssertUtil.notNull(additionalParameters[1], "instance of CertAndKeyProvider");
        if (!EAC1InputType.class.isInstance(additionalParameters[0])) {
            throw new IllegalArgumentException("parameter is not instance of EAC1InputType");
        }
        if (!CertAndKeyProvider.class.isInstance(additionalParameters[1])) {
            throw new IllegalArgumentException("parameter is not instance of CertAndKeyProvider");
        }
        if (additionalParameters.length == 3 && !Boolean.class.isInstance(additionalParameters[2])) {
            throw new IllegalArgumentException("parameter is not instance of Boolean");
        }
        EAC1InputType firstInput = (EAC1InputType)additionalParameters[0];
        CertAndKeyProvider cakProvider = (CertAndKeyProvider)additionalParameters[1];
        SecurityInfos efCardAccess = new SecurityInfos();
        efCardAccess.decode(firstOutput.getEfCardAccess());
        List<SecurityInfos.ChipAuthenticationDomainParameterInfo> caDomParamList = efCardAccess.getChipAuthenticationDomainParameterInfo();
        List<SecurityInfos.PACEInfo> paceInfoList = efCardAccess.getPACEInfo();
        if (caDomParamList == null || caDomParamList.size() == 0 || paceInfoList == null || paceInfoList.size() == 0) {
            throw new IllegalArgumentException("returned data from PACE+ does not contain correct EF.CardAccess");
        }
        this.caDomParamInfo = EPA.selectCADomainParameterInfo(caDomParamList);
        this.paceInfo = EPA.selectPACE(paceInfoList);
        OID protocol = new OID(this.caDomParamInfo.getProtocol().getEncoded());
        KeyHandlerEC kh = null;
        if (protocol.equals(OIDConstants.OID_CA_ECDH)) {
            kh = new KeyHandlerEC();
        }
        this.ephemeralTACAKeys = kh.generateKeyPair(this.caDomParamInfo);
        this.compressedKey = kh.compressKey(this.ephemeralTACAKeys.getPublic());
        EAC2InputType result = new EAC2InputType();
        if (additionalParameters.length == 3 && !((Boolean)additionalParameters[2]).booleanValue()) {
            result.setEphemeralPublicKey(ByteUtil.subbytes(kh.ephemeralKeyBytes(this.ephemeralTACAKeys.getPublic()), 1));
        } else {
            result.setEphemeralPublicKey(kh.ephemeralKeyBytes(this.ephemeralTACAKeys.getPublic()));
        }
        ECCVCertificate termCert = new ECCVCertificate(firstInput.getCertificate());
        String termHolder = new String(termCert.getChildElementByPath(ECCVCPath.HOLDER_REFERENCE).getValue());
        for (String car : firstOutput.getCertificationAuthorityReference()) {
            List<byte[]> certList = cakProvider.getCertChain(car, termHolder);
            if (certList == null || certList.size() <= 0) continue;
            byte[] lastCert = certList.get(certList.size() - 1);
            if (!Arrays.equals(lastCert, termCert.getEncoded())) {
                certList.add(termCert.getEncoded());
            }
            result.setCertificate(certList);
            break;
        }
        if (result.getCertificate() == null && !firstOutput.getCertificationAuthorityReference().isEmpty()) {
            return null;
        }
        byte[] signatureKey = cakProvider.getKeyByHolder(termHolder);
        if (signatureKey != null) {
            LocalCertAndKeyProvider.getInstance().addKey(termHolder, signatureKey);
        }
        if ((rPicc = firstOutput.getChallenge()) != null) {
            byte[] idPicc = firstOutput.getIdPicc();
            byte[] convertedSignature = EACServer.produceSignature(firstInput, idPicc, rPicc, this.compressedKey);
            result.setSignature(convertedSignature);
        }
        return result;
    }

    private static byte[] produceSignature(EAC1InputType firstInput, byte[] idPicc, byte[] rPicc, byte[] compressedKey) throws IOException, IllegalArgumentException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, InvalidKeySpecException, SignatureException, UnrecoverableKeyException, KeyStoreException, CertificateException, HSMException {
        AssertUtil.notNull(firstInput, "input for PACE");
        AssertUtil.notNullOrEmpty(idPicc, "ID of PICC");
        AssertUtil.notNullOrEmpty(rPicc, "challenge");
        byte[] certBytes = firstInput.getCertificate();
        AssertUtil.notNullOrEmpty(certBytes, "bytes of certificate (input for PACE)");
        ECCVCertificate cert = new ECCVCertificate(certBytes);
        OID signatureAlg = (OID)cert.getChildElementByPath(ECCVCPath.PUBLIC_KEY_OID);
        String termHolder = new String(cert.getChildElementByPath(ECCVCPath.HOLDER_REFERENCE).getValue());
        return TerminalAuthentication.sign(termHolder, signatureAlg, idPicc, rPicc, compressedKey, firstInput.getAuthenticatedAuxiliaryData());
    }

    private EACAdditionalInputType produceThirdInput(EAC2OutputType secondOutput, Object[] additionalParameters) throws InvalidKeyException, IllegalArgumentException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, SignatureException, IOException, UnrecoverableKeyException, KeyStoreException, CertificateException, HSMException {
        AssertUtil.notNull(secondOutput, "output from TACA (first part)");
        AssertUtil.notNullOrEmpty(additionalParameters, "additional parameters");
        if (additionalParameters.length != 2) {
            throw new IllegalArgumentException("exactly two parameters required: EAC1InputType, EAC1Result");
        }
        if (!EAC1InputType.class.isInstance(additionalParameters[0])) {
            throw new IllegalArgumentException("first parameter is not instance of EAC1InputType");
        }
        if (!EAC1Result.class.isInstance(additionalParameters[1])) {
            throw new IllegalArgumentException("first parameter is not instance of EAC1Result");
        }
        EAC1InputType firstInput = (EAC1InputType)additionalParameters[0];
        EAC1Result firstResult = (EAC1Result)additionalParameters[1];
        EAC1OutputType firstOutput = (EAC1OutputType)firstResult.getData();
        AssertUtil.notNull(firstOutput, "output from PACE");
        byte[] idPicc = firstOutput.getIdPicc();
        byte[] rPicc = secondOutput.getChallenge();
        AssertUtil.notNullOrEmpty(idPicc, "ID of PICC");
        AssertUtil.notNullOrEmpty(rPicc, "challenge");
        byte[] signature = EACServer.produceSignature(firstInput, idPicc, rPicc, this.compressedKey);
        EACAdditionalInputType result = new EACAdditionalInputType();
        result.setSignature(signature);
        return result;
    }

    private EACFinal processCompleteTACAOutput(EAC2OutputType secondOutput, Object[] additionalParameters) throws IllegalArgumentException, IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeySpecException, SignatureException {
        ChipAuthentication ca;
        boolean success;
        AssertUtil.notNull(secondOutput, "second output");
        AssertUtil.notNullOrEmpty(additionalParameters, "additional parameters");
        if (additionalParameters.length != 1) {
            throw new IllegalArgumentException("exactly one parameter required as instance of SignedDataChecker");
        }
        AssertUtil.notNull(additionalParameters[0], "instance of SignedDataChecker");
        if (!SignedDataChecker.class.isInstance(additionalParameters[0])) {
            throw new IllegalArgumentException("parameter is not instance of SignedDataChecker");
        }
        SignedDataChecker checker = (SignedDataChecker)additionalParameters[0];
        byte[] cardSecurityBytes = secondOutput.getEfCardSecurity();
        byte[] nonce = secondOutput.getNonce();
        byte[] authToken = secondOutput.getAuthenticationToken();
        AssertUtil.notNull(cardSecurityBytes, "EF.CardSecurity from card");
        AssertUtil.notNull(nonce, "nonce from card");
        AssertUtil.notNull(authToken, "authentication token from card");
        if (!checker.checkSignedData(cardSecurityBytes)) {
            throw new SignatureException("signature on EF.CardSecurity could not be verified");
        }
        SecurityInfos cardSecurity = EPAUtil.extractFromCardSecurity(cardSecurityBytes);
        List<SecurityInfos.ChipAuthenticationPublicKeyInfo> caPubKeyInfoList = cardSecurity.getChipAuthenticationPublicKeyInfo();
        List<SecurityInfos.ChipAuthenticationInfo> caInfoList = cardSecurity.getChipAuthenticationInfo();
        List<SecurityInfos.ChipAuthenticationDomainParameterInfo> caDomainParameterInfoList = cardSecurity.getChipAuthenticationDomainParameterInfo();
        List<SecurityInfos.PACEInfo> paceInfoList = cardSecurity.getPACEInfo();
        if (caPubKeyInfoList == null || caPubKeyInfoList.size() == 0 || caInfoList == null || caInfoList.size() == 0 || this.caDomParamInfo == null && (caDomainParameterInfoList == null || caDomainParameterInfoList.size() == 0) || this.paceInfo == null && (paceInfoList == null || paceInfoList.size() == 0)) {
            throw new IllegalArgumentException("Required data for CA not available in EF.CardSecurity");
        }
        if (this.caDomParamInfo == null) {
            this.caDomParamInfo = EPA.selectCADomainParameterInfo(caDomainParameterInfoList);
        }
        SecurityInfos.ChipAuthenticationInfo caInfo = EPA.selectCAInfo(caInfoList, this.caDomParamInfo);
        SecurityInfos.ChipAuthenticationPublicKeyInfo caPubKeyInfo = EPA.selectCAPubKeyInfo(caPubKeyInfoList, caInfo);
        if (this.paceInfo == null) {
            this.paceInfo = EPA.selectPACE(paceInfoList);
        }
        if (success = (ca = new ChipAuthentication(caInfo, this.caDomParamInfo, caPubKeyInfo, this.paceInfo)).processResponse(this.ephemeralTACAKeys, nonce, authToken)) {
            SecretKey macKey = ca.getMacKey();
            SecretKey encKey = ca.getEncKey();
            AESSecureMessagingImpl sm = null;
            if (macKey.getAlgorithm().equals("AES")) {
                AESEncSSCIvParameterSpecImpl ssc = new AESEncSSCIvParameterSpecImpl(new byte[16], false, encKey);
                AESKeyMaterialImpl smKeyMaterial = new AESKeyMaterialImpl(encKey, macKey, ssc);
                sm = new AESSecureMessagingImpl(smKeyMaterial);
            }
            return new EACFinal(sm, cardSecurityBytes);
        }
        return null;
    }

    @Override
    public <Q extends ProtocolParameter> Q parameterStep(int stepSelect, Class<Q> parameterClass, Q parameter, Object[] additionalParameters) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Q extends ProtocolResult<?>> Q resultStep(int stepSelect, Class<Q> resultClass, Q result, Object[] additionalParameters) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <P extends ProtocolParameter, Q extends ProtocolResult<?>> P executeStep(int stepSelect, Class<Q> resultClass, Q result, Class<P> parameterClass, P parameter, Object[] additionalParameters) throws IllegalArgumentException, InternalError {
        if (stepSelect == 1) {
            if (resultClass != EAC1Result.class) {
                throw new IllegalArgumentException("incorrect result class for given step");
            }
            if (parameterClass != EAC2InputType.class) {
                throw new IllegalArgumentException("incorrect parameter class for given step");
            }
            try {
                return (P)this.produceSecondInput((EAC1OutputType)((EAC1Result)result).getData(), additionalParameters);
            }
            catch (Exception e) {
                throw new InternalError("internal error: " + e.getMessage());
            }
        }
        if (stepSelect == 2) {
            if (resultClass != EAC2Result.class) {
                throw new IllegalArgumentException("incorrect result class for given step");
            }
            if (parameterClass != EACAdditionalInputType.class) {
                throw new IllegalArgumentException("incorrect parameter class for given step");
            }
            try {
                return (P)this.produceThirdInput((EAC2OutputType)((EAC2Result)result).getData(), additionalParameters);
            }
            catch (Exception e) {
                throw new InternalError("internal error: " + e.getMessage());
            }
        }
        if (stepSelect == 3) {
            if (resultClass != EAC2Result.class) {
                throw new IllegalArgumentException("incorrect result class for given step");
            }
            try {
                return (P)this.processCompleteTACAOutput((EAC2OutputType)result.getData(), additionalParameters);
            }
            catch (Exception e) {
                throw new InternalError("internal error: " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown/unsupported step");
    }
}

