/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.verification.impl;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.ocf.TransmitCommand;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.ServerStep;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.FunctionParameter;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.TransmitCommandCreator;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.TransmitResultEvaluator;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.impl.AbstractFunction;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDU;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDUParameter;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDUResult;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.verification.ValidityFunction;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.verification.ValidityFunctionConnector;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.verification.ValidityVerificationResult;
import java.util.Arrays;
import java.util.List;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public abstract class AbstractValidityFunction<T extends FunctionParameter>
extends AbstractFunction<Boolean, T, ValidityVerificationResult>
implements ValidityFunction<T>,
ServerStep<TransmitAPDUParameter, ValidityVerificationResult>,
TransmitCommandCreator<T>,
TransmitResultEvaluator<ValidityVerificationResult> {
    protected TransmitAPDU transmit = null;

    public AbstractValidityFunction(TransmitAPDU transmit) throws IllegalArgumentException {
        AssertUtil.notNull(transmit, "TransmitAPDU");
        this.transmit = transmit;
    }

    public AbstractValidityFunction(ValidityFunctionConnector<T> connector) {
        super(connector);
    }

    @Override
    public final ValidityVerificationResult createResult(Throwable throwable) {
        return new ValidityVerificationResult(throwable);
    }

    @Override
    public final <Q extends ValidityVerificationResult> Q resultStep(int stepSelect, Class<Q> resultClass, Q result, Object[] additionalParameters) throws IllegalArgumentException, InternalError {
        if (!ValidityVerificationResult.class.equals(resultClass)) {
            throw new IllegalArgumentException("only ValidityVerificationResult.class supported");
        }
        AssertUtil.notNullOrEmpty(additionalParameters, "additionalParameters");
        if (additionalParameters.length != 1 || !TransmitAPDUResult.class.isInstance(additionalParameters[0])) {
            throw new IllegalArgumentException("exactly one additional parameter expected containing TransmitAPDUResult as result");
        }
        TransmitAPDUResult unsecuredResult = this.transmit.resultStep(0, TransmitAPDUResult.class, (TransmitAPDUResult)TransmitAPDUResult.class.cast(additionalParameters[0]), null);
        if (unsecuredResult.getThrowable() != null) {
            return (Q)((ValidityVerificationResult)resultClass.cast(new ValidityVerificationResult(unsecuredResult.getThrowable())));
        }
        int returnCode = unsecuredResult.getResponseList().get(0).sw();
        ValidityVerificationResult vvResult = returnCode == 36864 ? new ValidityVerificationResult(true) : (returnCode == 27272 ? new ValidityVerificationResult(new IllegalStateException("referenced data not found")) : (returnCode == 27010 ? new ValidityVerificationResult(new IllegalStateException("terminal not authorized to perform verification")) : new ValidityVerificationResult(false)));
        return (Q)((ValidityVerificationResult)resultClass.cast(vvResult));
    }

    @Override
    public final <Q extends TransmitAPDUParameter> Q parameterStep(int stepSelect, Class<Q> parameterClass, Q parameter, Object[] additionalParameters) throws IllegalArgumentException, InternalError {
        if (!TransmitAPDUParameter.class.equals(parameterClass)) {
            throw new IllegalArgumentException("only TransmitAPDUParameter.class supported");
        }
        if (parameter != null) {
            throw new IllegalArgumentException("parameter only expected as null");
        }
        if (!ArrayUtil.isNullOrEmpty(additionalParameters)) {
            throw new IllegalArgumentException("additionalParameters only expected as null or empty array");
        }
        CommandAPDU command = this.getVerifyCommand();
        TransmitAPDUParameter transmitParameter = new TransmitAPDUParameter(TransmitCommand.create(Arrays.asList(command)));
        TransmitAPDUParameter securedTransmitParameter = this.transmit.parameterStep(0, TransmitAPDUParameter.class, transmitParameter, null);
        return (Q)((TransmitAPDUParameter)parameterClass.cast(securedTransmitParameter));
    }

    @Override
    public final <P extends TransmitAPDUParameter, Q extends ValidityVerificationResult> P executeStep(int stepSelect, Class<Q> resultClass, Q result, Class<P> parameterClass, P parameter, Object[] additionalParameters) throws IllegalArgumentException, InternalError {
        throw new UnsupportedOperationException();
    }

    protected abstract CommandAPDU getVerifyCommand();

    @Override
    public final List<TransmitCommand> create(T parameter) {
        return this.create(parameter, (List<ResponseAPDU>)null);
    }

    @Override
    public final List<TransmitCommand> create(T parameter, List<ResponseAPDU> acceptedResponseList) {
        return TransmitCommand.create(this.getVerifyCommand(), acceptedResponseList);
    }

    @Override
    public final <Q extends ValidityVerificationResult> Q evaluate(Class<Q> resultClass, TransmitAPDUResult transmitResult, int[] responseIndices) {
        responseIndices = TransmitResultEvaluator.Util.checkArguments(resultClass, transmitResult, responseIndices, this.getMinimumCount(), this.getMaximumCount());
        if (transmitResult.getThrowable() != null) {
            return (Q)((ValidityVerificationResult)resultClass.cast(new ValidityVerificationResult(transmitResult.getThrowable())));
        }
        int returnCode = transmitResult.getResponseList().get(responseIndices[0]).sw();
        ValidityVerificationResult vvResult = returnCode == 36864 ? new ValidityVerificationResult(true) : (returnCode == 27272 ? new ValidityVerificationResult(new IllegalStateException("referenced data not found")) : (returnCode == 27010 ? new ValidityVerificationResult(new IllegalStateException("terminal not authorized to perform verification")) : new ValidityVerificationResult(false)));
        return (Q)((ValidityVerificationResult)resultClass.cast(vvResult));
    }

    @Override
    public int getMinimumCount() {
        return 1;
    }

    @Override
    public int getMaximumCount() {
        return 1;
    }
}

