/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.local;

import de.bos_bremen.gov2.jca_provider.ocf.TransmitResult;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPA;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.FunctionConnector;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDUParameter;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDUResult;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import java.util.Enumeration;
import java.util.List;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.CardRequest;
import opencard.core.service.CardServiceException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.ResponseAPDU;

public class LocalTransmitAPDUConnector
implements FunctionConnector<List<ResponseAPDU>, TransmitAPDUParameter, TransmitAPDUResult> {
    private EPA epaService = null;

    public LocalTransmitAPDUConnector() throws CardTerminalException, CardServiceException, ClassNotFoundException {
        this.createEPAService();
    }

    @Override
    public TransmitAPDUResult execute(TransmitAPDUParameter parameter) {
        TransmitResult result = this.epaService.transmit(parameter);
        TransmitAPDUResult transmitResult = new TransmitAPDUResult(result);
        return transmitResult;
    }

    private void createEPAService() throws CardTerminalException, CardServiceException, ClassNotFoundException {
        if (this.epaService == null) {
            Enumeration<CardTerminal> terminalEnum = CardTerminalRegistry.getRegistry().getCardTerminals();
            while (terminalEnum.hasMoreElements()) {
                GovCS cs;
                Card c;
                CardTerminal terminal = terminalEnum.nextElement();
                CardObjectRegistry cr = CardObjectRegistryImpl.getInstance();
                Terminal t = cr.getTerminal(terminal);
                if (t != null && (c = cr.getCardByTerminalAndSlotID(t, 0)) != null && EPA.class.isInstance(cs = c.getCardService())) {
                    this.epaService = (EPA)cs;
                    return;
                }
                if (!terminal.isCardPresent(0)) continue;
                CardTerminalEvent ctEvent = new CardTerminalEvent(terminal, 1, 0);
                CardRequest request = new CardRequest(1, terminal, null);
                SmartCard sc = SmartCard.getSmartCard(ctEvent, request);
                this.epaService = (EPA)sc.getCardService(EPA.class, false);
            }
        }
    }
}

