/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.ocf.TransmitCommand;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.ServerStep;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.Function;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.FunctionConnector;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.impl.AbstractFunction;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDUParameter;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDUResult;
import de.bos_bremen.gov2.jca_provider.ocf.channel.CardCommunication;
import de.bos_bremen.gov2.jca_provider.ocf.channel.SecureMessaging;
import de.bos_bremen.gov2.jca_provider.ocf.channel.impl.CardCommunicationImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public class TransmitAPDU
extends AbstractFunction<List<ResponseAPDU>, TransmitAPDUParameter, TransmitAPDUResult>
implements Function<List<ResponseAPDU>, TransmitAPDUParameter, TransmitAPDUResult>,
ServerStep<TransmitAPDUParameter, TransmitAPDUResult> {
    private SecureMessaging<?, ?, ?> sm = null;
    private CardCommunication cc = null;

    public TransmitAPDU(FunctionConnector<List<ResponseAPDU>, TransmitAPDUParameter, TransmitAPDUResult> fc, SecureMessaging<?, ?, ?> sm) throws IllegalArgumentException {
        super(fc);
        AssertUtil.notNull(sm, "Secure Messaging");
        this.sm = sm;
    }

    @Override
    public TransmitAPDUResult executeInt(TransmitAPDUParameter parameter) throws Throwable {
        ArrayList<CommandAPDU> commands = new ArrayList<CommandAPDU>();
        for (TransmitCommand tc : parameter.getCommandList()) {
            commands.add(tc.getCommand());
        }
        this.cc = new CardCommunicationImpl(commands.toArray(new CommandAPDU[commands.size()]));
        this.sm.toCard(this.cc);
        TransmitAPDUParameter securedParameter = new TransmitAPDUParameter(TransmitCommand.create(this.cc.getCommands()));
        TransmitAPDUResult securedResult = (TransmitAPDUResult)this.connector.execute(securedParameter);
        if (securedResult.getThrowable() != null) {
            return new TransmitAPDUResult(securedResult.getThrowable());
        }
        this.cc.setResponses(securedResult.getResponseList().toArray(new ResponseAPDU[securedResult.getResponseList().size()]));
        this.cc.setFinished(false);
        this.sm.fromCard(this.cc);
        TransmitAPDUResult result = new TransmitAPDUResult(Arrays.asList(this.cc.getResponses()));
        return result;
    }

    @Override
    public TransmitAPDUResult createResult(Throwable throwable) {
        return new TransmitAPDUResult(throwable);
    }

    @Override
    public <P extends TransmitAPDUParameter, Q extends TransmitAPDUResult> P executeStep(int stepSelect, Class<Q> resultClass, Q result, Class<P> parameterClass, P parameter, Object[] additionalParameters) throws IllegalArgumentException, InternalError {
        return null;
    }

    @Override
    public synchronized <Q extends TransmitAPDUParameter> Q parameterStep(int stepSelect, Class<Q> parameterClass, Q parameter, Object[] additionalParameters) throws IllegalArgumentException, InternalError {
        if (this.cc != null) {
            throw new IllegalStateException("cc already initialized from another parameterStep");
        }
        ArrayList<CommandAPDU> commands = new ArrayList<CommandAPDU>();
        for (TransmitCommand tc : parameter.getCommandList()) {
            commands.add(tc.getCommand());
        }
        this.cc = new CardCommunicationImpl(commands.toArray(new CommandAPDU[commands.size()]));
        this.sm.toCard(this.cc);
        ArrayList<TransmitCommand> resultList = new ArrayList<TransmitCommand>();
        Object[] securedCommands = this.cc.getCommands();
        if (!ArrayUtil.isNullOrEmpty(securedCommands)) {
            for (int i = 0; i < securedCommands.length; ++i) {
                resultList.add(new TransmitCommand((CommandAPDU)securedCommands[i], parameter.getCommandList().get(i).getAcceptedResponseList()));
            }
        }
        TransmitAPDUParameter securedParameter = new TransmitAPDUParameter(resultList);
        return (Q)((TransmitAPDUParameter)parameterClass.cast(securedParameter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <Q extends TransmitAPDUResult> Q resultStep(int stepSelect, Class<Q> resultClass, Q result, Object[] additionalParameters) throws IllegalArgumentException, InternalError {
        if (this.cc == null) {
            throw new IllegalStateException("cc not initialized from parameterStep");
        }
        try {
            this.cc.setResponses(result.getResponseList().toArray(new ResponseAPDU[result.getResponseList().size()]));
            this.cc.setFinished(false);
            this.sm.fromCard(this.cc);
            TransmitAPDUResult returnResult = new TransmitAPDUResult(Arrays.asList(this.cc.getResponses()));
            TransmitAPDUResult transmitAPDUResult = (TransmitAPDUResult)resultClass.cast(returnResult);
            return (Q)transmitAPDUResult;
        }
        finally {
            this.cc = null;
        }
    }
}

