/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.select;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.TransmitCommand;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.ServerStep;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.Function;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.TransmitCommandCreator;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.TransmitResultEvaluator;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.impl.AbstractFunction;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.impl.FileParameter;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.select.SelectResult;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDU;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDUParameter;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDUResult;
import java.util.List;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public class SelectApplication
extends AbstractFunction<Boolean, FileParameter, SelectResult>
implements Function<Boolean, FileParameter, SelectResult>,
ServerStep<TransmitAPDUParameter, SelectResult>,
TransmitCommandCreator<FileParameter>,
TransmitResultEvaluator<SelectResult> {
    private TransmitAPDU transmit = null;

    public SelectApplication(TransmitAPDU transmit) throws IllegalArgumentException {
        this.transmit = transmit;
    }

    @Override
    public SelectResult executeInt(FileParameter parameter) throws Throwable {
        AssertUtil.notNull(this.transmit, "TransmitAPDU");
        TransmitAPDUParameter transmitParameter = new TransmitAPDUParameter(this.create(parameter, (List<ResponseAPDU>)null));
        TransmitAPDUResult result = (TransmitAPDUResult)this.transmit.execute(transmitParameter);
        if (result.getThrowable() != null) {
            return new SelectResult(result.getThrowable());
        }
        SelectResult readResult = new SelectResult(result.getResponseList().get(0).sw() == 36864 ? Boolean.TRUE : Boolean.FALSE);
        return readResult;
    }

    @Override
    public SelectResult createResult(Throwable throwable) {
        return new SelectResult(throwable);
    }

    @Override
    public <P extends TransmitAPDUParameter, Q extends SelectResult> P executeStep(int stepSelect, Class<Q> resultClass, Q result, Class<P> parameterClass, P parameter, Object[] additionalParameters) throws IllegalArgumentException, InternalError {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Q extends TransmitAPDUParameter> Q parameterStep(int stepSelect, Class<Q> parameterClass, Q parameter, Object[] additionalParameters) throws IllegalArgumentException, InternalError {
        if (!TransmitAPDUParameter.class.equals(parameterClass)) {
            throw new IllegalArgumentException("only TransmitAPDUParameter.class supported");
        }
        if (parameter != null) {
            throw new IllegalArgumentException("parameter only expected as null");
        }
        AssertUtil.notNullOrEmpty(additionalParameters, "additionalParameters");
        if (additionalParameters.length != 1 || !FileParameter.class.isInstance(additionalParameters[0])) {
            throw new IllegalArgumentException("exactly one additional parameter expected containing FileParameter for selection");
        }
        FileParameter fileParameter = (FileParameter)additionalParameters[0];
        List<TransmitCommand> listTransmitCommand = this.create(fileParameter, (List<ResponseAPDU>)null);
        if (listTransmitCommand == null) {
            return (Q)((TransmitAPDUParameter)parameterClass.cast(new TransmitAPDUParameter()));
        }
        TransmitAPDUParameter transmitParameter = new TransmitAPDUParameter(listTransmitCommand);
        TransmitAPDUParameter securedTransmitParameter = this.transmit.parameterStep(0, TransmitAPDUParameter.class, transmitParameter, null);
        return (Q)((TransmitAPDUParameter)parameterClass.cast(securedTransmitParameter));
    }

    @Override
    public <Q extends SelectResult> Q resultStep(int stepSelect, Class<Q> resultClass, Q result, Object[] additionalParameters) throws IllegalArgumentException, InternalError {
        AssertUtil.notNull(this.transmit, "TransmitAPDU");
        if (!SelectResult.class.equals(resultClass)) {
            throw new IllegalArgumentException("only SelectResult.class supported");
        }
        AssertUtil.notNullOrEmpty(additionalParameters, "additionalParameters");
        if (additionalParameters.length != 1 || !TransmitAPDUResult.class.isInstance(additionalParameters[0])) {
            throw new IllegalArgumentException("exactly one additional parameter expected containing TransmitAPDUResult as result");
        }
        TransmitAPDUResult unsecuredResult = this.transmit.resultStep(0, TransmitAPDUResult.class, (TransmitAPDUResult)TransmitAPDUResult.class.cast(additionalParameters[0]), null);
        return (Q)this.evaluate((Class)resultClass, unsecuredResult, (int[])null);
    }

    @Override
    public List<TransmitCommand> create(FileParameter parameter) {
        return this.create(parameter, (List<ResponseAPDU>)null);
    }

    @Override
    public List<TransmitCommand> create(FileParameter parameter, List<ResponseAPDU> acceptedResponseList) {
        CommandAPDU command = null;
        if (parameter.getDFID() != null) {
            command = new CommandAPDU(HexUtil.parse("00a4040c" + HexUtil.hexify(parameter.getDFID().length) + HexUtil.hexify(parameter.getDFID())));
        } else if (parameter.getAID() != null) {
            command = new CommandAPDU(HexUtil.parse("00a4040c" + HexUtil.hexify(parameter.getAID().length) + HexUtil.hexify(parameter.getAID())));
        } else {
            return null;
        }
        return TransmitCommand.create(command, acceptedResponseList);
    }

    @Override
    public <Q extends SelectResult> Q evaluate(Class<Q> resultClass, TransmitAPDUResult transmitResult, int[] responseIndices) {
        responseIndices = TransmitResultEvaluator.Util.checkArguments(resultClass, transmitResult, responseIndices, this.getMinimumCount(), this.getMaximumCount());
        if (transmitResult.getThrowable() != null) {
            return (Q)((SelectResult)resultClass.cast(new SelectResult(transmitResult.getThrowable())));
        }
        SelectResult selectResult = new SelectResult(transmitResult.getResponseList().get(responseIndices[0]).sw() == 36864 ? Boolean.TRUE : Boolean.FALSE);
        return (Q)((SelectResult)resultClass.cast(selectResult));
    }

    @Override
    public int getMinimumCount() {
        return 1;
    }

    @Override
    public int getMaximumCount() {
        return 1;
    }
}

