/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.ri;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.common.constants.OIDConstants;
import de.bos_bremen.gov2.jca_provider.ocf.TransmitCommand;
import de.bos_bremen.gov2.jca_provider.ocf.asn1.epa.SecurityInfos;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.EPAUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.ServerStep;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.Function;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.TransmitCommandCreator;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.TransmitResultEvaluator;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.impl.AbstractFunction;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.ri.RestrictedIdentificationParameter;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.ri.RestrictedIdentificationResult;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDU;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDUParameter;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDUResult;
import java.util.ArrayList;
import java.util.List;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public class RestrictedIdentification
extends AbstractFunction<byte[], RestrictedIdentificationParameter, RestrictedIdentificationResult>
implements Function<byte[], RestrictedIdentificationParameter, RestrictedIdentificationResult>,
ServerStep<TransmitAPDUParameter, RestrictedIdentificationResult>,
TransmitCommandCreator<RestrictedIdentificationParameter>,
TransmitResultEvaluator<RestrictedIdentificationResult> {
    private static final String FIRST_KEY_TAG = "A0";
    private static final String SECOND_KEY_TAG = "A2";
    private static final byte[] FIRST_ID_TAG = new byte[]{-127};
    private static final byte[] SECOND_ID_TAG = new byte[]{-125};
    private TransmitAPDU transmit = null;
    private static final int[] DEFAULT_RESPONSE_INDICES_TO_EVALUATE_TWO_ID = new int[]{0, 1};

    public RestrictedIdentification(TransmitAPDU transmit) throws IllegalArgumentException {
        this.transmit = transmit;
    }

    @Override
    public RestrictedIdentificationResult executeInt(RestrictedIdentificationParameter parameter) throws Throwable {
        AssertUtil.notNull(this.transmit, "TransmitAPDU");
        Object apduParams = this.parameterStep(0, TransmitAPDUParameter.class, null, new Object[]{parameter});
        TransmitAPDUResult apduResult = (TransmitAPDUResult)this.transmit.execute(apduParams);
        RestrictedIdentificationResult riResult = this.resultStep(0, RestrictedIdentificationResult.class, null, new Object[]{apduResult});
        return riResult;
    }

    @Override
    public RestrictedIdentificationResult createResult(Throwable throwable) {
        return new RestrictedIdentificationResult(throwable);
    }

    @Override
    public <P extends TransmitAPDUParameter, Q extends RestrictedIdentificationResult> P executeStep(int stepSelect, Class<Q> resultClass, Q result, Class<P> parameterClass, P parameter, Object[] additionalParameters) throws IllegalArgumentException, InternalError {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Q extends TransmitAPDUParameter> Q parameterStep(int stepSelect, Class<Q> parameterClass, Q parameter, Object[] additionalParameters) throws IllegalArgumentException, InternalError {
        if (!TransmitAPDUParameter.class.equals(parameterClass)) {
            throw new IllegalArgumentException("only TransmitAPDUParameter.class supported");
        }
        if (parameter != null) {
            throw new IllegalArgumentException("parameter only expected as null");
        }
        AssertUtil.notNullOrEmpty(additionalParameters, "additionalParameters");
        if (additionalParameters.length != 1 || !RestrictedIdentificationParameter.class.isInstance(additionalParameters[0])) {
            throw new IllegalArgumentException("exactly one additional parameter expected containing RestrictedIdentificationParameter for selection");
        }
        RestrictedIdentificationParameter riParameter = (RestrictedIdentificationParameter)additionalParameters[0];
        try {
            List<TransmitCommand> tcList = this.create(riParameter, (List<ResponseAPDU>)null);
            TransmitAPDUParameter transmitParameter = new TransmitAPDUParameter(tcList);
            TransmitAPDUParameter securedTransmitParameter = this.transmit.parameterStep(0, TransmitAPDUParameter.class, transmitParameter, null);
            return (Q)((TransmitAPDUParameter)parameterClass.cast(securedTransmitParameter));
        }
        catch (Exception e) {
            throw new InternalError("Internal error: " + e.getMessage());
        }
    }

    @Override
    public <Q extends RestrictedIdentificationResult> Q resultStep(int stepSelect, Class<Q> resultClass, Q result, Object[] additionalParameters) throws IllegalArgumentException, InternalError {
        TransmitAPDUResult unsecuredResult;
        AssertUtil.notNull(this.transmit, "TransmitAPDU");
        if (!RestrictedIdentificationResult.class.equals(resultClass)) {
            throw new IllegalArgumentException("only RestrictedIdentificationResult.class supported");
        }
        AssertUtil.notNullOrEmpty(additionalParameters, "additionalParameters");
        if (additionalParameters.length != 1 || !TransmitAPDUResult.class.isInstance(additionalParameters[0])) {
            throw new IllegalArgumentException("exactly one additional parameter expected containing TransmitAPDUResult as result");
        }
        return (Q)this.evaluate((Class)resultClass, unsecuredResult, (int[])((unsecuredResult = this.transmit.resultStep(0, TransmitAPDUResult.class, (TransmitAPDUResult)TransmitAPDUResult.class.cast(additionalParameters[0]), null)).getResponseList().size() == 2 ? DEFAULT_RESPONSE_INDICES_TO_EVALUATE_TWO_ID : null));
    }

    @Override
    public List<TransmitCommand> create(RestrictedIdentificationParameter parameter) throws Exception {
        return this.create(parameter, (List<ResponseAPDU>)null);
    }

    @Override
    public List<TransmitCommand> create(RestrictedIdentificationParameter parameter, List<ResponseAPDU> acceptedResponseList) throws Exception {
        byte[] secondKey;
        ArrayList<TransmitCommand> tcList = new ArrayList<TransmitCommand>();
        SecurityInfos.RestrictedIdentificationInfo riInfo = parameter.getRiInfo();
        Object dataFieldString = EPAUtil.makeTag("80", HexUtil.hexify(riInfo.getProtocol().getValue())) + EPAUtil.makeTag("84", HexUtil.hexify(riInfo.getParams().getKeyID().getValue()));
        CommandAPDU cmd = EPAUtil.commandFromString("002241 A4", (String)dataFieldString, EPAUtil.LENGTH_EXPECTED_NONE);
        TransmitCommand tc = new TransmitCommand(cmd, TransmitCommand.RESPONSE_CODE_ACCEPT_OK_ONLY_LIST);
        tcList.add(tc);
        OID oid = new OID(riInfo.getProtocol().getEncoded());
        String expectedIDLength = "";
        if (oid.equals(OIDConstants.OID_RI_DH_SHA_1) || oid.equals(OIDConstants.OID_RI_ECDH_SHA_1)) {
            expectedIDLength = "18";
        } else if (oid.equals(OIDConstants.OID_RI_DH_SHA_224) || oid.equals(OIDConstants.OID_RI_ECDH_SHA_224)) {
            expectedIDLength = "20";
        } else if (oid.equals(OIDConstants.OID_RI_DH_SHA_256) || oid.equals(OIDConstants.OID_RI_ECDH_SHA_256)) {
            expectedIDLength = "24";
        }
        byte[] firstKey = parameter.getFirstKey();
        if (firstKey != null && firstKey.length > 0) {
            dataFieldString = EPAUtil.makeTag("7C", EPAUtil.makeTag(FIRST_KEY_TAG, HexUtil.hexify(firstKey)));
            cmd = EPAUtil.commandFromString("0086 00 00", (String)dataFieldString, expectedIDLength);
            tc = new TransmitCommand(cmd, TransmitCommand.RESPONSE_CODE_ACCEPT_OK_ONLY_LIST);
            tcList.add(tc);
        }
        if ((secondKey = parameter.getSecondKey()) != null && secondKey.length > 0) {
            dataFieldString = EPAUtil.makeTag("7C", EPAUtil.makeTag(SECOND_KEY_TAG, HexUtil.hexify(secondKey)));
            cmd = EPAUtil.commandFromString("0086 00 00", (String)dataFieldString, expectedIDLength);
            tc = new TransmitCommand(cmd, TransmitCommand.RESPONSE_CODE_ACCEPT_OK_ONLY_LIST);
            tcList.add(tc);
        }
        return tcList;
    }

    @Override
    public <Q extends RestrictedIdentificationResult> Q evaluate(Class<Q> resultClass, TransmitAPDUResult transmitResult, int[] responseIndices) {
        responseIndices = TransmitResultEvaluator.Util.checkArguments(resultClass, transmitResult, responseIndices, this.getMinimumCount(), this.getMaximumCount());
        if (transmitResult.getThrowable() != null) {
            return (Q)((RestrictedIdentificationResult)resultClass.cast(new RestrictedIdentificationResult(transmitResult.getThrowable())));
        }
        RestrictedIdentificationResult riResult = new RestrictedIdentificationResult();
        try {
            for (int i = 0; i < responseIndices.length; ++i) {
                ResponseAPDU r = transmitResult.getResponseList().get(responseIndices[i]);
                byte[] data = r.data();
                if (data == null) continue;
                ASN1 resASN1 = new ASN1(data);
                ASN1[] idData = resASN1.getChildElementsByDTagBytes(FIRST_ID_TAG);
                if (idData != null && idData.length == 1) {
                    riResult.setFirstID(idData[0].getValue());
                }
                if ((idData = resASN1.getChildElementsByDTagBytes(SECOND_ID_TAG)) == null || idData.length != 1) continue;
                riResult.setSecondID(idData[0].getValue());
            }
        }
        catch (Exception e) {
            riResult = new RestrictedIdentificationResult(e);
        }
        return (Q)((RestrictedIdentificationResult)resultClass.cast(riResult));
    }

    @Override
    public int getMinimumCount() {
        return 1;
    }

    @Override
    public int getMaximumCount() {
        return 2;
    }
}

