/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.read;

import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.FunctionParameter;

public class ReadParameter
implements FunctionParameter {
    public static final int DEFAULT_LENGTH = 0;
    public static final int DEFAULT_OFFSET = 0;
    public static final Byte DEFAULT_SFI = null;
    private Byte sfi = DEFAULT_SFI;
    private int length = 0;
    private int offset = 0;

    public final Byte getSfi() {
        return this.sfi;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getOffset() {
        return this.offset;
    }

    public ReadParameter() throws IllegalArgumentException {
        this(0, 0, DEFAULT_SFI);
    }

    public ReadParameter(int offset, int length, Byte sfi) throws IllegalArgumentException {
        if (offset < 0) {
            throw new IllegalArgumentException("only positive offset permitted");
        }
        if (sfi == null && offset > Short.MAX_VALUE) {
            throw new IllegalArgumentException("only offset less equals 32767 permitted");
        }
        if (sfi != null && offset > 255) {
            throw new IllegalArgumentException("only offset less equals 255 permitted (SFI set)");
        }
        if (length < 0) {
            throw new IllegalArgumentException("only positive length permitted");
        }
        if (length > 65536) {
            throw new IllegalArgumentException("only length less equals 65536 permitted");
        }
        this.offset = offset;
        this.length = length;
        this.sfi = sfi;
    }
}

