/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.read;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.TransmitCommand;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDU;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.ServerStep;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.Function;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.TransmitCommandCreator;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.TransmitResultEvaluator;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.impl.AbstractFunction;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.read.ReadParameter;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.read.ReadResult;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDU;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDUParameter;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDUResult;
import java.util.List;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public class Read
extends AbstractFunction<byte[], ReadParameter, ReadResult>
implements Function<byte[], ReadParameter, ReadResult>,
ServerStep<TransmitAPDUParameter, ReadResult>,
TransmitCommandCreator<ReadParameter>,
TransmitResultEvaluator<ReadResult> {
    private TransmitAPDU transmit = null;

    public Read(TransmitAPDU transmit) throws IllegalArgumentException {
        this.transmit = transmit;
    }

    @Override
    public ReadResult executeInt(ReadParameter parameter) throws Throwable {
        AssertUtil.notNull(this.transmit, "TransmitAPDU");
        TransmitAPDUParameter transmitParameter = null;
        TransmitAPDUResult result = null;
        transmitParameter = new TransmitAPDUParameter(this.create(parameter, (List<ResponseAPDU>)null));
        result = (TransmitAPDUResult)this.transmit.execute(transmitParameter);
        if (result.getThrowable() != null) {
            return new ReadResult(result.getThrowable());
        }
        ReadResult readResult = new ReadResult(result.getResponseList().get(0).data());
        return readResult;
    }

    @Override
    public ReadResult createResult(Throwable throwable) {
        return new ReadResult(throwable);
    }

    @Override
    public <P extends TransmitAPDUParameter, Q extends ReadResult> P executeStep(int stepSelect, Class<Q> resultClass, Q result, Class<P> parameterClass, P parameter, Object[] additionalParameters) throws IllegalArgumentException, InternalError {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Q extends TransmitAPDUParameter> Q parameterStep(int stepSelect, Class<Q> parameterClass, Q parameter, Object[] additionalParameters) throws IllegalArgumentException, InternalError {
        if (!TransmitAPDUParameter.class.equals(parameterClass)) {
            throw new IllegalArgumentException("only TransmitAPDUParameter.class supported");
        }
        if (parameter != null) {
            throw new IllegalArgumentException("parameter only expected as null");
        }
        if (!ArrayUtil.isNullOrEmpty(additionalParameters)) {
            throw new IllegalArgumentException("additionalParameters only expected as null or empty array");
        }
        ReadParameter readParameter = null;
        if (!ArrayUtil.isNullOrEmpty(additionalParameters)) {
            if (additionalParameters.length != 1 || !ReadParameter.class.isInstance(additionalParameters[0])) {
                throw new IllegalArgumentException("exactly one additional parameter expected containing ReadParameter for batch execution");
            }
            readParameter = (ReadParameter)additionalParameters[0];
            if (readParameter == null) {
                return (Q)((TransmitAPDUParameter)parameterClass.cast(new TransmitAPDUParameter()));
            }
        }
        TransmitAPDUParameter transmitParameter = new TransmitAPDUParameter(this.create(readParameter, (List<ResponseAPDU>)null));
        TransmitAPDUParameter securedTransmitParameter = this.transmit.parameterStep(0, TransmitAPDUParameter.class, transmitParameter, null);
        return (Q)((TransmitAPDUParameter)parameterClass.cast(securedTransmitParameter));
    }

    @Override
    public <Q extends ReadResult> Q resultStep(int stepSelect, Class<Q> resultClass, Q result, Object[] additionalParameters) throws IllegalArgumentException, InternalError {
        AssertUtil.notNull(this.transmit, "TransmitAPDU");
        if (!ReadResult.class.equals(resultClass)) {
            throw new IllegalArgumentException("only ReadResult.class supported");
        }
        AssertUtil.notNullOrEmpty(additionalParameters, "additionalParameters");
        if (additionalParameters.length != 1 || !TransmitAPDUResult.class.isInstance(additionalParameters[0])) {
            throw new IllegalArgumentException("exactly one additional parameter expected containing TransmitAPDUResult as result");
        }
        TransmitAPDUResult unsecuredResult = this.transmit.resultStep(0, TransmitAPDUResult.class, (TransmitAPDUResult)TransmitAPDUResult.class.cast(additionalParameters[0]), null);
        return (Q)this.evaluate((Class)resultClass, unsecuredResult, (int[])null);
    }

    @Override
    public List<TransmitCommand> create(ReadParameter parameter) {
        return this.create(parameter, (List<ResponseAPDU>)null);
    }

    @Override
    public List<TransmitCommand> create(ReadParameter parameter, List<ResponseAPDU> acceptedResponseList) {
        CommandAPDU command = null;
        command = parameter == null ? new CommandAPDU(HexUtil.parse("00b00000000000")) : new GISOCommandAPDU(parameter.getLength() > 256, (byte)0, (byte)-80, parameter.getSfi() != null ? parameter.getSfi() : (byte)(parameter.getOffset() / 256), (byte)(parameter.getOffset() % 256), null, parameter.getLength());
        return TransmitCommand.create(command, acceptedResponseList);
    }

    @Override
    public <Q extends ReadResult> Q evaluate(Class<Q> resultClass, TransmitAPDUResult transmitResult, int[] responseIndices) {
        responseIndices = TransmitResultEvaluator.Util.checkArguments(resultClass, transmitResult, responseIndices, this.getMinimumCount(), this.getMaximumCount());
        if (transmitResult.getThrowable() != null) {
            return (Q)((ReadResult)resultClass.cast(new ReadResult(transmitResult.getThrowable())));
        }
        ReadResult readResult = new ReadResult(transmitResult.getResponseList().get(responseIndices[0]).data());
        return (Q)((ReadResult)resultClass.cast(readResult));
    }

    @Override
    public int getMinimumCount() {
        return 1;
    }

    @Override
    public int getMaximumCount() {
        return 1;
    }
}

