/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.APDUCountRestricted;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.FunctionResult;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.server.functions.transmitAPDU.TransmitAPDUResult;

public interface TransmitResultEvaluator<T extends FunctionResult<?>>
extends APDUCountRestricted {
    public <Q extends T> Q evaluate(Class<Q> var1, TransmitAPDUResult var2, int[] var3) throws Exception, IllegalArgumentException;

    public static class Util {
        private Util() {
        }

        public static int[] checkArguments(Class<? extends FunctionResult<?>> resultClass, TransmitAPDUResult transmitResult, int[] responseIndices, int min, int max) throws IllegalArgumentException {
            AssertUtil.notNull(resultClass, "result class");
            AssertUtil.notNull(transmitResult, "transmit result");
            if (ArrayUtil.isNullOrEmpty(responseIndices)) {
                responseIndices = new int[]{0};
            }
            for (int responseIndex : responseIndices) {
                if (responseIndex < 0) {
                    throw new IllegalArgumentException("invalid index, only positive value permitted");
                }
                if (responseIndex < transmitResult.getResponseList().size()) continue;
                throw new IllegalArgumentException("invalid index, only value less equals " + transmitResult.getResponseList().size() + " permitted");
            }
            return responseIndices;
        }
    }
}

